/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.transport;

import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.agent.JasBean;
import javax.agent.Locator;
import javax.agent.TransportMessage;
import javax.agent.service.ServiceProperties;
import javax.agent.service.transport.MessageReceiver;
import javax.agent.service.transport.MessageSender;
import javax.agent.service.transport.MessageTransportService;
import javax.agent.service.transport.NoSuchTransportException;
import javax.agent.service.transport.NotLocatableException;
import javax.agent.service.transport.TransportException;
import javax.agent.service.transport.TransportFailure;
import javax.agent.service.transport.TransportSystem;
import org.jagent.service.spi.transport.MessageTransportManager;
import org.jagent.util.URIUtility;

public class BasicTransportSystem
implements TransportSystem {
    private Hashtable services = new Hashtable();

    public ServiceProperties getServiceProperties() {
        return null;
    }

    public void setServiceProperties(ServiceProperties serviceProperties) {
    }

    public void shutdown() {
        this.services.clear();
    }

    public void loadTransportService(String string, ServiceProperties serviceProperties) throws TransportException {
        if (this.services.containsKey(string)) {
            throw new TransportException("Transport service already loaded.");
        }
        try {
            MessageTransportService messageTransportService = MessageTransportManager.getMessageTransportService(serviceProperties);
            this.services.put(string, messageTransportService);
        }
        catch (Exception exception) {
            throw new TransportException("Cannot load transport service.", exception);
        }
    }

    public MessageTransportService unloadTransportService(String string) {
        return (MessageTransportService)this.services.remove(string);
    }

    public MessageTransportService[] getMessageTransportServices() throws TransportFailure {
        MessageTransportService[] messageTransportServiceArray = new MessageTransportService[this.services.size()];
        int n = 0;
        Enumeration enumeration = this.services.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            messageTransportServiceArray[n++] = (MessageTransportService)this.services.get(k);
        }
        return messageTransportServiceArray;
    }

    public MessageTransportService getMessageTransportService(Locator locator) throws NotLocatableException, TransportFailure {
        return this.getMessageTransportService((JasBean)locator);
    }

    public MessageTransportService getMessageTransportService(JasBean jasBean) throws NotLocatableException, TransportFailure {
        Object object = jasBean.get("javax.agent.transport-address");
        if (object != null && object instanceof String) {
            try {
                String string = URIUtility.parseAsURI((String)object)[0];
                if (string != null && this.services.containsKey(string)) {
                    return (MessageTransportService)this.services.get(string);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        throw new NotLocatableException();
    }

    public MessageSender newMessageSender(JasBean jasBean) throws NotLocatableException, TransportFailure {
        return this.getMessageTransportService(jasBean).newMessageSender(jasBean);
    }

    public MessageReceiver newMessageReceiver(JasBean jasBean) throws NotLocatableException, TransportFailure {
        return this.getMessageTransportService(jasBean).newMessageReceiver(jasBean);
    }

    public void sendMessage(TransportMessage transportMessage) throws NotLocatableException, NoSuchTransportException, TransportFailure {
        this.sendMessage(transportMessage, transportMessage.getReceiver());
    }

    public void sendMessage(TransportMessage transportMessage, Locator locator) throws NotLocatableException, NoSuchTransportException, TransportFailure {
        this.getMessageTransportService(locator).sendMessage(transportMessage);
    }
}

