/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.spi.transport;

import java.lang.reflect.InvocationTargetException;
import javax.agent.service.ServiceProperties;
import javax.agent.service.transport.MessageTransportService;
import javax.agent.service.transport.TransportException;
import javax.agent.service.transport.TransportFailure;
import org.jagent.service.spi.transport.MessageTransportFactory;
import org.jagent.service.spi.transport.MessageTransportFactoryBuilder;

public class MessageTransportManager {
    public static final String TRANSPORT_FACTORY_CLASS = "transport-factory-class";
    private static MessageTransportFactoryBuilder init_factory_builder = null;

    private MessageTransportManager() {
    }

    private static synchronized MessageTransportFactoryBuilder getMessageTransportFactoryBuilder() {
        return init_factory_builder;
    }

    public static synchronized void setMessageTransportFactoryBuilder(MessageTransportFactoryBuilder messageTransportFactoryBuilder) throws TransportException {
        if (init_factory_builder != null) {
            throw new IllegalStateException("TransportFactoryBuilder already set");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        init_factory_builder = messageTransportFactoryBuilder;
    }

    public static MessageTransportService getMessageTransportService(ServiceProperties serviceProperties) throws TransportException, TransportFailure {
        String string = TRANSPORT_FACTORY_CLASS;
        MessageTransportFactory messageTransportFactory = null;
        MessageTransportFactoryBuilder messageTransportFactoryBuilder = MessageTransportManager.getMessageTransportFactoryBuilder();
        if (messageTransportFactoryBuilder == null) {
            if (serviceProperties == null || !serviceProperties.containsKey(string)) {
                throw new TransportException("Need to specify class name in environment or system property " + string);
            }
            String string2 = (String)serviceProperties.get(string);
            try {
                Class<?> clazz = Class.forName(string2);
                messageTransportFactory = (MessageTransportFactory)clazz.newInstance();
            }
            catch (Exception exception) {
                Exception exception2;
                if (exception instanceof InvocationTargetException) {
                    InvocationTargetException invocationTargetException = (InvocationTargetException)exception;
                    exception2 = (Exception)invocationTargetException.getTargetException();
                }
                throw new TransportException("Cannot instantiate class: " + string2, exception2);
            }
        } else {
            messageTransportFactory = messageTransportFactoryBuilder.createMessageTransportFactory(serviceProperties);
        }
        return messageTransportFactory.getMessageTransportService(serviceProperties);
    }
}

