/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.spi;

import java.lang.reflect.InvocationTargetException;
import javax.agent.service.Service;
import javax.agent.service.ServiceException;
import javax.agent.service.ServiceProperties;
import org.jagent.service.spi.ServiceFactory;
import org.jagent.service.spi.ServiceFactoryBuilder;

public class ServiceManager {
    public static final String SERVICE_CLASS_FACTORY = "javax.agent.service.service-factory";
    private static ServiceFactoryBuilder init_factory_builder = null;

    private ServiceManager() {
    }

    private static synchronized ServiceFactoryBuilder getServiceFactoryBuilder() {
        return init_factory_builder;
    }

    public static synchronized void setServiceFactoryBuilder(ServiceFactoryBuilder serviceFactoryBuilder) throws ServiceException {
        if (init_factory_builder != null) {
            throw new IllegalStateException("ServiceFactoryBuilder already set");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        init_factory_builder = serviceFactoryBuilder;
    }

    public static Service getService(ServiceProperties serviceProperties) throws ServiceException {
        ServiceFactory serviceFactory = null;
        ServiceFactoryBuilder serviceFactoryBuilder = ServiceManager.getServiceFactoryBuilder();
        if (serviceFactoryBuilder == null) {
            if (serviceProperties == null || !serviceProperties.containsKey(SERVICE_CLASS_FACTORY)) {
                throw new ServiceException("Need to specify class name in environment or system property javax.agent.service.service-factory");
            }
            String string = (String)serviceProperties.get(SERVICE_CLASS_FACTORY);
            try {
                Class<?> clazz = Class.forName(string);
                serviceFactory = (ServiceFactory)clazz.newInstance();
            }
            catch (Exception exception) {
                Exception exception2;
                if (exception instanceof InvocationTargetException) {
                    InvocationTargetException invocationTargetException = (InvocationTargetException)exception;
                    exception2 = (Exception)invocationTargetException.getTargetException();
                }
                throw new ServiceException("Cannot instantiate class: " + string, exception2);
            }
        } else {
            serviceFactory = serviceFactoryBuilder.createServiceFactory(serviceProperties);
        }
        return serviceFactory.getService(serviceProperties);
    }
}

