/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.directory.rmi;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import javax.agent.service.Service;
import javax.agent.service.ServiceException;
import javax.agent.service.ServiceProperties;
import org.jagent.service.directory.rmi.RMIAgentDirectoryService;
import org.jagent.service.directory.rmi.RMIAgentDirectoryServiceProxy;
import org.jagent.service.directory.rmi.RMIAgentDirectorySystem;
import org.jagent.service.spi.ServiceFactory;
import org.jagent.service.util.RMIUtility;
import org.jagent.util.URIUtility;

public class RMIAgentDirectoryServiceFactory
implements ServiceFactory {
    private static final String RMI = "rmi";

    public Service getService(ServiceProperties serviceProperties) throws ServiceException {
        String string;
        RMIAgentDirectoryService rMIAgentDirectoryService = null;
        boolean bl = true;
        InetAddress inetAddress = null;
        String string2 = null;
        InetAddress inetAddress2 = null;
        String string3 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            throw new ServiceException("Cannot obtain local host address.", unknownHostException);
        }
        if (serviceProperties.containsKey("javax.agent.service.ip.service-host")) {
            string2 = (String)serviceProperties.get("javax.agent.service.ip.service-host");
            try {
                inetAddress2 = InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                throw new ServiceException("Cannot obtain local host's name.", unknownHostException);
            }
            String string4 = (String)serviceProperties.get("com.ibm.able.platform.requestors-port");
            string = (String)serviceProperties.get("javax.agent.service.ip.service-port");
            if (inetAddress.equals(inetAddress2) && string4 != null && string4.equalsIgnoreCase(string)) {
                bl = true;
                string3 = string2;
                if (string2.equalsIgnoreCase("localhost")) {
                    string3 = inetAddress.getHostName();
                }
            } else {
                bl = false;
                string3 = string2;
            }
        } else {
            bl = true;
            string3 = inetAddress.getHostName();
        }
        int n = 1099;
        if (serviceProperties.containsKey("javax.agent.service.ip.service-port")) {
            n = Integer.parseInt((String)serviceProperties.get("javax.agent.service.ip.service-port"));
        } else {
            serviceProperties.set("javax.agent.service.ip.service-port", String.valueOf(n));
        }
        string = "agent-directory-service";
        String string5 = URIUtility.buildURI(RMI, string3, n, string);
        Registry registry = null;
        if (bl) {
            try {
                registry = RMIUtility.getLocalRegistry(n);
            }
            catch (RemoteException remoteException) {
                throw new ServiceException("Could not obtain or create registry at port <" + n + ">.", remoteException);
            }
            try {
                rMIAgentDirectoryService = (RMIAgentDirectoryService)registry.lookup(string5);
            }
            catch (NotBoundException notBoundException) {
                try {
                    rMIAgentDirectoryService = new RMIAgentDirectorySystem(serviceProperties);
                }
                catch (AlreadyBoundException alreadyBoundException) {
                    try {
                        rMIAgentDirectoryService = (RMIAgentDirectoryService)registry.lookup(string5);
                    }
                    catch (Exception exception) {
                        throw new ServiceException("Exhausted all means to create or find Directory Service.", exception);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new ServiceException("Could not create Directory Service object.", exception);
                }
            }
            catch (RemoteException remoteException) {
                throw new ServiceException("Remote exception looking up local Directory Service.", remoteException);
            }
        } else {
            try {
                registry = LocateRegistry.getRegistry(string3, n);
            }
            catch (RemoteException remoteException) {
                throw new ServiceException("Cannot access remote RMI Registry on <" + string3 + ":" + n + ">.", remoteException);
            }
            try {
                rMIAgentDirectoryService = (RMIAgentDirectoryService)registry.lookup(string5);
            }
            catch (NotBoundException notBoundException) {
                throw new ServiceException("Directory Service on <" + string3 + ":" + n + "> is not bound to registry.", notBoundException);
            }
            catch (RemoteException remoteException) {
                throw new ServiceException("Remote exception looking up remote Directory Service.", remoteException);
            }
        }
        return new RMIAgentDirectoryServiceProxy(rMIAgentDirectoryService);
    }
}

