/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.directory.ldap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.agent.AgentName;
import javax.agent.service.ServiceException;
import javax.agent.service.ServiceFailure;
import javax.agent.service.ServiceProperties;
import javax.agent.service.directory.AgentDescription;
import javax.agent.service.directory.AgentDirectoryService;
import javax.agent.service.directory.AlreadyRegisteredException;
import javax.agent.service.directory.DirectoryFailure;
import javax.agent.service.directory.NotRegisteredException;
import javax.agent.service.directory.SearchException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import org.jagent.service.directory.BasicAgentDescription;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class LdapAgentDirectoryService
implements AgentDirectoryService {
    private static BASE64Encoder encoder = new BASE64Encoder();
    private static BASE64Decoder decoder = new BASE64Decoder();
    DirContext dctx = null;
    private ServiceProperties props = null;

    private static String encode(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            return encoder.encodeBuffer(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Object decode(String string) {
        try {
            byte[] byArray = decoder.decodeBuffer(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return objectInputStream.readObject();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Attributes desc2attrs(AgentDescription agentDescription) {
        BasicAttributes basicAttributes = new BasicAttributes();
        Enumeration enumeration = agentDescription.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = agentDescription.get(string);
            basicAttributes.put(new BasicAttribute(string, LdapAgentDirectoryService.encode(object)));
        }
        return basicAttributes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AgentDescription attrs2desc(Attributes attributes) {
        BasicAgentDescription basicAgentDescription = new BasicAgentDescription();
        NamingEnumeration<String> namingEnumeration = attributes.getIDs();
        try {
            while (true) {
                if (!namingEnumeration.hasMore()) {
                    return basicAgentDescription;
                }
                String string = namingEnumeration.next();
                Attribute attribute = attributes.get(string);
                String string2 = null;
                try {
                    string2 = (String)attribute.get();
                }
                catch (ClassCastException classCastException) {
                    continue;
                }
                Object object = LdapAgentDirectoryService.decode(string2);
                if (object == null) continue;
                basicAgentDescription.set(string, object);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return basicAgentDescription;
    }

    public LdapAgentDirectoryService(DirContext dirContext) {
        this.dctx = dirContext;
    }

    public ServiceProperties getServiceProperties() throws ServiceException, ServiceFailure {
        return this.props;
    }

    public void setServiceProperties(ServiceProperties serviceProperties) throws ServiceException, ServiceFailure {
        this.props = serviceProperties;
    }

    public AgentDescription createAgentDescription() {
        return new BasicAgentDescription();
    }

    public void register(AgentDescription agentDescription) throws AlreadyRegisteredException, DirectoryFailure {
        AgentName agentName = agentDescription.getAgentName();
        if (agentName == null) {
            throw new DirectoryFailure("AgentName is empty");
        }
        try {
            Attributes attributes = LdapAgentDirectoryService.desc2attrs(agentDescription);
            this.dctx.bind("cn=" + agentName, (Object)agentDescription, attributes);
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            throw new AlreadyRegisteredException(agentName.toString());
        }
        catch (Exception exception) {
            throw new DirectoryFailure(agentName.toString(), exception);
        }
    }

    public void deregister(AgentDescription agentDescription) throws NotRegisteredException, DirectoryFailure {
        AgentName agentName = agentDescription.getAgentName();
        if (agentName == null) {
            throw new DirectoryFailure("AgentName is empty");
        }
        try {
            this.dctx.unbind("cn=" + agentName);
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new NotRegisteredException(agentName.toString());
        }
        catch (Exception exception) {
            throw new DirectoryFailure(agentName.toString(), exception);
        }
    }

    public void modify(AgentDescription agentDescription) throws NotRegisteredException, DirectoryFailure {
        AgentName agentName = agentDescription.getAgentName();
        if (agentName == null) {
            throw new DirectoryFailure("AgentName is empty");
        }
        try {
            Attributes attributes = LdapAgentDirectoryService.desc2attrs(agentDescription);
            this.dctx.modifyAttributes("cn=" + agentName, 2, attributes);
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new NotRegisteredException(agentName.toString());
        }
        catch (Exception exception) {
            throw new DirectoryFailure(agentName.toString(), exception);
        }
    }

    public AgentDescription[] search(AgentDescription agentDescription) throws SearchException, DirectoryFailure {
        try {
            Object object;
            Attributes attributes = LdapAgentDirectoryService.desc2attrs(agentDescription);
            NamingEnumeration<SearchResult> namingEnumeration = this.dctx.search("", attributes);
            Vector<AgentDescription> vector = new Vector<AgentDescription>();
            while (namingEnumeration.hasMore()) {
                object = namingEnumeration.next();
                AgentDescription agentDescription2 = LdapAgentDirectoryService.attrs2desc(((SearchResult)object).getAttributes());
                vector.addElement(agentDescription2);
            }
            object = new AgentDescription[vector.size()];
            vector.copyInto((Object[])object);
            return object;
        }
        catch (NamingException namingException) {
            throw new SearchException("");
        }
        catch (Exception exception) {
            throw new DirectoryFailure("", exception);
        }
    }

    public AgentDescription[] search(AgentDescription agentDescription, int n) throws SearchException, DirectoryFailure {
        try {
            Object object;
            Attributes attributes = LdapAgentDirectoryService.desc2attrs(agentDescription);
            NamingEnumeration<SearchResult> namingEnumeration = this.dctx.search("", attributes);
            Vector<AgentDescription> vector = new Vector<AgentDescription>();
            int n2 = 0;
            while (n2 < n && namingEnumeration.hasMore()) {
                object = namingEnumeration.next();
                AgentDescription agentDescription2 = LdapAgentDirectoryService.attrs2desc(((SearchResult)object).getAttributes());
                vector.addElement(agentDescription2);
                ++n2;
            }
            object = new AgentDescription[vector.size()];
            vector.copyInto((Object[])object);
            return object;
        }
        catch (NamingException namingException) {
            throw new SearchException("");
        }
        catch (Exception exception) {
            throw new DirectoryFailure("", exception);
        }
    }

    protected void finalize() throws Throwable {
        this.dctx.close();
    }
}

