/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.boot;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;

public class SimpleShell {
    private Hashtable commands;
    private BufferedReader in;
    protected PrintStream out = System.out;
    protected PrintStream err = System.err;
    private String prompt = "simple shell> ";
    static /* synthetic */ Class class$java$lang$Object;

    protected SimpleShell() {
        this.commands = new Hashtable();
        this.in = new BufferedReader(new InputStreamReader(System.in));
    }

    protected void initialize() throws Exception {
        Method method = this.getClass().getMethod("exit", class$java$lang$Object == null ? (class$java$lang$Object = SimpleShell.class$("java.lang.Object")) : class$java$lang$Object);
        Method method2 = this.getClass().getMethod("exit", class$java$lang$Object == null ? (class$java$lang$Object = SimpleShell.class$("java.lang.Object")) : class$java$lang$Object);
        Method method3 = this.getClass().getMethod("cmds", class$java$lang$Object == null ? (class$java$lang$Object = SimpleShell.class$("java.lang.Object")) : class$java$lang$Object);
        this.addCommand("quit", method2);
        this.addCommand("exit", method2);
        this.addCommand("cmds", method3);
    }

    public final void setPrompt(String string) {
        if (string != null) {
            this.prompt = string;
        }
    }

    protected final void addCommand(String string, Method method) {
        this.addCommand(string, method, this);
    }

    protected final void addCommand(String string, Method method, Object object) {
        this.commands.put(string, new Act(object, string, method));
    }

    protected final void removeCommand(String string) {
        this.commands.remove(string);
    }

    protected final void show_prompt() {
        this.out.print(this.prompt);
    }

    public final void exit(Object object) {
        System.exit(0);
    }

    public final void noop(Object object) {
    }

    protected final String getCommandLine() {
        String string = "noop";
        try {
            string = this.in.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    protected final String[] tokenize(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[0]);
    }

    protected void start() {
        this.interactiveLoop();
    }

    public void cmds(Object object) {
        Iterator iterator = this.commands.keySet().iterator();
        while (iterator.hasNext()) {
            this.out.print(iterator.next() + "\t");
        }
        this.out.println();
    }

    protected void error(String[] stringArray) {
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            this.err.print(stringArray[n]);
            this.err.print(n != n2 - 1 ? ": " : "\n");
            ++n;
        }
    }

    private void interactiveLoop() {
        while (true) {
            this.show_prompt();
            String[] stringArray = this.tokenize(this.getCommandLine());
            if (stringArray.length <= 0) continue;
            if (this.commands.containsKey(stringArray[0])) {
                Object[] objectArray = new Object[stringArray.length - 1];
                System.arraycopy(stringArray, 1, objectArray, 0, stringArray.length - 1);
                try {
                    Act act = (Act)this.commands.get(stringArray[0]);
                    act.action.invoke(act.target, new Object[]{objectArray});
                }
                catch (Exception exception) {
                    this.error(new String[]{"Error invoking command", stringArray[0]});
                    exception.printStackTrace(this.err);
                }
                continue;
            }
            this.error(new String[]{stringArray[0], "Command not found."});
        }
    }

    public static void main(String[] stringArray) throws Exception {
        SimpleShell simpleShell = new SimpleShell();
        simpleShell.setPrompt("simple shell % ");
        simpleShell.initialize();
        simpleShell.start();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Act {
        Method action;
        Object target;
        String name;

        public Act(Object object, String string, Method method) {
            this.action = method;
            this.target = object;
            this.name = string;
        }
    }
}

