/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.service.boot;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import javax.agent.service.ServiceProperties;
import javax.agent.service.ServiceRoot;
import javax.agent.service.directory.AgentDirectoryService;
import javax.agent.service.naming.AgentNamingService;
import javax.agent.service.transport.TransportSystem;
import org.jagent.service.DefaultServiceRoot;
import org.jagent.service.ServicePropertiesImpl;
import org.jagent.service.boot.BootProperties;
import org.jagent.service.spi.ServiceManager;
import org.jagent.util.HierarchialMap;
import org.jagent.util.KVTReader;

public final class Booter {
    private static BootProperties defaults;
    private static final String FACTORY = "javax.agent.service.service-factory";
    private static final String ANS_TYPE = "agent-naming-service";
    private static final String ADS_TYPE = "agent-directory-service";
    private static final String MTS_TYPE = "message-transport-system";
    private static final String DEFAULT_ADS_FACTORY = "org.jagent.service.directory.rmi.RMIAgentDirectoryServiceFactory";
    private static final String DEFAULT_ANS_FACTORY = "org.jagent.service.naming.rmi.RMIAgentNamingServiceFactory";
    private static final String DEFAULT_MTS_FACTORY = "org.jagent.service.transport.rmi.RMITransportSystemFactory";
    private static final String DEFAULT_TM_FACTORY = "org.jagent.service.transport.rmi.RMIMessageTransportServiceFactory";
    private static final Booter BOOTER;

    private Booter() {
        defaults = new BootProperties();
        defaults.put("agent-directory-service.javax.agent.service.service-factory", DEFAULT_ADS_FACTORY);
        defaults.put("agent-naming-service.javax.agent.service.service-factory", DEFAULT_ANS_FACTORY);
        defaults.put("message-transport-system.javax.agent.service.service-factory", DEFAULT_MTS_FACTORY);
        InputStream inputStream = this.getClass().getResourceAsStream("srcv.cfg");
        if (inputStream != null) {
            try {
                KVTReader kVTReader = new KVTReader(new InputStreamReader(inputStream));
                defaults.load(kVTReader);
                kVTReader.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error(exception.getMessage());
            }
        }
    }

    public static synchronized void setDefaultEnvironment(BootProperties bootProperties) throws Exception {
        ServiceRoot serviceRoot = Booter.getServiceRoot(bootProperties);
        defaults = bootProperties;
    }

    public static synchronized ServiceRoot getServiceRoot() throws Exception {
        return Booter.getServiceRoot(defaults);
    }

    public static synchronized ServiceRoot getServiceRoot(BootProperties bootProperties) throws Exception {
        ServiceProperties serviceProperties;
        DefaultServiceRoot defaultServiceRoot = (DefaultServiceRoot)DefaultServiceRoot.getInstance();
        TransportSystem transportSystem = defaultServiceRoot.getTransportSystem();
        AgentNamingService agentNamingService = defaultServiceRoot.getAgentNamingService();
        AgentDirectoryService agentDirectoryService = defaultServiceRoot.getAgentDirectoryService();
        if (agentNamingService == null) {
            serviceProperties = Booter.getProperties(ANS_TYPE, bootProperties);
            defaultServiceRoot.setService(ANS_TYPE, ServiceManager.getService(serviceProperties));
        }
        if (agentDirectoryService == null) {
            serviceProperties = Booter.getProperties(ADS_TYPE, bootProperties);
            defaultServiceRoot.setService(ADS_TYPE, ServiceManager.getService(serviceProperties));
        }
        if (transportSystem == null) {
            serviceProperties = Booter.getProperties(MTS_TYPE, bootProperties);
            defaultServiceRoot.setService(MTS_TYPE, ServiceManager.getService(serviceProperties));
        }
        return defaultServiceRoot;
    }

    private static ServiceProperties getProperties(String string, BootProperties bootProperties) {
        boolean bl = false;
        HierarchialMap hierarchialMap = bootProperties;
        if (hierarchialMap.containsKey("java-agent-services")) {
            if ((hierarchialMap = (HierarchialMap)hierarchialMap.get("java-agent-services")).containsKey(string)) {
                hierarchialMap = (HierarchialMap)hierarchialMap.get(string);
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        String string2 = "";
        if (!bl && hierarchialMap.containsKey("key-prefix")) {
            string2 = (String)hierarchialMap.get("key-prefix") + ".";
        }
        ServicePropertiesImpl servicePropertiesImpl = new ServicePropertiesImpl();
        Iterator iterator = hierarchialMap.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            Object object = hierarchialMap.get(string3);
            if (bl) {
                if (!string3.startsWith(string)) continue;
                servicePropertiesImpl.set(string3.substring(string.length() + 1), object);
                continue;
            }
            servicePropertiesImpl.set(string2 + string3, object);
        }
        return servicePropertiesImpl;
    }

    public static void main(String[] stringArray) {
        try {
            ServiceRoot serviceRoot = Booter.getServiceRoot();
            AgentNamingService agentNamingService = serviceRoot.getAgentNamingService();
            AgentDirectoryService agentDirectoryService = serviceRoot.getAgentDirectoryService();
            TransportSystem transportSystem = serviceRoot.getTransportSystem();
            System.out.println(agentNamingService.getClass().toString());
            System.out.println(agentDirectoryService.getClass().toString());
            System.out.println(transportSystem.getClass().toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        BOOTER = new Booter();
    }
}

