/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.example;

import javax.agent.Payload;
import javax.agent.TransportMessage;
import javax.agent.service.ServiceRoot;
import javax.agent.service.directory.AgentDescription;
import org.jagent.acr.AclMessage;
import org.jagent.acr.AcrNode;
import org.jagent.acr.AcrPayload;
import org.jagent.acr.AcrString;
import org.jagent.example.Usecase1;
import org.jagent.example.Usecase2;
import org.jagent.service.boot.Booter;

public class Usecase3
extends Usecase2 {
    protected Usecase3(ServiceRoot serviceRoot) {
        super(serviceRoot);
    }

    public AgentDescription getAgentDescription() {
        AgentDescription agentDescription = this.ads.createAgentDescription();
        agentDescription.setAgentName(this.name);
        agentDescription.addLocator(this.lctr);
        agentDescription.set("javax.agent.owner-display-name", "Agent B");
        return agentDescription;
    }

    protected TransportMessage buildTransportMessage(AgentDescription agentDescription) {
        TransportMessage transportMessage = super.buildTransportMessage(agentDescription);
        if (transportMessage != null) {
            Payload payload = transportMessage.getPayload();
            AcrNode acrNode = ((AcrPayload)payload).getMessage();
            AclMessage aclMessage = (AclMessage)acrNode;
            aclMessage.setConversationID(new AcrString("seuss"));
            transportMessage.set("conversation-flag", new Integer(0));
        }
        return transportMessage;
    }

    public static void main(String[] stringArray) throws Exception {
        ServiceRoot serviceRoot = Booter.getServiceRoot();
        Usecase1.LOGGER.println("ServiceRoot acquired...");
        Usecase3 usecase3 = new Usecase3(serviceRoot);
        usecase3.initialize();
        if (!usecase3.verifyRegistration()) {
            Usecase1.LOGGER.println("Cannot verify Agent B registration...");
            System.exit(1);
        }
        Usecase1.LOGGER.println("Agent B ready!");
        AgentDescription agentDescription = usecase3.findAgentA();
        if (agentDescription != null) {
            TransportMessage transportMessage = usecase3.buildTransportMessage(agentDescription);
            try {
                Usecase1.LOGGER.println("Sending message ...\n" + transportMessage + "\n");
                usecase3.sendTransportMessage(transportMessage);
                Usecase1.LOGGER.println("Message sent.");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Usecase1.LOGGER.println("Agent B deregistration...");
        usecase3.deregister();
        Usecase1.LOGGER.println("Agent B deregistration complete.");
        Usecase1.LOGGER.println("Usecase 3 complete!");
    }
}

