/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.example;

import javax.agent.AgentName;
import javax.agent.Locator;
import javax.agent.TransportMessage;
import javax.agent.service.ServiceRoot;
import javax.agent.service.directory.AgentDescription;
import org.jagent.acr.AclMessage;
import org.jagent.acr.AcrAgentName;
import org.jagent.acr.AcrElementHelper;
import org.jagent.acr.AcrLocator;
import org.jagent.acr.AcrPayload;
import org.jagent.example.Usecase1;
import org.jagent.service.boot.Booter;

public class Usecase2
extends Usecase1 {
    protected Usecase2(ServiceRoot serviceRoot) {
        super(serviceRoot);
    }

    public AgentDescription getAgentDescription() {
        AgentDescription agentDescription = this.ads.createAgentDescription();
        agentDescription.setAgentName(this.name);
        agentDescription.addLocator(this.lctr);
        agentDescription.set("javax.agent.agent-display-name", "Agent B");
        return agentDescription;
    }

    protected AgentDescription findAgentA() throws Exception {
        AgentDescription agentDescription = this.ads.createAgentDescription();
        agentDescription.set("javax.agent.agent-display-name", "Agent A");
        Usecase1.LOGGER.println("Created search query for Agent 'A' ...\n" + agentDescription);
        AgentDescription[] agentDescriptionArray = this.ads.search(agentDescription);
        Usecase1.LOGGER.println("Submitted search query ...\n");
        return agentDescriptionArray.length == 0 ? null : agentDescriptionArray[0];
    }

    protected TransportMessage buildTransportMessage(AgentDescription agentDescription) {
        AgentName agentName = agentDescription.getAgentName();
        Locator[] locatorArray = agentDescription.getLocators();
        if (locatorArray.length == 0) {
            return null;
        }
        AcrElementHelper acrElementHelper = AcrElementHelper.newInstance();
        AcrAgentName acrAgentName = acrElementHelper.narrowAgentName(agentName);
        AcrAgentName acrAgentName2 = acrElementHelper.narrowAgentName(this.name);
        AclMessage aclMessage = new AclMessage();
        aclMessage.setPerformative("org.fipa.acl.inform");
        aclMessage.setSender(acrAgentName2);
        aclMessage.addReceiver(acrAgentName);
        aclMessage.setContent(Usecase1.STATEMENT[0]);
        AcrLocator acrLocator = acrElementHelper.narrowLocator(locatorArray[0]);
        AcrLocator acrLocator2 = acrElementHelper.narrowLocator(this.lctr);
        TransportMessage transportMessage = this.mts.createTransportMessage();
        transportMessage.setReceiver(acrLocator);
        transportMessage.setSender(acrLocator2);
        AcrPayload acrPayload = new AcrPayload();
        acrPayload.setMessage(aclMessage);
        transportMessage.setPayload(acrPayload);
        return transportMessage;
    }

    protected void sendTransportMessage(TransportMessage transportMessage) throws Exception {
        this.mts.sendMessage(transportMessage);
    }

    protected void deregister() throws Exception {
        this.ads.deregister(this.getAgentDescription());
    }

    public static void main(String[] stringArray) throws Exception {
        Usecase1.LOGGER.println("\nJAS Use Case II : Agent 'B' starts and sends message to Agent 'A'\n================================================================\n");
        ServiceRoot serviceRoot = Booter.getServiceRoot();
        Usecase1.LOGGER.println("ServiceRoot acquired ... [" + serviceRoot + "]\n");
        Usecase2 usecase2 = new Usecase2(serviceRoot);
        usecase2.initialize();
        if (!usecase2.verifyRegistration()) {
            Usecase1.LOGGER.println("Cannot verify Agent B registration...");
            System.exit(1);
        }
        Usecase1.LOGGER.println("Agent B ready!\n");
        AgentDescription agentDescription = usecase2.findAgentA();
        if (agentDescription != null) {
            Usecase1.LOGGER.println("First matching result : \n" + agentDescription + "\n");
            TransportMessage transportMessage = usecase2.buildTransportMessage(agentDescription);
            try {
                Usecase1.LOGGER.println("Sending message ...\n" + transportMessage);
                usecase2.sendTransportMessage(transportMessage);
                Usecase1.LOGGER.println("Message sent.\n");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Usecase1.LOGGER.println("Deregistering Agent B ...\n");
        usecase2.deregister();
        Usecase1.LOGGER.println("Usecase 2 complete!");
    }
}

