/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.example;

import java.io.PrintStream;
import javax.agent.AgentName;
import javax.agent.Locator;
import javax.agent.TransportMessage;
import javax.agent.service.ServiceRoot;
import javax.agent.service.directory.AgentDescription;
import javax.agent.service.directory.AgentDirectoryService;
import javax.agent.service.naming.AgentNamingService;
import javax.agent.service.transport.MessageListener;
import javax.agent.service.transport.MessageReceiver;
import javax.agent.service.transport.MessageTransportService;
import javax.agent.service.transport.TransportSystem;
import org.jagent.acr.AclMessage;
import org.jagent.acr.AcrAgentName;
import org.jagent.acr.AcrElementHelper;
import org.jagent.acr.AcrNode;
import org.jagent.acr.AcrPayload;
import org.jagent.service.boot.Booter;

public class Usecase1
implements MessageListener {
    protected ServiceRoot sr;
    protected AgentName name;
    protected Locator lctr;
    protected AgentNamingService ans;
    protected AgentDirectoryService ads;
    protected MessageTransportService mts;
    protected static final PrintStream LOGGER = System.out;
    protected static final String CONVERSATION_FLAG = "conversation-flag";
    protected static final String[] STATEMENT = new String[]{"Here I am!", "I hear you.", "Life is good.", "So it is..."};

    protected Usecase1(ServiceRoot serviceRoot) {
        this.sr = serviceRoot;
    }

    public void receiveMessage(TransportMessage transportMessage) {
        AcrElementHelper acrElementHelper;
        AcrPayload acrPayload;
        AcrNode acrNode;
        String string;
        int n;
        this.printTransportMessage(transportMessage);
        if (transportMessage.containsKey(CONVERSATION_FLAG) && (n = Integer.parseInt(string = transportMessage.get(CONVERSATION_FLAG).toString()) + 1) < STATEMENT.length && (acrNode = (acrPayload = (acrElementHelper = AcrElementHelper.newInstance()).narrowPayload(transportMessage.getPayload())).getMessage()) instanceof AclMessage) {
            AclMessage aclMessage = (AclMessage)acrNode;
            AcrAgentName acrAgentName = aclMessage.getSender();
            AcrAgentName acrAgentName2 = acrElementHelper.narrowAgentName(this.name);
            aclMessage.setSender(acrAgentName2);
            aclMessage.setReceivers(new AcrAgentName[]{acrAgentName});
            aclMessage.setContent(STATEMENT[n]);
            acrPayload.setMessage(aclMessage);
            TransportMessage transportMessage2 = this.mts.createTransportMessage();
            transportMessage2.setSender(this.lctr);
            transportMessage2.setReceiver(transportMessage.getSender());
            transportMessage2.setPayload(acrPayload);
            transportMessage2.set(CONVERSATION_FLAG, new Integer(n));
            try {
                LOGGER.println("Sending response message ...\n" + transportMessage2);
                this.mts.sendMessage(transportMessage2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Usecase1)) {
            return false;
        }
        return this.hashCode() == ((Usecase1)object).hashCode();
    }

    public int hashCode() {
        return this.name == null ? super.hashCode() : this.name.hashCode();
    }

    public AgentNamingService acquireAgentNamingService() throws Exception {
        this.assertTrue(this.ans == null, "AgentNamingService previously acquired.");
        this.ans = this.sr.getAgentNamingService();
        return this.ans;
    }

    public AgentDirectoryService acquireAgentDirectoryService() throws Exception {
        this.assertTrue(this.ads == null, "AgentDirectoryService previously acquired.");
        this.ads = this.sr.getAgentDirectoryService();
        return this.ads;
    }

    public MessageTransportService acquireMessageTransportService() throws Exception {
        this.assertTrue(this.mts == null, "MessageTransportService previously acquired.");
        TransportSystem transportSystem = this.sr.getTransportSystem();
        MessageTransportService[] messageTransportServiceArray = transportSystem.getMessageTransportServices();
        this.mts = messageTransportServiceArray.length == 0 ? null : messageTransportServiceArray[0];
        return this.mts;
    }

    public Locator bindToMessageTransportService() throws Exception {
        if (this.mts == null) {
            this.acquireMessageTransportService();
        }
        this.lctr = this.mts.newLocalLocator();
        MessageReceiver messageReceiver = this.mts.newMessageReceiver();
        messageReceiver.addMessageListener(this);
        messageReceiver.bindToLocalLocator(this.lctr);
        return this.lctr;
    }

    public AgentName acquireAgentName() throws Exception {
        this.assertTrue(this.name == null, "AgentName previously acquired.");
        if (this.ans == null) {
            this.acquireAgentNamingService();
        }
        this.name = this.ans.createAgentName();
        return this.name;
    }

    public AgentDescription getAgentDescription() {
        AgentDescription agentDescription = this.ads.createAgentDescription();
        agentDescription.setAgentName(this.name);
        agentDescription.addLocator(this.lctr);
        agentDescription.set("javax.agent.agent-display-name", "Agent A");
        agentDescription.set("user.attribute1", "foo.bar");
        agentDescription.set("user.attribute2", "fee.fum");
        agentDescription.set("user.attribute3", "more.stuff");
        return agentDescription;
    }

    protected void assertTrue(boolean bl, String string) throws Exception {
        if (!bl) {
            throw new Exception("Assert [~true]: " + string);
        }
    }

    protected void assertFalse(boolean bl, String string) throws Exception {
        if (!bl) {
            throw new Exception("Assert [~false]: " + string);
        }
    }

    protected boolean verifyRegistration() {
        AgentDescription agentDescription = this.getAgentDescription();
        try {
            AgentDescription[] agentDescriptionArray = this.ads.search(agentDescription);
            return agentDescriptionArray.length != 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private void printTransportMessage(TransportMessage transportMessage) {
        System.out.println("\nIncoming transport message:\n" + transportMessage);
    }

    protected void initialize() throws Exception {
        AgentNamingService agentNamingService = this.acquireAgentNamingService();
        LOGGER.println("AgentNamingService acquired ...\n[" + agentNamingService + "]\n");
        AgentName agentName = this.acquireAgentName();
        LOGGER.println("AgentName acquired from AgentNamingService ...\n" + agentName + "\n");
        MessageTransportService messageTransportService = this.acquireMessageTransportService();
        LOGGER.println("MessageTransportService acquired ...\n[" + messageTransportService + "]\n");
        Locator locator = this.bindToMessageTransportService();
        LOGGER.println("Agent Locator bound to MessageTransportService ...\n" + locator + "\n");
        AgentDirectoryService agentDirectoryService = this.acquireAgentDirectoryService();
        LOGGER.println("AgentDirectoryService acquired ...\n[" + agentDirectoryService + "]\n");
        AgentDescription agentDescription = this.getAgentDescription();
        LOGGER.println("AgentDescription created ...\n" + agentDescription + "\n");
        agentDirectoryService.register(agentDescription);
        LOGGER.println("AgentDescription registered with AgentDirectoryService.\n");
    }

    public static void main(String[] stringArray) throws Exception {
        LOGGER.println("\nJAS Use Case I : Agent 'A' starts, registers and waits for messages\n===================================================================\n");
        ServiceRoot serviceRoot = Booter.getServiceRoot();
        LOGGER.println("ServiceRoot acquired ...\n[" + serviceRoot + "]\n");
        Usecase1 usecase1 = new Usecase1(serviceRoot);
        usecase1.initialize();
        if (!usecase1.verifyRegistration()) {
            LOGGER.println("Cannot verify Agent A registration...");
            System.exit(1);
        }
        LOGGER.println("Agent A waiting for incoming messages ...");
        Thread thread = Thread.currentThread();
        synchronized (thread) {
            Thread.currentThread().wait();
        }
    }
}

