/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.example;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.agent.Envelope;
import javax.agent.Locator;
import javax.agent.Payload;
import javax.agent.TransportMessage;
import javax.agent.service.directory.AgentDescription;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jagent.example.AgentBase;

public class Sender
extends AgentBase {
    protected static JTextArea textArea = null;
    protected static JFrame theFrame = null;
    protected static final String[] STATEMENT = new String[]{"Here I am!", "I hear you.", "Life is good.", "So it is..."};

    public Sender() {
        System.out.println("Sender: Our base constructor was called");
    }

    protected void processMessage(TransportMessage transportMessage, Envelope envelope, Payload payload) {
        System.out.println("Sender: processMessage");
        Locator locator = transportMessage.getSender();
        Enumeration enumeration = payload.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println("Sender: key[" + string + "]");
        }
    }

    protected void doSendStuff() {
        AgentDescription agentDescription = null;
        try {
            agentDescription = this.findAgentByDisplayName("EchoBot");
        }
        catch (Exception exception) {
            System.out.println("Sender:main: Exception doing lookup of EchoBot");
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            System.exit(0);
        }
        if (null == agentDescription) {
            System.out.println("Sender:Main: Could not locate EchoBot.");
            System.exit(0);
        }
        TransportMessage transportMessage = this.rawTransportMessageBuilder(agentDescription, "Hello EchoBot Raw!");
        try {
            this.sendTransportMessage(transportMessage);
        }
        catch (Exception exception) {
            System.out.println("Sender:main: Exception while sending the message");
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Sender: main:  entry");
        textArea = new JTextArea();
        theFrame = new JFrame("Sender Display Pane");
        textArea.append("Sender display pane\n");
        JScrollPane jScrollPane = new JScrollPane(textArea);
        theFrame.getContentPane().add(jScrollPane);
        ((Component)theFrame).setSize(400, 200);
        ((Component)theFrame).setVisible(true);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        theFrame.addWindowListener(windowAdapter);
        Sender sender = new Sender();
        sender.setAgentDisplayName("Sender");
        try {
            sender.setup();
        }
        catch (Exception exception) {
            System.out.println("Exception while setting up Sender.");
            System.exit(0);
        }
        sender.doSendStuff();
        try {
            Thread thread = Thread.currentThread();
            synchronized (thread) {
                Thread.currentThread().wait();
            }
        }
        catch (Exception exception) {
            System.out.println("Wait intterupted. Exiting.");
        }
    }
}

