/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.example;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.agent.AgentName;
import javax.agent.Envelope;
import javax.agent.Locator;
import javax.agent.Payload;
import javax.agent.TransportMessage;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jagent.acr.AcrNode;
import org.jagent.example.AgentBase;

public class EchoBot
extends AgentBase {
    protected static JTextArea textArea = null;
    protected static JFrame theFrame = null;
    protected static final String[] STATEMENT = new String[]{"Here I am!", "I hear you.", "Life is good.", "So it is..."};

    public EchoBot() {
        System.out.println("EchoBot: Our base constructor was called");
    }

    protected void processMessage(TransportMessage transportMessage, Envelope envelope, Payload payload) {
        Object object;
        String string;
        Object object2;
        System.out.println("Echobot: processMessage");
        Locator locator = transportMessage.getSender();
        Enumeration enumeration = envelope.keys();
        System.out.println("EchoBot: Envelope keys:");
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            System.out.println("EchoBot: key[" + (String)object2 + "]");
        }
        object2 = payload.keys();
        System.out.println("Echobot: Payload Keys:");
        while (object2.hasMoreElements()) {
            string = (String)object2.nextElement();
            System.out.println("EchoBot: key[" + string + "]");
        }
        string = (String)envelope.get("com.ibm.research.dwl.displayname");
        textArea.append("Echoing message from: " + string + "\n");
        AcrNode acrNode = (AcrNode)payload.get("jas.acr.node");
        if (null == acrNode) {
            System.out.println("Didn't find expected content node jas.acr.node");
            textArea.append("*** ERROR *** invalid payload structure -- no echo\n");
            return;
        }
        System.out.println("Echobot: Content keys:");
        Enumeration enumeration2 = acrNode.keys();
        while (enumeration2.hasMoreElements()) {
            object = (String)enumeration2.nextElement();
            System.out.println("EchoBot: key[" + (String)object + "]");
        }
        object = (AcrNode)acrNode.get("org.fipa.acl.content");
        if (null == object) {
            System.out.println("Didn't find expected content node org.fipa.acl.content");
            textArea.append("*** ERROR *** invalid payload structure -- no echo\n");
            return;
        }
        String string2 = ((AcrNode)object).toString();
        if (null == string2) {
            System.out.println("failred on toString of content node org.fipa.acl.content");
            textArea.append("*** ERROR *** invalid payload structure -- no echo\n");
            return;
        }
        AgentName agentName = (AgentName)acrNode.get("org.fipa.acl.sender");
        if (null == agentName) {
            System.out.println("Didn't find expected content node org.fipa.acl.sender");
            textArea.append("*** ERROR *** invalid payload structure -- no echo\n");
            return;
        }
        String string3 = "EchoBot:" + string2;
        TransportMessage transportMessage2 = this.rawTransportMessageBuilder(locator, agentName, string3);
        try {
            this.sendTransportMessage(transportMessage2);
        }
        catch (Exception exception) {
            System.out.println("EchoBot: Exception while sending the echo message");
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            textArea.append("*** ERROR *** exception while sending echo message.\n");
            return;
        }
        textArea.append("Echobot: echoed back: " + string3 + "\n");
    }

    public static void main(String[] stringArray) {
        System.out.println("EchoBot: main:  entry");
        textArea = new JTextArea();
        theFrame = new JFrame("EchoBot Display Pane");
        textArea.append("EchoBot display started\n");
        textArea.append("_______________________________________________________________________");
        JScrollPane jScrollPane = new JScrollPane(textArea);
        theFrame.getContentPane().add(jScrollPane);
        ((Component)theFrame).setSize(150, 400);
        ((Component)theFrame).setVisible(true);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        theFrame.addWindowListener(windowAdapter);
        EchoBot echoBot = new EchoBot();
        echoBot.setAgentDisplayName("EchoBot");
        try {
            echoBot.setup();
        }
        catch (Exception exception) {
            System.out.println("Exception while setting up EchoBot");
            System.exit(0);
        }
        try {
            Thread thread = Thread.currentThread();
            synchronized (thread) {
                Thread.currentThread().wait();
            }
        }
        catch (Exception exception) {
            System.out.println("Wait intterupted. Exiting.");
        }
    }
}

