/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.example;

import java.io.PrintStream;
import java.net.InetAddress;
import javax.agent.AgentName;
import javax.agent.Envelope;
import javax.agent.Locator;
import javax.agent.Payload;
import javax.agent.TransportMessage;
import javax.agent.service.ServiceFailure;
import javax.agent.service.ServiceRoot;
import javax.agent.service.directory.AgentDescription;
import javax.agent.service.directory.AgentDirectoryService;
import javax.agent.service.naming.AgentNamingService;
import javax.agent.service.transport.MessageListener;
import javax.agent.service.transport.MessageReceiver;
import javax.agent.service.transport.MessageTransportService;
import javax.agent.service.transport.TransportSystem;
import org.jagent.acr.AclMessage;
import org.jagent.acr.AcrAgentName;
import org.jagent.acr.AcrElementHelper;
import org.jagent.acr.AcrEnvelope;
import org.jagent.acr.AcrLocator;
import org.jagent.acr.AcrPayload;
import org.jagent.acr.AcrString;
import org.jagent.acr.AcrTransportMessage;
import org.jagent.service.boot.Booter;

public class AgentBase
implements MessageListener {
    protected ServiceRoot myServiceRoot;
    protected AgentName myAgentName;
    protected Locator myLocator;
    protected AgentNamingService localAgentNamingService;
    protected AgentDirectoryService localAgentDirectoryService;
    protected MessageTransportService localMessageTransportService;
    protected static String agentDisplayName = "";
    protected static final PrintStream LOGGER = System.out;
    protected static final String CONVERSATION_FLAG = "conversation-flag";

    public AgentBase() {
        System.out.println("AgentBase: Our base constructor was called");
    }

    public void setup() throws ServiceFailure {
        Object object;
        try {
            this.myServiceRoot = Booter.getServiceRoot();
        }
        catch (Exception exception) {
            System.out.println("AgentBase: Exception while getting service root");
            System.out.println("Exception was: " + exception.getMessage());
            exception.printStackTrace();
            throw new ServiceFailure("Failure getting service root", exception);
        }
        try {
            this.acquireAgentNamingService();
        }
        catch (Exception exception) {
            System.out.println("AgentBase: Exception while getting Naming Service");
            System.out.println("Exception was: " + exception.getMessage());
            exception.printStackTrace();
            throw new ServiceFailure("Failure getting naming service.", exception);
        }
        try {
            object = this.acquireAgentName();
        }
        catch (Exception exception) {
            System.out.println("AgentBase: Exception while getting Agent Name");
            System.out.println("Exception was: " + exception.getMessage());
            exception.printStackTrace();
            throw new ServiceFailure("Failure getting Agent Name", exception);
        }
        try {
            object = this.acquireMessageTransportService();
        }
        catch (Exception exception) {
            System.out.println("AgentBase: Exception while getting MessageTransport Service");
            System.out.println("Exception was: " + exception.getMessage());
            exception.printStackTrace();
            throw new ServiceFailure("Failure getting MessageTransport Service.", exception);
        }
        try {
            object = this.bindToMessageTransportService();
        }
        catch (Exception exception) {
            System.out.println("AgentBase: Exception while binding Transport Service");
            System.out.println("Exception was: " + exception.getMessage());
            exception.printStackTrace();
            throw new ServiceFailure("Failure binding transport service.", exception);
        }
        try {
            object = this.acquireAgentDirectoryService();
        }
        catch (Exception exception) {
            System.out.println("AgentBase: Exception while getting Directory Service");
            System.out.println("Exception was: " + exception.getMessage());
            exception.printStackTrace();
            throw new ServiceFailure("Failure getting directory service.", exception);
        }
        object = this.getAgentDescription();
        LOGGER.println("AgentBase: AgentDescription created ...\n" + object + "\n");
        try {
            this.localAgentDirectoryService.register((AgentDescription)object);
        }
        catch (Exception exception) {
            System.out.println("AgentBase: Exception while registering the agent");
            System.out.println("Exception was: " + exception.getMessage());
            exception.printStackTrace();
            throw new ServiceFailure("Failure while registering the agent.", exception);
        }
        LOGGER.println("AgentBase: AgentDescription registered with AgentDirectoryService.\n");
    }

    protected void processMessage(TransportMessage transportMessage, Envelope envelope, Payload payload) {
    }

    public void receiveMessage(TransportMessage transportMessage) {
        System.out.println("AgentBase:receiveMessage: got>" + transportMessage + "<");
        Envelope envelope = transportMessage.getEnvelope();
        Payload payload = transportMessage.getPayload();
        try {
            this.processMessage(transportMessage, envelope, payload);
        }
        catch (Exception exception) {
            System.out.println("AgentBase: Exception while processing message");
            System.out.println("AgentBase: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public String setAgentDisplayName(String string) {
        agentDisplayName = string;
        return agentDisplayName;
    }

    public String getAgentDisplayName() {
        return agentDisplayName;
    }

    public AgentNamingService acquireAgentNamingService() throws Exception {
        this.assertTrue(this.localAgentNamingService == null, "AgentNamingService previously acquired.");
        this.localAgentNamingService = this.myServiceRoot.getAgentNamingService();
        return this.localAgentNamingService;
    }

    public AgentDirectoryService acquireAgentDirectoryService() throws Exception {
        this.assertTrue(this.localAgentDirectoryService == null, "AgentDirectoryService previously acquired.");
        this.localAgentDirectoryService = this.myServiceRoot.getAgentDirectoryService();
        return this.localAgentDirectoryService;
    }

    public MessageTransportService acquireMessageTransportService() throws Exception {
        this.assertTrue(this.localMessageTransportService == null, "MessageTransportService previously acquired.");
        TransportSystem transportSystem = this.myServiceRoot.getTransportSystem();
        MessageTransportService[] messageTransportServiceArray = transportSystem.getMessageTransportServices();
        this.localMessageTransportService = messageTransportServiceArray.length == 0 ? null : messageTransportServiceArray[0];
        return this.localMessageTransportService;
    }

    public Locator bindToMessageTransportService() throws Exception {
        if (this.localMessageTransportService == null) {
            this.acquireMessageTransportService();
        }
        this.assertTrue(this.myLocator == null, "Locator already bound");
        this.myLocator = this.localMessageTransportService.newLocalLocator();
        MessageReceiver messageReceiver = this.localMessageTransportService.newMessageReceiver();
        messageReceiver.addMessageListener(this);
        messageReceiver.bindToLocalLocator(this.myLocator);
        return this.myLocator;
    }

    public AgentName acquireAgentName() throws Exception {
        this.assertTrue(this.myAgentName == null, "AgentName previously acquired.");
        if (this.localAgentNamingService == null) {
            this.acquireAgentNamingService();
        }
        this.myAgentName = this.localAgentNamingService.createAgentName();
        return this.myAgentName;
    }

    public AgentDescription getAgentDescription() {
        AgentDescription agentDescription = this.localAgentDirectoryService.createAgentDescription();
        agentDescription.setAgentName(this.myAgentName);
        agentDescription.addLocator(this.myLocator);
        agentDescription.set("javax.agent.agent-display-name", agentDisplayName);
        return agentDescription;
    }

    protected void assertTrue(boolean bl, String string) throws Exception {
        if (!bl) {
            throw new Exception("Assert [~true]: " + string);
        }
    }

    protected void assertFalse(boolean bl, String string) throws Exception {
        if (!bl) {
            throw new Exception("Assert [~false]: " + string);
        }
    }

    protected boolean verifyRegistration() {
        AgentDescription agentDescription = this.getAgentDescription();
        try {
            AgentDescription[] agentDescriptionArray = this.localAgentDirectoryService.search(agentDescription);
            return agentDescriptionArray.length != 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    protected TransportMessage buildTransportMessage(AgentDescription agentDescription, String string) {
        AgentName agentName = agentDescription.getAgentName();
        Locator[] locatorArray = agentDescription.getLocators();
        if (locatorArray.length == 0) {
            return null;
        }
        AcrElementHelper acrElementHelper = AcrElementHelper.newInstance();
        AcrAgentName acrAgentName = acrElementHelper.narrowAgentName(agentName);
        AcrAgentName acrAgentName2 = acrElementHelper.narrowAgentName(this.myAgentName);
        AclMessage aclMessage = new AclMessage();
        aclMessage.setPerformative("org.fipa.acl.inform");
        aclMessage.setSender(acrAgentName2);
        aclMessage.addReceiver(acrAgentName);
        aclMessage.setContent(string);
        AcrLocator acrLocator = acrElementHelper.narrowLocator(locatorArray[0]);
        AcrLocator acrLocator2 = acrElementHelper.narrowLocator(this.myLocator);
        TransportMessage transportMessage = this.localMessageTransportService.createTransportMessage();
        transportMessage.setReceiver(acrLocator);
        transportMessage.setSender(acrLocator2);
        AcrPayload acrPayload = new AcrPayload();
        acrPayload.setMessage(aclMessage);
        transportMessage.setPayload(acrPayload);
        transportMessage.set(CONVERSATION_FLAG, new Integer(0));
        return transportMessage;
    }

    protected TransportMessage rawTransportMessageBuilder(AgentDescription agentDescription, String string) {
        Object object;
        Object object2;
        System.out.println("AgentBase: rawTransportMessageBuilder: entry");
        AgentName agentName = agentDescription.getAgentName();
        Locator[] locatorArray = agentDescription.getLocators();
        if (locatorArray.length == 0) {
            System.out.println("couldn't get valid locator out of destination description");
            return null;
        }
        Locator locator = locatorArray[0];
        AcrEnvelope acrEnvelope = new AcrEnvelope();
        acrEnvelope.setReceiver(locator);
        acrEnvelope.setSender(this.myLocator);
        String string2 = null;
        try {
            object2 = InetAddress.getLocalHost();
            object = ((InetAddress)object2).getHostName();
            string2 = agentDisplayName + "@" + (String)object;
        }
        catch (Exception exception) {
            System.out.println("Error while getting agent name.");
        }
        acrEnvelope.set("com.ibm.research.dwl.displayname", string2);
        acrEnvelope.addProperty("com.ibm.research.dwl.nestedDisplayName", new AcrString(string2));
        System.out.println(acrEnvelope);
        object2 = AcrElementHelper.newInstance();
        object = ((AcrElementHelper)object2).narrowAgentName(agentName);
        AcrAgentName acrAgentName = ((AcrElementHelper)object2).narrowAgentName(this.myAgentName);
        AclMessage aclMessage = new AclMessage();
        aclMessage.setPerformative("org.fipa.acl.inform");
        aclMessage.setSender(acrAgentName);
        aclMessage.addReceiver((AcrAgentName)object);
        aclMessage.setContent(string);
        AcrTransportMessage acrTransportMessage = new AcrTransportMessage();
        acrTransportMessage.setEnvelope(acrEnvelope);
        AcrPayload acrPayload = new AcrPayload();
        acrPayload.setMessage(aclMessage);
        acrTransportMessage.setPayload(acrPayload);
        return acrTransportMessage;
    }

    protected TransportMessage rawTransportMessageBuilder(Locator locator, AgentName agentName, String string) {
        Object object;
        Object object2;
        System.out.println("AgentBase: rawTransportMessageBuilder: entry");
        AcrEnvelope acrEnvelope = new AcrEnvelope();
        acrEnvelope.setReceiver(locator);
        acrEnvelope.setSender(this.myLocator);
        String string2 = null;
        try {
            object2 = InetAddress.getLocalHost();
            object = ((InetAddress)object2).getHostName();
            string2 = agentDisplayName + "@" + (String)object;
        }
        catch (Exception exception) {
            System.out.println("Error while getting agent name.");
        }
        acrEnvelope.set("com.ibm.research.dwl.displayname", string2);
        acrEnvelope.addProperty("com.ibm.research.dwl.nestedDisplayName", new AcrString(string2));
        System.out.println(acrEnvelope);
        object2 = AcrElementHelper.newInstance();
        object = ((AcrElementHelper)object2).narrowAgentName(agentName);
        AcrAgentName acrAgentName = ((AcrElementHelper)object2).narrowAgentName(this.myAgentName);
        AclMessage aclMessage = new AclMessage();
        aclMessage.setPerformative("org.fipa.acl.inform");
        aclMessage.setSender(acrAgentName);
        aclMessage.addReceiver((AcrAgentName)object);
        aclMessage.setContent(string);
        AcrTransportMessage acrTransportMessage = new AcrTransportMessage();
        acrTransportMessage.setEnvelope(acrEnvelope);
        AcrPayload acrPayload = new AcrPayload();
        acrPayload.setMessage(aclMessage);
        acrTransportMessage.setPayload(acrPayload);
        return acrTransportMessage;
    }

    protected AgentDescription findAgentByDisplayName(String string) throws Exception {
        AgentDescription agentDescription = this.localAgentDirectoryService.createAgentDescription();
        agentDescription.set("javax.agent.agent-display-name", string);
        System.out.println("Created search query for>" + string + "<" + agentDescription);
        AgentDescription[] agentDescriptionArray = this.localAgentDirectoryService.search(agentDescription);
        System.out.println("Submitted search query ...\n");
        return agentDescriptionArray.length == 0 ? null : agentDescriptionArray[0];
    }

    protected void sendTransportMessage(TransportMessage transportMessage) throws Exception {
        this.localMessageTransportService.sendMessage(transportMessage);
    }
}

