/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.acr;

import java.util.Enumeration;
import javax.agent.AgentName;
import javax.agent.Envelope;
import javax.agent.JasBean;
import javax.agent.JasSerializer;
import javax.agent.Locator;
import javax.agent.Payload;
import javax.agent.TransportMessage;
import org.jagent.acr.AclMessage;
import org.jagent.acr.AcrAct;
import org.jagent.acr.AcrAgentName;
import org.jagent.acr.AcrConnective;
import org.jagent.acr.AcrConstructor;
import org.jagent.acr.AcrDateTime;
import org.jagent.acr.AcrEnvelope;
import org.jagent.acr.AcrLabel;
import org.jagent.acr.AcrLocator;
import org.jagent.acr.AcrNode;
import org.jagent.acr.AcrNumber;
import org.jagent.acr.AcrObject;
import org.jagent.acr.AcrPayload;
import org.jagent.acr.AcrPredication;
import org.jagent.acr.AcrQuantifier;
import org.jagent.acr.AcrReference;
import org.jagent.acr.AcrString;
import org.jagent.acr.AcrSymbol;
import org.jagent.acr.AcrTransportMessage;
import org.jagent.acr.AcrTuple;
import org.jagent.acr.AcrVariable;

public class AcrSerializer
extends JasSerializer {
    private StringBuffer sbuff;
    private StringBuffer ibuff;
    private static final int INDENT_AMOUNT = 3;

    public AcrSerializer() {
        this.clear();
    }

    public void clear() {
        this.ibuff = new StringBuffer();
        this.sbuff = new StringBuffer();
    }

    public String toString() {
        if (this.sbuff.length() > 0) {
            this.sbuff.deleteCharAt(this.sbuff.length() - 1);
        }
        return this.sbuff.toString();
    }

    public void serializeTransportMessage(AcrTransportMessage acrTransportMessage) {
        this.header(acrTransportMessage, "transportmessage");
        acrTransportMessage.getEnvelope().acceptSerializer(this);
        acrTransportMessage.getPayload().acceptSerializer(this);
        this.footer(acrTransportMessage, "transportmessage");
    }

    public void serialize(TransportMessage transportMessage) {
        this.serializeTransportMessage((AcrTransportMessage)transportMessage);
    }

    public void serializeEnvelope(AcrEnvelope acrEnvelope) {
        this.header(acrEnvelope, "envelope");
        this.entry("receiver", (AcrLocator)acrEnvelope.getReceiver());
        this.entry("sender", (AcrLocator)acrEnvelope.getSender());
        this.footer(acrEnvelope, "envelope");
    }

    public void serialize(Envelope envelope) {
        this.serializeEnvelope((AcrEnvelope)envelope);
    }

    public void serializePayload(AcrPayload acrPayload) {
        this.header(acrPayload, "payload");
        acrPayload.getMessage().acceptSerializer(this);
        this.footer(acrPayload, "payload");
    }

    public void serialize(Payload payload) {
        this.serializePayload((AcrPayload)payload);
    }

    public void serializeAclMessage(AclMessage aclMessage) {
        this.header(aclMessage, "aclmessage");
        this.entry("performative", aclMessage.getPerformative());
        this.entry("sender", aclMessage.getSender());
        this.entry("receiver", aclMessage.getReceivers());
        this.entry("content", aclMessage.getContent());
        this.footer(aclMessage, "aclmessage");
    }

    public void serializeAct(AcrAct acrAct) {
        this.header(acrAct, "act");
        this.entry("agent", acrAct.getAgent());
        this.entry("action", acrAct.getAction());
        this.entry("patient", acrAct.getPatient());
        this.entry("instrument", acrAct.getInstrument());
        this.footer(acrAct, "act");
    }

    public void serializeDateTime(AcrDateTime acrDateTime) {
        this.header(acrDateTime, "datetime");
        this.indent().write("year   = ").write(acrDateTime.getYear()).newln();
        this.indent().write("month  = ").write(acrDateTime.getMonth()).newln();
        this.indent().write("day    = ").write(acrDateTime.getDay()).newln();
        this.indent().write("hour   = ").write(acrDateTime.getHour()).newln();
        this.indent().write("minute = ").write(acrDateTime.getMinute()).newln();
        this.indent().write("second = ").write(acrDateTime.getSecond()).newln();
        this.indent().write("millis = ").write(acrDateTime.getMillis()).newln();
        this.indent().write("zulu   ? ").write(acrDateTime.isUTC()).newln();
        this.footer(acrDateTime, "datetime");
    }

    public void serializeConnective(AcrConnective acrConnective) {
        this.header(acrConnective, "connective");
        this.entry("fqn", acrConnective.getName());
        AcrNode[] acrNodeArray = acrConnective.getArguments();
        int n = 0;
        int n2 = acrNodeArray.length;
        while (n < n2) {
            acrNodeArray[n].acceptSerializer(this);
            ++n;
        }
        this.footer(acrConnective, "connective");
    }

    public void serializeConstructor(AcrConstructor acrConstructor) {
        this.header(acrConstructor, "constructor");
        this.entry("fqn", acrConstructor.getName());
        this.entry("arg", acrConstructor.getArgument());
        this.footer(acrConstructor, "constructor");
    }

    public void serializeLabel(AcrLabel acrLabel) {
        this.header(acrLabel, "label");
        this.entry("fqn", acrLabel.getName());
        this.entry("arg", acrLabel.getArgument());
        this.footer(acrLabel, "label");
    }

    public void serializeLocator(AcrLocator acrLocator) {
        this.header(acrLocator, "locator");
        this.entry("type", acrLocator.getType());
        this.entry("address", acrLocator.getAddress());
        this.footer(acrLocator, "locator");
    }

    public void serialize(Locator locator) {
        this.serializeLocator((AcrLocator)locator);
    }

    public void serializeObject(AcrObject acrObject) {
        this.header(acrObject, "object");
        this.entry("string", acrObject.getObject().toString());
        this.footer(acrObject, "object");
    }

    public void serializePredication(AcrPredication acrPredication) {
        this.header(acrPredication, "predication");
        this.entry("fqn", acrPredication.getName());
        this.entry("arg", acrPredication.getArgument());
        this.footer(acrPredication, "predication");
    }

    public void serializeQuantifier(AcrQuantifier acrQuantifier) {
        this.header(acrQuantifier, "quantifier");
        this.entry("fqn", acrQuantifier.getName());
        acrQuantifier.getVariable().acceptSerializer(this);
        acrQuantifier.getNode().acceptSerializer(this);
        this.footer(acrQuantifier, "quantifier");
    }

    public void serializeAgentName(AcrAgentName acrAgentName) {
        this.entry(acrAgentName, "agentname", acrAgentName.getName());
    }

    public void serialize(AgentName agentName) {
        this.serializeAgentName((AcrAgentName)agentName);
    }

    public void serializeNumber(AcrNumber acrNumber) {
        this.entry(acrNumber, "number", acrNumber.getNumber());
    }

    public void serializeString(AcrString acrString) {
        this.entry(acrString, "string", acrString.getString());
    }

    public void serializeSymbol(AcrSymbol acrSymbol) {
        this.entry(acrSymbol, "symbol", acrSymbol.getSymbol());
    }

    public void serializeVariable(AcrVariable acrVariable) {
        this.entry(acrVariable, "variable", acrVariable.getVariable());
    }

    public void serializeReference(AcrReference acrReference) {
        this.entry(acrReference, "reference", acrReference.getReference());
    }

    public void serializeTuple(AcrTuple acrTuple) {
        this.header(acrTuple, "tuple");
        AcrNode[] acrNodeArray = acrTuple.getTupleElements();
        int n = 0;
        int n2 = acrNodeArray.length;
        while (n < n2) {
            acrNodeArray[n].acceptSerializer(this);
            ++n;
        }
        this.footer(acrTuple, "tuple");
    }

    protected void listProperties(AcrNode acrNode) {
        if (acrNode.containsKey("jas.acr.node-properties")) {
            this.header("properties");
            JasBean jasBean = acrNode.getProperties();
            Enumeration enumeration = jasBean.keys();
            while (enumeration.hasMoreElements()) {
                this.header("property");
                String string = (String)enumeration.nextElement();
                AcrNode acrNode2 = (AcrNode)jasBean.get(string);
                this.entry("fqn", string);
                acrNode2.acceptSerializer(this);
                this.footer("property");
            }
            this.footer("properties");
        }
    }

    protected void entry(String string, String string2) {
        this.indent().open().write(string).separator().write(" ");
        this.write(string2).close().newln();
    }

    protected void entry(AcrNode acrNode, String string, String string2) {
        this.indent().open().write(string).separator();
        if (acrNode.containsKey("jas.acr.node-properties")) {
            this.newln();
            this.pushIndent();
            this.listProperties(acrNode);
            this.indent().write(string2).newln();
            this.popIndent();
            this.indent();
        } else {
            this.write(" ").write(string2);
        }
        this.close().newln();
    }

    protected void entry(String string, AcrNode acrNode) {
        this.header(string);
        acrNode.acceptSerializer(this);
        this.footer(string);
    }

    protected void entry(String string, AcrAgentName[] acrAgentNameArray) {
        this.header(string);
        int n = 0;
        int n2 = acrAgentNameArray.length;
        while (n < n2) {
            acrAgentNameArray[n].acceptSerializer(this);
            ++n;
        }
        this.footer(string);
    }

    protected void header(String string) {
        this.indent().open().write(string).separator().newln();
        this.pushIndent();
    }

    protected void header(AcrNode acrNode, String string) {
        this.header(string);
        this.listProperties(acrNode);
    }

    protected void footer(String string) {
        this.popIndent();
        this.indent().close().newln();
    }

    protected void footer(AcrNode acrNode, String string) {
        this.footer(string);
    }

    protected void pushIndent() {
        int n = 0;
        while (n < 3) {
            this.ibuff.append(' ');
            ++n;
        }
    }

    protected void popIndent() {
        int n = this.ibuff.length();
        if (n == 3) {
            this.ibuff.delete(0, n);
        } else {
            this.ibuff.delete(n - 1 - 3, n - 1);
        }
    }

    protected AcrSerializer newln() {
        this.write("\n");
        return this;
    }

    protected AcrSerializer write(boolean bl) {
        this.sbuff.append(bl);
        return this;
    }

    protected AcrSerializer write(int n) {
        this.sbuff.append(n);
        return this;
    }

    protected AcrSerializer write(Object object) {
        this.sbuff.append(object);
        return this;
    }

    protected AcrSerializer indent() {
        this.write(this.ibuff);
        return this;
    }

    protected AcrSerializer open() {
        this.write("[");
        return this;
    }

    protected AcrSerializer close() {
        this.write("]");
        return this;
    }

    protected AcrSerializer separator() {
        this.write(":");
        return this;
    }
}

