/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.acr;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.jagent.acr.AcrNode;
import org.jagent.acr.AcrSerializer;

public class AcrDateTime
extends AcrNode {
    private GregorianCalendar datetime;
    private boolean usesUTC;

    public AcrDateTime() {
        this(false);
    }

    public AcrDateTime(boolean bl) {
        this.datetime = bl ? new GregorianCalendar(TimeZone.getTimeZone("UTC")) : new GregorianCalendar();
        this.usesUTC = bl;
    }

    public void set(int n) {
        this.set(n, 0, 0, 0, 0, 0, 0);
    }

    public void set(int n, int n2) {
        this.set(n, n2, 0, 0, 0, 0, 0);
    }

    public void set(int n, int n2, int n3) {
        this.set(n, n2, n3, 0, 0, 0, 0);
    }

    public void set(int n, int n2, int n3, int n4) {
        this.set(n, n2, n3, n4, 0, 0, 0);
    }

    public void set(int n, int n2, int n3, int n4, int n5) {
        this.set(n, n2, n3, n4, n5, 0, 0);
    }

    public void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.set(n, n2, n3, n4, n5, n6, 0);
    }

    public void set(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.datetime.clear();
        this.datetime.set(n, n2, n3, n4, n5, n6);
        this.datetime.set(14, n7);
    }

    public int getYear() {
        return this.datetime.get(1);
    }

    public int getMonth() {
        return this.datetime.get(2);
    }

    public int getDay() {
        return this.datetime.get(5);
    }

    public int getHour() {
        return this.datetime.get(10);
    }

    public int getMinute() {
        return this.datetime.get(12);
    }

    public int getSecond() {
        return this.datetime.get(13);
    }

    public int getMillis() {
        return this.datetime.get(14);
    }

    public boolean isUTC() {
        return this.usesUTC;
    }

    public long getTime() {
        return this.datetime.getTime().getTime();
    }

    public int compareTo(AcrDateTime acrDateTime) {
        return this.datetime.getTime().compareTo(acrDateTime.datetime.getTime());
    }

    public int compareTo(Object object) {
        return this.compareTo((AcrDateTime)object);
    }

    public static AcrDateTime parse(String string) {
        int n = Integer.parseInt(string.substring(0, 4));
        int n2 = Integer.parseInt(string.substring(4, 2));
        int n3 = Integer.parseInt(string.substring(6, 2));
        int n4 = Integer.parseInt(string.substring(9, 2));
        int n5 = Integer.parseInt(string.substring(11, 2));
        int n6 = Integer.parseInt(string.substring(13, 2));
        int n7 = Integer.parseInt(string.substring(15, 3));
        boolean bl = false;
        if (!Character.isDigit(string.charAt(string.length() - 1))) {
            bl = true;
        }
        AcrDateTime acrDateTime = new AcrDateTime(bl);
        acrDateTime.set(n, n2, n3, n4, n5, n6, n7);
        return acrDateTime;
    }

    public int hashCode() {
        return this.datetime.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AcrDateTime)) {
            return false;
        }
        AcrDateTime acrDateTime = (AcrDateTime)object;
        return this.isUTC() == acrDateTime.isUTC() && this.datetime.equals(acrDateTime.datetime);
    }

    public void acceptSerializer(AcrSerializer acrSerializer) {
        acrSerializer.serializeDateTime(this);
    }
}

