/*
 * Decompiled with CFR 0.152.
 */
package org.jagent.acr;

import java.util.ArrayList;
import java.util.List;
import org.jagent.acr.AcrAgentName;
import org.jagent.acr.AcrDateTime;
import org.jagent.acr.AcrNode;
import org.jagent.acr.AcrSerializer;
import org.jagent.acr.AcrString;
import org.jagent.acr.FipaAclPerformative;

public final class AclMessage
extends AcrNode {
    public AclMessage() {
    }

    public AclMessage(String string) {
        this.setPerformative(string);
    }

    public void setPerformative(String string) {
        if (!FipaAclPerformative.isValidPerformative(string)) {
            throw new IllegalArgumentException("Non conforment action type.");
        }
        this.set("org.fipa.acl.performative", string);
    }

    public String getPerformative() {
        return (String)this.get("org.fipa.acl.performative");
    }

    public void setSender(AcrAgentName acrAgentName) {
        this.set("org.fipa.acl.sender", acrAgentName);
    }

    public AcrAgentName getSender() {
        return (AcrAgentName)this.get("org.fipa.acl.sender");
    }

    public void addReceiver(AcrAgentName acrAgentName) {
        this.check(acrAgentName);
        if (!this.containsKey("org.fipa.acl.receiver")) {
            this.set("org.fipa.acl.receiver", new ArrayList());
        }
        List list = (List)this.get("org.fipa.acl.receiver");
        list.add(acrAgentName);
    }

    public void setReceivers(AcrAgentName[] acrAgentNameArray) {
        this.check(acrAgentNameArray);
        if (!this.containsKey("org.fipa.acl.receiver")) {
            this.set("org.fipa.acl.receiver", new ArrayList());
        }
        List list = (List)this.get("org.fipa.acl.receiver");
        list.clear();
        int n = 0;
        int n2 = acrAgentNameArray.length;
        while (n < n2) {
            list.add(this.check(acrAgentNameArray[n]));
            ++n;
        }
    }

    public AcrAgentName[] getReceivers() {
        if (!this.containsKey("org.fipa.acl.receiver")) {
            return new AcrAgentName[0];
        }
        List list = (List)this.get("org.fipa.acl.receiver");
        return list.toArray(new AcrAgentName[0]);
    }

    public void setContent(String string) {
        this.setContent(new AcrString(string));
    }

    public void setContent(AcrNode acrNode) {
        this.set("org.fipa.acl.content", acrNode);
    }

    public AcrNode getContent() {
        return (AcrNode)this.get("org.fipa.acl.content");
    }

    public void setReplyTo(AcrAgentName acrAgentName) {
        this.check(acrAgentName);
        this.addProperty("org.fipa.acl.reply-to", acrAgentName);
    }

    public AcrAgentName getReplyTo() {
        return (AcrAgentName)this.getPropertyByName("org.fipa.acl.reply-to");
    }

    public void setLanguage(AcrNode acrNode) {
        this.check(acrNode);
        this.addProperty("org.fipa.acl.language", acrNode);
    }

    public AcrNode getLanguage() {
        return this.getPropertyByName("org.fipa.acl.language");
    }

    public void setOntology(AcrNode acrNode) {
        this.check(acrNode);
        this.addProperty("org.fipa.acl.ontology", acrNode);
    }

    public AcrNode getOntology() {
        return this.getPropertyByName("org.fipa.acl.ontology");
    }

    public void setEncoding(AcrNode acrNode) {
        this.check(acrNode);
        this.addProperty("org.fipa.acl.encoding", acrNode);
    }

    public AcrNode getEncoding() {
        return this.getPropertyByName("org.fipa.acl.encoding");
    }

    public void setConversationID(AcrNode acrNode) {
        this.check(acrNode);
        this.addProperty("org.fipa.acl.conversation-id", acrNode);
    }

    public AcrNode getConversationID() {
        return this.getPropertyByName("org.fipa.acl.conversation-id");
    }

    public void setReplyWith(AcrNode acrNode) {
        this.check(acrNode);
        this.addProperty("org.fipa.acl.reply-with", acrNode);
    }

    public AcrNode getReplyWith() {
        return this.getPropertyByName("org.fipa.acl.reply-with");
    }

    public void setInReplyTo(AcrNode acrNode) {
        this.check(acrNode);
        this.addProperty("org.fipa.acl.in-reply-to", acrNode);
    }

    public AcrNode getInReplyTo() {
        return this.getPropertyByName("org.fipa.acl.in-reply-to");
    }

    public void setProtocol(AcrNode acrNode) {
        this.check(acrNode);
        this.addProperty("org.fipa.acl.protocol", acrNode);
    }

    public AcrNode getProtocol() {
        return this.getPropertyByName("org.fipa.acl.protocol");
    }

    public void setReplyBy(AcrDateTime acrDateTime) {
        this.check(acrDateTime);
        this.addProperty("org.fipa.acl.reply-by", acrDateTime);
    }

    public AcrDateTime getReplyBy() {
        return (AcrDateTime)this.getPropertyByName("org.fipa.acl.reply-by");
    }

    public void acceptSerializer(AcrSerializer acrSerializer) {
        acrSerializer.serializeAclMessage(this);
    }
}

