/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.statistics;

import com.ibm.able.statistics.AbleProbabilityDistribution;
import java.io.Serializable;

public class AbleExponentialDistribution
extends AbleProbabilityDistribution
implements Serializable {
    static final long serialVersionUID = -1310461563639667387L;
    private double mu;
    private double meanVal;

    public AbleExponentialDistribution() {
    }

    public AbleExponentialDistribution(double d) {
        this.meanVal = d;
        this.mu = 1.0 / d;
    }

    public AbleExponentialDistribution(double d, long l) {
        this.meanVal = d;
        this.mu = 1.0 / d;
        if (l != 0L) {
            this.random.setSeed(l);
        }
    }

    public void changeRate(double d) {
        this.meanVal = d;
        this.mu = 1.0 / d;
    }

    public double next() {
        return -this.meanVal * Math.log(this.random.nextDouble());
    }

    public double mean() {
        return this.meanVal;
    }

    public double variance() {
        return 1.0 / (this.mu * this.mu);
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

