/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataContext;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleLhs;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleReferences;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.BitSet;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class AbleVariable
extends AbleLhs
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static String clsNm = "AbleVariable";
    protected int myDataType = 0;
    protected int myId = 0;
    protected String myName = "";
    protected AbleDataContext myContext = null;
    protected AbleReferences myReferences = null;
    protected PropertyChangeSupport myChgSupport = null;
    protected boolean myStaticFlag = false;
    protected boolean myGlobalFlag = true;
    protected AbleRd myValueInitial;
    protected String myComment = "";
    protected String myPrompt = null;
    protected boolean myTemplateFlag = false;
    protected boolean myBoundFlag = false;

    protected AbleVariable(int n, String string) {
        this.myDataType = n;
        this.myName = string;
    }

    protected AbleVariable(int n, String string, boolean bl, boolean bl2) {
        this.myDataType = n;
        this.myName = string;
        this.myStaticFlag = bl;
        this.myGlobalFlag = bl2;
    }

    public int getReferent() {
        return this.myId;
    }

    public BitSet getReferents() {
        BitSet bitSet = new BitSet();
        bitSet.set(this.myId);
        return bitSet;
    }

    public int getDataType() {
        return this.myDataType;
    }

    public String arlCRdString() {
        return this.myName;
    }

    public String xmlCRdString() {
        String string = "";
        string = string + "<variableValue varRef=\"" + this.myName + "\"/>";
        return string;
    }

    public String armlCRdString() {
        String string = "      ";
        string = string + "<variableReference varRef=\"" + this.myName + "\"/>" + Able.LS;
        return string;
    }

    public abstract String traceString(int var1);

    public abstract String arlDclString();

    public String getTemplateString(Vector vector) {
        int n = -1;
        n = vector.indexOf(this);
        if (n > 0) {
            return "{" + n + "}";
        }
        return this.arlCRdString();
    }

    public abstract String xmlDclString();

    public abstract String armlDclString();

    public String xmlCWrString() {
        String string = "";
        string = string + "<variableReference varRef=\"" + this.myName + "\"/>";
        return string;
    }

    public String xmlInitializerString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myValueInitial == null) {
            return "";
        }
        stringBuffer.append("        <varInitializer>" + Able.LS);
        stringBuffer.append("          " + this.myValueInitial.xmlCRdString() + Able.LS);
        stringBuffer.append("        </varInitializer>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlInitializerString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myValueInitial == null) {
            return "";
        }
        String string = this.myValueInitial.arlCRdString();
        if (string.length() > 0) {
            stringBuffer.append("        <varInitializer>" + string + "</varInitializer>" + Able.LS);
        }
        return stringBuffer.toString();
    }

    public String arlInitializerString() {
        return this.myValueInitial.arlCRdString();
    }

    public abstract void setValueString(String var1) throws AbleDataException;

    public abstract String getValueString();

    public abstract void init() throws AbleDataException;

    public abstract void reset() throws AbleDataException;

    public abstract Class getLiteralClass();

    public String getDataTypeAsString() {
        return AbleData.DataType(this.myDataType);
    }

    public abstract String getDataTypeName();

    public void setId(int n) {
        this.myId = n;
    }

    public int getId() {
        return this.myId;
    }

    public String getName() {
        return this.myName;
    }

    public void setContext(AbleDataContext ableDataContext) {
        this.myContext = ableDataContext;
    }

    public AbleDataContext getContext() {
        return this.myContext;
    }

    public void setComment(String string) {
        this.myComment = string;
    }

    public String getComment() {
        return this.myComment;
    }

    public String getArlComment() {
        if (this.myComment == null || this.myComment.length() == 0) {
            return "";
        }
        return "/** " + this.myComment + " */";
    }

    public void setPrompt(String string) {
        this.myPrompt = string;
    }

    public String getPrompt() {
        return this.myPrompt;
    }

    public String getPromptString() {
        String string = null;
        if (this.myContext != null) {
            ResourceBundle resourceBundle = this.myContext.getResourceBundle();
            string = resourceBundle == null ? (this.myPrompt == null || this.myPrompt.length() == 0 ? "Select a value for " + this.myName : this.myPrompt) : (this.myPrompt == null || this.myPrompt.length() == 0 ? resourceBundle.getString(this.myName) : resourceBundle.getString(this.myPrompt));
        }
        return string;
    }

    public void setChgSupport(PropertyChangeSupport propertyChangeSupport) {
        this.myChgSupport = propertyChangeSupport;
    }

    public Object getChgSupport() {
        return this.myChgSupport;
    }

    public void setReferences(AbleReferences ableReferences) {
        this.myReferences = ableReferences;
    }

    public AbleReferences getReferences() {
        return this.myReferences;
    }

    public void setStatic(boolean bl) {
        this.myStaticFlag = bl;
    }

    public boolean isStatic() {
        return this.myStaticFlag;
    }

    public boolean notStatic() {
        return !this.myStaticFlag;
    }

    public boolean isGlobal() {
        return this.myGlobalFlag;
    }

    public boolean isLocal() {
        return !this.myGlobalFlag;
    }

    public boolean isBound() {
        return this.myBoundFlag;
    }

    public boolean isConstant() {
        return false;
    }

    public void setInitialValue(AbleRd ableRd) throws AbleDataException {
        this.myValueInitial = ableRd;
        this.init();
    }

    public void setTemplate(boolean bl) {
        this.myTemplateFlag = bl;
    }

    public boolean isTemplate() {
        return this.myTemplateFlag;
    }

    public String toString() {
        return this.arlDclString();
    }
}

