/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.AbleClearable;
import com.ibm.able.data.AbleBooleanLiteral;
import com.ibm.able.data.AbleByteLiteral;
import com.ibm.able.data.AbleCharacterLiteral;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleDoubleLiteral;
import com.ibm.able.data.AbleFloatLiteral;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleGenericLiteral;
import com.ibm.able.data.AbleIntegerLiteral;
import com.ibm.able.data.AbleLhs;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleLongLiteral;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleShortLiteral;
import com.ibm.able.data.AbleStringLiteral;
import com.ibm.able.data.AbleTypedVariable;
import com.ibm.able.rules.AbleParException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Vector;

public class AbleTypedVariableField
extends AbleLhs
implements AbleClearable,
Serializable {
    static final long serialVersionUID = 2001030200000000001L;
    static String clsNm = "AbleTypedVariableField";
    protected int myDataType = 21;
    protected AbleTypedVariable myTypedVariable = null;
    protected transient Field myField = null;
    protected String myFieldName = "";
    protected boolean myGetDirectFlag = false;
    protected transient Method myGetMethod = null;
    protected boolean mySetDirectFlag = false;
    protected transient Method mySetMethod = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public AbleTypedVariableField(AbleTypedVariable ableTypedVariable, Field field, boolean bl, Method method, boolean bl2, Method method2) {
        this.myTypedVariable = ableTypedVariable;
        this.myField = field;
        this.myFieldName = field.getName();
        this.myGetDirectFlag = bl;
        this.myGetMethod = method;
        this.mySetDirectFlag = bl2;
        this.mySetMethod = method2;
    }

    public AbleTypedVariableField(AbleTypedVariable ableTypedVariable, AbleTypedVariableField ableTypedVariableField) {
        this(ableTypedVariable, ableTypedVariableField.myField, ableTypedVariableField.myGetDirectFlag, ableTypedVariableField.myGetMethod, ableTypedVariableField.mySetDirectFlag, ableTypedVariableField.mySetMethod);
    }

    public AbleTypedVariableField(AbleTypedVariable ableTypedVariable, String string) throws AbleParException {
        this.myTypedVariable = ableTypedVariable;
        this.myFieldName = string;
        this.resolveFieldAndMethods();
    }

    private void resolveFieldAndMethods() throws AbleParException {
        Class clazz = this.myTypedVariable.getDataTypeClass();
        this.myField = this.discoverField(clazz, this.myFieldName);
        if (this.myField == null) {
            throw new AbleParException(Able.NlsMsg("Ex_RsInvalidFieldRef", new Object[]{this.myFieldName, this.myTypedVariable.getName(), clazz.getName()}));
        }
        try {
            this.myField.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Method[] methodArray = this.discoverMethods(clazz, this.myField);
        this.myGetMethod = methodArray[0];
        this.myGetDirectFlag = this.myGetMethod == null;
        this.mySetMethod = methodArray[1];
        this.mySetDirectFlag = this.mySetMethod == null;
    }

    public boolean getBooleanValue() throws AbleDataException {
        return (Boolean)this.getFieldValue();
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromFuzzy", new Object[]{Integer.toString(0), this.myTypedVariable.getName() + "." + this.myField.getName(), clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        return this.getFieldValue();
    }

    public double getNumericValue() throws AbleDataException {
        Object object = this.getFieldValue();
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof Short) {
            return ((Short)object).doubleValue();
        }
        if (object instanceof Long) {
            return ((Long)object).doubleValue();
        }
        if (object instanceof Byte) {
            return ((Byte)object).doubleValue();
        }
        if (object instanceof Long) {
            return ((Character)object).charValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object == Boolean.TRUE ? 1.0 : 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return this.getValue().getNumericValue();
    }

    public String getStringValue() throws AbleDataException {
        return this.getFieldValue().toString();
    }

    public AbleLiteral getValue() throws AbleDataException {
        Object object = this.getFieldValue();
        if (object != null) {
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    return AbleBooleanLiteral.TRUE;
                }
                return AbleBooleanLiteral.FALSE;
            }
            if (object instanceof String) {
                return new AbleStringLiteral((String)object);
            }
            if (object instanceof Integer) {
                return new AbleIntegerLiteral((Integer)object);
            }
            if (object instanceof Double) {
                return new AbleDoubleLiteral((Double)object);
            }
            if (object instanceof Float) {
                return new AbleFloatLiteral(((Float)object).floatValue());
            }
            if (object instanceof Long) {
                return new AbleLongLiteral((Long)object);
            }
            if (object instanceof Short) {
                return new AbleShortLiteral((Short)object);
            }
            if (object instanceof Byte) {
                return new AbleByteLiteral((Byte)object);
            }
            if (object instanceof Character) {
                return new AbleCharacterLiteral(((Character)object).charValue());
            }
            if (object instanceof Number) {
                return new AbleDoubleLiteral(((Number)object).doubleValue());
            }
            if (object instanceof Object) {
                return new AbleGenericLiteral(object);
            }
            throw new AbleDataException(Able.NlsMsg("Ex_UnsupportedResultType", new Object[]{object}));
        }
        return new AbleGenericLiteral(object);
    }

    public int getReferent() {
        return this.myTypedVariable.getReferent();
    }

    public BitSet getReferents() {
        BitSet bitSet = new BitSet();
        bitSet.set(this.getReferent());
        return bitSet;
    }

    public int getDataType() {
        return this.myDataType;
    }

    public String arlCRdString() {
        return this.myTypedVariable.getName() + "." + this.myFieldName;
    }

    public String xmlCRdString() {
        return "<fieldValue varRef=\"" + this.myTypedVariable.getName() + "\" fieldName=\"" + this.myFieldName + "\"/>";
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        Object object = this.getFieldValue();
        if (object != null) {
            if (object instanceof String) {
                return ((String)object).equals(ableRd.getStringValue());
            }
            if (object instanceof Boolean) {
                return ((Boolean)object).booleanValue() == ableRd.getBooleanValue();
            }
            if (object instanceof Integer) {
                return ((Integer)object).doubleValue() == ableRd.getNumericValue();
            }
            if (object instanceof Double) {
                return ((Double)object).doubleValue() == ableRd.getNumericValue();
            }
            if (object instanceof Float) {
                return ((Float)object).doubleValue() == ableRd.getNumericValue();
            }
            if (object instanceof Long) {
                return ((Long)object).doubleValue() == ableRd.getNumericValue();
            }
            if (object instanceof Short) {
                return ((Short)object).doubleValue() == ableRd.getNumericValue();
            }
            if (object instanceof Byte) {
                return ((Byte)object).doubleValue() == ableRd.getNumericValue();
            }
            if (object instanceof Character) {
                return ((Character)object).charValue() == (char)ableRd.getNumericValue();
            }
            if (object instanceof Number) {
                return ((Number)object).doubleValue() == ableRd.getNumericValue();
            }
        }
        return this.getValue().cmpEq(ableRd);
    }

    public boolean cmpGt(AbleRd ableRd) throws AbleDataException {
        Object object = this.getFieldValue();
        if (object != null) {
            if (object instanceof Integer) {
                return ((Integer)object).doubleValue() > ableRd.getNumericValue();
            }
            if (object instanceof Double) {
                return (Double)object > ableRd.getNumericValue();
            }
            if (object instanceof Float) {
                return ((Float)object).doubleValue() > ableRd.getNumericValue();
            }
            if (object instanceof Long) {
                return ((Long)object).doubleValue() > ableRd.getNumericValue();
            }
            if (object instanceof Short) {
                return ((Short)object).doubleValue() > ableRd.getNumericValue();
            }
            if (object instanceof Byte) {
                return ((Byte)object).doubleValue() > ableRd.getNumericValue();
            }
            if (object instanceof Character) {
                return ((Character)object).charValue() > (char)ableRd.getNumericValue();
            }
            if (object instanceof Number) {
                return ((Number)object).doubleValue() > ableRd.getNumericValue();
            }
        }
        return this.getValue().cmpGt(ableRd);
    }

    public boolean cmpGtEq(AbleRd ableRd) throws AbleDataException {
        Object object = this.getFieldValue();
        if (object != null) {
            if (object instanceof Integer) {
                return ((Integer)object).doubleValue() >= ableRd.getNumericValue();
            }
            if (object instanceof Double) {
                return (Double)object >= ableRd.getNumericValue();
            }
            if (object instanceof Float) {
                return ((Float)object).doubleValue() >= ableRd.getNumericValue();
            }
            if (object instanceof Long) {
                return ((Long)object).doubleValue() >= ableRd.getNumericValue();
            }
            if (object instanceof Short) {
                return ((Short)object).doubleValue() >= ableRd.getNumericValue();
            }
            if (object instanceof Byte) {
                return ((Byte)object).doubleValue() >= ableRd.getNumericValue();
            }
            if (object instanceof Character) {
                return ((Character)object).charValue() >= (char)ableRd.getNumericValue();
            }
            if (object instanceof Number) {
                return ((Number)object).doubleValue() >= ableRd.getNumericValue();
            }
        }
        return this.getValue().cmpGtEq(ableRd);
    }

    public boolean cmpLt(AbleRd ableRd) throws AbleDataException {
        Object object = this.getFieldValue();
        if (object != null) {
            if (object instanceof Integer) {
                return ((Integer)object).doubleValue() < ableRd.getNumericValue();
            }
            if (object instanceof Double) {
                return (Double)object < ableRd.getNumericValue();
            }
            if (object instanceof Float) {
                return ((Float)object).doubleValue() < ableRd.getNumericValue();
            }
            if (object instanceof Long) {
                return ((Long)object).doubleValue() < ableRd.getNumericValue();
            }
            if (object instanceof Short) {
                return ((Short)object).doubleValue() < ableRd.getNumericValue();
            }
            if (object instanceof Byte) {
                return ((Byte)object).doubleValue() < ableRd.getNumericValue();
            }
            if (object instanceof Character) {
                return ((Character)object).charValue() < (char)ableRd.getNumericValue();
            }
            if (object instanceof Number) {
                return ((Number)object).doubleValue() < ableRd.getNumericValue();
            }
        }
        return this.getValue().cmpLt(ableRd);
    }

    public boolean cmpLtEq(AbleRd ableRd) throws AbleDataException {
        Object object = this.getFieldValue();
        if (object != null) {
            if (object instanceof Integer) {
                return ((Integer)object).doubleValue() <= ableRd.getNumericValue();
            }
            if (object instanceof Double) {
                return (Double)object <= ableRd.getNumericValue();
            }
            if (object instanceof Float) {
                return ((Float)object).doubleValue() <= ableRd.getNumericValue();
            }
            if (object instanceof Long) {
                return ((Long)object).doubleValue() <= ableRd.getNumericValue();
            }
            if (object instanceof Short) {
                return ((Short)object).doubleValue() <= ableRd.getNumericValue();
            }
            if (object instanceof Byte) {
                return ((Byte)object).doubleValue() <= ableRd.getNumericValue();
            }
            if (object instanceof Character) {
                return ((Character)object).charValue() <= (char)ableRd.getNumericValue();
            }
            if (object instanceof Number) {
                return ((Number)object).doubleValue() <= ableRd.getNumericValue();
            }
        }
        return this.getValue().cmpLtEq(ableRd);
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        Object object = this.getFieldValue();
        if (object != null) {
            if (object instanceof String) {
                return !((String)object).equals(ableRd.getStringValue());
            }
            if (object instanceof Boolean) {
                return ((Boolean)object).booleanValue() != ableRd.getBooleanValue();
            }
            if (object instanceof Integer) {
                return ((Integer)object).doubleValue() != ableRd.getNumericValue();
            }
            if (object instanceof Double) {
                return ((Double)object).doubleValue() != ableRd.getNumericValue();
            }
            if (object instanceof Float) {
                return ((Float)object).doubleValue() != ableRd.getNumericValue();
            }
            if (object instanceof Long) {
                return ((Long)object).doubleValue() != ableRd.getNumericValue();
            }
            if (object instanceof Short) {
                return ((Short)object).doubleValue() != ableRd.getNumericValue();
            }
            if (object instanceof Byte) {
                return ((Byte)object).doubleValue() != ableRd.getNumericValue();
            }
            if (object instanceof Character) {
                return ((Character)object).charValue() != (char)ableRd.getNumericValue();
            }
            if (object instanceof Number) {
                return ((Number)object).doubleValue() != ableRd.getNumericValue();
            }
        }
        return this.getValue().cmpNeq(ableRd);
    }

    public AbleLiteral compPlus(AbleRd ableRd) throws AbleDataException {
        Object object = this.getFieldValue();
        if (object != null) {
            if (object instanceof Integer) {
                return new AbleIntegerLiteral((Integer)object + (int)ableRd.getNumericValue());
            }
            if (object instanceof Double) {
                return new AbleDoubleLiteral((Double)object + ableRd.getNumericValue());
            }
            if (object instanceof Float) {
                return new AbleFloatLiteral(((Float)object).floatValue() + (float)ableRd.getNumericValue());
            }
            if (object instanceof Long) {
                return new AbleLongLiteral((Long)object + (long)ableRd.getNumericValue());
            }
            if (object instanceof Short) {
                return new AbleShortLiteral((Short)object + (short)ableRd.getNumericValue());
            }
            if (object instanceof Byte) {
                return new AbleByteLiteral((Byte)object + (byte)ableRd.getNumericValue());
            }
        }
        return this.getValue().compPlus(ableRd);
    }

    public AbleLiteral compMinus(AbleRd ableRd) throws AbleDataException {
        Object object = this.getFieldValue();
        if (object != null) {
            if (object instanceof Integer) {
                return new AbleIntegerLiteral((Integer)object - (int)ableRd.getNumericValue());
            }
            if (object instanceof Double) {
                return new AbleDoubleLiteral((Double)object - ableRd.getNumericValue());
            }
            if (object instanceof Float) {
                return new AbleFloatLiteral(((Float)object).floatValue() - (float)ableRd.getNumericValue());
            }
            if (object instanceof Long) {
                return new AbleLongLiteral((Long)object - (long)ableRd.getNumericValue());
            }
            if (object instanceof Short) {
                return new AbleShortLiteral((Short)object - (short)ableRd.getNumericValue());
            }
            if (object instanceof Byte) {
                return new AbleByteLiteral((Byte)object - (byte)ableRd.getNumericValue());
            }
        }
        return this.getValue().compMinus(ableRd);
    }

    public AbleLiteral compMultiply(AbleRd ableRd) throws AbleDataException {
        Object object = this.getFieldValue();
        if (object != null) {
            if (object instanceof Integer) {
                return new AbleIntegerLiteral((Integer)object * (int)ableRd.getNumericValue());
            }
            if (object instanceof Double) {
                return new AbleDoubleLiteral((Double)object * ableRd.getNumericValue());
            }
            if (object instanceof Float) {
                return new AbleFloatLiteral(((Float)object).floatValue() * (float)ableRd.getNumericValue());
            }
            if (object instanceof Long) {
                return new AbleLongLiteral((Long)object * (long)ableRd.getNumericValue());
            }
            if (object instanceof Short) {
                return new AbleShortLiteral((Short)object * (short)ableRd.getNumericValue());
            }
            if (object instanceof Byte) {
                return new AbleByteLiteral((Byte)object * (byte)ableRd.getNumericValue());
            }
        }
        return this.getValue().compMultiply(ableRd);
    }

    public AbleLiteral compDivide(AbleRd ableRd) throws AbleDataException {
        Object object = this.getFieldValue();
        if (object != null) {
            if (object instanceof Integer) {
                return new AbleIntegerLiteral((Integer)object / (int)ableRd.getNumericValue());
            }
            if (object instanceof Double) {
                return new AbleDoubleLiteral((Double)object / ableRd.getNumericValue());
            }
            if (object instanceof Float) {
                return new AbleFloatLiteral(((Float)object).floatValue() / (float)ableRd.getNumericValue());
            }
            if (object instanceof Long) {
                return new AbleLongLiteral((Long)object / (long)ableRd.getNumericValue());
            }
            if (object instanceof Short) {
                return new AbleShortLiteral((Short)object / (short)ableRd.getNumericValue());
            }
            if (object instanceof Byte) {
                return new AbleByteLiteral((Byte)object / (byte)ableRd.getNumericValue());
            }
        }
        return this.getValue().compDivide(ableRd);
    }

    public AbleLiteral compModulo(AbleRd ableRd) throws AbleDataException {
        return this.getValue().compModulo(ableRd);
    }

    public boolean logicalAND(AbleRd ableRd) throws AbleDataException {
        return this.getBooleanValue() && ableRd.getBooleanValue();
    }

    public boolean logicalOR(AbleRd ableRd) throws AbleDataException {
        return this.getBooleanValue() || ableRd.getBooleanValue();
    }

    public boolean logicalNOT(AbleRd ableRd) throws AbleDataException {
        return !this.getBooleanValue();
    }

    public AbleLiteral bitwiseAND(AbleRd ableRd) throws AbleDataException {
        return this.getValue().bitwiseAND(ableRd);
    }

    public AbleLiteral bitwiseOR(AbleRd ableRd) throws AbleDataException {
        return this.getValue().bitwiseOR(ableRd);
    }

    public AbleLiteral bitwiseXOR(AbleRd ableRd) throws AbleDataException {
        return this.getValue().bitwiseXOR(ableRd);
    }

    public AbleLiteral bitwiseNOT(AbleRd ableRd) throws AbleDataException {
        return this.getValue().bitwiseNOT(ableRd);
    }

    public AbleLiteral bitwiseShiftLeft(AbleRd ableRd) throws AbleDataException {
        return this.getValue().bitwiseShiftLeft(ableRd);
    }

    public AbleLiteral bitwiseShiftRight(AbleRd ableRd) throws AbleDataException {
        return this.getValue().bitwiseShiftRight(ableRd);
    }

    public AbleLiteral bitwiseShiftRightZeroFill(AbleRd ableRd) throws AbleDataException {
        return this.getValue().bitwiseShiftRightZeroFill(ableRd);
    }

    public void setBooleanValue(boolean bl) throws AbleDataException {
        this.setValue(bl ? AbleBooleanLiteral.TRUE : AbleBooleanLiteral.FALSE);
    }

    public void setFuzzyValue(AbleFuzzySet ableFuzzySet) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromFuzzy", new Object[]{Integer.toString(0), this.myTypedVariable.getName() + "." + this.myField.getName(), clsNm}));
    }

    public void setGenericValue(Object object) throws AbleDataException {
        this.setValue(new AbleGenericLiteral(object));
    }

    public void setNumericValue(double d) throws AbleDataException {
        this.setValue(new AbleDoubleLiteral(d));
    }

    public void setStringValue(String string) throws AbleDataException {
        this.setValue(new AbleStringLiteral(string));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(AbleLiteral ableLiteral) throws AbleDataException {
        Object object = this.myTypedVariable.getGenericValue();
        Object object2 = null;
        Class<?> clazz = null;
        if (this.mySetDirectFlag) {
            if (this.myField == null) throw new AbleDataException(Able.NlsMsg("Ex_VarNullFieldSettingField", new Object[]{object, object2}));
            clazz = this.myField.getType();
            object2 = this.extractProperValue(clazz, ableLiteral);
            try {
                this.myField.set(object, object2);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AbleDataException(Able.NlsMsg("Ex_VarAccessSettingField", new Object[]{this.myField, object, object2}));
            }
        }
        if (this.mySetMethod == null) throw new AbleDataException(Able.NlsMsg("Ex_VarNullMethodSettingField", new Object[]{this.myField, object}));
        clazz = this.mySetMethod.getParameterTypes()[0];
        object2 = this.extractProperValue(clazz, ableLiteral);
        try {
            this.mySetMethod.invoke(object, object2);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarAccessSettingFieldByMethod", new Object[]{this.myField, object, object2, this.mySetMethod}));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvocationSettingField", new Object[]{this.myField, object, object2, this.mySetMethod, invocationTargetException.getTargetException()}));
        }
    }

    private Object extractProperValue(Class clazz, AbleLiteral ableLiteral) throws AbleDataException {
        Object object = null;
        if (clazz.isAssignableFrom(Boolean.TYPE)) {
            object = new Boolean(ableLiteral.getBooleanValue());
        } else if (clazz.isAssignableFrom(Byte.TYPE)) {
            object = new Byte(new Double(ableLiteral.getNumericValue()).byteValue());
        } else if (clazz.isAssignableFrom(Character.TYPE)) {
            object = new Character((char)ableLiteral.getNumericValue());
        } else if (clazz.isAssignableFrom(Double.TYPE)) {
            object = new Double(ableLiteral.getNumericValue());
        } else if (clazz.isAssignableFrom(Float.TYPE)) {
            object = new Float(ableLiteral.getNumericValue());
        } else if (clazz.isAssignableFrom(Integer.TYPE)) {
            object = new Integer(new Double(ableLiteral.getNumericValue()).intValue());
        } else if (clazz.isAssignableFrom(Long.TYPE)) {
            object = new Long(new Double(ableLiteral.getNumericValue()).longValue());
        } else if (clazz.isAssignableFrom(Short.TYPE)) {
            object = new Short(new Double(ableLiteral.getNumericValue()).shortValue());
        } else if (clazz.isAssignableFrom(class$java$lang$Object == null ? (class$java$lang$Object = AbleTypedVariableField.class$("java.lang.Object")) : class$java$lang$Object)) {
            object = ableLiteral.getGenericValue();
        } else if (clazz.isAssignableFrom(class$java$lang$String == null ? (class$java$lang$String = AbleTypedVariableField.class$("java.lang.String")) : class$java$lang$String)) {
            object = ableLiteral.getStringValue();
        } else if (clazz.isAssignableFrom(class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbleTypedVariableField.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            object = new Boolean(ableLiteral.getBooleanValue());
        } else if (clazz.isAssignableFrom(class$java$lang$Byte == null ? (class$java$lang$Byte = AbleTypedVariableField.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            object = new Byte(new Double(ableLiteral.getNumericValue()).byteValue());
        } else if (clazz.isAssignableFrom(class$java$lang$Character == null ? (class$java$lang$Character = AbleTypedVariableField.class$("java.lang.Character")) : class$java$lang$Character)) {
            object = new Character((char)ableLiteral.getNumericValue());
        } else if (clazz.isAssignableFrom(class$java$lang$Double == null ? (class$java$lang$Double = AbleTypedVariableField.class$("java.lang.Double")) : class$java$lang$Double)) {
            object = new Double(ableLiteral.getNumericValue());
        } else if (clazz.isAssignableFrom(class$java$lang$Float == null ? (class$java$lang$Float = AbleTypedVariableField.class$("java.lang.Float")) : class$java$lang$Float)) {
            object = new Float(ableLiteral.getNumericValue());
        } else if (clazz.isAssignableFrom(class$java$lang$Integer == null ? (class$java$lang$Integer = AbleTypedVariableField.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            object = new Integer(new Double(ableLiteral.getNumericValue()).intValue());
        } else if (clazz.isAssignableFrom(class$java$lang$Long == null ? (class$java$lang$Long = AbleTypedVariableField.class$("java.lang.Long")) : class$java$lang$Long)) {
            object = new Long(new Double(ableLiteral.getNumericValue()).longValue());
        } else if (clazz.isAssignableFrom(class$java$lang$Short == null ? (class$java$lang$Short = AbleTypedVariableField.class$("java.lang.Short")) : class$java$lang$Short)) {
            object = new Short(new Double(ableLiteral.getNumericValue()).shortValue());
        } else if (clazz.isAssignableFrom(ableLiteral.getDataTypeClass())) {
            object = ableLiteral.getGenericValue();
        }
        return object;
    }

    public String arlDclString() {
        return "";
    }

    public String xmlDclString() {
        return "";
    }

    public String xmlCWrString() {
        return "<fieldValue varRef=\"" + this.myTypedVariable.getName() + "\" fieldName=\"" + this.myField.getName() + "\"/>";
    }

    public String getTemplateString(Vector vector) {
        return this.arlCRdString();
    }

    public void asgnEq(AbleRd ableRd) throws AbleDataException {
        this.setValue(ableRd.getValue());
    }

    public void asgnIs(AbleRd ableRd) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_InvalidDataTypeLhs", new Object[]{this}));
    }

    public void asgnIs(AbleRd ableRd, double d) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_InvalidDataTypeLhs", new Object[]{this}));
    }

    public boolean isWritable() {
        return this.mySetDirectFlag || this.mySetMethod != null;
    }

    public boolean isReadable() {
        return this.myGetDirectFlag || this.myGetMethod != null;
    }

    public AbleTypedVariable getVariable() {
        return this.myTypedVariable;
    }

    public String getFieldName() {
        return this.myFieldName;
    }

    public Class getDataTypeClass() {
        return this.myField.getType();
    }

    public String getDataTypeClassName() {
        return this.myField.getType().getName();
    }

    public AbleTypedVariable getTypedVariable() {
        return this.myTypedVariable;
    }

    public Class getTypedVariableClass() {
        return this.myTypedVariable.getDataTypeClass();
    }

    public void setField(Field field) {
        this.myField = field;
    }

    public void setGetMethod(Method method) {
        this.myGetMethod = method;
    }

    public void setSetMethod(Method method) {
        this.mySetMethod = method;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object getFieldValue() throws AbleDataException {
        if (this.myField == null) {
            try {
                this.resolveFieldAndMethods();
            }
            catch (AbleParException ableParException) {
                throw new AbleDataException("Error de-serializing field ", ableParException);
            }
        }
        Object object = null;
        Object object2 = this.myTypedVariable.getGenericValue();
        if (this.myGetDirectFlag) {
            if (this.myField == null) throw new AbleDataException(Able.NlsMsg("Ex_VarNullFieldGettingField", new Object[]{object2}));
            try {
                return this.myField.get(object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AbleDataException(Able.NlsMsg("Ex_VarAccessGettingField", new Object[]{this.myField, object2}), illegalAccessException);
            }
        }
        if (this.myGetMethod == null) throw new AbleDataException(Able.NlsMsg("Ex_VarNullMethodGettingField", new Object[]{this.myField, object2}));
        try {
            return this.myGetMethod.invoke(object2, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarAccessGettingFieldByMethod", new Object[]{this.myField, object2, this.mySetMethod}), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvocationGettingField", new Object[]{this.myField, object2, this.mySetMethod, invocationTargetException}), invocationTargetException);
        }
    }

    private void validateSources() throws AbleDataException {
        if (this.myTypedVariable == null) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarNullTypedVariable"));
        }
        if (this.myTypedVariable.getGenericValue() == null) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarNullTypedVariableValue"));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof AbleTypedVariableField) {
            AbleTypedVariableField ableTypedVariableField = (AbleTypedVariableField)object;
            return this.myTypedVariable == ableTypedVariableField.myTypedVariable && this.myField == ableTypedVariableField.myField;
        }
        return false;
    }

    private Field discoverField(Class clazz, String string) throws AbleParException {
        Field field = null;
        Class clazz2 = clazz;
        try {
            while (clazz2 != null) {
                Field[] fieldArray = clazz2.getDeclaredFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    if (!string.equals(fieldArray[i].getName())) continue;
                    field = fieldArray[i];
                    break;
                }
                if (field == null && (clazz2 = clazz2.getSuperclass()) != null) continue;
                break;
            }
        }
        catch (SecurityException securityException) {
            throw new AbleParException(Able.NlsMsg("Ex_RsSecurityExceptionOnFieldRef", new Object[]{string, clazz.getName()}));
        }
        if (field != null) {
            // empty if block
        }
        return field;
    }

    private Method[] discoverMethods(Class clazz, Field field) throws AbleParException {
        int n;
        String string = field.getName();
        int n2 = field.getModifiers();
        boolean bl = true;
        boolean bl2 = true;
        Method[] methodArray = new Method[]{null, null};
        if (Modifier.isPublic(n2)) {
            bl = false;
            if (!Modifier.isFinal(n2)) {
                bl2 = false;
                return methodArray;
            }
        }
        char[] cArray = string.toCharArray();
        if (Character.isLowerCase(string.charAt(0))) {
            cArray[0] = Character.toUpperCase(cArray[0]);
        }
        Method[] methodArray2 = null;
        try {
            methodArray2 = clazz.getMethods();
        }
        catch (SecurityException securityException) {
            throw new AbleParException(Able.NlsMsg("Ex_RsSecurityExceptionOnFieldGetSet", new Object[]{field.getName(), clazz.getName()}));
        }
        String string2 = "";
        Method method = null;
        int n3 = 0;
        if (bl) {
            string2 = "get" + String.valueOf(cArray);
            for (n = 0; n < methodArray2.length; ++n) {
                if (!string2.equals(methodArray2[n].getName()) || !Modifier.isPublic(n3 = (method = methodArray2[n]).getModifiers())) continue;
                methodArray[0] = method;
                break;
            }
        }
        if (bl2 && !Modifier.isFinal(n2)) {
            string2 = "set" + String.valueOf(cArray);
            for (n = 0; n < methodArray2.length; ++n) {
                if (!string2.equals(methodArray2[n].getName()) || !Modifier.isPublic(n3 = (method = methodArray2[n]).getModifiers())) continue;
                methodArray[1] = method;
                break;
            }
        }
        return methodArray;
    }

    public int hashCode() {
        int n = 0;
        if (this.myTypedVariable != null) {
            n ^= this.myTypedVariable.hashCode();
        }
        if (this.myField != null) {
            n ^= this.myField.hashCode();
        }
        return n;
    }

    public String toString() {
        return this.arlCRdString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlCRdString();
            }
            case 4: {
                return this.arlCRdString();
            }
            case 5: {
                return this.xmlCRdString();
            }
        }
        return this.arlCRdString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        try {
            stringBuffer.append(this.myTypedVariable.getName() + "." + this.myFieldName + ":<" + this.getFieldValue() + ">");
        }
        catch (AbleDataException ableDataException) {
            stringBuffer.append(this.myTypedVariable.getName() + "." + this.myFieldName + ":<" + "--Undetermined--" + ">");
        }
        return stringBuffer.toString();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    public static void clear(Iterator iterator) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            AbleTypedVariableField ableTypedVariableField = (AbleTypedVariableField)e;
            ableTypedVariableField.clear();
        }
    }

    public void clear() {
        this.myField = null;
        this.myGetMethod = null;
        this.mySetMethod = null;
        this.myTypedVariable.clear();
        this.myTypedVariable = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

