/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.AbleClearable;
import com.ibm.able.data.AbleArrayLiteral;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleFuzzyVariable;
import com.ibm.able.data.AbleGenericLiteral;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleStringLiteral;
import com.ibm.able.data.AbleVariable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class AbleTypedVariable
extends AbleVariable
implements AbleClearable,
Serializable {
    static final long serialVersionUID = 2001022000000000001L;
    static String clsNm = "AbleTypedVariable";
    protected String myDataTypeName;
    protected Object myValue;
    protected transient Class myDataTypeClass;
    protected String myDataTypeClassName;
    protected Vector myInitialParms;
    static /* synthetic */ Class class$com$ibm$able$data$AbleStringLiteral;
    static /* synthetic */ Class class$com$ibm$able$data$AbleGenericLiteral;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public AbleTypedVariable(String string, boolean bl, boolean bl2, Object object, String string2) {
        super(20, string, bl, bl2);
        this.myValue = object;
        this.myValueInitial = this.myValue == null ? null : new AbleGenericLiteral(object);
        this.myDataTypeName = string2;
        this.myDataTypeClass = object instanceof Class ? (Class)object : object.getClass();
        this.myDataTypeClassName = this.myDataTypeClass.getName();
        this.myInitialParms = null;
    }

    public AbleTypedVariable(String string, boolean bl, boolean bl2, String string2, String string3) {
        super(20, string, bl, bl2);
        this.myDataTypeName = string2;
        this.myDataTypeClassName = string3;
        try {
            this.myDataTypeClass = Thread.currentThread().getContextClassLoader().loadClass(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myInitialParms = new Vector();
    }

    public AbleTypedVariable(String string, boolean bl, boolean bl2, String string2, Class clazz) {
        super(20, string, bl, bl2);
        this.myDataTypeName = string2;
        this.myDataTypeClass = clazz;
        this.myDataTypeClassName = clazz.getName();
        this.myInitialParms = new Vector();
    }

    public AbleTypedVariable(String string, String string2, String string3) {
        super(20, string, false, false);
        this.myDataTypeName = string2;
        this.myDataTypeClassName = string3;
        try {
            this.myDataTypeClass = Thread.currentThread().getContextClassLoader().loadClass(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myInitialParms = new Vector();
    }

    public AbleTypedVariable(AbleTypedVariable ableTypedVariable) {
        this(ableTypedVariable.myName + "clone", false, false, ableTypedVariable.myValueInitial, ableTypedVariable.myDataTypeName);
    }

    public Object getGenericValue() throws AbleDataException {
        return this.myValue;
    }

    public String getStringValue() throws AbleDataException {
        if (this.myValue == null) {
            return "<null>";
        }
        if (this.myValue instanceof Boolean) {
            boolean bl = (Boolean)this.myValue;
            if (bl) {
                return "true";
            }
            return "false";
        }
        if (this.myValue instanceof Number) {
            return Double.toString(((Number)this.myValue).doubleValue());
        }
        if (this.myValue instanceof String) {
            return (String)this.myValue;
        }
        if (this.myValue.getClass().isArray()) {
            return AbleArrayLiteral.arrayToString(this.myValue);
        }
        if (this.myValue instanceof AbleLiteral) {
            return ((AbleLiteral)this.myValue).getStringValue();
        }
        return this.getValueString();
    }

    public void asgnEq(AbleRd ableRd) throws AbleDataException {
        this.setGenericValue(ableRd.getGenericValue());
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        if (this.myValue == null) {
            return null == ableRd.getGenericValue();
        }
        if (this.myValue instanceof AbleRd) {
            return ((AbleRd)this.myValue).cmpEq(ableRd);
        }
        return this.myValue.equals(ableRd.getGenericValue());
    }

    public boolean cmpGt(AbleRd ableRd) throws AbleDataException {
        if (this.myValue instanceof AbleRd) {
            return ((AbleRd)this.myValue).cmpGt(ableRd);
        }
        return super.cmpGt(ableRd);
    }

    public boolean cmpGtEq(AbleRd ableRd) throws AbleDataException {
        if (this.myValue instanceof AbleRd) {
            return ((AbleRd)this.myValue).cmpGtEq(ableRd);
        }
        return super.cmpGt(ableRd);
    }

    public double cmpIs(AbleRd ableRd) throws AbleDataException {
        if (this.myValue instanceof AbleFuzzyVariable) {
            return ((AbleFuzzyVariable)this.myValue).cmpIs(ableRd);
        }
        return super.cmpIs(ableRd);
    }

    public boolean cmpLt(AbleRd ableRd) throws AbleDataException {
        if (this.myValue instanceof AbleRd) {
            return ((AbleRd)this.myValue).cmpLt(ableRd);
        }
        return super.cmpGt(ableRd);
    }

    public boolean cmpLtEq(AbleRd ableRd) throws AbleDataException {
        if (this.myValue instanceof AbleRd) {
            return ((AbleRd)this.myValue).cmpLtEq(ableRd);
        }
        return super.cmpGt(ableRd);
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        if (this.myValue == null) {
            return null != ableRd.getGenericValue();
        }
        if (this.myValue instanceof AbleRd) {
            return ((AbleRd)this.myValue).cmpNeq(ableRd);
        }
        return !this.myValue.equals(ableRd.getGenericValue());
    }

    public AbleLiteral compPlus(AbleRd ableRd) throws AbleDataException {
        if (this.myValue instanceof AbleRd) {
            return ((AbleRd)this.myValue).compPlus(ableRd);
        }
        throw new AbleDataException(Able.NlsMsg("Ex_InvalidDataTypeLhs", new Object[]{this}));
    }

    public AbleLiteral compMinus(AbleRd ableRd) throws AbleDataException {
        if (this.myValue instanceof AbleRd) {
            return ((AbleRd)this.myValue).compMinus(ableRd);
        }
        throw new AbleDataException(Able.NlsMsg("Ex_InvalidDataTypeLhs", new Object[]{this}));
    }

    public AbleLiteral compMultiply(AbleRd ableRd) throws AbleDataException {
        if (this.myValue instanceof AbleRd) {
            return ((AbleRd)this.myValue).compMultiply(ableRd);
        }
        throw new AbleDataException(Able.NlsMsg("Ex_InvalidDataTypeLhs", new Object[]{this}));
    }

    public AbleLiteral compDivide(AbleRd ableRd) throws AbleDataException {
        if (this.myValue instanceof AbleRd) {
            return ((AbleRd)this.myValue).compDivide(ableRd);
        }
        throw new AbleDataException(Able.NlsMsg("Ex_InvalidDataTypeLhs", new Object[]{this}));
    }

    public AbleLiteral compUnaryMinus(AbleRd ableRd) throws AbleDataException {
        if (this.myValue instanceof AbleRd) {
            return ((AbleRd)this.myValue).compUnaryMinus(ableRd);
        }
        throw new AbleDataException(Able.NlsMsg("Ex_InvalidDataTypeLhs", new Object[]{this}));
    }

    public void setBooleanValue(boolean bl) throws AbleDataException {
        if (bl) {
            this.setGenericValue(Boolean.TRUE);
        } else {
            this.setGenericValue(Boolean.FALSE);
        }
    }

    public void setFuzzyValue(AbleFuzzySet ableFuzzySet) throws AbleDataException {
        this.setGenericValue(ableFuzzySet);
    }

    public void setNumericValue(double d) throws AbleDataException {
        this.setGenericValue(new Double(d));
    }

    public void setValue(AbleLiteral ableLiteral) throws AbleDataException {
        if (ableLiteral != null) {
            this.setGenericValue(ableLiteral.getGenericValue());
        } else {
            this.setGenericValue(ableLiteral);
        }
    }

    public void setGenericValue(Object object) throws AbleDataException {
        Object object2 = this.myValue;
        if (object == null) {
            this.myValue = null;
            this.myBoundFlag = false;
        } else if (this.myDataTypeClass.isInstance(object) || this.myDataTypeClass.isAssignableFrom(object.getClass())) {
            this.myValue = object;
            this.myBoundFlag = true;
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarTypeMismatch", new Object[]{this.myName, this.myDataTypeClass.toString(), object.getClass().toString()}));
        }
        if (this.myContext != null) {
            this.myContext.updateCurrentFactBase(this.myId);
        }
        if (this.myChgSupport != null) {
            this.myChgSupport.firePropertyChange("GenericValue " + this.myName, object2, object);
        }
    }

    public String arlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myComment.length() > 0) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        stringBuffer.append(this.isTemplate() ? "    template " : "    ");
        stringBuffer.append(this.isStatic() ? "    static " : "    ");
        stringBuffer.append(this.myDataTypeName + " " + this.myName);
        if (this.myValueInitial == null) {
            stringBuffer.append(";" + Able.LS);
        } else {
            Object object = null;
            try {
                object = this.myValueInitial.getGenericValue();
            }
            catch (AbleDataException ableDataException) {
                // empty catch block
            }
            if (object == null) {
                stringBuffer.append(";" + Able.LS);
            } else {
                stringBuffer.append(" = " + this.myValueInitial.arlCRdString() + ";" + Able.LS);
            }
        }
        return stringBuffer.toString();
    }

    public String xmlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <declareVar varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"" + " dataType=\"" + this.myDataTypeName + "\"" + (this.isStatic() ? " static=\"true\"" : "") + (this.isTemplate() ? " template=\"true\"" : "") + ">" + Able.LS);
        stringBuffer.append(this.xmlInitializerString());
        stringBuffer.append("       </declareVar>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <Variable varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"" + " dataType=\"" + this.myDataTypeName + "\"" + (this.isStatic() ? " static=\"true\"" : "") + (this.isTemplate() ? " template=\"true\"" : "") + ">" + Able.LS);
        stringBuffer.append(this.armlInitializerString());
        stringBuffer.append("       </Variable>" + Able.LS);
        return stringBuffer.toString();
    }

    public Class getDataTypeClass() {
        try {
            if (this.myDataTypeClass == null) {
                this.resolveDataTypeClass();
            }
        }
        catch (AbleDataException ableDataException) {
            // empty catch block
        }
        return this.myDataTypeClass;
    }

    public String getDataTypeClassName() {
        return this.myDataTypeClassName;
    }

    public void setStringValue(String string) throws AbleDataException {
        if (this.myDataTypeClass == (class$com$ibm$able$data$AbleStringLiteral == null ? (class$com$ibm$able$data$AbleStringLiteral = AbleTypedVariable.class$("com.ibm.able.data.AbleStringLiteral")) : class$com$ibm$able$data$AbleStringLiteral)) {
            this.setGenericValue(new AbleStringLiteral(string));
        } else {
            this.setGenericValue(string);
        }
    }

    public String getDataTypeName() {
        return this.myDataTypeName;
    }

    public void reset() throws AbleDataException {
        if (this.myDataTypeClass == null) {
            this.resolveDataTypeClass();
        }
        if (!this.myStaticFlag) {
            this.init();
        }
    }

    public void init() throws AbleDataException {
        if (this.myValueInitial == null) {
            this.myValue = null;
            this.myBoundFlag = false;
        } else {
            this.myValue = this.myValueInitial.getGenericValue();
            this.myBoundFlag = true;
        }
    }

    private void resolveDataTypeClass() throws AbleDataException {
        Class<?> clazz = null;
        try {
            if (this.myDataTypeClassName.startsWith("$")) {
                clazz = this.myContext.getInnerClass(this.myDataTypeClassName);
            } else {
                ClassLoader classLoader = this.getContext().getClassLoader();
                clazz = classLoader.loadClass(this.myDataTypeClassName);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarClassNotFoundInitializer", new Object[]{this.myDataTypeClassName, this.myDataTypeClassName}));
        }
        this.myDataTypeClass = clazz;
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToFuzzy", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public boolean getBooleanValue() throws AbleDataException {
        if (this.myValue == null) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToBoolean", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
        }
        if (this.myValue instanceof Boolean) {
            return (Boolean)this.myValue;
        }
        if (this.myValue instanceof Number) {
            double d = ((Number)this.myValue).doubleValue();
            return d != 0.0;
        }
        if (this.myValue instanceof String) {
            String string = (String)this.myValue;
            if (string.equalsIgnoreCase("True")) {
                return true;
            }
            if (string.equalsIgnoreCase("False")) {
                return false;
            }
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToBoolean", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
        }
        if (this.myValue instanceof AbleLiteral) {
            return ((AbleLiteral)this.myValue).getBooleanValue();
        }
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToBoolean", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public Class getLiteralClass() {
        return class$com$ibm$able$data$AbleGenericLiteral == null ? (class$com$ibm$able$data$AbleGenericLiteral = AbleTypedVariable.class$("com.ibm.able.data.AbleGenericLiteral")) : class$com$ibm$able$data$AbleGenericLiteral;
    }

    public String getValueString() {
        if (this.myValue == null) {
            return "null";
        }
        return this.myValue.toString();
    }

    public AbleLiteral getValue() throws AbleDataException {
        return new AbleGenericLiteral(this.myValue);
    }

    public double getNumericValue() throws AbleDataException {
        if (this.myValue == null) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToNumeric", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
        }
        if (this.myValue instanceof Boolean) {
            boolean bl = (Boolean)this.myValue;
            if (bl) {
                return 1.0;
            }
            return 0.0;
        }
        if (this.myValue instanceof Number) {
            return ((Number)this.myValue).doubleValue();
        }
        if (this.myValue instanceof String) {
            String string = (String)this.myValue;
            Double d = new Double(Double.NaN);
            try {
                d = Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToNumeric", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
            }
            return d;
        }
        if (this.myValue instanceof AbleLiteral) {
            return ((AbleLiteral)this.myValue).getNumericValue();
        }
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToNumeric", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public void setValueString(String string) throws AbleDataException {
        this.setGenericValue(string);
    }

    public void replaceValues(Object object) {
        this.myValue = object;
        this.myValueInitial = new AbleGenericLiteral(object);
    }

    public String toString() {
        return this.arlDclString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlDclString();
            }
            case 4: {
                return this.arlDclString();
            }
            case 5: {
                return this.xmlDclString();
            }
        }
        return this.arlDclString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.myName + ":<" + this.getValueString() + ">");
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        try {
            if (this.myDataTypeClassName.endsWith("Object[]")) {
                this.myDataTypeClass = array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbleTypedVariable.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object;
                this.myDataTypeClassName = this.myDataTypeClass.getName();
            } else {
                this.myDataTypeClass = Thread.currentThread().getContextClassLoader().loadClass(this.myDataTypeClassName);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("myDataTypeClassName=" + this.myDataTypeClassName);
            System.out.println(classNotFoundException);
            classNotFoundException.printStackTrace();
            throw classNotFoundException;
        }
    }

    public void clear() {
        this.myDataTypeClass = null;
        if (this.myInitialParms != null) {
            this.myInitialParms.clear();
        }
        this.myValue = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

