/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import java.io.Serializable;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class AbleTimeStampLiteral
extends AbleLiteral
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static final String clsNm = "AbleTimeStampLiteral";
    protected Calendar myValue;
    static /* synthetic */ Class class$java$util$Calendar;

    public AbleTimeStampLiteral() {
        this(Calendar.getInstance());
    }

    public AbleTimeStampLiteral(Calendar calendar) {
        this.myValue = calendar;
    }

    public AbleTimeStampLiteral(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(string, parsePosition);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.myValue = calendar;
    }

    public boolean getBooleanValue() throws AbleDataException {
        return true;
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToFuzzy", new Object[]{clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        return this.myValue;
    }

    public double getNumericValue() throws AbleDataException {
        return this.myValue.getTime().getTime();
    }

    public String getStringValue() throws AbleDataException {
        return this.myValue.toString();
    }

    public AbleLiteral getValue() throws AbleDataException {
        return this;
    }

    public Class getDataTypeClass() {
        return class$java$util$Calendar == null ? (class$java$util$Calendar = AbleTimeStampLiteral.class$("java.util.Calendar")) : class$java$util$Calendar;
    }

    public String getDataTypeClassName() {
        return (class$java$util$Calendar == null ? (class$java$util$Calendar = AbleTimeStampLiteral.class$("java.util.Calendar")) : class$java$util$Calendar).getName();
    }

    public String arlCRdString() {
        return "new TimeStamp(\"" + this.formatDateAndTime(this.myValue) + "\")";
    }

    public String xmlCRdString() {
        return "<timeStampLiteral value=\"" + this.formatDateAndTime(this.myValue) + "\"/>";
    }

    private Calendar parseCalendar(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(string, parsePosition);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public String formatDateAndTime(Calendar calendar) {
        if (calendar == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        return simpleDateFormat.format(calendar.getTime());
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        return this.getNumericValue() == ableRd.getNumericValue();
    }

    public boolean cmpGt(AbleRd ableRd) throws AbleDataException {
        return this.getNumericValue() > ableRd.getNumericValue();
    }

    public boolean cmpGtEq(AbleRd ableRd) throws AbleDataException {
        return this.getNumericValue() >= ableRd.getNumericValue();
    }

    public boolean cmpLt(AbleRd ableRd) throws AbleDataException {
        return this.getNumericValue() < ableRd.getNumericValue();
    }

    public boolean cmpLtEq(AbleRd ableRd) throws AbleDataException {
        return this.getNumericValue() <= ableRd.getNumericValue();
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        return this.getNumericValue() != ableRd.getNumericValue();
    }

    public boolean equals(Object object) {
        if (object instanceof AbleTimeStampLiteral) {
            return this.myValue.equals(((AbleTimeStampLiteral)object).myValue);
        }
        return false;
    }

    public int hashCode() {
        if (this.myValue != null) {
            return this.myValue.hashCode();
        }
        return 0;
    }

    public String toString() {
        return this.arlCRdString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlCRdString();
            }
            case 4: {
                return this.arlCRdString();
            }
            case 5: {
                return this.xmlCRdString();
            }
        }
        return this.arlCRdString();
    }

    private String trcString(int n) {
        return this.myValue.toString();
    }

    public int getDataType() {
        return 7;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

