/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleBuiltInVariable;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleStringLiteral;
import com.ibm.able.data.AbleTypedVariable;
import java.io.Serializable;

public class AbleStringVariable
extends AbleTypedVariable
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static String clsNm = "AbleStringVariable";
    protected String myValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$ibm$able$data$AbleStringLiteral;

    public AbleStringVariable(String string, String string2) {
        super(string, false, false, string2, "String");
        this.myDataType = 18;
        this.myValue = string2;
        this.myValueInitial = new AbleStringLiteral(string2);
    }

    public AbleStringVariable(String string, boolean bl, boolean bl2) {
        super(string, bl, bl2, "String", "java.lang.String");
        this.myDataType = 18;
        this.myDataTypeClass = class$java$lang$String == null ? (class$java$lang$String = AbleStringVariable.class$("java.lang.String")) : class$java$lang$String;
        this.myValue = null;
        this.myValueInitial = null;
    }

    public AbleStringVariable(String string, boolean bl, boolean bl2, String string2) {
        super(string, bl, bl2, string2, "String");
        this.myDataType = 18;
        this.myValue = string2;
        this.myValueInitial = new AbleStringLiteral(string2);
    }

    public boolean getBooleanValue() throws AbleDataException {
        if (this.myValue.equalsIgnoreCase("True")) {
            return true;
        }
        if (this.myValue.equalsIgnoreCase("False")) {
            return false;
        }
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToBoolean", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToFuzzy", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        return this.myValue;
    }

    public double getNumericValue() throws AbleDataException {
        Double d = null;
        try {
            d = Double.valueOf(this.myValue);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToNumeric", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
        }
        return d;
    }

    public String getStringValue() throws AbleDataException {
        return this.myValue;
    }

    public AbleLiteral getValue() throws AbleDataException {
        return new AbleStringLiteral(this.myValue);
    }

    public void asgnEq(AbleRd ableRd) throws AbleDataException {
        this.setRawValue(ableRd.getStringValue());
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        if (this.myValue == null) {
            return this.myValue == ableRd.getGenericValue();
        }
        return this.myValue.equals(ableRd.getStringValue());
    }

    public boolean cmpGt(AbleRd ableRd) throws AbleDataException {
        return AbleData.Collator.compare(this.myValue, ableRd.getStringValue()) > 0;
    }

    public boolean cmpGtEq(AbleRd ableRd) throws AbleDataException {
        return AbleData.Collator.compare(this.myValue, ableRd.getStringValue()) >= 0;
    }

    public boolean cmpLt(AbleRd ableRd) throws AbleDataException {
        return AbleData.Collator.compare(this.myValue, ableRd.getStringValue()) < 0;
    }

    public boolean cmpLtEq(AbleRd ableRd) throws AbleDataException {
        return AbleData.Collator.compare(this.myValue, ableRd.getStringValue()) <= 0;
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        if (this.myValue == null) {
            return this.myValue != ableRd.getGenericValue();
        }
        return !this.myValue.equals(ableRd.getStringValue());
    }

    public AbleLiteral compPlus(AbleRd ableRd) throws AbleDataException {
        return new AbleStringLiteral(this.myValue + ableRd.getStringValue());
    }

    public void setBooleanValue(boolean bl) throws AbleDataException {
        if (bl) {
            this.setRawValue("true");
        } else {
            this.setRawValue("false");
        }
    }

    public void setFuzzyValue(AbleFuzzySet ableFuzzySet) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromFuzzy", new Object[]{Integer.toString(this.myId), this.myName}));
    }

    public void setGenericValue(Object object) throws AbleDataException {
        if (object instanceof Boolean) {
            this.setBooleanValue((Boolean)object);
        } else if (object instanceof Number) {
            this.setNumericValue(((Number)object).doubleValue());
        } else if (object instanceof String) {
            this.setStringValue((String)object);
        } else if (object instanceof AbleLiteral) {
            this.setValue((AbleLiteral)object);
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromGeneric", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
        }
    }

    public void setNumericValue(double d) throws AbleDataException {
        this.setRawValue(Double.toString(d));
    }

    public void setStringValue(String string) throws AbleDataException {
        this.setRawValue(string);
    }

    public void setValue(AbleLiteral ableLiteral) throws AbleDataException {
        this.setRawValue(ableLiteral.getStringValue());
    }

    public String arlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myComment.length() > 0) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        stringBuffer.append(this.isTemplate() ? "    template " : "    ");
        stringBuffer.append(this.isStatic() ? "    static " : "    ");
        stringBuffer.append("String " + this.myName);
        if (this.myValueInitial == null) {
            stringBuffer.append(";" + Able.LS);
        } else {
            stringBuffer.append(" = " + this.myValueInitial.arlCRdString() + ";" + Able.LS);
        }
        return stringBuffer.toString();
    }

    public String xmlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <declareVar varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"" + " dataType=\"" + "String" + "\"" + (this.isStatic() ? " static=\"true\"" : "") + (this.isTemplate() ? " template=\"true\"" : "") + ">" + Able.LS);
        stringBuffer.append(this.xmlInitializerString());
        stringBuffer.append("       </declareVar>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <Variable varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"" + " dataType=\"" + "String" + "\"" + (this.isStatic() ? " static=\"true\"" : "") + (this.isTemplate() ? " template=\"true\"" : "") + ">" + Able.LS);
        stringBuffer.append(this.armlInitializerString());
        stringBuffer.append("       </Variable>" + Able.LS);
        return stringBuffer.toString();
    }

    public void setValueString(String string) throws AbleDataException {
        this.setRawValue(string);
    }

    public String getValueString() {
        return this.myValue;
    }

    public void reset() throws AbleDataException {
        if (!this.myStaticFlag) {
            this.init();
        }
    }

    public void init() throws AbleDataException {
        this.myBoundFlag = false;
        if (this.myValueInitial == null) {
            this.myValue = null;
        } else if (this.myValueInitial instanceof AbleBuiltInVariable) {
            this.myValue = (String)this.myValueInitial.getGenericValue();
            if (this.myValue != null) {
                this.myBoundFlag = true;
            }
        } else {
            this.myValue = this.myValueInitial.getStringValue();
            this.myBoundFlag = true;
        }
    }

    public Class getDataTypeClass() {
        return class$java$lang$String == null ? (class$java$lang$String = AbleStringVariable.class$("java.lang.String")) : class$java$lang$String;
    }

    public String getDataTypeClassName() {
        return (class$java$lang$String == null ? (class$java$lang$String = AbleStringVariable.class$("java.lang.String")) : class$java$lang$String).getName();
    }

    public Class getLiteralClass() {
        return class$com$ibm$able$data$AbleStringLiteral == null ? (class$com$ibm$able$data$AbleStringLiteral = AbleStringVariable.class$("com.ibm.able.data.AbleStringLiteral")) : class$com$ibm$able$data$AbleStringLiteral;
    }

    void setRawValue(String string) throws AbleDataException {
        String string2 = this.myValue;
        this.myValue = string;
        this.myBoundFlag = true;
        if (this.myContext != null) {
            this.myContext.updateCurrentFactBase(this.myId);
        }
        if (this.myChgSupport != null) {
            this.myChgSupport.firePropertyChange("StringValue " + this.myName, string2, string);
        }
    }

    public String toString() {
        return this.arlDclString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlDclString();
            }
            case 4: {
                return this.arlDclString();
            }
            case 5: {
                return this.xmlDclString();
            }
        }
        return this.arlDclString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.myName + ":<\"" + this.getValueString() + "\">");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

