/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleCharacterLiteral;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.WeakHashMap;

public class AbleStringLiteral
extends AbleLiteral
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static final String clsNm = "AbleStringLiteral";
    private static final String EMPTY_STRING = "";
    public static final AbleStringLiteral EMPTY_STRING_LITERAL = new AbleStringLiteral("");
    public static boolean InternStringLiterals = false;
    protected static volatile WeakHashMap internedStrings = new WeakHashMap();
    protected String myValue;
    static /* synthetic */ Class class$java$lang$String;

    public AbleStringLiteral() {
        this.myValue = AbleStringLiteral.findOrCreateInternedString(EMPTY_STRING);
    }

    public AbleStringLiteral(String string) {
        this.myValue = AbleStringLiteral.findOrCreateInternedString(string);
    }

    public static String valueOf(String string) {
        if (string.indexOf("\\") != -1) {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n = 0;
            int n2 = 0;
            n = 0;
            while (n < cArray.length) {
                char c;
                if ((c = cArray[n++]) != '\\') {
                    cArray2[n2++] = c;
                    continue;
                }
                String string2 = "\\" + cArray[n++];
                char c2 = AbleCharacterLiteral.valueOf(string2);
                cArray2[n2++] = c2;
            }
            char[] cArray3 = new char[n2];
            for (int i = 0; i < n2; ++i) {
                cArray3[i] = cArray2[i];
            }
            return new String(cArray3);
        }
        return string;
    }

    public boolean getBooleanValue() throws AbleDataException {
        if (this.myValue.trim().equalsIgnoreCase("true")) {
            return true;
        }
        if (this.myValue.trim().equalsIgnoreCase("false")) {
            return false;
        }
        throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToBoolean", new Object[]{clsNm}));
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToFuzzy", new Object[]{clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        return this.myValue;
    }

    public double getNumericValue() throws AbleDataException {
        try {
            return Double.valueOf(this.myValue.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToNumeric", new Object[]{clsNm}), numberFormatException);
        }
    }

    public String getStringValue() throws AbleDataException {
        return this.myValue;
    }

    public AbleLiteral getValue() throws AbleDataException {
        return this;
    }

    public Class getDataTypeClass() {
        return class$java$lang$String == null ? (class$java$lang$String = AbleStringLiteral.class$("java.lang.String")) : class$java$lang$String;
    }

    public String getDataTypeClassName() {
        return (class$java$lang$String == null ? (class$java$lang$String = AbleStringLiteral.class$("java.lang.String")) : class$java$lang$String).getName();
    }

    public String arlCRdString() {
        return "\"" + this.myValue + "\"";
    }

    public String xmlCRdString() {
        return "<stringLiteral value=\"" + AbleData.escapeXMLString(this.myValue) + "\"/>";
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        String string = ableRd.getStringValue();
        if (string == this.myValue) {
            return true;
        }
        if (InternStringLiterals) {
            return false;
        }
        return this.myValue.equals(string);
    }

    public boolean cmpGt(AbleRd ableRd) throws AbleDataException {
        return AbleData.Collator.compare(this.myValue, ableRd.getStringValue()) > 0;
    }

    public boolean cmpGtEq(AbleRd ableRd) throws AbleDataException {
        return AbleData.Collator.compare(this.myValue, ableRd.getStringValue()) >= 0;
    }

    public boolean cmpLt(AbleRd ableRd) throws AbleDataException {
        return AbleData.Collator.compare(this.myValue, ableRd.getStringValue()) < 0;
    }

    public boolean cmpLtEq(AbleRd ableRd) throws AbleDataException {
        return AbleData.Collator.compare(this.myValue, ableRd.getStringValue()) <= 0;
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        return !this.myValue.equals(ableRd.getStringValue());
    }

    public AbleLiteral compPlus(AbleRd ableRd) throws AbleDataException {
        return new AbleStringLiteral(this.myValue + ableRd.getStringValue());
    }

    public boolean equals(Object object) {
        if (object instanceof AbleStringLiteral) {
            return this.myValue.equals(((AbleStringLiteral)object).myValue);
        }
        return false;
    }

    public int hashCode() {
        if (this.myValue != null) {
            return this.myValue.hashCode();
        }
        return 0;
    }

    public String toString() {
        return this.arlCRdString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlCRdString();
            }
            case 4: {
                return this.arlCRdString();
            }
            case 5: {
                return this.xmlCRdString();
            }
        }
        return this.arlCRdString();
    }

    private String trcString(int n) {
        return "\"" + this.myValue + "\"";
    }

    public int getDataType() {
        return 5;
    }

    public static String findOrCreateInternedString(String string) {
        String string2;
        if (internedStrings == null) {
            internedStrings = new WeakHashMap();
        }
        if ((string2 = (String)internedStrings.get(string)) == null) {
            string2 = string;
            internedStrings.put(string2, string2);
        }
        return string2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.myValue = AbleStringLiteral.findOrCreateInternedString(this.myValue);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

