/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.AbleLogger;
import com.ibm.able.data.AbleBooleanLiteral;
import com.ibm.able.data.AbleCharacterLiteral;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataContext;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleDoubleLiteral;
import com.ibm.able.data.AbleEmptyListPredicate;
import com.ibm.able.data.AbleGenericVariable;
import com.ibm.able.data.AbleIntegerLiteral;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleStringLiteral;
import com.ibm.able.data.AbleTypedVariable;
import com.ibm.able.data.AbleVariable;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class AblePredicate
implements Serializable {
    static final long serialVersionUID = 2001041300000000001L;
    protected String name;
    protected int arity = 0;
    protected Vector argList = new Vector();
    protected Hashtable replacementVars = new Hashtable();
    protected Vector variables = new Vector();
    protected AbleLogger myTracer = null;
    public static final String DontCareSymbol = "_";
    public static final String ListPredicate = ".";
    public static final String IsListPredicate = "isList";
    public static final AbleEmptyListPredicate EmptyListPredicate = new AbleEmptyListPredicate(".");
    public static final String NotPredicate = "not";
    public static final String CutPredicate = "cut";
    public static final String FailPredicate = "fail";
    public static final String CallPredicate = "call";
    public static final String UnivPredicate = "univ";
    public static final String AtomCharsPredicate = "atom_chars";
    public static final String AtomConcatPredicate = "atom_concat";
    public static final String SubAtomPredicate = "sub_atom";
    public static final String VarPredicate = "var";
    public static final String NonVarPredicate = "nonvar";
    public static final String AssertPredicate = "assert";
    public static final String AssertAPredicate = "asserta";
    public static final String AssertZPredicate = "assertz";
    public static final String RetractPredicate = "retract";
    public static final String RetractAllPredicate = "retractall";
    public static final String MemberPredicate = "member";
    public static final String UnifyPredicate = "unify";
    public static final String ConsultPredicate = "consult";
    public static final String AtomNumberPredicate = "atom_number";
    public static final String FunctorPredicate = "functor";
    public static final String AtomLengthPredicate = "atom_length";

    public AblePredicate() {
        this.name = "unnamed";
    }

    public AblePredicate(String string) {
        this.name = string;
    }

    public AblePredicate(String string, Vector vector) {
        this.name = string;
        this.argList = vector;
        this.arity = vector.size();
        if (this.isList() && !this.isEmptyList()) {
            if (vector.size() == 1) {
                if (this.isTraceActive()) {
                    this.myTracer.message(0x40000000000L, this, "AblePredicate", "Wn_RsPredicateOnlyOneArg");
                }
                Able.MessageLog.message(2L, this, "AblePredicate", "Wn_RsPredicateOnlyOneArg");
            } else if (vector.size() != 2 && vector.size() > 2) {
                Vector vector2 = (Vector)vector.clone();
                vector.clear();
                vector.add(vector2.get(0));
                vector2.remove(0);
                vector.add(AblePredicate.getStandardList(vector2));
                this.arity = vector.size();
            }
        }
        this.findAllVariables();
        this.digOutTracer();
    }

    public AblePredicate(Vector vector) {
        AblePredicate ablePredicate = EmptyListPredicate;
        if (vector.size() > 0) {
            vector.add(EmptyListPredicate);
            ablePredicate = new AblePredicate(ListPredicate, vector);
        }
        this.name = ablePredicate.name;
        this.argList = ablePredicate.argList;
        this.arity = ablePredicate.arity;
        this.myTracer = ablePredicate.myTracer;
        this.variables = ablePredicate.variables;
        this.findAllVariables();
        this.digOutTracer();
    }

    public AblePredicate(Object object, AblePredicate ablePredicate) {
        this.name = ListPredicate;
        this.argList.add(object);
        this.argList.add(ablePredicate);
        this.arity = this.argList.size();
        this.findAllVariables();
        this.digOutTracer();
    }

    public AblePredicate(AblePredicate ablePredicate) {
        this.replacementVars.clear();
        Vector vector = ablePredicate.getVariables();
        for (int i = 0; i < vector.size(); ++i) {
            AbleVariable ableVariable = (AbleVariable)vector.get(i);
            AbleGenericVariable ableGenericVariable = new AbleGenericVariable(ableVariable.getName(), null);
            try {
                Object object = ableVariable.getGenericValue();
                if (object instanceof AblePredicate) {
                    object = ((AblePredicate)object).makeGround();
                }
                ableGenericVariable.setGenericValue(object);
            }
            catch (AbleDataException ableDataException) {
                // empty catch block
            }
            this.replacementVars.put(ableVariable, ableGenericVariable);
        }
        AblePredicate ablePredicate2 = ablePredicate.createMatchPredicate(this.replacementVars);
        this.name = ablePredicate2.name;
        this.argList = ablePredicate2.argList;
        this.arity = ablePredicate2.arity;
        this.myTracer = ablePredicate2.myTracer;
        this.variables = ablePredicate2.variables;
    }

    private void digOutTracer() {
        AbleVariable ableVariable;
        AbleDataContext ableDataContext;
        if (!this.variables.isEmpty() && (ableDataContext = (ableVariable = (AbleVariable)this.variables.firstElement()).getContext()) != null) {
            this.myTracer = ableDataContext.getInferTraceLogger();
        }
    }

    public boolean isMember(Object object) throws AbleDataException {
        if (this.isEmptyList()) {
            return false;
        }
        Object object2 = null;
        AblePredicate ablePredicate = this;
        do {
            if ((object2 = ablePredicate.getHead()) instanceof AbleVariable && ((AbleVariable)object2).isBound()) {
                object2 = ((AbleVariable)object2).getGenericValue();
            }
            if (object.equals(object2)) {
                return true;
            }
            if (object instanceof String && object2 instanceof AbleStringLiteral ? object.equals(((AbleStringLiteral)object2).getStringValue()) : object instanceof AbleStringLiteral && object2 instanceof String && ((AbleStringLiteral)object).getStringValue().equals(object2)) {
                return true;
            }
            Object object3 = ablePredicate.getTail();
            if (object3 instanceof AblePredicate) {
                ablePredicate = (AblePredicate)object3;
                continue;
            }
            if (object3 instanceof AbleVariable && ((AbleVariable)object3).isBound()) {
                object3 = ((AbleVariable)object3).getGenericValue();
            }
            if (object.equals(object3)) {
                return true;
            }
            if (object instanceof String && object3 instanceof AbleStringLiteral ? object.equals(((AbleStringLiteral)object3).getStringValue()) : object instanceof AbleStringLiteral && object3 instanceof String && ((AbleStringLiteral)object).getStringValue().equals(object3)) {
                return true;
            }
            ablePredicate = null;
        } while (ablePredicate != null && !ablePredicate.isEmptyList());
        return false;
    }

    private boolean isTraceActive() {
        if (this.myTracer == null) {
            return false;
        }
        return this.myTracer.isLogging();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AblePredicate)) {
            return false;
        }
        AblePredicate ablePredicate = (AblePredicate)object;
        if (!this.name.equals(ablePredicate.name)) {
            return false;
        }
        if (this.isList() && ablePredicate.isList()) {
            Vector vector = this.getListArguments();
            Vector vector2 = ablePredicate.getListArguments();
            int n = vector.size();
            if (n != vector2.size()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (vector.get(i).equals(vector2.get(i))) continue;
                return false;
            }
            return true;
        }
        if (!this.isList() && !ablePredicate.isList()) {
            Vector vector = this.getArguments();
            Vector vector3 = ablePredicate.getArguments();
            int n = vector.size();
            if (n != vector3.size()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (vector.get(i).equals(vector3.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        if (this.name != null) {
            n ^= this.name.hashCode();
        }
        if (this.isList()) {
            Vector vector = this.getListArguments();
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                Object e = vector.get(i);
                if (e == null) continue;
                n ^= e.hashCode();
            }
        } else {
            Vector vector = this.getArguments();
            int n3 = vector.size();
            for (int i = 0; i < n3; ++i) {
                Object e = vector.get(i);
                if (e == null) continue;
                n ^= e.hashCode();
            }
        }
        return n;
    }

    public String getSignature() {
        return this.name + "/" + this.arity;
    }

    public String getFunctor() {
        return this.name;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean isList() {
        return this.name.equals(ListPredicate);
    }

    public boolean isEmptyList() {
        return this.name.equals(ListPredicate) && this.argList.size() == 0;
    }

    public boolean isNot() {
        return this.name.equals(NotPredicate);
    }

    public Object getArgument(int n) {
        return this.argList.get(n);
    }

    public Vector getArguments() {
        return (Vector)this.argList.clone();
    }

    public Vector getVariables() {
        return this.variables;
    }

    public boolean isGround() {
        return this.variables.size() == 0;
    }

    public boolean isFail() {
        return this.name.equals(FailPredicate) && this.argList.size() == 0;
    }

    public boolean isCut() {
        return this.name.equals(CutPredicate) && this.argList.size() == 0;
    }

    public Object getHead() {
        return this.argList.get(0);
    }

    public Object getTail() {
        return this.argList.get(1);
    }

    public AblePredicate makeGround() {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.argList.size(); ++i) {
            Object e = this.argList.get(i);
            if (e instanceof String) {
                vector.add(e);
                continue;
            }
            if (e instanceof AbleVariable) {
                AbleVariable ableVariable = (AbleVariable)e;
                try {
                    Object object = ableVariable.getGenericValue();
                    if (object instanceof AblePredicate) {
                        vector.add(((AblePredicate)object).makeGround());
                        continue;
                    }
                    vector.add(object);
                }
                catch (AbleDataException ableDataException) {
                    Able.MessageLog.message(4L, this, "makeGround", ableDataException.getLocalizedMessage());
                }
                continue;
            }
            if (e instanceof AbleStringLiteral) {
                vector.add(e);
                continue;
            }
            if (e instanceof AbleDoubleLiteral) {
                vector.add(e);
                continue;
            }
            if (e instanceof AbleBooleanLiteral) {
                vector.add(e);
                continue;
            }
            if (e instanceof AbleCharacterLiteral) {
                vector.add(e);
                continue;
            }
            if (e instanceof AbleIntegerLiteral) {
                vector.add(e);
                continue;
            }
            if (e instanceof AblePredicate) {
                vector.add(((AblePredicate)e).makeGround());
                continue;
            }
            Able.MessageLog.message(4L, (Object)this, "makeGround", "Ex_RsPredicateUnsupportedArgumentType", new Object[]{e.getClass().getName()});
        }
        return new AblePredicate(this.name, vector);
    }

    public boolean isBound() {
        boolean bl = true;
        for (int i = 0; i < this.variables.size(); ++i) {
            AbleVariable ableVariable = (AbleVariable)this.variables.get(i);
            if (ableVariable.isBound()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    protected static AblePredicate getStandardList(Vector vector) {
        if (vector.isEmpty()) {
            return EmptyListPredicate;
        }
        Object e = vector.get(0);
        if (vector.size() == 2) {
            return new AblePredicate(ListPredicate, vector);
        }
        if (e instanceof AbleEmptyListPredicate) {
            return EmptyListPredicate;
        }
        Vector vector2 = (Vector)vector.clone();
        vector2.remove(0);
        return new AblePredicate(e, AblePredicate.getStandardList(vector2));
    }

    public AblePredicate createMatchPredicate(Hashtable hashtable) {
        Vector vector = new Vector();
        for (int i = 0; i < this.argList.size(); ++i) {
            Object e = this.argList.get(i);
            if (e instanceof String) {
                vector.add(e);
                continue;
            }
            if (e instanceof AbleVariable) {
                AbleVariable ableVariable = (AbleVariable)e;
                AbleVariable ableVariable2 = null;
                if (hashtable.containsKey(ableVariable)) {
                    ableVariable2 = (AbleVariable)hashtable.get(ableVariable);
                } else {
                    ableVariable2 = new AbleGenericVariable(ableVariable.getName() + "'", null);
                    hashtable.put(ableVariable, ableVariable2);
                }
                vector.add(ableVariable2);
                continue;
            }
            if (e instanceof AbleStringLiteral) {
                vector.add(e);
                continue;
            }
            if (e instanceof AbleDoubleLiteral) {
                vector.add(e);
                continue;
            }
            if (e instanceof AbleBooleanLiteral) {
                vector.add(e);
                continue;
            }
            if (e instanceof AbleCharacterLiteral) {
                vector.add(e);
                continue;
            }
            if (e instanceof AbleIntegerLiteral) {
                vector.add(e);
                continue;
            }
            if (e instanceof AblePredicate) {
                vector.add(((AblePredicate)e).createMatchPredicate(hashtable));
                continue;
            }
            Able.MessageLog.message(4L, (Object)this, "createMatchPredicate", "Ex_RsPredicateUnsupportedArgumentType", new Object[]{e.getClass().getName()});
        }
        return new AblePredicate(this.name, vector);
    }

    public Vector getUnboundVariables() throws AbleDataException {
        Vector<AbleVariable> vector = new Vector<AbleVariable>();
        for (int i = 0; i < this.variables.size(); ++i) {
            AbleVariable ableVariable = (AbleVariable)this.variables.get(i);
            if (!ableVariable.isBound()) {
                vector.add(ableVariable);
                continue;
            }
            Object object = ableVariable.getGenericValue();
            if (!(object instanceof AblePredicate)) continue;
            Vector vector2 = ((AblePredicate)object).getUnboundVariables();
            vector.addAll(vector2);
        }
        return vector;
    }

    protected void findAllVariables() {
        for (int i = 0; i < this.argList.size(); ++i) {
            Object e = this.argList.get(i);
            if (e instanceof String || e instanceof AbleLiteral) continue;
            if (e instanceof AblePredicate) {
                Vector vector = ((AblePredicate)e).getVariables();
                for (int j = 0; j < vector.size(); ++j) {
                    Object e2 = vector.get(j);
                    if (this.variables.contains(e2)) continue;
                    this.variables.add(e2);
                }
                continue;
            }
            if (!(e instanceof AbleVariable) || this.variables.contains(e)) continue;
            this.variables.add(e);
        }
    }

    public Vector getBoundVariables() {
        Vector<AbleVariable> vector = new Vector<AbleVariable>();
        for (int i = 0; i < this.variables.size(); ++i) {
            AbleVariable ableVariable = (AbleVariable)this.variables.get(i);
            if (!ableVariable.isBound()) continue;
            vector.add(ableVariable);
        }
        return vector;
    }

    public void clearBindings() {
        for (int i = 0; i < this.variables.size(); ++i) {
            AbleVariable ableVariable = (AbleVariable)this.variables.get(i);
            try {
                ableVariable.setGenericValue(null);
                continue;
            }
            catch (AbleDataException ableDataException) {
                Able.MessageLog.message(4L, this, "clearBindings()", ableDataException.getLocalizedMessage());
                if (!Able.TraceLog.isLogging()) continue;
                Able.TraceLog.exception(262144L, this, "clearBindings()", ableDataException);
            }
        }
    }

    public void clearBindings(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            AbleVariable ableVariable = (AbleVariable)vector.get(i);
            try {
                ableVariable.setGenericValue(null);
                continue;
            }
            catch (AbleDataException ableDataException) {
                Able.MessageLog.message(4L, this, "clearBindings(Vector)", ableDataException.getLocalizedMessage());
                if (!Able.TraceLog.isLogging()) continue;
                Able.TraceLog.exception(262144L, this, "clearBindings()", ableDataException);
            }
        }
    }

    public Vector getListArguments() {
        Vector<Object> vector = new Vector<Object>();
        if (this.isList() && !this.isEmptyList()) {
            Object object = null;
            AblePredicate ablePredicate = this;
            do {
                if ((object = ablePredicate.getHead()) instanceof AbleVariable && ((AbleVariable)object).isBound()) {
                    try {
                        object = ((AbleVariable)object).getGenericValue();
                    }
                    catch (AbleDataException ableDataException) {
                        // empty catch block
                    }
                }
                vector.add(object);
                Object object2 = ablePredicate.getTail();
                if (object2 instanceof AbleVariable && ((AbleVariable)object2).isBound()) {
                    try {
                        object2 = ((AbleVariable)object2).getGenericValue();
                    }
                    catch (AbleDataException ableDataException) {
                        // empty catch block
                    }
                }
                if (object2 instanceof AblePredicate) {
                    ablePredicate = (AblePredicate)object2;
                    continue;
                }
                vector.add(object2);
                ablePredicate = null;
            } while (ablePredicate != null && !ablePredicate.isEmptyList());
        }
        return vector;
    }

    public static String listToString(AblePredicate ablePredicate) {
        if (ablePredicate.isEmptyList()) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        Object object = null;
        AblePredicate ablePredicate2 = ablePredicate;
        do {
            object = ablePredicate2.getHead();
            if (stringBuffer.length() > 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append(object.toString());
            Object object2 = ablePredicate2.getTail();
            if (object2 instanceof AblePredicate) {
                ablePredicate2 = (AblePredicate)object2;
                continue;
            }
            stringBuffer.append(" | " + object2.toString());
            ablePredicate2 = null;
        } while (ablePredicate2 != null && !ablePredicate2.isEmptyList());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String arlString() {
        int n = this.argList.size();
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.isList()) {
            if (this.isEmptyList()) {
                stringBuffer.append("[]");
            } else {
                stringBuffer.append("[");
                Object object = null;
                AblePredicate ablePredicate = this;
                do {
                    object = ablePredicate.getHead();
                    if (stringBuffer.length() > 1) {
                        stringBuffer.append(",");
                    }
                    if (object instanceof String) {
                        stringBuffer.append(object);
                    } else if (object instanceof AbleVariable) {
                        stringBuffer.append(((AbleVariable)object).arlCRdString());
                    } else if (object instanceof AbleLiteral) {
                        stringBuffer.append(((AbleRd)object).arlCRdString());
                    } else if (object instanceof AblePredicate) {
                        stringBuffer.append(((AblePredicate)object).arlString());
                    }
                    Object object2 = ablePredicate.getTail();
                    if (object2 instanceof AblePredicate) {
                        ablePredicate = (AblePredicate)object2;
                        continue;
                    }
                    stringBuffer.append(" | ");
                    if (object2 instanceof String) {
                        stringBuffer.append(object2);
                    } else if (object2 instanceof AbleLiteral) {
                        stringBuffer.append(((AbleRd)object2).arlCRdString());
                    } else if (object2 instanceof AbleVariable) {
                        stringBuffer.append(((AbleVariable)object2).arlCRdString());
                    }
                    ablePredicate = null;
                } while (ablePredicate != null && !ablePredicate.isEmptyList());
                stringBuffer.append("]");
            }
        } else {
            stringBuffer.append(this.name);
            stringBuffer.append("(");
            for (int i = 0; i < n; ++i) {
                Object e = this.argList.get(i);
                stringBuffer.append(this.arlString(e));
                if (i >= n - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private String arlString(Object object) {
        String string = "";
        string = object == null ? "<null>" : (object instanceof AblePredicate ? ((AblePredicate)object).arlString() : (object instanceof AbleRd ? ((AbleRd)object).arlCRdString() : object.toString()));
        return string;
    }

    public String getTemplateString(Vector vector) {
        int n = this.argList.size();
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.name.equals(ListPredicate)) {
            int n2 = n;
            boolean bl = true;
            stringBuffer.append("[");
            if (n > 0) {
                if (this.argList.lastElement() instanceof AbleEmptyListPredicate) {
                    n2 = n - 1;
                    bl = false;
                }
                for (int i = 0; i < n2; ++i) {
                    Object e = this.argList.get(i);
                    stringBuffer.append(this.getTemplateString(vector, e));
                    if (bl) {
                        if (i == n2 - 2) {
                            stringBuffer.append("|");
                            continue;
                        }
                        if (i >= n2 - 1) continue;
                        stringBuffer.append(",");
                        continue;
                    }
                    if (i >= n2 - 1) continue;
                    stringBuffer.append(",");
                }
            }
            stringBuffer.append("]");
        } else {
            stringBuffer.append(this.name);
            stringBuffer.append("(");
            for (int i = 0; i < n; ++i) {
                Object e = this.argList.get(i);
                stringBuffer.append(this.getTemplateString(vector, e));
                if (i >= n - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private String getTemplateString(Vector vector, Object object) {
        String string = "";
        string = object instanceof AblePredicate ? ((AblePredicate)object).getTemplateString(vector) : (object instanceof AbleRd ? ((AbleRd)object).getTemplateString(vector) : object.toString());
        return string;
    }

    public String armlString() {
        return "<predicate>" + this.arlString() + "</predicate>" + Able.LS;
    }

    public String xmlCRdString() {
        return this.xmlString();
    }

    public String xmlString() {
        String string = "";
        int n = this.argList.size();
        String string2 = " name=\"" + this.name + "\"";
        if (this.name.equals(ListPredicate)) {
            int n2 = n;
            boolean bl = true;
            string = string + "" + "<predicateListArg>" + Able.LS;
            if (n > 0) {
                if (this.argList.lastElement() instanceof AbleEmptyListPredicate) {
                    n2 = n - 1;
                    bl = false;
                }
                for (int i = 0; i < n2; ++i) {
                    Object e = this.argList.get(i);
                    string = string + this.xmlString2(e);
                    if (!bl || i != n2 - 2) continue;
                    string = string + "          " + "<predicateListArgTail/>" + Able.LS;
                }
            }
            string = string + "          " + "</predicateListArg>" + Able.LS;
        } else {
            string = string + "        " + "<predicateDef" + string2 + ">" + Able.LS;
            for (int i = 0; i < n; ++i) {
                Object e = this.argList.get(i);
                string = string + this.xmlString2(e);
            }
            string = string + "        " + "</predicateDef>" + Able.LS;
        }
        return string;
    }

    private String xmlString2(Object object) {
        String string = "          ";
        try {
            if (object instanceof AblePredicate) {
                string = string + ((AblePredicate)object).xmlString();
            } else if (object instanceof AbleBooleanLiteral) {
                String string2 = ((AbleBooleanLiteral)object).getStringValue();
                string = string + "<predicateBooleanArg value=\"" + string2 + "\"/>" + Able.LS;
            } else if (object instanceof AbleGenericVariable) {
                String string3 = ((AbleGenericVariable)object).getName();
                string = string3.equalsIgnoreCase(DontCareSymbol) ? string + "<predicateDontCareSymbol/>" + Able.LS : string + "<predicateVariableArg varRef=\"" + string3 + "\"/>" + Able.LS;
            } else if (object instanceof AbleDoubleLiteral) {
                String string4 = ((AbleDoubleLiteral)object).getStringValue();
                string = string + "<predicateNumericArg value=\"" + string4 + "\"/>" + Able.LS;
            } else if (object instanceof AbleStringLiteral) {
                String string5 = ((AbleStringLiteral)object).getStringValue();
                string = string + "<predicateStringArg value=\"" + AbleData.escapeXMLString(string5) + "\"/>" + Able.LS;
            } else if (object instanceof AbleCharacterLiteral) {
                String string6 = ((AbleCharacterLiteral)object).getStringValue();
                string = string + "<predicateCharacterArg value=\"" + AbleData.escapeXMLString(string6) + "\"/>" + Able.LS;
            } else if (object instanceof AbleTypedVariable) {
                String string7 = ((AbleTypedVariable)object).getName();
                string = string + "<predicateVariableArg varRef=\"" + string7 + "\"/>" + Able.LS;
            } else {
                String string8;
                string = object instanceof String ? ((string8 = ((String)object).toString()).equalsIgnoreCase(DontCareSymbol) ? string + "<predicateDontCareSymbol/>\n" : string + "<predicateSymbol value=\"" + AbleData.escapeXMLString(string8) + "\"/>" + Able.LS) : object.toString();
            }
        }
        catch (AbleDataException ableDataException) {
            string = string + "<!-- Exception: " + ableDataException + "-->";
        }
        return string;
    }

    public String toString() {
        if (this.isGround()) {
            return this.arlString();
        }
        if (this.isBound()) {
            AblePredicate ablePredicate = this.makeGround();
            return ablePredicate.arlString();
        }
        return this.arlString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlString();
            }
            case 4: {
                return this.arlString();
            }
            case 5: {
                return this.xmlString();
            }
        }
        return this.arlString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isList()) {
            if (this.isEmptyList()) {
                stringBuffer.append("[]");
            } else {
                stringBuffer.append("[");
                Object object = null;
                AblePredicate ablePredicate = this;
                do {
                    object = ablePredicate.getHead();
                    if (stringBuffer.length() > 1) {
                        stringBuffer.append(",");
                    }
                    if (object instanceof String) {
                        stringBuffer.append(object);
                    } else if (object instanceof AbleVariable) {
                        stringBuffer.append(((AbleVariable)object).traceString(n));
                    } else if (object instanceof AbleLiteral) {
                        stringBuffer.append(((AbleRd)object).traceString(n));
                    } else if (object instanceof AblePredicate) {
                        stringBuffer.append(((AblePredicate)object).traceString(n));
                    }
                    Object object2 = ablePredicate.getTail();
                    if (object2 instanceof AblePredicate) {
                        ablePredicate = (AblePredicate)object2;
                        continue;
                    }
                    stringBuffer.append(" | ");
                    if (object2 instanceof String) {
                        stringBuffer.append(object2);
                    } else if (object2 instanceof AbleLiteral) {
                        stringBuffer.append(((AbleRd)object2).traceString(n));
                    } else if (object2 instanceof AbleVariable) {
                        stringBuffer.append(((AbleVariable)object2).traceString(n));
                    }
                    ablePredicate = null;
                } while (ablePredicate != null && !ablePredicate.isEmptyList());
                stringBuffer.append("]");
            }
        } else {
            stringBuffer.append(this.name);
            stringBuffer.append("(");
            for (int i = 0; i < this.argList.size(); ++i) {
                Object e;
                if (i != 0) {
                    stringBuffer.append(",");
                }
                if ((e = this.argList.get(i)) instanceof AbleVariable) {
                    stringBuffer.append(((AbleVariable)e).traceString(n));
                    continue;
                }
                if (e instanceof AblePredicate) {
                    stringBuffer.append(((AblePredicate)e).traceString(n));
                    continue;
                }
                stringBuffer.append(e.toString());
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

