/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleDoubleLiteral;
import com.ibm.able.data.AbleFloatLiteral;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleIntegerLiteral;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleTypedVariable;
import java.io.Serializable;

public class AbleIntegerVariable
extends AbleTypedVariable
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static String clsNm = "AbleIntegerVariable";
    protected int myValue;
    static /* synthetic */ Class class$com$ibm$able$data$AbleIntegerLiteral;

    public AbleIntegerVariable(String string, int n) {
        super(string, false, false, new Integer(n), "Integer");
        this.myDataType = 24;
        this.myValue = n;
        this.myValueInitial = new AbleIntegerLiteral(n);
    }

    public AbleIntegerVariable(String string, boolean bl, boolean bl2, int n) {
        super(string, bl, bl2, new Integer(n), "Integer");
        this.myDataType = 24;
        this.myValue = n;
        this.myValueInitial = new AbleIntegerLiteral(n);
    }

    public AbleIntegerVariable(String string, boolean bl, boolean bl2) {
        super(string, bl, bl2, "Integer", "com.ibm.able.data.AbleIntegerVariable");
        this.myDataType = 24;
        this.myValue = 0;
        this.myValueInitial = null;
    }

    public boolean getBooleanValue() throws AbleDataException {
        return (double)this.myValue != 0.0;
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToFuzzy", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        return new Integer(this.myValue);
    }

    public double getNumericValue() throws AbleDataException {
        return this.myValue;
    }

    public String getStringValue() throws AbleDataException {
        return this.getValueString();
    }

    public AbleLiteral getValue() throws AbleDataException {
        return new AbleIntegerLiteral(this.myValue);
    }

    public void asgnEq(AbleRd ableRd) throws AbleDataException {
        this.setRawValue((int)ableRd.getNumericValue());
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        return (double)this.myValue == ableRd.getNumericValue();
    }

    public boolean cmpGt(AbleRd ableRd) throws AbleDataException {
        return (double)this.myValue > ableRd.getNumericValue();
    }

    public boolean cmpGtEq(AbleRd ableRd) throws AbleDataException {
        return (double)this.myValue >= ableRd.getNumericValue();
    }

    public boolean cmpLt(AbleRd ableRd) throws AbleDataException {
        return (double)this.myValue < ableRd.getNumericValue();
    }

    public boolean cmpLtEq(AbleRd ableRd) throws AbleDataException {
        return (double)this.myValue <= ableRd.getNumericValue();
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        return (double)this.myValue != ableRd.getNumericValue();
    }

    public AbleLiteral compPlus(AbleRd ableRd) throws AbleDataException {
        Class clazz = ableRd.getDataTypeClass();
        if (clazz == Double.TYPE) {
            return new AbleDoubleLiteral((double)this.myValue + ableRd.getNumericValue());
        }
        if (clazz == Float.TYPE) {
            return new AbleFloatLiteral((double)this.myValue + ableRd.getNumericValue());
        }
        return new AbleIntegerLiteral(this.myValue + (int)ableRd.getNumericValue());
    }

    public AbleLiteral compMinus(AbleRd ableRd) throws AbleDataException {
        Class clazz = ableRd.getDataTypeClass();
        if (clazz == Double.TYPE) {
            return new AbleDoubleLiteral((double)this.myValue - ableRd.getNumericValue());
        }
        if (clazz == Float.TYPE) {
            return new AbleFloatLiteral((double)this.myValue - ableRd.getNumericValue());
        }
        return new AbleIntegerLiteral(this.myValue - (int)ableRd.getNumericValue());
    }

    public AbleLiteral compMultiply(AbleRd ableRd) throws AbleDataException {
        Class clazz = ableRd.getDataTypeClass();
        if (clazz == Double.TYPE) {
            return new AbleDoubleLiteral((double)this.myValue * ableRd.getNumericValue());
        }
        if (clazz == Float.TYPE) {
            return new AbleFloatLiteral((double)this.myValue * ableRd.getNumericValue());
        }
        return new AbleIntegerLiteral(this.myValue * (int)ableRd.getNumericValue());
    }

    public AbleLiteral compDivide(AbleRd ableRd) throws AbleDataException {
        Class clazz = ableRd.getDataTypeClass();
        if (clazz == Double.TYPE) {
            return new AbleDoubleLiteral((double)this.myValue / ableRd.getNumericValue());
        }
        if (clazz == Float.TYPE) {
            return new AbleFloatLiteral((double)this.myValue / ableRd.getNumericValue());
        }
        return new AbleIntegerLiteral(this.myValue / (int)ableRd.getNumericValue());
    }

    public AbleLiteral compUnaryMinus(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(0 - this.myValue);
    }

    public AbleLiteral compModulo(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.myValue % (int)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseAND(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.myValue & (int)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseOR(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.myValue | (int)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseXOR(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.myValue ^ (int)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseNOT(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(~this.myValue);
    }

    public AbleLiteral bitwiseShiftLeft(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.myValue << (int)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseShiftRight(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.myValue >> (int)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseShiftRightZeroFill(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.myValue >>> (int)ableRd.getNumericValue());
    }

    public void setBooleanValue(boolean bl) throws AbleDataException {
        if (bl) {
            this.setRawValue(1);
        } else {
            this.setRawValue(0);
        }
    }

    public void setFuzzyValue(AbleFuzzySet ableFuzzySet) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromFuzzy", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public void setGenericValue(Object object) throws AbleDataException {
        if (object instanceof Boolean) {
            this.setBooleanValue((Boolean)object);
        } else if (object instanceof Number) {
            this.setNumericValue(((Number)object).doubleValue());
        } else if (object instanceof String) {
            this.setStringValue((String)object);
        } else if (object instanceof AbleLiteral) {
            this.setValue((AbleLiteral)object);
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromGeneric", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
        }
    }

    public void setNumericValue(double d) throws AbleDataException {
        this.setRawValue((int)d);
    }

    public void setStringValue(String string) throws AbleDataException {
        this.setValueString(string);
    }

    public void setValue(AbleLiteral ableLiteral) throws AbleDataException {
        this.setRawValue((int)ableLiteral.getNumericValue());
    }

    public String arlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myComment.length() > 0) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        stringBuffer.append(this.isTemplate() ? "    template " : "    ");
        stringBuffer.append(this.isStatic() ? "    static " : "    ");
        stringBuffer.append("Integer " + this.myName);
        if (this.myValueInitial == null) {
            stringBuffer.append(";" + Able.LS);
        } else {
            stringBuffer.append(" = " + this.myValueInitial.arlCRdString() + ";" + Able.LS);
        }
        return stringBuffer.toString();
    }

    public String xmlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <declareVar varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"" + " dataType=\"" + "Integer" + "\"" + (this.isStatic() ? " static=\"true\"" : "") + (this.isTemplate() ? " template=\"true\"" : "") + ">" + Able.LS);
        stringBuffer.append(this.xmlInitializerString());
        stringBuffer.append("       </declareVar>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <Variable varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"" + " dataType=\"" + "Integer" + "\"" + (this.isStatic() ? " static=\"true\"" : "") + (this.isTemplate() ? " template=\"true\"" : "") + ">" + Able.LS);
        stringBuffer.append(this.armlInitializerString());
        stringBuffer.append("       </Variable>" + Able.LS);
        return stringBuffer.toString();
    }

    public void setValueString(String string) throws AbleDataException {
        try {
            Integer n = Integer.valueOf(string);
            this.setRawValue(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidNumericString", new Object[]{Integer.toString(this.myId), this.myName, string}));
        }
    }

    public String getValueString() {
        return Integer.toString(this.myValue);
    }

    public void reset() throws AbleDataException {
        if (!this.myStaticFlag) {
            this.init();
        }
    }

    public void init() throws AbleDataException {
        if (this.myValueInitial == null) {
            this.myValue = 0;
            this.myBoundFlag = false;
        } else {
            this.myValue = (int)this.myValueInitial.getNumericValue();
            this.myBoundFlag = true;
        }
    }

    public Class getDataTypeClass() {
        return Integer.TYPE;
    }

    public String getDataTypeClassName() {
        return Integer.TYPE.getName();
    }

    public Class getLiteralClass() {
        return class$com$ibm$able$data$AbleIntegerLiteral == null ? (class$com$ibm$able$data$AbleIntegerLiteral = AbleIntegerVariable.class$("com.ibm.able.data.AbleIntegerLiteral")) : class$com$ibm$able$data$AbleIntegerLiteral;
    }

    void setRawValue(int n) throws AbleDataException {
        int n2 = this.myValue;
        this.myValue = n;
        this.myBoundFlag = true;
        if (this.myContext != null) {
            this.myContext.updateCurrentFactBase(this.myId);
        }
        if (this.myChgSupport != null) {
            this.myChgSupport.firePropertyChange("NumericValue " + this.myName, new Integer(n2), new Integer(n));
        }
    }

    public Object getRawValue() {
        return new Integer(this.myValue);
    }

    public String toString() {
        return this.arlDclString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlDclString();
            }
            case 4: {
                return this.arlDclString();
            }
            case 5: {
                return this.xmlDclString();
            }
        }
        return this.arlDclString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.myName + ":<" + this.getValueString() + ">");
        return stringBuffer.toString();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

