/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleArrayLiteral;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AblePredicate;
import com.ibm.able.data.AbleRd;
import java.io.Serializable;

public class AbleGenericLiteral
extends AbleLiteral
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static final String clsNm = "AbleGenericLiteral";
    public static final AbleGenericLiteral NULL_LITERAL = new AbleGenericLiteral(null);
    protected final Object myValue;
    static /* synthetic */ Class class$java$lang$Object;

    public AbleGenericLiteral(Object object) {
        this.myValue = object;
    }

    public AbleGenericLiteral() {
        this.myValue = null;
    }

    public boolean getBooleanValue() throws AbleDataException {
        if (this.myValue == null) {
            throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToBoolean", new Object[]{clsNm}));
        }
        if (this.myValue instanceof Boolean) {
            return (Boolean)this.myValue;
        }
        if (this.myValue instanceof Number) {
            double d = ((Number)this.myValue).doubleValue();
            return d != 0.0;
        }
        if (this.myValue instanceof String) {
            String string = (String)this.myValue;
            if (string.equalsIgnoreCase("True")) {
                return true;
            }
            if (string.equalsIgnoreCase("False")) {
                return false;
            }
            throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToBoolean", new Object[]{clsNm}));
        }
        if (this.myValue instanceof AbleLiteral) {
            return ((AbleLiteral)this.myValue).getBooleanValue();
        }
        throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToBoolean", new Object[]{clsNm}));
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        if (this.myValue == null) {
            throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToFuzzy", new Object[]{clsNm}));
        }
        if (this.myValue instanceof AbleFuzzySet) {
            return (AbleFuzzySet)this.myValue;
        }
        throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToFuzzy", new Object[]{clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        return this.myValue;
    }

    public double getNumericValue() throws AbleDataException {
        if (this.myValue == null) {
            throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToNumeric", new Object[]{clsNm}));
        }
        if (this.myValue instanceof Boolean) {
            boolean bl = (Boolean)this.myValue;
            if (bl) {
                return 1.0;
            }
            return 0.0;
        }
        if (this.myValue instanceof Number) {
            return ((Number)this.myValue).doubleValue();
        }
        if (this.myValue instanceof String) {
            String string = (String)this.myValue;
            Double d = new Double(Double.NaN);
            try {
                d = Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToNumeric", new Object[]{clsNm}));
            }
            return d;
        }
        if (this.myValue instanceof AbleLiteral) {
            return ((AbleLiteral)this.myValue).getNumericValue();
        }
        throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToNumeric", new Object[]{clsNm}));
    }

    public String getStringValue() throws AbleDataException {
        if (this.myValue == null) {
            return "null";
        }
        if (this.myValue instanceof Boolean) {
            boolean bl = (Boolean)this.myValue;
            if (bl) {
                return "true";
            }
            return "false";
        }
        if (this.myValue instanceof Number) {
            return Double.toString(((Number)this.myValue).doubleValue());
        }
        if (this.myValue instanceof String) {
            return (String)this.myValue;
        }
        if (this.myValue.getClass().isArray()) {
            return AbleArrayLiteral.arrayToString(this.myValue);
        }
        if (this.myValue instanceof AbleLiteral) {
            return ((AbleLiteral)this.myValue).getStringValue();
        }
        return this.myValue.toString();
    }

    public AbleLiteral getValue() throws AbleDataException {
        return this;
    }

    public Class getDataTypeClass() {
        if (this.myValue == null) {
            return class$java$lang$Object == null ? (class$java$lang$Object = AbleGenericLiteral.class$("java.lang.Object")) : class$java$lang$Object;
        }
        return this.myValue.getClass();
    }

    public String getDataTypeClassName() {
        if (this.myValue == null) {
            return (class$java$lang$Object == null ? (class$java$lang$Object = AbleGenericLiteral.class$("java.lang.Object")) : class$java$lang$Object).getName();
        }
        return this.myValue.getClass().getName();
    }

    public String arlCRdString() {
        if (this.myValue != null && this.myValue instanceof AblePredicate) {
            return ((AblePredicate)this.myValue).arlString();
        }
        return "";
    }

    public String xmlCRdString() {
        if (this.myValue != null && this.myValue instanceof AblePredicate) {
            return ((AblePredicate)this.myValue).xmlString();
        }
        return "";
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        if (this.myValue == null) {
            return null == ableRd.getGenericValue();
        }
        return this.getGenericValue().equals(ableRd.getGenericValue());
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        if (this.myValue == null) {
            return null != ableRd.getGenericValue();
        }
        return !this.getGenericValue().equals(ableRd.getGenericValue());
    }

    public String toString() {
        return this.arlCRdString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlCRdString();
            }
            case 4: {
                return this.arlCRdString();
            }
            case 5: {
                return this.xmlCRdString();
            }
        }
        return this.arlCRdString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.myValue instanceof AblePredicate) {
            stringBuffer.append(((AblePredicate)this.myValue).traceString(n));
        } else {
            try {
                stringBuffer.append(this.getStringValue() + ">");
            }
            catch (AbleDataException ableDataException) {
                stringBuffer.append("--Undetermined-->");
                Able.MessageLog.text(262144L, this, "traceString", "AbleDataException obtaining trace string.");
            }
        }
        return stringBuffer.toString();
    }

    public int getDataType() {
        return 3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

