/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleContinuousVariable;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataContext;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleDoubleLiteral;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleFuzzySetBeta;
import com.ibm.able.data.AbleFuzzySetGaussian;
import com.ibm.able.data.AbleFuzzySetLinear;
import com.ibm.able.data.AbleFuzzySetPi;
import com.ibm.able.data.AbleFuzzySetSegments;
import com.ibm.able.data.AbleFuzzySetShoulder;
import com.ibm.able.data.AbleFuzzySetSigmoid;
import com.ibm.able.data.AbleFuzzySetTrapezoid;
import com.ibm.able.data.AbleFuzzySetTriangle;
import com.ibm.able.data.AbleFuzzySetWork;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AbleFuzzyVariable
extends AbleContinuousVariable
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static String clsNm = "AbleFuzzyVariable";
    protected Hashtable mySetList;
    protected double myValCrisp;
    protected AbleFuzzySetWork myValFzy;
    protected boolean myValKnown;
    protected AbleFuzzySetWork myValFzyTmp;
    protected double myAlphaCut;
    protected int myDefuzzifyMethod = 1;
    static /* synthetic */ Class class$com$ibm$able$data$AbleFuzzySetWork;

    public AbleFuzzyVariable(String string, double d, double d2, double d3) {
        super(string, d, d2);
        this.myDataType = 15;
        this.mySetList = new Hashtable();
        this.myValKnown = false;
        this.myValCrisp = 0.0;
        this.myAlphaCut = d3;
        this.myValFzy = new AbleFuzzySetWork(this, string + " Fuzzy Solution Space", d3, d, d2);
        this.myValFzyTmp = new AbleFuzzySetWork(this, string + " Fuzzy Work Space", d3, d, d2);
    }

    public AbleFuzzyVariable(String string, boolean bl, boolean bl2, double d, double d2, double d3) {
        super(string, bl, bl2, d, d2);
        this.myDataType = 15;
        this.mySetList = new Hashtable();
        this.myValKnown = false;
        this.myValCrisp = 0.0;
        this.myAlphaCut = d3;
        this.myValFzy = new AbleFuzzySetWork(this, string + " Fuzzy Solution Space", d3, d, d2);
        this.myValFzyTmp = new AbleFuzzySetWork(this, string + " Fuzzy Work Space", d3, d, d2);
    }

    public boolean getBooleanValue() throws AbleDataException {
        return this.myValCrisp != 0.0;
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        return this.myValFzy;
    }

    public Object getGenericValue() throws AbleDataException {
        return new Double(this.getRawValue());
    }

    public double getNumericValue() throws AbleDataException {
        return this.getRawValue();
    }

    public String getStringValue() throws AbleDataException {
        return Double.toString(this.getRawValue());
    }

    public AbleLiteral getValue() throws AbleDataException {
        return new AbleDoubleLiteral(this.getRawValue());
    }

    public double cmpIs(AbleRd ableRd) throws AbleDataException {
        return ableRd.getFuzzyValue().membership(this.getNumericValue());
    }

    public void setBooleanValue(boolean bl) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToBoolean", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public void setFuzzyValue(AbleFuzzySet ableFuzzySet) throws AbleDataException {
        this.setRawValue(ableFuzzySet);
    }

    public void setGenericValue(Object object) throws AbleDataException {
        if (object instanceof Boolean) {
            this.setBooleanValue((Boolean)object);
        } else if (object instanceof Number) {
            this.setNumericValue(((Number)object).doubleValue());
        } else if (object instanceof String) {
            this.setStringValue((String)object);
        } else if (object instanceof AbleLiteral) {
            this.setValue((AbleLiteral)object);
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromGeneric", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
        }
    }

    public void setNumericValue(double d) throws AbleDataException {
        this.setRawValue(d);
    }

    public void setStringValue(String string) throws AbleDataException {
        this.setValueString(string);
    }

    public void setValue(AbleLiteral ableLiteral) throws AbleDataException {
        switch (ableLiteral.getDataType()) {
            case 6: {
                this.setFuzzyValue(ableLiteral.getFuzzyValue());
                break;
            }
            default: {
                this.setNumericValue(ableLiteral.getNumericValue());
            }
        }
    }

    public String arlDclString() {
        Enumeration enumeration = this.mySetList.elements();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myComment.length() > 0) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        stringBuffer.append(this.isTemplate() ? "    template " : "    ");
        stringBuffer.append((this.isStatic() ? "    static" : "    ") + "Fuzzy " + this.myName + " = new Fuzzy(" + this.myDiscourseLo + " , " + this.myDiscourseHi + ")  { " + Able.LS);
        while (enumeration.hasMoreElements()) {
            AbleFuzzySet ableFuzzySet = (AbleFuzzySet)enumeration.nextElement();
            String string = ableFuzzySet.getSetName();
            int n = string.indexOf(" ");
            if (n >= 0) continue;
            stringBuffer.append(ableFuzzySet.arlString());
        }
        stringBuffer.append("     };" + Able.LS);
        return stringBuffer.toString();
    }

    public String xmlDclString() {
        Enumeration enumeration = this.mySetList.elements();
        String string = "";
        string = string + "    " + "<declareVar varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"" + " dataType=\"" + "Fuzzy" + "\"" + (this.isStatic() ? " static=\"true\"" : "") + " from=\"" + this.myDiscourseLo + "\" to=\"" + this.myDiscourseHi + "\">" + Able.LS;
        if (enumeration.hasMoreElements()) {
            string = string + "      " + "<setDefinitions>" + Able.LS;
            while (enumeration.hasMoreElements()) {
                AbleFuzzySet ableFuzzySet = (AbleFuzzySet)enumeration.nextElement();
                String string2 = ableFuzzySet.getSetName();
                int n = string2.indexOf(" ");
                if (n >= 0) continue;
                string = string + ableFuzzySet.xmlString() + Able.LS;
            }
            string = string + "      " + "</setDefinitions>" + Able.LS;
        }
        string = string + "    " + "</declareVar>" + Able.LS;
        return string;
    }

    public String xmlCWrString() {
        String string = "";
        string = string + "<fuzzyVar varRef=\"" + this.myName + "\"/>";
        return string;
    }

    public String armlDclString() {
        Enumeration enumeration = this.mySetList.elements();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <FuzzyVariable varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"" + " dataType=\"" + "Fuzzy" + "\"" + (this.isStatic() ? " static=\"true\"" : "") + (this.isTemplate() ? " template=\"true\"" : "") + " from=\"" + this.myDiscourseLo + "\" to=\"" + this.myDiscourseHi + "\">" + Able.LS);
        stringBuffer.append(this.armlInitializerString());
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                String string;
                AbleFuzzySet ableFuzzySet = (AbleFuzzySet)enumeration.nextElement();
                String string2 = ableFuzzySet.getSetName();
                int n = string2.indexOf(" ");
                if (n >= 0 || (string = ableFuzzySet.arlString()).length() <= 0) continue;
                stringBuffer.append("      <setDefinition>" + string + "</setDefinition>" + Able.LS);
            }
        }
        stringBuffer.append("       </FuzzyVariable>" + Able.LS);
        return stringBuffer.toString();
    }

    public void asgnIs(AbleRd ableRd) throws AbleDataException {
        this.setFuzzyValue(ableRd.getFuzzyValue());
    }

    public void asgnIs(AbleRd ableRd, double d) throws AbleDataException {
        this.setFuzzyValue(ableRd.getFuzzyValue(), d);
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        return this.myValCrisp == ableRd.getNumericValue();
    }

    public boolean cmpGt(AbleRd ableRd) throws AbleDataException {
        return this.myValCrisp > ableRd.getNumericValue();
    }

    public boolean cmpGtEq(AbleRd ableRd) throws AbleDataException {
        return this.myValCrisp >= ableRd.getNumericValue();
    }

    public boolean cmpLt(AbleRd ableRd) throws AbleDataException {
        return this.myValCrisp < ableRd.getNumericValue();
    }

    public boolean cmpLtEq(AbleRd ableRd) throws AbleDataException {
        return this.myValCrisp <= ableRd.getNumericValue();
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        return this.myValCrisp != ableRd.getNumericValue();
    }

    public AbleLiteral compPlus(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(this.myValCrisp + ableRd.getNumericValue());
    }

    public AbleLiteral compMinus(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(this.myValCrisp - ableRd.getNumericValue());
    }

    public AbleLiteral compMultiply(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(this.myValCrisp * ableRd.getNumericValue());
    }

    public AbleLiteral compDivide(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(this.myValCrisp / ableRd.getNumericValue());
    }

    public AbleLiteral compUnaryMinus(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(0.0 - this.myValCrisp);
    }

    public void setValueString(String string) throws AbleDataException {
        try {
            Double d = Double.valueOf(string);
            this.setRawValue(d);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidNumericString", new Object[]{Integer.toString(this.myId), this.myName, string}));
        }
    }

    public String getValueString() {
        return Double.toString(this.myValCrisp);
    }

    public void reset() throws AbleDataException {
        if (!this.myStaticFlag) {
            if (this.myValueInitial == null) {
                this.myValue = Double.NaN;
                this.myBoundFlag = false;
            } else {
                this.myValue = this.myInitialValue;
                this.myBoundFlag = true;
            }
            this.myValKnown = false;
            this.myValCrisp = 0.0;
            this.myValFzy.reset();
            if (this.myChgSupport != null) {
                this.myChgSupport.firePropertyChange("FuzzyValue " + this.myName, null, null);
            }
            this.myValFzyTmp.reset();
            if (this.myChgSupport != null) {
                this.myChgSupport.firePropertyChange("FuzzyWorkArea " + this.myName, null, null);
            }
        }
    }

    public Class getDataTypeClass() {
        return class$com$ibm$able$data$AbleFuzzySetWork == null ? (class$com$ibm$able$data$AbleFuzzySetWork = AbleFuzzyVariable.class$("com.ibm.able.data.AbleFuzzySetWork")) : class$com$ibm$able$data$AbleFuzzySetWork;
    }

    public String getDataTypeClassName() {
        return (class$com$ibm$able$data$AbleFuzzySetWork == null ? (class$com$ibm$able$data$AbleFuzzySetWork = AbleFuzzyVariable.class$("com.ibm.able.data.AbleFuzzySetWork")) : class$com$ibm$able$data$AbleFuzzySetWork).getName();
    }

    void setRawValue(double d) throws AbleDataException {
        if (this.withinUniverseOfDiscourse(d)) {
            double d2 = this.myValCrisp;
            this.myValCrisp = d;
            if (this.myContext != null) {
                this.myContext.updateCurrentFactBase(this.myId);
            }
            if (this.myChgSupport != null) {
                this.myChgSupport.firePropertyChange("CrispValue " + this.myName, new Double(d2), new Double(d));
            }
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
    }

    double getRawValue() {
        return this.myValCrisp;
    }

    void setRawValue(AbleFuzzySet ableFuzzySet) throws AbleDataException {
        if (this.myContext != null) {
            this.myContext.updateCurrentFactBase(this.myId);
        }
        Vector vector = this.myValFzy.getSetProperties();
        this.myValFzy.copyOrAssertFzy(ableFuzzySet);
        Vector vector2 = this.myValFzy.getSetProperties();
        if (this.myChgSupport != null) {
            this.myChgSupport.firePropertyChange("FuzzyValue " + this.myName, vector, vector2);
        }
        this.setRawValue(this.myValFzy.defuzzify(this.myDefuzzifyMethod));
    }

    void setFuzzyValue(AbleFuzzySet ableFuzzySet, double d) throws AbleDataException {
        AbleDataContext ableDataContext = this.myContext;
        Vector vector = this.myValFzy.getSetProperties();
        this.myValFzyTmp.correlateWith(ableFuzzySet, ableDataContext.getCorrelationMethod(), d);
        if (this.myChgSupport != null) {
            this.myChgSupport.firePropertyChange("FuzzyWorkArea " + this.myName, null, null);
        }
        this.myValFzy.implicateTo(this.myValFzyTmp, ableDataContext.getFuzzyInferenceMethod());
        Vector vector2 = this.myValFzy.getSetProperties();
        if (this.myChgSupport != null) {
            this.myChgSupport.firePropertyChange("FuzzyValue " + this.myName, vector, vector2);
        }
        this.setRawValue(this.myValFzy.defuzzify(ableDataContext.getDefuzzifyMethod()));
    }

    public Hashtable getFuzzySets() {
        return (Hashtable)this.mySetList.clone();
    }

    public AbleFuzzySet getFuzzyWorkArea() {
        return this.myValFzyTmp;
    }

    public boolean setExist(String string) {
        return this.mySetList.containsKey(string);
    }

    public AbleFuzzySet getSet(String string) {
        if (this.setExist(string)) {
            return (AbleFuzzySet)this.mySetList.get(string);
        }
        return null;
    }

    public AbleFuzzySet getOrAddHedgedSet(String string, String string2) throws AbleDataException {
        String string3 = string + " " + string2;
        if (!this.setExist(string)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarUnknownNamedSet", new Object[]{Integer.toString(this.myId), this.myName, string}));
        }
        if (this.setExist(string3)) {
            return this.getSet(string3);
        }
        ((AbleFuzzySet)this.mySetList.get(string)).addClone(string3);
        ((AbleFuzzySet)this.mySetList.get(string3)).applyHedges(string2);
        return this.getSet(string3);
    }

    synchronized void setApplyComplement(String string) throws AbleDataException {
        if (!this.setExist(string)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarUnknownNamedSet", new Object[]{Integer.toString(this.myId), this.myName, string}));
        }
        ((AbleFuzzySet)this.mySetList.get(string)).applyComplement();
    }

    synchronized void setAddHedges(String string, String string2) throws AbleDataException {
        String string3 = string + " " + string2;
        if (!this.setExist(string)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarUnknownNamedSet", new Object[]{Integer.toString(this.myId), this.myName, string}));
        }
        if (this.setExist(string3)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarNamedSetExists", new Object[]{Integer.toString(this.myId), this.myName, string}));
        }
        ((AbleFuzzySet)this.mySetList.get(string)).addClone(string3);
        ((AbleFuzzySet)this.mySetList.get(string3)).applyHedges(string2);
    }

    public void addSet(AbleFuzzySetBeta ableFuzzySetBeta) throws AbleDataException {
        double d = ableFuzzySetBeta.getPtCenter();
        double d2 = ableFuzzySetBeta.getWeight();
        this.validateSetBasics(ableFuzzySetBeta);
        if (this.chkRange(d)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
        if (this.chkWeight(d2)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeWeight", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d2)}));
        }
        this.mySetList.put(ableFuzzySetBeta.getSetName(), ableFuzzySetBeta);
    }

    public void addSet(AbleFuzzySetGaussian ableFuzzySetGaussian) throws AbleDataException {
        double d = ableFuzzySetGaussian.getPtCenter();
        double d2 = ableFuzzySetGaussian.getWidth();
        this.validateSetBasics(ableFuzzySetGaussian);
        if (this.chkRange(d)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
        if (this.chkWidthG(d2)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeWidthG", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d2)}));
        }
        this.mySetList.put(ableFuzzySetGaussian.getSetName(), ableFuzzySetGaussian);
    }

    public void addSet(AbleFuzzySetLinear ableFuzzySetLinear) throws AbleDataException {
        double d = ableFuzzySetLinear.getPtBeg();
        double d2 = ableFuzzySetLinear.getPtEnd();
        int n = ableFuzzySetLinear.getSetDir();
        this.validateSetBasics(ableFuzzySetLinear);
        if (this.chkRange(d)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
        if (this.chkRange(d2)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d2), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
        if (this.chkSeq(d, d2)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidPtSequence2", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d), Double.toString(d2)}));
        }
        if (this.chkSetDirUp(n)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidSetDirUp", new Object[]{Integer.toString(this.myId), this.myName, Integer.toString(n)}));
        }
        this.mySetList.put(ableFuzzySetLinear.getSetName(), ableFuzzySetLinear);
    }

    public void addSet(AbleFuzzySetPi ableFuzzySetPi) throws AbleDataException {
        double d = ableFuzzySetPi.getPtCenter();
        double d2 = ableFuzzySetPi.getWidth();
        this.validateSetBasics(ableFuzzySetPi);
        if (this.chkRange(d)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
        if (d2 <= 0.0) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeWidthP", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d2)}));
        }
        this.mySetList.put(ableFuzzySetPi.getSetName(), ableFuzzySetPi);
    }

    public void addSet(AbleFuzzySetSegments ableFuzzySetSegments) throws AbleDataException {
        int n = ableFuzzySetSegments.getNumberOfValues();
        double[] dArray = ableFuzzySetSegments.getScalarVector();
        double[] dArray2 = ableFuzzySetSegments.getTruthVector();
        this.validateSetBasics(ableFuzzySetSegments);
        if (this.chkIndex(n)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidNumberOfPoints", new Object[]{Integer.toString(this.myId), this.myName, Integer.toString(n), Integer.toString(256)}));
        }
        for (int i = 0; i < n; ++i) {
            if (this.chkRange(dArray[i])) {
                throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(dArray[i]), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
            }
            if (this.chkTv(dArray2[i])) {
                throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidTruthValue", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(dArray2[i])}));
            }
            if (i <= 0 || dArray[i - 1] < dArray[i]) continue;
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidPtSequenceSeg", new Object[]{Integer.toString(this.myId), this.myName}));
        }
        this.mySetList.put(ableFuzzySetSegments.getSetName(), ableFuzzySetSegments);
    }

    public void addSet(AbleFuzzySetShoulder ableFuzzySetShoulder) throws AbleDataException {
        double d = ableFuzzySetShoulder.getPtBeg();
        double d2 = ableFuzzySetShoulder.getPtEnd();
        int n = ableFuzzySetShoulder.getSetDir();
        this.validateSetBasics(ableFuzzySetShoulder);
        if (this.chkRange(d)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
        if (this.chkRange(d2)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d2), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
        if (this.chkSeq(d, d2)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidPtSequence2", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d), Double.toString(d2)}));
        }
        if (this.chkSetDirLe(n)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidSetDirLeft", new Object[]{Integer.toString(this.myId), this.myName, Integer.toString(n)}));
        }
        this.mySetList.put(ableFuzzySetShoulder.getSetName(), ableFuzzySetShoulder);
    }

    public void addSet(AbleFuzzySetSigmoid ableFuzzySetSigmoid) throws AbleDataException {
        double d = ableFuzzySetSigmoid.getPtBeg();
        double d2 = ableFuzzySetSigmoid.getPtEnd();
        double d3 = ableFuzzySetSigmoid.getPtFlex();
        int n = ableFuzzySetSigmoid.getSetDir();
        this.validateSetBasics(ableFuzzySetSigmoid);
        if (this.chkRange(d)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
        if (this.chkRange(d2)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d2), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
        if (this.chkRange(d3)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d3), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
        if (this.chkSeq(d, d3, d2)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidPtSequence3", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d), Double.toString(d3), Double.toString(d2)}));
        }
        if (this.chkSetDirUp(n)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidSetDirUp", new Object[]{Integer.toString(this.myId), this.myName, Integer.toString(n)}));
        }
        this.mySetList.put(ableFuzzySetSigmoid.getSetName(), ableFuzzySetSigmoid);
    }

    public void addSet(AbleFuzzySetTrapezoid ableFuzzySetTrapezoid) throws AbleDataException {
        double d = ableFuzzySetTrapezoid.getPtLeft();
        double d2 = ableFuzzySetTrapezoid.getPtLeftCore();
        double d3 = ableFuzzySetTrapezoid.getPtRightCore();
        double d4 = ableFuzzySetTrapezoid.getPtRight();
        this.validateSetBasics(ableFuzzySetTrapezoid);
        if (this.chkRange(d)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
        if (this.chkRange(d2)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d2), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
        if (this.chkRange(d3)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d3), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
        if (this.chkRange(d4)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d4), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
        if (this.chkSeq(d, d2, d3, d4)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidPtSequence4", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d), Double.toString(d2), Double.toString(d3), Double.toString(d4)}));
        }
        this.mySetList.put(ableFuzzySetTrapezoid.getSetName(), ableFuzzySetTrapezoid);
    }

    public void addSet(AbleFuzzySetTriangle ableFuzzySetTriangle) throws AbleDataException {
        double d = ableFuzzySetTriangle.getPtLeft();
        double d2 = ableFuzzySetTriangle.getPtCenter();
        double d3 = ableFuzzySetTriangle.getPtRight();
        this.validateSetBasics(ableFuzzySetTriangle);
        if (this.chkRange(d)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
        if (this.chkRange(d2)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d2), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
        if (this.chkRange(d3)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d3), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
        if (this.chkSeq(d, d2, d3)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidPtSequence3", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d), Double.toString(d2), Double.toString(d3)}));
        }
        this.mySetList.put(ableFuzzySetTriangle.getSetName(), ableFuzzySetTriangle);
    }

    protected void validateSetBasics(AbleFuzzySet ableFuzzySet) throws AbleDataException {
        String string = ableFuzzySet.getSetName();
        double d = ableFuzzySet.getAlphaCut();
        if (this.setExist(string)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarNamedSetExists", new Object[]{Integer.toString(this.myId), this.myName, string}));
        }
        if (this.chkAlphaCut(d)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeAlphaCut", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d)}));
        }
    }

    public void addSetComplement(String string, String string2) throws AbleDataException {
        if (!this.setExist(string)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarUnknownNamedSet", new Object[]{Integer.toString(this.myId), this.myName, string}));
        }
        if (this.setExist(string2)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarNamedSetExists", new Object[]{Integer.toString(this.myId), this.myName, string2}));
        }
        ((AbleFuzzySet)this.mySetList.get(string)).addClone(string2);
        ((AbleFuzzySet)this.mySetList.get(string)).setComplementName(string2);
        ((AbleFuzzySet)this.mySetList.get(string2)).applyComplement();
        ((AbleFuzzySet)this.mySetList.get(string2)).setComplement();
    }

    public void setAlphaCut(double d) {
        this.myAlphaCut = d;
        Enumeration enumeration = this.mySetList.elements();
        while (enumeration.hasMoreElements()) {
            AbleFuzzySet ableFuzzySet = (AbleFuzzySet)enumeration.nextElement();
            ableFuzzySet.setAlphaCut(d);
        }
        if (this.myValFzy != null) {
            this.myValFzy.setAlphaCut(d);
        }
        if (this.myValFzyTmp != null) {
            this.myValFzyTmp.setAlphaCut(d);
        }
    }

    public double getAlphaCut() {
        return this.myAlphaCut;
    }

    public final int getDefuzzifyMethod() {
        return this.myDefuzzifyMethod;
    }

    public void setDefuzzifyMethod(int n) throws AbleDataException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                this.myDefuzzifyMethod = n;
                break;
            }
            default: {
                throw new AbleDataException(Able.NlsMsg("Ex_RsUnrecognizedDefuzzMethod", new Object[]{AbleFuzzySet.DefuzzifyMethod(n)}));
            }
        }
    }

    public void setDiscourseRange(double d, double d2) {
        this.myDiscourseLo = d;
        this.myDiscourseHi = d2;
        this.myValFzy = new AbleFuzzySetWork(this, this.myName + " Fuzzy Solution Space", this.myAlphaCut, this.myDiscourseLo, this.myDiscourseHi);
        this.myValFzyTmp = new AbleFuzzySetWork(this, this.myName + " Fuzzy Work Space", this.myAlphaCut, this.myDiscourseLo, this.myDiscourseHi);
    }

    public void replaceSetSegments(String string, double[] dArray) throws AbleDataException {
        AbleFuzzySet ableFuzzySet = null;
        ableFuzzySet = (AbleFuzzySet)this.mySetList.get(string);
        if (ableFuzzySet == null) {
            throw new AbleDataException(Able.NlsMsg("Ex_RsNoFuzzySet", new Object[]{string, this.myName}));
        }
        int n = ableFuzzySet.getSetType();
        if (n != 5) {
            throw new AbleDataException(Able.NlsMsg("Ex_RsFuzzySetNotSegments", new Object[]{string, this.myName}));
        }
        int n2 = dArray.length;
        int n3 = ((AbleFuzzySetSegments)ableFuzzySet).getNumberOfValues();
        if (n2 != n3) {
            throw new AbleDataException(Able.NlsMsg("Ex_RsFuzzyInvalidTruthValueCount", new Object[]{Integer.toString(n2), string, Integer.toString(n3)}));
        }
        for (int i = 0; i < n3; ++i) {
            if (!this.chkTv(dArray[i])) continue;
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidTruthValue", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(dArray[i])}));
        }
        ((AbleFuzzySetSegments)ableFuzzySet).replaceSegments(dArray);
    }

    private boolean chkAlphaCut(double d) {
        return !(d > 0.0) || !(d < 1.0);
    }

    private boolean chkIndex(int n) {
        return 0 >= n || n > 256;
    }

    private boolean chkSeq(double d, double d2) {
        return !(d < d2);
    }

    private boolean chkSeq(double d, double d2, double d3) {
        return !(d < d2) || !(d2 < d3);
    }

    private boolean chkSeq(double d, double d2, double d3, double d4) {
        return !(d < d2) || !(d2 < d3) || !(d3 < d4);
    }

    private boolean chkSetDirLe(int n) {
        return n != 3 && n != 4;
    }

    private boolean chkSetDirUp(int n) {
        return n != 1 && n != 2;
    }

    private boolean chkTv(double d) {
        return !(0.0 <= d) || !(d <= 1.0);
    }

    private boolean chkWeight(double d) {
        return !(d > 0.0) || !(d <= 1.0);
    }

    private boolean chkWidthG(double d) {
        return !(d > 0.0);
    }

    public String toString() {
        return this.arlDclString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlDclString();
            }
            case 4: {
                return this.arlDclString();
            }
            case 5: {
                return this.xmlDclString();
            }
        }
        return this.arlDclString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.myName + ":<" + this.getValueString() + ">");
        return stringBuffer.toString();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

