/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleFuzzyVariable;
import java.io.Serializable;

public class AbleFuzzySetWork
extends AbleFuzzySet
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static final String clsNm = "AbleFuzzySetWork";
    boolean mySetEmpty = true;

    AbleFuzzySetWork(AbleFuzzyVariable ableFuzzyVariable, String string, double d, double d2, double d3) {
        super(10, string, ableFuzzyVariable, d, d2, d3);
    }

    void addClone(String string) {
    }

    public String arlString() {
        return "";
    }

    public String xmlString() {
        return "";
    }

    public boolean isEmpty() {
        return this.mySetEmpty;
    }

    void copyOrAssertFzy(AbleFuzzySet ableFuzzySet) {
        if (this.mySetEmpty) {
            this.copy(ableFuzzySet);
        } else {
            this.assertSet(ableFuzzySet);
        }
    }

    void correlateWith(AbleFuzzySet ableFuzzySet, int n, double d) throws AbleDataException {
        switch (n) {
            case 2: {
                for (int i = 0; i < 256; ++i) {
                    this.myTruthVector[i] = d <= ableFuzzySet.getTruthValue(i) ? d : ableFuzzySet.getTruthValue(i);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < 256; ++i) {
                    this.myTruthVector[i] = ableFuzzySet.getTruthValue(i) * d;
                }
                break;
            }
            default: {
                throw new AbleDataException(Able.NlsMsg("Ex_SetUnrecognisedCorrMethod", new Object[]{AbleFuzzySet.CorrelationMethod(n)}));
            }
        }
    }

    void implicateTo(AbleFuzzySetWork ableFuzzySetWork, int n) throws AbleDataException {
        switch (n) {
            case 0: {
                for (int i = 0; i < 256; ++i) {
                    double d = this.myTruthVector[i] + ableFuzzySetWork.getTruthValue(i);
                    this.myTruthVector[i] = d < 1.0 ? d : 1.0;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < 256; ++i) {
                    if (!(this.myTruthVector[i] < ableFuzzySetWork.getTruthValue(i))) continue;
                    this.myTruthVector[i] = ableFuzzySetWork.getTruthValue(i);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < 256; ++i) {
                    this.myTruthVector[i] = 1.0 - (1.0 - this.myTruthVector[i]) * (1.0 - ableFuzzySetWork.getTruthValue(i));
                }
                break;
            }
            default: {
                throw new AbleDataException(Able.NlsMsg("Ex_SetUnrecognisedInferMethod", new Object[]{new Integer(n)}));
            }
        }
    }

    void reset() {
        this.mySetEmpty = true;
        for (int i = 0; i < 256; ++i) {
            this.myTruthVector[i] = 0.0;
        }
    }

    void assertSet(AbleFuzzySet ableFuzzySet) {
        for (int i = 0; i < 256; ++i) {
            if (!(this.myTruthVector[i] > ableFuzzySet.getTruthValue(i))) continue;
            this.myTruthVector[i] = ableFuzzySet.getTruthValue(i);
        }
    }

    void copy(AbleFuzzySet ableFuzzySet) {
        for (int i = 0; i < 256; ++i) {
            this.myTruthVector[i] = ableFuzzySet.getTruthValue(i);
        }
        this.mySetEmpty = false;
    }

    public String toString() {
        return this.arlString();
    }
}

