/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleFuzzyVariable;
import com.ibm.able.data.AbleLiteral;
import java.io.Serializable;
import java.util.Vector;

public abstract class AbleFuzzySet
extends AbleLiteral
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static final String clsNm = "AbleFuzzySet";
    public static final int MaxValues = 256;
    public static final char HedgeNull = '.';
    public static final char HedgeAbout = 'A';
    public static final char HedgeAbove = 'O';
    public static final char HedgeBelow = 'B';
    public static final char HedgeCloseTo = 'C';
    public static final char HedgeExtremely = 'E';
    public static final char HedgeGenerally = 'G';
    public static final char HedgeInVicinityOf = 'I';
    public static final char HedgeNot = 'N';
    public static final char HedgePositively = 'P';
    public static final char HedgeSlightly = 'S';
    public static final char HedgeSomewhat = 'M';
    public static final char HedgeVery = 'V';
    public static final int SetDirectionUp = 1;
    public static final int SetDirectionDown = 2;
    public static final int SetDirectionLeft = 3;
    public static final int SetDirectionRight = 4;
    public static final int SetTypeBeta = 1;
    public static final int SetTypeGaussian = 2;
    public static final int SetTypeLinear = 3;
    public static final int SetTypePi = 4;
    public static final int SetTypeSegments = 5;
    public static final int SetTypeShoulder = 6;
    public static final int SetTypeSigmoid = 7;
    public static final int SetTypeTrapezoid = 8;
    public static final int SetTypeTriangle = 9;
    public static final int SetTypeWork = 10;
    public static final double AlphaCutDefault = 0.1;
    public static final int AlphaCutStrong = 1;
    public static final int AlphaCutWeak = 2;
    public static final int CorrelationMethodProduct = 1;
    public static final int CorrelationMethodMinimise = 2;
    public static final int CorrelationMethodDefault = 1;
    public static final int DefuzzifyMethodCentroid = 1;
    public static final int DefuzzifyMethodMaxHeight = 2;
    public static final int DefuzzifyMethodAverageHeight = 3;
    public static final int DefuzzifyMethodDefault = 1;
    public static final int FUZZY_ADD = 0;
    public static final int MIN_MAX = 1;
    public static final int PRODUCT_OR = 2;
    public static final int FuzzyInferenceMethodDefault = 0;
    protected int mySetType;
    protected String mySetName;
    protected double myAlphaCut;
    protected double myDomainLo;
    protected double myDomainHi;
    protected double[] myTruthVector;
    protected AbleFuzzyVariable myParentVar = null;
    protected String myComplementName;
    protected boolean myComplementFlag;
    protected double myPtBeg = Double.NaN;
    protected double myPtCenter = Double.NaN;
    protected double myPtEnd = Double.NaN;
    protected double myPtFlex = Double.NaN;
    protected double myPtLeft = Double.NaN;
    protected double myPtLeftCore = Double.NaN;
    protected double myPtRightCore = Double.NaN;
    protected double myPtRight = Double.NaN;
    protected double myFlexFactor = Double.NaN;
    protected int mySetDir = 0;
    protected double myWeight = Double.NaN;
    protected double myWidth = Double.NaN;
    protected int myNumberOfValues;
    protected double[] myScalarVecSav = new double[256];
    protected double[] myTruthVecSav = new double[256];
    static /* synthetic */ Class class$com$ibm$able$data$AbleFuzzySet;

    public static final String CorrelationMethod(int n) {
        String string = Integer.toString(n);
        switch (n) {
            case 1: {
                return string + ":" + ".CorrelationMethodProduct";
            }
            case 2: {
                return string + ":" + ".CorrelationMethodMinimise";
            }
        }
        return string + ":" + ".CorrelationMethodUnrecognized";
    }

    public static final String CorrelationMethodRl(int n) {
        switch (n) {
            case 1: {
                return "Product  ";
            }
            case 2: {
                return "Minimum  ";
            }
        }
        return "Unrecognized";
    }

    public static final String CorrelationMethodXml(int n) {
        switch (n) {
            case 1: {
                return "product";
            }
            case 2: {
                return "minimum";
            }
        }
        return "unrecognized";
    }

    public static final String DefuzzifyMethod(int n) {
        String string = Integer.toString(n);
        switch (n) {
            case 1: {
                return string + ":" + ".DefuzzifyMethodCentroid";
            }
            case 2: {
                return string + ":" + ".DefuzzifyMethodMaxHeight";
            }
            case 3: {
                return string + ":" + ".DefuzzifyMethodAverageHeight";
            }
        }
        return string + ":" + ".DefuzzifyMethodUnrecognized";
    }

    public static final String DefuzzifyMethodRl(int n) {
        switch (n) {
            case 1: {
                return "Centroid ";
            }
            case 2: {
                return "MaxHeight";
            }
            case 3: {
                return "Average";
            }
        }
        return "Unrecognized";
    }

    public static final String DefuzzifyMethodXml(int n) {
        switch (n) {
            case 1: {
                return "centroid";
            }
            case 2: {
                return "maxHeight";
            }
            case 3: {
                return "average";
            }
        }
        return "unrecognized";
    }

    public static final String FuzzyInferenceMethod(int n) {
        String string = Integer.toString(n);
        switch (n) {
            case 0: {
                return string + ":" + clsNm + ".InferenceMethodFuzzyAdd";
            }
            case 1: {
                return string + ":" + clsNm + ".InferenceMethodMinMax";
            }
            case 2: {
                return string + ":" + clsNm + ".InferenceMethodProductOr";
            }
        }
        return string + ":" + clsNm + ".FuzzyInferenceMethodIsUnrecognized";
    }

    public static final String FuzzyInferenceMethodRl(int n) {
        switch (n) {
            case 0: {
                return "FuzzyAdd ";
            }
            case 1: {
                return "MinMax   ";
            }
            case 2: {
                return "ProductOr";
            }
        }
        return "Unrecognized";
    }

    public static final String FuzzyInferenceMethodXml(int n) {
        switch (n) {
            case 0: {
                return "fuzzyAdd";
            }
            case 1: {
                return "minMax";
            }
            case 2: {
                return "productOr";
            }
        }
        return "unrecognized";
    }

    public static final String Hedge(char c) {
        String string = new Character(c).toString();
        switch (c) {
            case '.': {
                return string + ":" + clsNm + ".HedgeNull";
            }
            case 'A': {
                return string + ":" + clsNm + ".HedgeAbout";
            }
            case 'O': {
                return string + ":" + clsNm + ".HedgeAbove";
            }
            case 'B': {
                return string + ":" + clsNm + ".HedgeBelow";
            }
            case 'C': {
                return string + ":" + clsNm + ".HedgeCloseTo";
            }
            case 'E': {
                return string + ":" + clsNm + ".HedgeExtremely";
            }
            case 'G': {
                return string + ":" + clsNm + ".HedgeGenerally";
            }
            case 'I': {
                return string + ":" + clsNm + ".HedgeInVicinityOf";
            }
            case 'N': {
                return string + ":" + clsNm + ".HedgeNot";
            }
            case 'P': {
                return string + ":" + clsNm + ".HedgePositively";
            }
            case 'S': {
                return string + ":" + clsNm + ".HedgeSlightly";
            }
            case 'M': {
                return string + ":" + clsNm + ".HedgeSomewhat";
            }
            case 'V': {
                return string + ":" + clsNm + ".HedgeVery";
            }
        }
        return string + ":" + clsNm + ".HedgeUNKNOWN";
    }

    public static final String HedgeRl(char c) {
        switch (c) {
            case '.': {
                return "";
            }
            case 'A': {
                return "about";
            }
            case 'O': {
                return "above";
            }
            case 'B': {
                return "below";
            }
            case 'C': {
                return "closeTo";
            }
            case 'E': {
                return "extremely";
            }
            case 'G': {
                return "generally";
            }
            case 'I': {
                return "inVicinityOf";
            }
            case 'N': {
                return "not";
            }
            case 'P': {
                return "positively";
            }
            case 'S': {
                return "slightly";
            }
            case 'M': {
                return "somewhat";
            }
            case 'V': {
                return "very";
            }
        }
        return "UNKNOWN";
    }

    public static final String HedgeXml(char c) {
        switch (c) {
            case '.': {
                return "";
            }
            case 'A': {
                return "about";
            }
            case 'O': {
                return "above";
            }
            case 'B': {
                return "below";
            }
            case 'C': {
                return "closeTo";
            }
            case 'E': {
                return "extremely";
            }
            case 'G': {
                return "generally";
            }
            case 'I': {
                return "inVicinityOf";
            }
            case 'N': {
                return "not";
            }
            case 'P': {
                return "positively";
            }
            case 'S': {
                return "slightly";
            }
            case 'M': {
                return "somewhat";
            }
            case 'V': {
                return "very";
            }
        }
        return "UNKNOWN";
    }

    public static final String SetDirection(int n) {
        String string = Integer.toString(n);
        switch (n) {
            case 1: {
                return string + ":" + clsNm + ".SetDirectionUp";
            }
            case 2: {
                return string + ":" + clsNm + ".SetDirectionDown";
            }
            case 3: {
                return string + ":" + clsNm + ".SetDirectionLeft";
            }
            case 4: {
                return string + ":" + clsNm + ".SetDirectionRight";
            }
        }
        return string + ":" + clsNm + ".SetDirectionUnrecognized";
    }

    public static final String SetDirectionRl(int n) {
        switch (n) {
            case 1: {
                return "ARL.Up";
            }
            case 2: {
                return "ARL.Down";
            }
            case 3: {
                return "ARL.Left";
            }
            case 4: {
                return "ARL.Right";
            }
        }
        return "Unrecognized";
    }

    public static final String SetDirectionXml(int n) {
        switch (n) {
            case 1: {
                return "up";
            }
            case 2: {
                return "down";
            }
            case 3: {
                return "left";
            }
            case 4: {
                return "right";
            }
        }
        return "unrecognized";
    }

    public static final String SetType(int n) {
        String string = Integer.toString(n);
        switch (n) {
            case 1: {
                return string + ":" + clsNm + ".SetTypeBeta";
            }
            case 2: {
                return string + ":" + clsNm + ".SetTypeGaussian";
            }
            case 3: {
                return string + ":" + clsNm + ".SetTypeLinear";
            }
            case 4: {
                return string + ":" + clsNm + ".SetTypePi";
            }
            case 5: {
                return string + ":" + clsNm + ".SetTypeSegments";
            }
            case 6: {
                return string + ":" + clsNm + ".SetTypeShoulder";
            }
            case 7: {
                return string + ":" + clsNm + ".SetTypeSigmoid";
            }
            case 8: {
                return string + ":" + clsNm + ".SetTypeTrapezoid";
            }
            case 9: {
                return string + ":" + clsNm + ".SetTypeTriangle";
            }
            case 10: {
                return string + ":" + clsNm + ".SetTypeWork";
            }
        }
        return string + ":" + clsNm + ".SetTypeUnrecognized";
    }

    public static final String SetTypeRl(int n) {
        switch (n) {
            case 1: {
                return "Beta     ";
            }
            case 2: {
                return "Gaussian ";
            }
            case 3: {
                return "Linear   ";
            }
            case 4: {
                return "Pi       ";
            }
            case 5: {
                return "Segments ";
            }
            case 6: {
                return "Shoulder ";
            }
            case 7: {
                return "Sigmoid  ";
            }
            case 8: {
                return "Trapezoid";
            }
            case 9: {
                return "Triangle ";
            }
            case 10: {
                return "Work";
            }
        }
        return "Unrecognized";
    }

    public static final String SetTypeXml(int n) {
        switch (n) {
            case 1: {
                return "betaSet";
            }
            case 2: {
                return "gaussianSet";
            }
            case 3: {
                return "linearSet";
            }
            case 4: {
                return "piSet";
            }
            case 5: {
                return "segmentsSet";
            }
            case 6: {
                return "shoulderSet";
            }
            case 7: {
                return "sigmoidSet";
            }
            case 8: {
                return "trapezoidSet";
            }
            case 9: {
                return "triangleSet";
            }
            case 10: {
                return "workSet";
            }
        }
        return "unrecognized";
    }

    final void setComplementName(String string) {
        this.myComplementName = string;
    }

    void setComplement() {
        this.myComplementFlag = true;
    }

    public final double getPtBeg() {
        return this.myPtBeg;
    }

    public final double getPtCenter() {
        return this.myPtCenter;
    }

    public final double getPtEnd() {
        return this.myPtEnd;
    }

    public final double getPtFlex() {
        return this.myPtFlex;
    }

    public final double getPtLeft() {
        return this.myPtLeft;
    }

    public final double getPtLeftCore() {
        return this.myPtLeftCore;
    }

    public final double getPtRightCore() {
        return this.myPtRightCore;
    }

    public final double getPtRight() {
        return this.myPtRight;
    }

    public final double getFlexFactor() {
        return this.myFlexFactor;
    }

    public final int getSetDir() {
        return this.mySetDir;
    }

    public final double getWeight() {
        return this.myWeight;
    }

    public final double getWidth() {
        return this.myWidth;
    }

    public final int getNumberOfValues() {
        return this.myNumberOfValues;
    }

    public final double[] getScalarVector() {
        return this.myScalarVecSav;
    }

    public final double[] getTruthVector() {
        return this.myTruthVecSav;
    }

    protected AbleFuzzySet(int n, String string, AbleFuzzyVariable ableFuzzyVariable, double d, double d2, double d3) {
        this.mySetType = n;
        this.mySetName = string;
        this.myParentVar = ableFuzzyVariable;
        this.myAlphaCut = d;
        this.myDomainLo = d2;
        this.myDomainHi = d3;
        this.myTruthVector = new double[256];
        for (int i = 0; i < 256; ++i) {
            this.myTruthVector[i] = 0.0;
        }
        this.myComplementName = "";
        this.myComplementFlag = false;
    }

    public boolean getBooleanValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_SetCannotConvertToBoolean", new Object[]{this.myParentVar.getName(), this.mySetName}));
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        return this;
    }

    public Object getGenericValue() throws AbleDataException {
        return new Double(this.defuzzify(this.myParentVar.getDefuzzifyMethod()));
    }

    public double getNumericValue() throws AbleDataException {
        return this.defuzzify(this.myParentVar.getDefuzzifyMethod());
    }

    public String getStringValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_SetCannotConvertToString", new Object[]{this.myParentVar.getName(), this.mySetName}));
    }

    public AbleLiteral getValue() throws AbleDataException {
        return this;
    }

    public int getReferent() {
        if (this.myParentVar != null) {
            return this.myParentVar.getId();
        }
        return 0;
    }

    public String arlCRdString() {
        int n = this.mySetName.indexOf(" ");
        if (n < 0) {
            return this.mySetName;
        }
        String string = this.mySetName.substring(0, n);
        String string2 = this.mySetName.substring(n + 1);
        String string3 = "";
        string3 = string3 + AbleFuzzySet.HedgeRl(string2.charAt(0));
        for (int i = 1; i < string2.length(); ++i) {
            string3 = string3 + ", " + AbleFuzzySet.HedgeRl(string2.charAt(i));
        }
        string3 = string3 + " " + string;
        return string3;
    }

    public String xmlCRdString() {
        String string = "";
        String string2 = "";
        String string3 = "";
        int n = this.mySetName.indexOf(" ");
        if (n < 0) {
            string2 = this.mySetName;
        } else {
            string2 = this.mySetName.substring(0, n);
            string3 = this.mySetName.substring(n + 1);
        }
        if (string3.length() != 0) {
            for (int i = 0; i < string3.length(); ++i) {
                string = string + "<hedge type=\"" + AbleFuzzySet.HedgeXml(string3.charAt(i)) + "\"/> ";
            }
        }
        string = string + "<fuzzyValue setRef=\"" + string2 + "\"/>";
        return string;
    }

    abstract void addClone(String var1) throws AbleDataException;

    abstract String arlString();

    abstract String xmlString();

    public final int getSetType() {
        return this.mySetType;
    }

    public final String getSetName() {
        return this.mySetName;
    }

    public final void setAlphaCut(double d) {
        this.myAlphaCut = d;
    }

    public final double getAlphaCut() {
        return this.myAlphaCut;
    }

    public final double getDomainLo() {
        return this.myDomainLo;
    }

    public final double getDomainHi() {
        return this.myDomainHi;
    }

    public final double[] getTruthValues() {
        return this.myTruthVector;
    }

    public Vector getSetProperties() {
        Vector<Double> vector = new Vector<Double>();
        for (int i = 0; i < 256; ++i) {
            vector.addElement(new Double(this.myTruthVector[i]));
        }
        return vector;
    }

    double getTruthValue(int n) {
        return this.myTruthVector[n];
    }

    void applyAlphaCut(int n) {
        for (int i = 0; i < 256; ++i) {
            if (this.aboveAlphaCut(this.myTruthVector[i], n)) continue;
            this.myTruthVector[i] = 0.0;
        }
    }

    void applyComplement() {
        this.complement();
    }

    void applyHedges(String string) throws AbleDataException {
        block15: for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            switch (c) {
                case '.': {
                    continue block15;
                }
                case 'A': {
                    this.applyHedgeAbout();
                    continue block15;
                }
                case 'O': {
                    this.applyHedgeAbove();
                    continue block15;
                }
                case 'B': {
                    this.applyHedgeBelow();
                    continue block15;
                }
                case 'C': {
                    this.applyHedgeCloseTo();
                    continue block15;
                }
                case 'E': {
                    this.applyHedgeExtremely();
                    continue block15;
                }
                case 'G': {
                    this.applyHedgeGenerally();
                    continue block15;
                }
                case 'I': {
                    this.applyHedgeInVicinityOf();
                    continue block15;
                }
                case 'N': {
                    this.applyHedgeNot();
                    continue block15;
                }
                case 'P': {
                    this.applyHedgePositively();
                    continue block15;
                }
                case 'S': {
                    this.applyHedgeSlightly();
                    continue block15;
                }
                case 'M': {
                    this.applyHedgeSomewhat();
                    continue block15;
                }
                case 'V': {
                    this.applyHedgeVery();
                    continue block15;
                }
                default: {
                    throw new AbleDataException(Able.NlsMsg("Ex_SetCannotApplyUnrecognizedHedge", new Object[]{this.myParentVar.getName(), this.mySetName, new Character(c)}));
                }
            }
        }
    }

    void applyHedgeAbout() {
        this.applyHedgeApprox(2.0);
    }

    void applyHedgeAbove() {
        int n;
        int n2 = 0;
        double d = 0.0;
        for (n = 0; n < 256; ++n) {
            if (!(this.myTruthVector[n] >= d)) continue;
            n2 = n;
            d = this.myTruthVector[n];
            if (d == 1.0) break;
        }
        for (n = 0; n < 256; ++n) {
            this.myTruthVector[n] = n <= n2 ? 0.0 : 1.0 - this.myTruthVector[n];
        }
    }

    void applyHedgeBelow() {
        int n;
        int n2 = 256;
        double d = 0.0;
        for (n = 0; n < 256; ++n) {
            if (!(this.myTruthVector[n] >= d)) continue;
            n2 = n;
            d = this.myTruthVector[n];
            if (d == 1.0) break;
        }
        for (n = 0; n < 256; ++n) {
            this.myTruthVector[n] = n >= n2 ? 0.0 : 1.0 - this.myTruthVector[n];
        }
    }

    void applyHedgeCloseTo() {
        this.applyHedgeApprox(1.2);
    }

    void applyHedgeExtremely() {
        this.applyHedgeConDil(3.0);
    }

    void applyHedgeGenerally() {
        double d = 0.5;
        for (int i = 0; i < 256; ++i) {
            double d2;
            if (this.myTruthVector[i] >= d) {
                d2 = this.myTruthVector[i];
                this.myTruthVector[i] = d2 = 0.8 * Math.pow(d2, 0.5);
                continue;
            }
            d2 = this.myTruthVector[i];
            this.myTruthVector[i] = d2 = 1.0 - 0.8 * Math.pow(1.0 - d2, 0.5);
        }
    }

    void applyHedgeInVicinityOf() {
        this.applyHedgeApprox(4.0);
    }

    void applyHedgeNot() {
        this.complement();
    }

    void applyHedgePositively() {
        double d = 0.5;
        for (int i = 0; i < 256; ++i) {
            double d2;
            if (this.myTruthVector[i] >= d) {
                d2 = this.myTruthVector[i];
                this.myTruthVector[i] = (d2 = 2.0 * Math.pow(d2, 2.0)) > 1.0 ? 1.0 : d2;
                continue;
            }
            d2 = this.myTruthVector[i];
            this.myTruthVector[i] = (d2 = 1.0 - 2.0 * Math.pow(1.0 - d2, 2.0)) < 0.0 ? 0.0 : d2;
        }
    }

    void applyHedgeSlightly() {
        this.applyHedgeConDil(0.3);
    }

    void applyHedgeSomewhat() {
        this.applyHedgeConDil(0.5);
    }

    void applyHedgeVery() {
        this.applyHedgeConDil(2.0);
    }

    void applyHedgeApprox(double d) {
        int n;
        double[] dArray = new double[257];
        double d2 = this.myDomainHi - this.myDomainLo;
        for (n = 0; n < 256; ++n) {
            dArray[n] = 0.0;
        }
        for (n = 0; n < 256; ++n) {
            if (this.myTruthVector[n] == 0.0) continue;
            double d3 = n;
            for (int i = 0; i < 256; ++i) {
                double d4 = Math.abs((double)i - d3) * d2 / 256.0;
                double d5 = 1.0 / (1.0 + Math.pow(d4, d)) * this.myTruthVector[n];
                dArray[i] = Math.max(dArray[i], d5);
            }
        }
        for (n = 0; n < 256; ++n) {
            this.myTruthVector[n] = dArray[n];
        }
    }

    void applyHedgeConDil(double d) {
        for (int i = 0; i < 256; ++i) {
            this.myTruthVector[i] = Math.pow(this.myTruthVector[i], d);
        }
    }

    double defuzzify(int n) throws AbleDataException {
        double d = 0.0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.applyAlphaCut(1);
        if (this.getSetHeight() == 0.0) {
            d = 0.0;
            return d;
        }
        switch (n) {
            case 1: {
                double d2 = 0.0;
                double d3 = 0.0;
                for (n2 = 0; n2 < 256; ++n2) {
                    d2 += this.myTruthVector[n2] * (double)n2;
                    d3 += this.myTruthVector[n2];
                }
                if (d3 == 0.0) {
                    d = 0.0;
                    break;
                }
                n3 = (int)(d2 / d3);
                d = this.getScalar(n3);
                break;
            }
            case 2: {
                double d4 = this.myTruthVector[0];
                n3 = 0;
                for (n2 = 0; n2 < 256; ++n2) {
                    if (!(this.myTruthVector[n2] > d4)) continue;
                    d4 = this.myTruthVector[n2];
                    n4 = n2;
                }
                for (n5 = n4 + 1; n5 < 256 && this.myTruthVector[n5] == d4; ++n5) {
                }
                n3 = (int)(((double)n5 - (double)n4) / 2.0);
                n3 = n3 == 0 ? n4 : (n3 += n4);
                d = this.getScalar(n3);
                break;
            }
            case 3: {
                double d5 = 0.0;
                for (n2 = 0; n2 < 256; ++n2) {
                    d5 += this.myTruthVector[n2];
                }
                d = d5 / 256.0;
                break;
            }
            default: {
                d = 0.0;
                throw new AbleDataException(Able.NlsMsg("Ex_SetUnrecognizedDefuzzMethod", new Object[]{this.myParentVar.getName(), this.mySetName, Integer.toString(n)}));
            }
        }
        return d;
    }

    double membership(double d) {
        double d2 = 0.0;
        if (d < this.myDomainLo) {
            d2 = this.myTruthVector[0];
        } else if (d > this.myDomainHi) {
            d2 = this.myTruthVector[255];
        } else {
            double d3 = this.myDomainHi - this.myDomainLo;
            int n = (int)((d - this.myDomainLo) / d3 * 255.0);
            d2 = this.myTruthVector[n];
        }
        return d2;
    }

    boolean aboveAlphaCut(double d, int n) {
        boolean bl = false;
        switch (n) {
            case 1: {
                if (d > this.myAlphaCut) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                bl = d >= this.myAlphaCut;
            }
        }
        return bl;
    }

    void complement() {
        for (int i = 0; i < 256; ++i) {
            this.myTruthVector[i] = 1.0 - this.myTruthVector[i];
        }
    }

    void normalise() {
        double d = this.getSetHeight();
        if (d == 0.0) {
            return;
        }
        if (d == 1.0) {
            return;
        }
        for (int i = 0; i < 256; ++i) {
            this.myTruthVector[i] = this.myTruthVector[i] / d;
        }
    }

    double getScalar(int n) {
        double d = this.myDomainHi - this.myDomainLo;
        double d2 = d / 255.0;
        double d3 = (double)n * d2 + this.myDomainLo;
        return d3;
    }

    double getSetHeight() {
        double d = this.myTruthVector[0];
        for (int i = 0; i < 256; ++i) {
            if (!(this.myTruthVector[i] > d)) continue;
            d = this.myTruthVector[i];
        }
        return d;
    }

    int[] segmentCurve(int n, double[] dArray, double[] dArray2) {
        int n2;
        int n3 = 256;
        double[] dArray3 = new double[257];
        double d = this.myDomainHi - this.myDomainLo;
        int[] nArray = new int[]{-1, 256};
        for (n2 = 0; n2 < 256; ++n2) {
            dArray3[n2] = -1.0;
        }
        for (n2 = 0; n2 < n; ++n2) {
            n3 = (int)((dArray[n2] - this.myDomainLo) / d * 255.0);
            dArray3[n3] = dArray2[n2];
            if (nArray[0] != -1) continue;
            nArray[0] = n3;
        }
        nArray[1] = n3;
        if (dArray3[0] == -1.0) {
            dArray3[0] = 0.0;
        }
        this.vectorInterpret(dArray3);
        for (n2 = 0; n2 < 256; ++n2) {
            this.myTruthVector[n2] = dArray3[n2];
        }
        return nArray;
    }

    void sigmoidCurve(double d, double d2, double d3, int n) {
        double d4 = this.myDomainHi - this.myDomainLo;
        double d5 = d2 - d;
        for (int i = 0; i < 256; ++i) {
            double d6;
            double d7 = this.myDomainLo + (double)i / 255.0 * d4;
            if (d7 >= d2) {
                this.myTruthVector[i] = 1.0;
                continue;
            }
            if (d7 > d3) {
                d6 = (d7 - d2) / d5;
                this.myTruthVector[i] = 1.0 - 2.0 * Math.pow(d6, 2.0);
                continue;
            }
            if (d7 > d) {
                d6 = (d7 - d) / d5;
                this.myTruthVector[i] = 2.0 * Math.pow(d6, 2.0);
                continue;
            }
            this.myTruthVector[i] = 0.0;
        }
        if (n == 2) {
            this.complement();
        }
    }

    void vectorInterpret(double[] dArray) {
        int n = 0;
        int n2 = 0;
        while (true) {
            if (++n2 > 256) {
                return;
            }
            if (dArray[n2] == -1.0) continue;
            int n3 = n + 1;
            int n4 = n2;
            for (int i = n3; i < n4; ++i) {
                double d = i - n;
                double d2 = n2 - n;
                double d3 = d / d2;
                if (i > 256) {
                    return;
                }
                dArray[i] = dArray[n] + d3 * (dArray[n2] - dArray[n]);
            }
            n = n2;
            if (n >= 256) break;
        }
    }

    public Class getDataTypeClass() {
        return class$com$ibm$able$data$AbleFuzzySet == null ? (class$com$ibm$able$data$AbleFuzzySet = AbleFuzzySet.class$("com.ibm.able.data.AbleFuzzySet")) : class$com$ibm$able$data$AbleFuzzySet;
    }

    public String getDataTypeClassName() {
        return (class$com$ibm$able$data$AbleFuzzySet == null ? (class$com$ibm$able$data$AbleFuzzySet = AbleFuzzySet.class$("com.ibm.able.data.AbleFuzzySet")) : class$com$ibm$able$data$AbleFuzzySet).getName();
    }

    public String toString() {
        return this.arlCRdString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlCRdString();
            }
            case 4: {
                return this.arlCRdString();
            }
            case 5: {
                return this.xmlCRdString();
            }
        }
        return this.arlCRdString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.arlCRdString());
        try {
            stringBuffer.append(":<" + this.defuzzify(this.myParentVar.getDefuzzifyMethod()) + ">");
        }
        catch (AbleDataException ableDataException) {
            stringBuffer.append(":<--Undetermined-->");
        }
        return stringBuffer.toString();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    public int getDataType() {
        return 6;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

