/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleBooleanLiteral;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleDoubleLiteral;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleTypedVariable;
import java.io.Serializable;

public class AbleExpressionVariable
extends AbleTypedVariable
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static String clsNm = "AbleExpressionVariable";
    protected AbleExpression myValue;
    static /* synthetic */ Class class$com$ibm$able$data$AbleExpression;

    public AbleExpressionVariable(String string, AbleExpression ableExpression) {
        super(string, false, false, ableExpression, "Expression");
        this.myDataType = 42;
        this.myValue = ableExpression;
        this.myValueInitial = ableExpression;
    }

    public AbleExpressionVariable(String string, boolean bl, boolean bl2, AbleExpression ableExpression) {
        super(string, bl, bl2, ableExpression, "Expression");
        this.myDataType = 42;
        this.myValue = ableExpression;
        this.myValueInitial = ableExpression;
    }

    public AbleExpressionVariable(String string, boolean bl, boolean bl2) {
        super(string, bl, bl2, "Expression", "com.ibm.able.data.AbleExpression");
        this.myDataType = 42;
        this.myValue = null;
        this.myValueInitial = null;
    }

    public boolean getBooleanValue() throws AbleDataException {
        return this.myValue.getBooleanValue();
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToFuzzy", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        return this.myValue;
    }

    public double getNumericValue() throws AbleDataException {
        return this.myValue.getNumericValue();
    }

    public String getStringValue() throws AbleDataException {
        return this.getValueString();
    }

    public AbleLiteral getValue() throws AbleDataException {
        return this.myValue.getValue();
    }

    public void asgnEq(AbleRd ableRd) throws AbleDataException {
        this.setRawValue(ableRd.getGenericValue());
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        return this.getNumericValue() == ableRd.getNumericValue();
    }

    public boolean cmpGt(AbleRd ableRd) throws AbleDataException {
        return this.getNumericValue() > ableRd.getNumericValue();
    }

    public boolean cmpGtEq(AbleRd ableRd) throws AbleDataException {
        return this.getNumericValue() >= ableRd.getNumericValue();
    }

    public boolean cmpLt(AbleRd ableRd) throws AbleDataException {
        return this.getNumericValue() < ableRd.getNumericValue();
    }

    public boolean cmpLtEq(AbleRd ableRd) throws AbleDataException {
        return this.getNumericValue() <= ableRd.getNumericValue();
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        return this.getNumericValue() != ableRd.getNumericValue();
    }

    public AbleLiteral compPlus(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(this.getNumericValue() + ableRd.getNumericValue());
    }

    public AbleLiteral compMinus(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(this.getNumericValue() - ableRd.getNumericValue());
    }

    public AbleLiteral compMultiply(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(this.getNumericValue() * ableRd.getNumericValue());
    }

    public AbleLiteral compDivide(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(this.getNumericValue() / ableRd.getNumericValue());
    }

    public AbleLiteral compUnaryMinus(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(0.0 - this.getNumericValue());
    }

    public boolean logicalAND(AbleRd ableRd) throws AbleDataException {
        return this.getBooleanValue() && ableRd.getBooleanValue();
    }

    public boolean logicalOR(AbleRd ableRd) throws AbleDataException {
        return this.getBooleanValue() || ableRd.getBooleanValue();
    }

    public boolean logicalNOT(AbleRd ableRd) throws AbleDataException {
        return !this.getBooleanValue();
    }

    public AbleLiteral bitwiseXOR(AbleRd ableRd) throws AbleDataException {
        return this.myValue.getBooleanValue() ^ ableRd.getBooleanValue() ? AbleBooleanLiteral.TRUE : AbleBooleanLiteral.FALSE;
    }

    public void setBooleanValue(boolean bl) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromBoolean", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public void setFuzzyValue(AbleFuzzySet ableFuzzySet) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromFuzzy", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public void setGenericValue(Object object) throws AbleDataException {
        if (object instanceof Boolean) {
            this.setBooleanValue((Boolean)object);
        } else if (object instanceof Number) {
            this.setNumericValue(((Number)object).doubleValue());
        } else if (object instanceof String) {
            this.setStringValue((String)object);
        } else if (object instanceof AbleLiteral) {
            this.setValue((AbleLiteral)object);
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromGeneric", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
        }
    }

    public void setNumericValue(double d) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromNumeric", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public void setStringValue(String string) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToString", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public void setValue(AbleLiteral ableLiteral) throws AbleDataException {
        this.setRawValue(ableLiteral.getGenericValue());
    }

    public String arlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myComment.length() > 0) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        stringBuffer.append(this.isTemplate() ? "    template " : "    ");
        stringBuffer.append(this.isStatic() ? "    static " : "    ");
        stringBuffer.append("Expression " + this.myName);
        if (this.myValueInitial == null) {
            stringBuffer.append(";" + Able.LS);
        } else {
            stringBuffer.append(" = " + this.myValueInitial.arlCRdString() + ";" + Able.LS);
        }
        return stringBuffer.toString();
    }

    public String xmlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <declareVar varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"" + " dataType=\"" + "Expression" + "\"" + (this.isStatic() ? " static=\"true\"" : "") + (this.isTemplate() ? " template=\"true\"" : "") + ">" + Able.LS);
        stringBuffer.append(this.xmlInitializerString());
        stringBuffer.append("       </declareVar>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <Variable varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"" + " dataType=\"" + "Expression" + "\"" + (this.isStatic() ? " static=\"true\"" : "") + (this.isTemplate() ? " template=\"true\"" : "") + ">" + Able.LS);
        if (this.myValueInitial != null) {
            stringBuffer.append("        <varInitializer>" + AbleData.escapeXMLString(this.myValueInitial.arlCRdString()) + "</varInitializer>" + Able.LS);
        }
        stringBuffer.append("       </Variable>" + Able.LS);
        return stringBuffer.toString();
    }

    public String getValueString() {
        return this.myValue.toString();
    }

    public void setInitialValue(AbleRd ableRd) throws AbleDataException {
        this.myValueInitial = ableRd instanceof AbleExpression ? ableRd : new AbleExpression(null, 10, ableRd);
        this.init();
    }

    public void reset() throws AbleDataException {
        if (!this.myStaticFlag) {
            this.init();
        }
    }

    public void init() throws AbleDataException {
        if (this.myValueInitial == null) {
            this.myValue = null;
            this.myBoundFlag = false;
        } else {
            this.myValue = (AbleExpression)this.myValueInitial;
            this.myBoundFlag = true;
        }
    }

    public Class getDataTypeClass() {
        return class$com$ibm$able$data$AbleExpression == null ? (class$com$ibm$able$data$AbleExpression = AbleExpressionVariable.class$("com.ibm.able.data.AbleExpression")) : class$com$ibm$able$data$AbleExpression;
    }

    public String getDataTypeClassName() {
        return (class$com$ibm$able$data$AbleExpression == null ? (class$com$ibm$able$data$AbleExpression = AbleExpressionVariable.class$("com.ibm.able.data.AbleExpression")) : class$com$ibm$able$data$AbleExpression).getName();
    }

    public Class getLiteralClass() {
        return class$com$ibm$able$data$AbleExpression == null ? (class$com$ibm$able$data$AbleExpression = AbleExpressionVariable.class$("com.ibm.able.data.AbleExpression")) : class$com$ibm$able$data$AbleExpression;
    }

    protected void setRawValue(Object object) throws AbleDataException {
        AbleExpression ableExpression = this.myValue;
        try {
            this.myValue = (AbleExpression)object;
            this.myBoundFlag = true;
        }
        catch (Exception exception) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarIllegalSetRawValueArray", new Object[]{object.getClass().getName(), exception.getLocalizedMessage()}));
        }
        if (this.myContext != null) {
            this.myContext.updateCurrentFactBase(this.myId);
        }
        if (this.myChgSupport != null) {
            this.myChgSupport.firePropertyChange("GenericValue " + this.myName, ableExpression, object);
        }
    }

    public Object getRawValue() {
        return this.myValue;
    }

    public String toString() {
        return this.arlDclString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlDclString();
            }
            case 4: {
                return this.arlDclString();
            }
            case 5: {
                return this.xmlDclString();
            }
        }
        return this.arlDclString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.myName + ":<" + this.getValueString() + ">");
        return stringBuffer.toString();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

