/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.data.AbleBooleanLiteral;
import com.ibm.able.data.AbleCallLiteral;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataContext;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleDoubleLiteral;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleFuzzyVariable;
import com.ibm.able.data.AbleGenericVariable;
import com.ibm.able.data.AbleLhs;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleNewObjectLiteral;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleReferences;
import com.ibm.able.data.AbleTypedVariable;
import com.ibm.able.data.AbleTypedVariableCompoundLiteral;
import com.ibm.able.data.AbleTypedVariableField;
import com.ibm.able.data.AbleTypedVariableMethodLiteral;
import com.ibm.able.data.AbleTypedVariableStringField;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleLocation;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class AbleExpression
extends AbleLiteral {
    static final long serialVersionUID = 2000083100000000001L;
    static final String clsNm = "AbleExpression";
    protected AbleRd myLhs;
    protected int myOp;
    protected AbleRd myRhs;
    protected transient AbleRd myValue;
    public static final double DefaultWeight = 1.0;
    protected double myWeight = 1.0;
    private boolean myExprIsConstant = false;
    protected AbleLocation myLocation;
    static /* synthetic */ Class class$com$ibm$able$data$AbleExpression;

    public AbleExpression(AbleRd ableRd, int n, AbleRd ableRd2) {
        this.myLhs = ableRd;
        this.myOp = n;
        this.myRhs = ableRd2;
        this.checkVariableToClauseReference(this.myLhs);
        this.checkVariableToClauseReference(this.myRhs);
        this.checkIfExpressionIsConstant();
    }

    public AbleExpression(AbleDataContext ableDataContext, String string) throws AbleException {
        AbleRd ableRd = ableDataContext.parseExpressionFromARL(string);
        if (ableRd instanceof AbleExpression) {
            AbleExpression ableExpression = (AbleExpression)ableRd;
            this.myLhs = ableExpression.myLhs;
            this.myOp = ableExpression.myOp;
            this.myRhs = ableExpression.myRhs;
        } else {
            this.myLhs = null;
            this.myOp = 10;
            this.myRhs = ableRd;
        }
        this.checkVariableToClauseReference(this.myLhs);
        this.checkVariableToClauseReference(this.myRhs);
        this.checkIfExpressionIsConstant();
    }

    public AbleExpression createMatchExpression(Hashtable hashtable) {
        AbleRd ableRd;
        AbleRd ableRd2;
        block51: {
            AbleVariable ableVariable;
            AbleVariable ableVariable2;
            block50: {
                ableRd2 = null;
                ableRd = null;
                if (this.myLhs instanceof AbleExpression) {
                    ableRd2 = ((AbleExpression)this.myLhs).createMatchExpression(hashtable);
                } else if (this.myLhs instanceof AbleVariable) {
                    ableVariable = ableVariable2 = (AbleVariable)this.myLhs;
                    if (ableVariable2.isGlobal()) {
                        ableVariable = ableVariable2;
                    } else if (hashtable.containsKey(ableVariable2)) {
                        ableVariable = (AbleVariable)hashtable.get(ableVariable2);
                    } else {
                        Able.MessageLog.message(4L, (Object)this, "createMatchExpression()", "Ex_RsNoSuchVariable", new Object[]{ableVariable2.getName()});
                        ableVariable = new AbleGenericVariable(ableVariable2.getName() + "'", null);
                        hashtable.put(ableVariable2, ableVariable);
                    }
                    ableRd2 = ableVariable;
                } else if (this.myLhs instanceof AbleTypedVariableMethodLiteral) {
                    try {
                        ableRd2 = ((AbleTypedVariableMethodLiteral)this.myLhs).createMatchLiteral(hashtable);
                    }
                    catch (Exception exception) {}
                } else if (this.myLhs instanceof AbleTypedVariableCompoundLiteral) {
                    try {
                        ableRd2 = ((AbleTypedVariableCompoundLiteral)this.myLhs).createMatchLiteral(hashtable);
                    }
                    catch (Exception exception) {}
                } else if (this.myLhs instanceof AbleTypedVariableField) {
                    ableVariable = ableVariable2 = ((AbleTypedVariableField)this.myLhs).getTypedVariable();
                    if (ableVariable2.isGlobal()) {
                        ableVariable = ableVariable2;
                    } else if (hashtable.containsKey(ableVariable2)) {
                        ableVariable = (AbleTypedVariable)hashtable.get(ableVariable2);
                    } else {
                        Able.MessageLog.message(4L, (Object)this, "createMatchExpression()", "Ex_RsNoSuchVariable", new Object[]{ableVariable2.getName()});
                    }
                    try {
                        if (this.myLhs instanceof AbleTypedVariableStringField) {
                            ableRd2 = new AbleTypedVariableStringField((AbleTypedVariable)ableVariable, (AbleTypedVariableField)this.myLhs);
                            break block50;
                        }
                        ableRd2 = new AbleTypedVariableField((AbleTypedVariable)ableVariable, (AbleTypedVariableField)this.myLhs);
                    }
                    catch (Exception exception) {}
                } else {
                    ableRd2 = this.myLhs instanceof AbleCallLiteral ? ((AbleCallLiteral)this.myLhs).createMatchLiteral(hashtable) : this.myLhs;
                }
            }
            if (this.myRhs instanceof AbleExpression) {
                ableRd = ((AbleExpression)this.myRhs).createMatchExpression(hashtable);
            } else if (this.myRhs instanceof AbleVariable) {
                ableVariable = ableVariable2 = (AbleVariable)this.myRhs;
                if (ableVariable2.isGlobal()) {
                    ableVariable = ableVariable2;
                } else if (hashtable.containsKey(ableVariable2)) {
                    ableVariable = (AbleVariable)hashtable.get(ableVariable2);
                } else {
                    Able.MessageLog.message(2L, (Object)this, "createMatchExpression()", "Ex_RsNoSuchVariable", new Object[]{ableVariable2.getName()});
                    ableVariable = new AbleGenericVariable(ableVariable2.getName() + "'", null);
                    hashtable.put(ableVariable2, ableVariable);
                }
                ableRd = ableVariable;
            } else if (this.myRhs instanceof AbleTypedVariableMethodLiteral) {
                try {
                    ableRd = ((AbleTypedVariableMethodLiteral)this.myRhs).createMatchLiteral(hashtable);
                }
                catch (Exception exception) {}
            } else if (this.myRhs instanceof AbleTypedVariableCompoundLiteral) {
                try {
                    ableRd = ((AbleTypedVariableCompoundLiteral)this.myRhs).createMatchLiteral(hashtable);
                }
                catch (Exception exception) {}
            } else if (this.myRhs instanceof AbleTypedVariableField) {
                ableVariable = ableVariable2 = ((AbleTypedVariableField)this.myRhs).getTypedVariable();
                if (ableVariable2.isGlobal()) {
                    ableVariable = ableVariable2;
                } else if (hashtable.containsKey(ableVariable2)) {
                    ableVariable = (AbleTypedVariable)hashtable.get(ableVariable2);
                } else {
                    Able.MessageLog.message(4L, (Object)this, "createMatchExpression()", "Ex_RsNoSuchVariable", new Object[]{ableVariable2.getName()});
                }
                try {
                    if (this.myRhs instanceof AbleTypedVariableStringField) {
                        ableRd = new AbleTypedVariableStringField((AbleTypedVariable)ableVariable, (AbleTypedVariableField)this.myRhs);
                        break block51;
                    }
                    ableRd = new AbleTypedVariableField((AbleTypedVariable)ableVariable, (AbleTypedVariableField)this.myRhs);
                }
                catch (Exception exception) {}
            } else {
                ableRd = this.myRhs instanceof AbleCallLiteral ? ((AbleCallLiteral)this.myRhs).createMatchLiteral(hashtable) : this.myRhs;
            }
        }
        return new AbleExpression(ableRd2, this.myOp, ableRd);
    }

    private void checkIfExpressionIsConstant() {
        this.myExprIsConstant = false;
        if (this.myLhs != null && !this.myLhs.isConstant()) {
            return;
        }
        if (this.myRhs != null && !this.myRhs.isConstant()) {
            return;
        }
        this.myExprIsConstant = true;
    }

    public final AbleRd getLhs() {
        return this.myLhs;
    }

    public final int getOp() {
        return this.myOp;
    }

    public String getOpAsString() {
        return AbleData.Operator(this.myOp);
    }

    public final AbleRd getRhs() {
        return this.myRhs;
    }

    public BitSet getReferents() {
        BitSet bitSet = new BitSet();
        if (this.myLhs != null) {
            bitSet.or(this.myLhs.getReferents());
        }
        if (this.myRhs != null) {
            bitSet.or(this.myRhs.getReferents());
        }
        return bitSet;
    }

    private void checkVariableToClauseReference(AbleRd ableRd) {
        AbleReferences ableReferences;
        if (ableRd instanceof AbleVariable && (ableReferences = ((AbleVariable)ableRd).getReferences()) != null) {
            ableReferences.addElement(this);
        }
    }

    public String traceString(int n) {
        return this.arlCRdString();
    }

    public String xmlCRdString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(Able.LS);
        if (this.myWeight == 1.0) {
            stringBuffer.append("        <expression>" + Able.LS);
        } else {
            stringBuffer.append("        <expression weight=\"" + this.myWeight + "\">" + Able.LS);
        }
        stringBuffer.append("  ");
        if (this.myLhs == null) {
            stringBuffer.append("          <null/>" + Able.LS);
        } else if (this.myLhs instanceof AbleLhs) {
            stringBuffer.append("        " + ((AbleLhs)this.myLhs).xmlCWrString() + Able.LS);
        } else {
            stringBuffer.append("          " + this.myLhs.xmlCRdString() + Able.LS);
        }
        stringBuffer.append("            <" + AbleData.OperatorXml(this.myOp) + "/>" + Able.LS);
        stringBuffer.append("  ");
        if (this.myRhs == null) {
            stringBuffer.append("          <null/>" + Able.LS);
        } else {
            stringBuffer.append("          " + this.myRhs.xmlCRdString() + Able.LS);
        }
        stringBuffer.append("        </expression>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlCRdString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.myWeight == 1.0) {
            stringBuffer.append("        <expression>");
        } else {
            stringBuffer.append("        <expression weight=\"" + this.myWeight + "\">");
        }
        stringBuffer.append(AbleData.escapeXMLString(this.arlCRdString()) + "</expression>" + Able.LS);
        return stringBuffer.toString();
    }

    public String arlCRdString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isUnary(this.myOp)) {
            stringBuffer.append(" " + AbleData.OperatorRl(this.myOp));
            if (this.myLhs != null) {
                if (this.myLhs instanceof AbleExpression) {
                    stringBuffer.append("(" + this.myLhs.arlCRdString() + ")");
                } else {
                    stringBuffer.append(this.myLhs.arlCRdString());
                }
            }
        } else {
            if (this.myLhs != null) {
                if (this.myLhs instanceof AbleExpression) {
                    stringBuffer.append("(" + this.myLhs.arlCRdString() + ")");
                } else {
                    stringBuffer.append(this.myLhs.arlCRdString());
                }
            }
            stringBuffer.append(" " + AbleData.OperatorRl(this.myOp) + " ");
            if (this.myRhs != null) {
                if (this.myRhs instanceof AbleExpression) {
                    stringBuffer.append("(" + this.myRhs.arlCRdString() + ")");
                } else {
                    stringBuffer.append(this.myRhs.arlCRdString());
                }
            }
        }
        if (this.myWeight != 1.0) {
            stringBuffer.append(" [" + this.myWeight + "]");
        }
        return stringBuffer.toString();
    }

    private boolean isUnary(int n) {
        return n == 20 || n == 19 || n == 18 || n == 24;
    }

    public Vector convertToConjunctiveNormalForm() {
        Vector<AbleExpression> vector = new Vector<AbleExpression>();
        AbleExpression ableExpression = this;
        if (!ableExpression.isCompoundExpression()) {
            vector.add(this);
            return vector;
        }
        while (ableExpression.isCompoundExpression() && ableExpression.getOp() == 16) {
            vector.addAll(((AbleExpression)ableExpression.getLhs()).convertToConjunctiveNormalForm());
            ableExpression = (AbleExpression)ableExpression.getRhs();
        }
        vector.add(ableExpression);
        return vector;
    }

    public Vector convertToDisjunctiveNormalForm() {
        Vector<AbleExpression> vector = new Vector<AbleExpression>();
        AbleExpression ableExpression = this;
        if (!ableExpression.isCompoundExpression()) {
            vector.add(this);
            return vector;
        }
        while (ableExpression.isCompoundExpression() && ableExpression.getOp() == 17) {
            vector.addAll(((AbleExpression)ableExpression.getLhs()).convertToDisjunctiveNormalForm());
            ableExpression = (AbleExpression)ableExpression.getRhs();
        }
        vector.add(ableExpression);
        return vector;
    }

    public String getTemplateString(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.isUnary(this.myOp)) {
            stringBuffer.append(" " + AbleData.OperatorRl(this.myOp));
            if (this.myLhs != null) {
                stringBuffer.append(this.myLhs.getTemplateString(vector));
            }
        } else if (this.myOp == 10) {
            stringBuffer.append(this.myRhs.getTemplateString(vector));
        } else {
            stringBuffer.append(this.myLhs.getTemplateString(vector));
            stringBuffer.append(" " + AbleData.OperatorRl(this.myOp) + " ");
            stringBuffer.append(this.myRhs.getTemplateString(vector));
        }
        return stringBuffer.toString();
    }

    public AbleLiteral getValue() throws AbleDataException {
        if (this.myExprIsConstant && this.myValue != null) {
            return (AbleLiteral)this.myValue;
        }
        AbleRd ableRd = this.myLhs;
        int n = this.myOp;
        AbleRd ableRd2 = this.myRhs;
        while (ableRd instanceof AbleExpression) {
            if (!((ableRd = ableRd.getValue()) instanceof AbleBooleanLiteral) || !(n == 16 ? !((AbleBooleanLiteral)ableRd).getBooleanValue() : n == 17 && ((AbleBooleanLiteral)ableRd).getBooleanValue())) continue;
            return (AbleLiteral)ableRd;
        }
        while (ableRd2 instanceof AbleExpression) {
            ableRd2 = ableRd2.getValue();
        }
        switch (n) {
            case 1: {
                ((AbleLhs)ableRd).asgnEq(ableRd2);
                this.myValue = ableRd.getValue();
                break;
            }
            case 2: {
                ((AbleFuzzyVariable)ableRd).asgnIs(ableRd2);
                this.myValue = ableRd.getValue();
                break;
            }
            case 6: {
                this.myValue = new AbleDoubleLiteral(ableRd.cmpIs(ableRd2));
                break;
            }
            case 3: {
                if (ableRd.cmpEq(ableRd2)) {
                    this.myValue = AbleBooleanLiteral.TRUE;
                    break;
                }
                this.myValue = AbleBooleanLiteral.FALSE;
                break;
            }
            case 4: {
                if (ableRd.cmpGt(ableRd2)) {
                    this.myValue = AbleBooleanLiteral.TRUE;
                    break;
                }
                this.myValue = AbleBooleanLiteral.FALSE;
                break;
            }
            case 5: {
                if (ableRd.cmpGtEq(ableRd2)) {
                    this.myValue = AbleBooleanLiteral.TRUE;
                    break;
                }
                this.myValue = AbleBooleanLiteral.FALSE;
                break;
            }
            case 7: {
                if (ableRd.cmpLt(ableRd2)) {
                    this.myValue = AbleBooleanLiteral.TRUE;
                    break;
                }
                this.myValue = AbleBooleanLiteral.FALSE;
                break;
            }
            case 8: {
                if (ableRd.cmpLtEq(ableRd2)) {
                    this.myValue = AbleBooleanLiteral.TRUE;
                    break;
                }
                this.myValue = AbleBooleanLiteral.FALSE;
                break;
            }
            case 9: {
                if (ableRd.cmpNeq(ableRd2)) {
                    this.myValue = AbleBooleanLiteral.TRUE;
                    break;
                }
                this.myValue = AbleBooleanLiteral.FALSE;
                break;
            }
            case 10: {
                this.myValue = ableRd2.getValue();
                break;
            }
            case 11: {
                this.myValue = ableRd.compPlus(ableRd2);
                break;
            }
            case 12: {
                this.myValue = ableRd.compMinus(ableRd2);
                break;
            }
            case 13: {
                this.myValue = ableRd.compMultiply(ableRd2);
                break;
            }
            case 14: {
                this.myValue = ableRd.compDivide(ableRd2);
                break;
            }
            case 15: {
                this.myValue = ableRd.compModulo(ableRd2);
                break;
            }
            case 21: {
                this.myValue = ableRd.bitwiseAND(ableRd2);
                break;
            }
            case 22: {
                this.myValue = ableRd.bitwiseOR(ableRd2);
                break;
            }
            case 23: {
                this.myValue = ableRd.bitwiseXOR(ableRd2);
                break;
            }
            case 24: {
                this.myValue = ableRd.bitwiseNOT(ableRd2);
                break;
            }
            case 25: {
                this.myValue = ableRd.bitwiseShiftLeft(ableRd2);
                break;
            }
            case 26: {
                this.myValue = ableRd.bitwiseShiftRight(ableRd2);
                break;
            }
            case 27: {
                this.myValue = ableRd.bitwiseShiftRightZeroFill(ableRd2);
                break;
            }
            case 20: {
                this.myValue = ableRd.compUnaryMinus(ableRd2);
                break;
            }
            case 19: {
                this.myValue = ableRd;
                break;
            }
            case 16: {
                if (ableRd.logicalAND(ableRd2)) {
                    this.myValue = AbleBooleanLiteral.TRUE;
                    break;
                }
                this.myValue = AbleBooleanLiteral.FALSE;
                break;
            }
            case 17: {
                if (ableRd.logicalOR(ableRd2)) {
                    this.myValue = AbleBooleanLiteral.TRUE;
                    break;
                }
                this.myValue = AbleBooleanLiteral.FALSE;
                break;
            }
            case 18: {
                if (ableRd.logicalNOT(ableRd2)) {
                    this.myValue = AbleBooleanLiteral.TRUE;
                    break;
                }
                this.myValue = AbleBooleanLiteral.FALSE;
                break;
            }
            default: {
                throw new AbleDataException(Able.NlsMsg("Ex_DataUnrecognizedOperatorInExpression", new Object[]{Integer.toString(n)}));
            }
        }
        return (AbleLiteral)this.myValue;
    }

    public String getStringValue() throws AbleDataException {
        return this.getValue().getStringValue();
    }

    public double getNumericValue() throws AbleDataException {
        return this.getValue().getNumericValue();
    }

    public Object getGenericValue() throws AbleDataException {
        return this.getValue().getGenericValue();
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        return null;
    }

    public boolean getBooleanValue() throws AbleDataException {
        return this.getValue().getBooleanValue();
    }

    public Class getDataTypeClass() {
        try {
            if (this.myValue == null) {
                this.getValue();
            }
        }
        catch (AbleDataException ableDataException) {
            // empty catch block
        }
        if (this.myValue == null) {
            return class$com$ibm$able$data$AbleExpression == null ? (class$com$ibm$able$data$AbleExpression = AbleExpression.class$("com.ibm.able.data.AbleExpression")) : class$com$ibm$able$data$AbleExpression;
        }
        return this.myValue.getDataTypeClass();
    }

    public String getDataTypeClassName() {
        try {
            if (this.myValue == null) {
                this.getValue();
            }
        }
        catch (AbleDataException ableDataException) {
            // empty catch block
        }
        if (this.myValue == null) {
            return (class$com$ibm$able$data$AbleExpression == null ? (class$com$ibm$able$data$AbleExpression = AbleExpression.class$("com.ibm.able.data.AbleExpression")) : class$com$ibm$able$data$AbleExpression).getName();
        }
        return this.myValue.getDataTypeClass().getName();
    }

    public final void setWeight(double d) {
        this.myWeight = d;
    }

    public final double getWeight() {
        return this.myWeight;
    }

    public HashSet getVariableReferences() {
        HashSet<AbleRd> hashSet = new HashSet<AbleRd>();
        if (this.myLhs instanceof AbleExpression) {
            hashSet.addAll(((AbleExpression)this.myLhs).getVariableReferences());
        } else if (this.myLhs instanceof AbleVariable) {
            hashSet.add(this.myLhs);
        } else if (this.myLhs instanceof AbleTypedVariableMethodLiteral) {
            hashSet.addAll(((AbleTypedVariableMethodLiteral)this.myLhs).getVariableReferences());
        } else if (this.myLhs instanceof AbleTypedVariableField) {
            hashSet.add(((AbleTypedVariableField)this.myLhs).getTypedVariable());
        } else if (this.myLhs instanceof AbleCallLiteral) {
            hashSet.addAll(((AbleCallLiteral)this.myLhs).getVariableReferences());
        } else if (this.myRhs instanceof AbleNewObjectLiteral) {
            hashSet.addAll(((AbleNewObjectLiteral)this.myRhs).getVariableReferences());
        }
        if (this.myRhs instanceof AbleExpression) {
            hashSet.addAll(((AbleExpression)this.myRhs).getVariableReferences());
        } else if (this.myLhs instanceof AbleVariable) {
            hashSet.add(this.myRhs);
        } else if (this.myRhs instanceof AbleTypedVariableMethodLiteral) {
            hashSet.addAll(((AbleTypedVariableMethodLiteral)this.myRhs).getVariableReferences());
        } else if (this.myRhs instanceof AbleTypedVariableField) {
            hashSet.add(((AbleTypedVariableField)this.myRhs).getTypedVariable());
        } else if (this.myRhs instanceof AbleCallLiteral) {
            hashSet.addAll(((AbleCallLiteral)this.myRhs).getVariableReferences());
        } else if (this.myRhs instanceof AbleNewObjectLiteral) {
            hashSet.addAll(((AbleNewObjectLiteral)this.myRhs).getVariableReferences());
        }
        return hashSet;
    }

    public boolean equals(AbleExpression ableExpression) {
        if (this.myOp != ableExpression.getOp() || this.myWeight != ableExpression.getWeight()) {
            return false;
        }
        if (this.myLhs == null && ableExpression.getLhs() != null || this.myLhs != null && !this.myLhs.equals(ableExpression.getLhs())) {
            return false;
        }
        return (this.myRhs != null || ableExpression.getRhs() == null) && (this.myRhs == null || this.myRhs.equals(ableExpression.getRhs()));
    }

    public boolean equals(Object object) {
        if (object instanceof AbleExpression) {
            return this.equals((AbleExpression)object);
        }
        return false;
    }

    public int hashCode() {
        int n = this.myOp;
        if (this.myLhs != null) {
            n ^= this.myLhs.hashCode();
        }
        if (this.myRhs != null) {
            n ^= this.myRhs.hashCode();
        }
        return n;
    }

    public boolean isSimpleExpression() {
        return !this.isComplexExpression();
    }

    public boolean isComplexExpression() {
        return this.myLhs instanceof AbleExpression || this.myRhs instanceof AbleExpression;
    }

    public boolean isCompoundExpression() {
        return this.myLhs instanceof AbleExpression && this.myRhs instanceof AbleExpression;
    }

    public boolean isConstant() {
        return this.myExprIsConstant;
    }

    public int getDataType() {
        return 26;
    }

    public void setLocation(AbleLocation ableLocation) {
        this.myLocation = ableLocation;
    }

    public AbleLocation getLocation() {
        return this.myLocation;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

