/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import java.io.Serializable;

public class AbleDoubleLiteral
extends AbleLiteral
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static final String clsNm = "AbleDoubleLiteral";
    protected double myValue;

    public AbleDoubleLiteral(int n) {
        this.myValue = n;
    }

    public AbleDoubleLiteral(long l) {
        this.myValue = l;
    }

    public AbleDoubleLiteral(float f) {
        this.myValue = f;
    }

    public AbleDoubleLiteral(double d) {
        this.myValue = d;
    }

    public boolean getBooleanValue() throws AbleDataException {
        return this.myValue != 0.0;
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToFuzzy", new Object[]{clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        return new Double(this.myValue);
    }

    public double getNumericValue() throws AbleDataException {
        return this.myValue;
    }

    public String getStringValue() throws AbleDataException {
        return Double.toString(this.myValue);
    }

    public AbleLiteral getValue() throws AbleDataException {
        return this;
    }

    public Class getDataTypeClass() {
        return Double.TYPE;
    }

    public String getDataTypeClassName() {
        return Double.TYPE.getName();
    }

    public String arlCRdString() {
        return Double.toString(this.myValue);
    }

    public String xmlCRdString() {
        return "<doubleLiteral value=\"" + Double.toString(this.myValue) + "\"/>";
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        return this.myValue == ableRd.getNumericValue();
    }

    public boolean cmpGt(AbleRd ableRd) throws AbleDataException {
        return this.myValue > ableRd.getNumericValue();
    }

    public boolean cmpGtEq(AbleRd ableRd) throws AbleDataException {
        return this.myValue >= ableRd.getNumericValue();
    }

    public boolean cmpLt(AbleRd ableRd) throws AbleDataException {
        return this.myValue < ableRd.getNumericValue();
    }

    public boolean cmpLtEq(AbleRd ableRd) throws AbleDataException {
        return this.myValue <= ableRd.getNumericValue();
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        return this.myValue != ableRd.getNumericValue();
    }

    public AbleLiteral compPlus(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(this.myValue + ableRd.getNumericValue());
    }

    public AbleLiteral compMinus(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(this.myValue - ableRd.getNumericValue());
    }

    public AbleLiteral compMultiply(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(this.myValue * ableRd.getNumericValue());
    }

    public AbleLiteral compDivide(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(this.myValue / ableRd.getNumericValue());
    }

    public AbleLiteral compUnaryMinus(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(0.0 - this.myValue);
    }

    public boolean equals(Object object) {
        if (object instanceof AbleDoubleLiteral) {
            return this.myValue == ((AbleDoubleLiteral)object).myValue;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.myValue % 2.147483646E9);
    }

    public String toString() {
        return this.arlCRdString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlCRdString();
            }
            case 4: {
                return this.arlCRdString();
            }
            case 5: {
                return this.xmlCRdString();
            }
        }
        return this.arlCRdString();
    }

    private String trcString(int n) {
        return Double.toString(this.myValue);
    }

    public int getDataType() {
        return 8;
    }
}

