/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataContext;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleDoubleLiteral;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleNewObjectLiteral;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleTypedVariable;
import java.io.Serializable;
import java.util.Vector;

public class AbleDiscreteVariable
extends AbleTypedVariable
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static String clsNm = "AbleDiscreteVariable";
    protected double myValue;
    protected Vector myValueList;
    protected double myInitialValue = Double.NaN;
    protected boolean myMaxValueKnown = false;
    protected double myMaxValue = Double.NaN;
    protected boolean myMinValueKnown = false;
    protected double myMinValue = Double.NaN;
    static /* synthetic */ Class class$com$ibm$able$data$AbleDoubleLiteral;

    public AbleDiscreteVariable(Object[] objectArray) throws AbleDataException {
        super("initializer", false, false, "Discrete", "com.ibm.able.data.AbleDiscreteVariable");
        this.myValue = 0.0;
        this.myValueInitial = null;
        Vector<Double> vector = new Vector<Double>();
        for (int i = 0; i < objectArray.length; ++i) {
            Double d = new Double(((AbleRd)objectArray[i]).getNumericValue());
            vector.add(d);
        }
        this.myValueList = vector;
    }

    public AbleDiscreteVariable(Vector vector) throws AbleDataException {
        super("initializer", false, false, "Discrete", "com.ibm.able.data.AbleDiscreteVariable");
        this.myValue = 0.0;
        this.myValueInitial = null;
        this.myValueList = (Vector)vector.clone();
    }

    public AbleDiscreteVariable(Object[] objectArray, double d) throws AbleDataException {
        super("initializer", false, false, "Discrete", "com.ibm.able.data.AbleDiscreteVariable");
        this.myValue = d;
        this.myValueInitial = new AbleDoubleLiteral(d);
        Vector<Double> vector = new Vector<Double>();
        for (int i = 0; i < objectArray.length; ++i) {
            Double d2 = new Double(((AbleRd)objectArray[i]).getNumericValue());
            vector.add(d2);
        }
        this.myValueList = vector;
    }

    public AbleDiscreteVariable(Vector vector, double d) throws AbleDataException {
        super("initializer", false, false, "Discrete", "com.ibm.able.data.AbleDiscreteVariable");
        this.myValue = d;
        this.myInitialValue = d;
        this.myValueInitial = new AbleDoubleLiteral(d);
        this.myValueList = (Vector)vector.clone();
    }

    public AbleDiscreteVariable(String string, Vector vector) {
        super(string, false, false, "Discrete", "com.ibm.able.data.AbleDiscreteVariable");
        this.myValue = 0.0;
        this.myValueInitial = null;
        this.myValueList = (Vector)vector.clone();
    }

    public AbleDiscreteVariable(String string, boolean bl, boolean bl2, Vector vector) {
        super(string, bl, bl2, "Discrete", "com.ibm.able.data.AbleDiscreteVariable");
        this.myDataType = 14;
        this.myValue = 0.0;
        this.myValueInitial = null;
        this.myValueList = (Vector)vector.clone();
    }

    public AbleDiscreteVariable(String string) {
        super(string, false, false, "Discrete", "com.ibm.able.data.AbleDiscreteVariable");
        this.myDataType = 14;
        this.myValue = 0.0;
        this.myValueInitial = null;
        this.myValueList = new Vector();
    }

    public static AbleRd createInitializer(AbleDataContext ableDataContext, Vector vector, double d) throws AbleDataException {
        Object object;
        AbleNewObjectLiteral ableNewObjectLiteral = null;
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            object = vector.get(i);
            if (object instanceof String) {
                object = new AbleDoubleLiteral(Double.valueOf((String)object));
            }
            if (object instanceof Integer) {
                object = new AbleDoubleLiteral(Integer.valueOf((String)object).doubleValue());
            }
            if (object instanceof Double) {
                object = new AbleDoubleLiteral((Double)object);
            }
            vector2.add(object);
        }
        AbleNewObjectLiteral ableNewObjectLiteral2 = new AbleNewObjectLiteral(ableDataContext, "Double[]", "", vector2, null);
        object = new Vector();
        ((Vector)object).add((AbleNewObjectLiteral)ableNewObjectLiteral2);
        ((Vector)object).add((AbleDoubleLiteral)new AbleDoubleLiteral(d));
        ableNewObjectLiteral = new AbleNewObjectLiteral(ableDataContext, "Discrete", "", (Vector)object, null);
        return ableNewObjectLiteral;
    }

    public static AbleRd createInitializer(AbleDataContext ableDataContext, Vector vector) throws AbleDataException {
        Object object;
        AbleNewObjectLiteral ableNewObjectLiteral = null;
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            object = vector.get(i);
            if (object instanceof String) {
                object = new AbleDoubleLiteral(Double.valueOf((String)object));
            }
            if (object instanceof Integer) {
                object = new AbleDoubleLiteral(Integer.valueOf((String)object).doubleValue());
            }
            if (object instanceof Double) {
                object = new AbleDoubleLiteral((Double)object);
            }
            vector2.add(object);
        }
        AbleNewObjectLiteral ableNewObjectLiteral2 = new AbleNewObjectLiteral(ableDataContext, "Double[]", "", vector2, null);
        object = new Vector();
        ((Vector)object).add((AbleNewObjectLiteral)ableNewObjectLiteral2);
        ableNewObjectLiteral = new AbleNewObjectLiteral(ableDataContext, "Discrete", "", (Vector)object, null);
        return ableNewObjectLiteral;
    }

    public boolean getBooleanValue() throws AbleDataException {
        if (Double.isNaN(this.myValue)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToBoolean", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
        }
        return this.myValue != 0.0;
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToFuzzy", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        return new Double(this.myValue);
    }

    public double getNumericValue() throws AbleDataException {
        return this.myValue;
    }

    public String getStringValue() throws AbleDataException {
        return this.getValueString();
    }

    public AbleLiteral getValue() throws AbleDataException {
        return new AbleDoubleLiteral(this.myValue);
    }

    public void asgnEq(AbleRd ableRd) throws AbleDataException {
        if (ableRd instanceof AbleNewObjectLiteral) {
            AbleDiscreteVariable ableDiscreteVariable = (AbleDiscreteVariable)ableRd.getGenericValue();
            this.myValueList = ableDiscreteVariable.getValueList();
            this.myValue = ableDiscreteVariable.getNumericValue();
            this.myValueInitial = Double.isNaN(this.myValue) ? null : new AbleDoubleLiteral(this.myValue);
            this.myBoundFlag = true;
        } else {
            this.setRawValue(ableRd.getNumericValue());
        }
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        return this.myValue == ableRd.getNumericValue();
    }

    public boolean cmpGt(AbleRd ableRd) throws AbleDataException {
        return this.myValue > ableRd.getNumericValue();
    }

    public boolean cmpGtEq(AbleRd ableRd) throws AbleDataException {
        return this.myValue >= ableRd.getNumericValue();
    }

    public boolean cmpLt(AbleRd ableRd) throws AbleDataException {
        return this.myValue < ableRd.getNumericValue();
    }

    public boolean cmpLtEq(AbleRd ableRd) throws AbleDataException {
        return this.myValue <= ableRd.getNumericValue();
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        return this.myValue != ableRd.getNumericValue();
    }

    public void setBooleanValue(boolean bl) throws AbleDataException {
        if (bl) {
            try {
                this.setRawValue(1.0);
            }
            catch (AbleDataException ableDataException) {
                throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromBoolean", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
            }
        }
        try {
            this.setRawValue(0.0);
        }
        catch (AbleDataException ableDataException) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromBoolean", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
        }
    }

    public void setFuzzyValue(AbleFuzzySet ableFuzzySet) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromFuzzy", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public void setGenericValue(Object object) throws AbleDataException {
        if (object instanceof Boolean) {
            this.setBooleanValue((Boolean)object);
        } else if (object instanceof Number) {
            this.setNumericValue(((Number)object).doubleValue());
        } else if (object instanceof String) {
            this.setStringValue((String)object);
        } else if (object instanceof AbleLiteral) {
            this.setValue((AbleLiteral)object);
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromGeneric", new Object[]{Integer.toString(this.myId), this.myName, "AbleDiscrteVariable"}));
        }
    }

    public void setNumericValue(double d) throws AbleDataException {
        try {
            this.setRawValue(d);
        }
        catch (AbleDataException ableDataException) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromNumeric", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
        }
    }

    public void setStringValue(String string) throws AbleDataException {
        this.setValueString(string);
    }

    public void setValue(AbleLiteral ableLiteral) throws AbleDataException {
        this.setNumericValue(ableLiteral.getNumericValue());
    }

    public String arlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myComment.length() > 0) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        stringBuffer.append(this.isTemplate() ? "    template " : "    ");
        stringBuffer.append(this.isStatic() ? "    static " : "    ");
        stringBuffer.append("Discrete " + this.myName);
        if (this.myValueInitial == null) {
            stringBuffer.append(";" + Able.LS);
        } else {
            String string = this.myValueInitial.arlCRdString();
            if (string.length() == 0) {
                stringBuffer.append(";");
            } else {
                stringBuffer.append(" = ");
                stringBuffer.append(string + ";" + Able.LS);
            }
        }
        return stringBuffer.toString();
    }

    public String xmlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <declareVar varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"");
        stringBuffer.append(" dataType=\"Discrete\"");
        stringBuffer.append((this.isStatic() ? " static=\"true\"" : "") + (this.isTemplate() ? " template=\"true\"" : "") + ">" + Able.LS);
        stringBuffer.append(this.xmlInitializerString());
        stringBuffer.append("       </declareVar>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <Variable varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"" + " dataType=\"" + "Discrete" + "\"" + (this.isStatic() ? " static=\"true\"" : "") + (this.isTemplate() ? " template=\"true\"" : "") + ">" + Able.LS);
        stringBuffer.append(this.armlInitializerString());
        stringBuffer.append("       </Variable>" + Able.LS);
        return stringBuffer.toString();
    }

    public void setValueString(String string) throws AbleDataException {
        try {
            Double d = Double.valueOf(string);
            this.setRawValue(d);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidDiscreteNumber", new Object[]{Integer.toString(this.myId), this.myName, string}));
        }
    }

    public String getValueString() {
        return Double.toString(this.myValue);
    }

    public void reset() throws AbleDataException {
        if (!this.myStaticFlag) {
            this.init();
        }
    }

    public void init() throws AbleDataException {
        if (Double.isNaN(this.myInitialValue)) {
            this.myValue = 0.0;
            this.myBoundFlag = false;
        } else {
            this.myValue = this.myInitialValue;
            this.myBoundFlag = true;
        }
    }

    public Class getDataTypeClass() {
        return Double.TYPE;
    }

    public String getDataTypeClassName() {
        return Double.TYPE.getName();
    }

    public Class getLiteralClass() {
        return class$com$ibm$able$data$AbleDoubleLiteral == null ? (class$com$ibm$able$data$AbleDoubleLiteral = AbleDiscreteVariable.class$("com.ibm.able.data.AbleDoubleLiteral")) : class$com$ibm$able$data$AbleDoubleLiteral;
    }

    public void setInitialValue(AbleRd ableRd) throws AbleDataException {
        Object object;
        if (ableRd instanceof AbleNewObjectLiteral) {
            object = ableRd.getGenericValue();
            if (!(object instanceof AbleDiscreteVariable)) {
                throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidInitialValueForDiscrete", new Object[]{this.myName}));
            }
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidInitialValueForDiscrete", new Object[]{this.myName}));
        }
        AbleDiscreteVariable ableDiscreteVariable = (AbleDiscreteVariable)object;
        this.myValueList = ableDiscreteVariable.getValueList();
        this.myValue = ableDiscreteVariable.getNumericValue();
        this.myValueInitial = ableRd;
    }

    void setRawValue(double d) throws AbleDataException {
        if (this.valueExist(d)) {
            double d2 = this.myValue;
            this.myValue = d;
            this.myBoundFlag = true;
            if (this.myChgSupport != null) {
                this.myChgSupport.firePropertyChange("DiscreteValue " + this.myName, new Double(d2), new Double(d));
            }
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarDiscreteNotInNumberList", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d)}));
        }
    }

    public Object getRawValue() {
        return new Double(this.myValue);
    }

    public void setValueList(Vector vector) {
        Vector vector2 = (Vector)this.myValueList.clone();
        this.myValueList = (Vector)vector.clone();
        if (this.myChgSupport != null) {
            this.myChgSupport.firePropertyChange("DiscreteNumberList " + this.myName, vector2, vector);
        }
        if (!this.valueExist(this.myValue)) {
            this.myValue = Double.NaN;
        }
        this.myMaxValueKnown = false;
        this.myMinValueKnown = false;
    }

    public Vector getValueList() {
        return this.myValueList;
    }

    public int getValueListSize() {
        return this.myValueList.size();
    }

    public boolean valueExist(double d) {
        return this.myValueList.contains(new Double(d));
    }

    public void addValue(double d) throws AbleDataException {
        if (this.valueExist(d)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarDiscreteAlreadyInNumberList", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d)}));
        }
        this.myValueList.addElement(new Double(d));
        this.myMaxValueKnown = false;
        this.myMinValueKnown = false;
    }

    public void removeValue(double d) throws AbleDataException {
        if (this.valueExist(d)) {
            this.myValueList.removeElement(new Double(d));
            if (this.myValue == d) {
                this.myValue = Double.NaN;
            }
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarDiscreteNotInNumberList", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d)}));
        }
        this.myMaxValueKnown = false;
        this.myMinValueKnown = false;
    }

    public int getIndexOf(double d) throws AbleDataException {
        if (this.valueExist(d)) {
            return this.myValueList.indexOf(new Double(d));
        }
        throw new AbleDataException(Able.NlsMsg("Ex_VarCategoryNotInCategoryList", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d)}));
    }

    public double getValueAt(int n) throws AbleDataException {
        try {
            return (Double)this.myValueList.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCategoryIndex", new Object[]{Integer.toString(this.myId), this.myName, Integer.toString(n)}));
        }
    }

    public double getMaxValue() {
        double d = Double.NaN;
        if (this.myMaxValueKnown) {
            d = this.myMaxValue;
        } else if (this.myValueList.isEmpty()) {
            this.myMaxValueKnown = false;
            this.myMaxValue = Double.NaN;
        } else {
            this.myMaxValue = (Double)this.myValueList.firstElement();
            for (int i = 1; i < this.myValueList.size(); ++i) {
                double d2 = (Double)this.myValueList.elementAt(i);
                if (!(d2 > this.myMaxValue)) continue;
                this.myMaxValue = d2;
            }
            this.myMaxValueKnown = true;
            d = this.myMaxValue;
        }
        return d;
    }

    public double getMinValue() {
        double d = Double.NaN;
        if (this.myMinValueKnown) {
            d = this.myMinValue;
        } else if (this.myValueList.isEmpty()) {
            this.myMinValueKnown = false;
            this.myMinValue = Double.NaN;
        } else {
            this.myMinValue = (Double)this.myValueList.firstElement();
            for (int i = 1; i < this.myValueList.size(); ++i) {
                double d2 = (Double)this.myValueList.elementAt(i);
                if (!(d2 < this.myMinValue)) continue;
                this.myMinValue = d2;
            }
            this.myMinValueKnown = true;
            d = this.myMinValue;
        }
        return d;
    }

    public String toString() {
        return this.arlDclString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlDclString();
            }
            case 4: {
                return this.arlDclString();
            }
            case 5: {
                return this.xmlDclString();
            }
        }
        return this.arlDclString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.myName + ":<" + this.getValueString() + ">");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

