/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.beans.filter.AbleTranslateOperator;
import com.ibm.able.beans.filter.AbleTranslateTemplate;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleDiscreteVariable;
import com.ibm.able.data.AbleField;
import com.ibm.able.data.AbleFieldDefinition;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

public class AbleDiscreteField
extends AbleDiscreteVariable
implements AbleField {
    static final long serialVersionUID = 1999100100000000001L;
    protected int usage;
    protected int column = 0;
    protected double min = 0.0;
    protected double max = 0.0;
    protected double mean = 0.0;
    protected Hashtable table = new Hashtable();

    public AbleDiscreteField(AbleFieldDefinition ableFieldDefinition) {
        super(ableFieldDefinition.getName());
        this.usage = ableFieldDefinition.getUsageType();
    }

    public AbleDiscreteField(String string, int n, int n2) {
        super(string);
        this.usage = n;
        this.column = n2;
    }

    double getMin() {
        return this.min;
    }

    double getMax() {
        return this.max;
    }

    double getMean() {
        this.mean = (this.min + this.max) / 2.0;
        return this.mean;
    }

    public void computeStatistics(Object object) {
        String string = String.valueOf(object);
        double d = string.equals("SQL_NULL_SQL") ? Double.NaN : Double.valueOf(string);
        if (!this.valueExist(d)) {
            block5: {
                try {
                    this.addValue(d);
                }
                catch (AbleDataException ableDataException) {
                    Able.MessageLog.text(4L, this, "computeStatistics", ableDataException.getLocalizedMessage());
                    if (!Able.TraceLog.isLogging()) break block5;
                    Able.TraceLog.exception(262144L, this, "computeStatistics", ableDataException);
                }
            }
            if (d < this.min) {
                this.min = d;
            }
            if (d > this.max) {
                this.max = d;
            }
            this.table.put(String.valueOf(new Double(d)), String.valueOf(this.myValueList.size()));
        }
    }

    public double getNumericValue(Object object) {
        int n;
        block2: {
            n = 0;
            String string = String.valueOf(object);
            try {
                n = string.equals("SQL_NULL_SQL") ? this.getIndexOf(Double.NaN) + 1 : this.getIndexOf(Double.valueOf(string)) + 1;
            }
            catch (AbleDataException ableDataException) {
                Able.MessageLog.text(4L, this, "getNumericValue", ableDataException.getLocalizedMessage());
                if (!Able.TraceLog.isLogging()) break block2;
                Able.TraceLog.exception(262144L, this, "getNumericValue", ableDataException);
            }
        }
        return n;
    }

    public int getNormalizedSize() {
        return this.myValueList.size();
    }

    public AbleTranslateTemplate getInputTranslateTemplate() {
        AbleTranslateTemplate ableTranslateTemplate;
        if (this.usage == 1) {
            ableTranslateTemplate = new AbleTranslateTemplate(this.myName, 1, 1, 1, 1, 4, this.myValueList.size());
            AbleTranslateOperator ableTranslateOperator = new AbleTranslateOperator(30, this.table, "0", true);
            ableTranslateTemplate.setOperator(ableTranslateOperator);
        } else {
            ableTranslateTemplate = new AbleTranslateTemplate(this.myName, 0, 1, 1, 1, 1, 1);
            AbleTranslateOperator ableTranslateOperator = new AbleTranslateOperator(25, new double[]{this.min, this.getMean(), this.max, 0.0, 0.5, 1.0});
            ableTranslateTemplate.setPreOperator(ableTranslateOperator);
        }
        if (this.usage == 2) {
            ableTranslateTemplate.setUsage(2);
        }
        return ableTranslateTemplate;
    }

    public AbleTranslateTemplate getOutputTranslateTemplate() {
        if (this.usage == 1) {
            String string;
            String string2;
            AbleTranslateTemplate ableTranslateTemplate = new AbleTranslateTemplate(this.myName, 0, 1, 4, this.myValueList.size(), 2, 1);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            Enumeration enumeration = this.table.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                string = (String)this.table.get(string2);
                hashtable.put(string, string2);
            }
            string2 = new AbleTranslateOperator(17, null);
            ableTranslateTemplate.setPreOperator((AbleTranslateOperator)string2);
            string = new AbleTranslateOperator(30, hashtable, "unknown", true);
            ableTranslateTemplate.setOperator((AbleTranslateOperator)string);
            return ableTranslateTemplate;
        }
        return null;
    }

    public void setColumn(int n) {
        this.column = n;
    }

    public int getColumn() {
        return this.column;
    }

    public String getDataTypeString() {
        return AbleData.DataType(this.myDataType);
    }

    public String getUsageString() {
        return AbleData.UsageTypeString(this.usage);
    }

    public int getUsage() {
        return this.usage;
    }

    public void setUsage(String string) {
        this.usage = AbleData.UsageType(string);
    }

    public Map getMap() {
        return (Hashtable)this.table.clone();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

