/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataContext;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleDoubleLiteral;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleNewObjectLiteral;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleVariable;
import java.io.Serializable;
import java.util.Vector;

public class AbleContinuousVariable
extends AbleVariable
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static String clsNm = "AbleContinuousVariable";
    protected double myDiscourseLo;
    protected double myDiscourseHi;
    protected double myValue;
    protected double myInitialValue;
    static /* synthetic */ Class class$com$ibm$able$data$AbleDoubleLiteral;

    public AbleContinuousVariable(double d, double d2) {
        super(13, "initializer");
        this.myDiscourseLo = d;
        this.myDiscourseHi = d2;
        this.myValue = Double.NaN;
        this.myValueInitial = null;
    }

    public AbleContinuousVariable(double d, double d2, double d3) {
        super(13, "initializer");
        this.myDiscourseLo = d;
        this.myDiscourseHi = d2;
        this.myValue = d3;
        this.myValueInitial = new AbleDoubleLiteral(d3);
    }

    public AbleContinuousVariable(String string, double d, double d2) {
        super(13, string);
        this.myDiscourseLo = d;
        this.myDiscourseHi = d2;
        this.myValue = Double.NaN;
        this.myValueInitial = null;
    }

    public AbleContinuousVariable(String string, boolean bl, boolean bl2, double d, double d2) {
        super(13, string, bl, bl2);
        this.myDiscourseLo = d;
        this.myDiscourseHi = d2;
        this.myValue = Double.NaN;
        this.myValueInitial = null;
    }

    public static AbleRd createInitializer(AbleDataContext ableDataContext, double d, double d2, double d3) throws AbleDataException {
        AbleNewObjectLiteral ableNewObjectLiteral = null;
        Vector<AbleDoubleLiteral> vector = new Vector<AbleDoubleLiteral>();
        vector.add(new AbleDoubleLiteral(d));
        vector.add(new AbleDoubleLiteral(d2));
        vector.add(new AbleDoubleLiteral(d3));
        ableNewObjectLiteral = new AbleNewObjectLiteral(ableDataContext, "Continuous", "", vector, null);
        return ableNewObjectLiteral;
    }

    public static AbleRd createInitializer(AbleDataContext ableDataContext, double d, double d2) throws AbleDataException {
        AbleNewObjectLiteral ableNewObjectLiteral = null;
        Vector<AbleDoubleLiteral> vector = new Vector<AbleDoubleLiteral>();
        vector.add(new AbleDoubleLiteral(d));
        vector.add(new AbleDoubleLiteral(d2));
        ableNewObjectLiteral = new AbleNewObjectLiteral(ableDataContext, "Continuous", "", vector, null);
        return ableNewObjectLiteral;
    }

    public boolean getBooleanValue() throws AbleDataException {
        return this.myValue != 0.0;
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToFuzzy", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        return new Double(this.myValue);
    }

    public double getNumericValue() throws AbleDataException {
        return this.myValue;
    }

    public String getStringValue() throws AbleDataException {
        return this.getValueString();
    }

    public AbleLiteral getValue() throws AbleDataException {
        return new AbleDoubleLiteral(this.myValue);
    }

    public void asgnEq(AbleRd ableRd) throws AbleDataException {
        if (ableRd instanceof AbleNewObjectLiteral) {
            AbleContinuousVariable ableContinuousVariable = (AbleContinuousVariable)ableRd.getGenericValue();
            this.myDiscourseLo = ableContinuousVariable.getDiscourseLo();
            this.myDiscourseHi = ableContinuousVariable.getDiscourseHi();
            this.myValue = ableContinuousVariable.getNumericValue();
            this.myValueInitial = Double.isNaN(this.myValue) ? null : new AbleDoubleLiteral(this.myValue);
            this.myBoundFlag = true;
        } else {
            this.setRawValue(ableRd.getNumericValue());
        }
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        return this.myValue == ableRd.getNumericValue();
    }

    public boolean cmpGt(AbleRd ableRd) throws AbleDataException {
        return this.myValue > ableRd.getNumericValue();
    }

    public boolean cmpGtEq(AbleRd ableRd) throws AbleDataException {
        return this.myValue >= ableRd.getNumericValue();
    }

    public boolean cmpLt(AbleRd ableRd) throws AbleDataException {
        return this.myValue < ableRd.getNumericValue();
    }

    public boolean cmpLtEq(AbleRd ableRd) throws AbleDataException {
        return this.myValue <= ableRd.getNumericValue();
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        return this.myValue != ableRd.getNumericValue();
    }

    public AbleLiteral compPlus(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(this.myValue + ableRd.getNumericValue());
    }

    public AbleLiteral compMinus(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(this.myValue - ableRd.getNumericValue());
    }

    public AbleLiteral compMultiply(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(this.myValue * ableRd.getNumericValue());
    }

    public AbleLiteral compDivide(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(this.myValue / ableRd.getNumericValue());
    }

    public AbleLiteral compUnaryMinus(AbleRd ableRd) throws AbleDataException {
        return new AbleDoubleLiteral(0.0 - this.myValue);
    }

    public void setBooleanValue(boolean bl) throws AbleDataException {
        if (bl) {
            this.setRawValue(1.0);
        } else {
            this.setRawValue(0.0);
        }
    }

    public void setFuzzyValue(AbleFuzzySet ableFuzzySet) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromFuzzy", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public void setGenericValue(Object object) throws AbleDataException {
        if (object instanceof Boolean) {
            this.setBooleanValue((Boolean)object);
        } else if (object instanceof Number) {
            this.setNumericValue(((Number)object).doubleValue());
        } else if (object instanceof String) {
            this.setStringValue((String)object);
        } else if (object instanceof AbleLiteral) {
            this.setValue((AbleLiteral)object);
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromGeneric", new Object[]{Integer.toString(this.myId), this.myName, "AbleContinousVariable"}));
        }
    }

    public void setNumericValue(double d) throws AbleDataException {
        this.setRawValue(d);
    }

    public void setStringValue(String string) throws AbleDataException {
        this.setValueString(string);
    }

    public void setValue(AbleLiteral ableLiteral) throws AbleDataException {
        this.setRawValue(ableLiteral.getNumericValue());
    }

    public String arlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myComment.length() > 0) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        stringBuffer.append(this.isTemplate() ? "    template " : "    ");
        stringBuffer.append(this.isStatic() ? "    static " : "    ");
        stringBuffer.append("Continuous " + this.myName);
        if (this.myValueInitial == null) {
            stringBuffer.append(";" + Able.LS);
        } else {
            String string = this.myValueInitial.arlCRdString();
            if (string.length() == 0) {
                stringBuffer.append(";");
            } else {
                stringBuffer.append(" = ");
                stringBuffer.append(string + ";" + Able.LS);
            }
        }
        return stringBuffer.toString();
    }

    public String xmlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <declareVar varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"");
        stringBuffer.append(" dataType=\"Continuous\"");
        stringBuffer.append((this.isStatic() ? " static=\"true\"" : "") + (this.isTemplate() ? " template=\"true\"" : "") + ">" + Able.LS);
        stringBuffer.append(this.xmlInitializerString());
        stringBuffer.append("       </declareVar>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <FuzzyVariable varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"" + " dataType=\"" + "Continuous" + "\"" + (this.isStatic() ? " static=\"true\"" : "") + (this.isTemplate() ? " template=\"true\"" : "") + " from=\"" + this.myDiscourseLo + "\" to=\"" + this.myDiscourseHi + "\">" + Able.LS);
        stringBuffer.append(this.armlInitializerString());
        stringBuffer.append("       </FuzzyVariable>" + Able.LS);
        return stringBuffer.toString();
    }

    public void setValueString(String string) throws AbleDataException {
        try {
            Double d = Double.valueOf(string);
            this.setRawValue(d);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidNumericString", new Object[]{Integer.toString(this.myId), this.myName, string}));
        }
    }

    public String getValueString() {
        return Double.toString(this.myValue);
    }

    public void reset() throws AbleDataException {
        if (!this.myStaticFlag) {
            this.init();
        }
    }

    public void init() throws AbleDataException {
        if (this.myValueInitial == null) {
            this.myValue = Double.NaN;
            this.myBoundFlag = false;
        } else {
            this.myValue = this.myInitialValue;
            this.myBoundFlag = true;
        }
    }

    public Class getDataTypeClass() {
        return Double.TYPE;
    }

    public String getDataTypeClassName() {
        return Double.TYPE.getName();
    }

    public String getDataTypeName() {
        return "Continuous";
    }

    public Class getLiteralClass() {
        return class$com$ibm$able$data$AbleDoubleLiteral == null ? (class$com$ibm$able$data$AbleDoubleLiteral = AbleContinuousVariable.class$("com.ibm.able.data.AbleDoubleLiteral")) : class$com$ibm$able$data$AbleDoubleLiteral;
    }

    void setRawValue(double d) throws AbleDataException {
        if (this.withinUniverseOfDiscourse(d)) {
            double d2 = this.myValue;
            this.myValue = d;
            this.myBoundFlag = true;
            if (this.myContext != null) {
                this.myContext.updateCurrentFactBase(this.myId);
            }
            if (this.myChgSupport != null) {
                this.myChgSupport.firePropertyChange("ContinuousValue " + this.myName, new Double(d2), new Double(d));
            }
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarOutOfRangeDiscourse", new Object[]{Integer.toString(this.myId), this.myName, Double.toString(d), Double.toString(this.myDiscourseLo), Double.toString(this.myDiscourseHi)}));
        }
    }

    public void setDiscourseLo(double d) {
        this.myDiscourseLo = d;
    }

    public double getDiscourseLo() {
        return this.myDiscourseLo;
    }

    public void setDiscourseHi(double d) {
        this.myDiscourseHi = d;
    }

    public double getDiscourseHi() {
        return this.myDiscourseHi;
    }

    public boolean withinUniverseOfDiscourse(double d) {
        return !this.chkRange(d);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setInitialValue(AbleRd ableRd) throws AbleDataException {
        if (!(ableRd instanceof AbleNewObjectLiteral)) throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidInitialValueForContinuous", new Object[]{this.myName}));
        Object object = ableRd.getGenericValue();
        if (!(object instanceof AbleContinuousVariable)) throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidInitialValueForContinuous", new Object[]{this.myName}));
        this.myValueInitial = ableRd;
        AbleContinuousVariable ableContinuousVariable = (AbleContinuousVariable)object;
        this.setDiscourseHi(ableContinuousVariable.getDiscourseHi());
        this.setDiscourseLo(ableContinuousVariable.getDiscourseLo());
        this.myInitialValue = this.myValue = ableContinuousVariable.getNumericValue();
        if (this.myDiscourseLo > this.myDiscourseHi) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidInitialValueForContinuous", new Object[]{this.myName}));
        }
        this.reset();
    }

    protected boolean chkRange(double d) {
        return !(this.myDiscourseLo <= d) || !(d <= this.myDiscourseHi);
    }

    public String toString() {
        return this.arlDclString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlDclString();
            }
            case 4: {
                return this.arlDclString();
            }
            case 5: {
                return this.xmlDclString();
            }
        }
        return this.arlDclString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.myName + ":<" + this.getValueString() + ">");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

