/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.beans.filter.AbleTranslateOperator;
import com.ibm.able.beans.filter.AbleTranslateTemplate;
import com.ibm.able.data.AbleContinuousVariable;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleField;
import com.ibm.able.data.AbleFieldDefinition;
import java.util.Map;

public class AbleContinuousField
extends AbleContinuousVariable
implements AbleField {
    static final long serialVersionUID = 1999100100000000001L;
    int usage;
    int column = 0;
    private static final double minDefault = 0.0;
    private static final double maxDefault = 100.0;
    double mean = 0.0;
    double sum = 0.0;
    int numItems = 0;

    public AbleContinuousField(AbleFieldDefinition ableFieldDefinition) {
        super(ableFieldDefinition.getName(), 0.0, 100.0);
        this.usage = ableFieldDefinition.getUsageType();
    }

    public AbleContinuousField(String string, int n, int n2) {
        super(string, 0.0, 100.0);
        this.usage = n;
        this.column = n2;
    }

    public void setMin(double d) {
        this.setDiscourseLo(d);
    }

    public void setMax(double d) {
        this.setDiscourseHi(d);
    }

    public double getMin() {
        return this.getDiscourseLo();
    }

    public double getMax() {
        return this.getDiscourseHi();
    }

    public double getMean() {
        return this.mean;
    }

    public void computeStatistics(Object object) {
        String string = String.valueOf(object);
        double d = string.equals("SQL_NULL_SQL") ? Double.NaN : Double.valueOf(string);
        double d2 = new Double(d);
        if (d2 < this.myDiscourseLo) {
            this.myDiscourseLo = d2;
        }
        if (d2 > this.myDiscourseHi) {
            this.myDiscourseHi = d2;
        }
        this.sum += d2;
        ++this.numItems;
        this.mean = this.sum / (double)this.numItems;
    }

    public double getNumericValue(Object object) {
        String string = String.valueOf(object);
        if (string.equals("SQL_NULL_SQL")) {
            return Double.NaN;
        }
        return Double.valueOf(string);
    }

    public AbleTranslateTemplate getInputTranslateTemplate() {
        AbleTranslateOperator ableTranslateOperator;
        AbleTranslateTemplate ableTranslateTemplate = new AbleTranslateTemplate(this.myName, 0, 1, 1, 1, 1, 1);
        if (this.usage == 1) {
            ableTranslateTemplate.setUsage(1);
            ableTranslateOperator = new AbleTranslateOperator(25, new double[]{this.myDiscourseLo, this.mean, this.myDiscourseHi, 0.1, 0.5, 0.9});
        } else {
            ableTranslateOperator = new AbleTranslateOperator(25, new double[]{this.myDiscourseLo, this.mean, this.myDiscourseHi, 0.0, 0.5, 1.0});
        }
        ableTranslateTemplate.setPreOperator(ableTranslateOperator);
        if (this.usage == 2) {
            ableTranslateTemplate.setUsage(2);
        }
        return ableTranslateTemplate;
    }

    public AbleTranslateTemplate getOutputTranslateTemplate() {
        if (this.usage == 1) {
            AbleTranslateTemplate ableTranslateTemplate = new AbleTranslateTemplate(this.myName, 0, 1, 1, 1, 1, 1);
            AbleTranslateOperator ableTranslateOperator = new AbleTranslateOperator(25, new double[]{0.1, 0.5, 0.9, this.myDiscourseLo, this.mean, this.myDiscourseHi});
            ableTranslateTemplate.setPreOperator(ableTranslateOperator);
            return ableTranslateTemplate;
        }
        return null;
    }

    public int getNormalizedSize() {
        return 1;
    }

    public void setColumn(int n) {
        this.column = n;
    }

    public int getColumn() {
        return this.column;
    }

    public String getDataTypeString() {
        return AbleData.DataType(this.myDataType);
    }

    public String getUsageString() {
        return AbleData.UsageTypeString(this.usage);
    }

    public int getUsage() {
        return this.usage;
    }

    public void setUsage(String string) {
        this.usage = AbleData.UsageType(string);
    }

    public Map getMap() {
        return null;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

