/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleDoubleLiteral;
import com.ibm.able.data.AbleFloatLiteral;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleIntegerLiteral;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import java.io.Serializable;

public class AbleCharacterLiteral
extends AbleLiteral
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static String clsNm = "AbleCharacterLiteral";
    protected char myValue;

    public AbleCharacterLiteral(String string) {
        if (string.length() == 1) {
            this.myValue = string.charAt(0);
        } else if (string.length() == 2) {
            if (string.equals("\b")) {
                this.myValue = (char)8;
            } else if (string.equals("\t")) {
                this.myValue = (char)9;
            } else if (string.equals("\n")) {
                this.myValue = (char)10;
            } else if (string.equals("\f")) {
                this.myValue = (char)12;
            } else if (string.equals("\r")) {
                this.myValue = (char)13;
            } else if (string.equals("\"")) {
                this.myValue = (char)34;
            } else if (string.equals("'")) {
                this.myValue = (char)39;
            } else if (string.equals("\\")) {
                this.myValue = (char)92;
            } else if (string.equals(" ")) {
                this.myValue = (char)32;
            }
        } else if (string.length() == 3) {
            if (string.startsWith("'") && string.endsWith("'")) {
                this.myValue = string.charAt(1);
            }
        } else if (string.length() == 4 && string.startsWith("'") && string.endsWith("'")) {
            if (string.equals("'\b'")) {
                this.myValue = (char)8;
            } else if (string.equals("'\t'")) {
                this.myValue = (char)9;
            } else if (string.equals("'\n'")) {
                this.myValue = (char)10;
            } else if (string.equals("'\f'")) {
                this.myValue = (char)12;
            } else if (string.equals("'\r'")) {
                this.myValue = (char)13;
            } else if (string.equals("'\"'")) {
                this.myValue = (char)34;
            } else if (string.equals("'''")) {
                this.myValue = (char)39;
            } else if (string.equals("'\\'")) {
                this.myValue = (char)92;
            } else if (string.equals(" ")) {
                this.myValue = (char)32;
            }
        }
    }

    public static char valueOf(String string) {
        int n = 32;
        if (string.length() == 1) {
            n = string.charAt(0);
        } else if (string.length() == 2) {
            if (string.equals("\\b")) {
                n = 8;
            } else if (string.equals("\\t")) {
                n = 9;
            } else if (string.equals("\\n")) {
                n = 10;
            } else if (string.equals("\\f")) {
                n = 12;
            } else if (string.equals("\\r")) {
                n = 13;
            } else if (string.equals("\\\"")) {
                n = 34;
            } else if (string.equals("\\'")) {
                n = 39;
            } else if (string.equals("\\\\")) {
                n = 92;
            } else if (string.equals(" ")) {
                n = 32;
            }
        } else if (string.length() == 3) {
            if (string.startsWith("'") && string.endsWith("'")) {
                n = string.charAt(1);
            }
        } else if (string.length() == 4 && string.startsWith("'") && string.endsWith("'")) {
            if (string.equals("'\b'")) {
                n = 8;
            } else if (string.equals("'\t'")) {
                n = 9;
            } else if (string.equals("'\n'")) {
                n = 10;
            } else if (string.equals("'\f'")) {
                n = 12;
            } else if (string.equals("'\r'")) {
                n = 13;
            } else if (string.equals("'\"'")) {
                n = 34;
            } else if (string.equals("'''")) {
                n = 39;
            } else if (string.equals("'\\'")) {
                n = 92;
            } else if (string.equals(" ")) {
                n = 32;
            }
        }
        return (char)n;
    }

    public AbleCharacterLiteral(int n) {
        this.myValue = (char)n;
    }

    public AbleCharacterLiteral(char c) {
        this.myValue = c;
    }

    public boolean getBooleanValue() throws AbleDataException {
        return this.myValue != '\u0000';
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToFuzzy", new Object[]{clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        return new Character(this.myValue);
    }

    public double getNumericValue() throws AbleDataException {
        return this.myValue;
    }

    public String getStringValue() throws AbleDataException {
        return new Character(this.myValue).toString();
    }

    public AbleLiteral getValue() throws AbleDataException {
        return this;
    }

    public Class getDataTypeClass() {
        return Character.TYPE;
    }

    public String getDataTypeClassName() {
        return Character.TYPE.getName();
    }

    public String arlCRdString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'");
        if (Character.isSpaceChar(this.myValue)) {
            if (this.myValue == '\t') {
                stringBuffer.append("\\t");
            } else if (this.myValue == '\n') {
                stringBuffer.append("\\n");
            } else if (this.myValue == '\f') {
                stringBuffer.append("\\f");
            } else if (this.myValue == '\r') {
                stringBuffer.append("\\r");
            } else if (this.myValue == ' ') {
                stringBuffer.append(' ');
            }
        } else {
            stringBuffer.append(new Character(this.myValue).toString());
        }
        stringBuffer.append("'");
        return stringBuffer.toString();
    }

    public String xmlCRdString() {
        return "<characterLiteral value=\"" + new Integer(this.myValue).toString() + "\"/>";
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        return this.myValue == (char)ableRd.getNumericValue();
    }

    public boolean cmpGt(AbleRd ableRd) throws AbleDataException {
        return this.myValue > (char)ableRd.getNumericValue();
    }

    public boolean cmpGtEq(AbleRd ableRd) throws AbleDataException {
        return this.myValue >= (char)ableRd.getNumericValue();
    }

    public boolean cmpLt(AbleRd ableRd) throws AbleDataException {
        return this.myValue < (char)ableRd.getNumericValue();
    }

    public boolean cmpLtEq(AbleRd ableRd) throws AbleDataException {
        return this.myValue <= (char)ableRd.getNumericValue();
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        return this.myValue != (char)ableRd.getNumericValue();
    }

    public AbleLiteral compPlus(AbleRd ableRd) throws AbleDataException {
        Class clazz = ableRd.getDataTypeClass();
        if (clazz == Double.TYPE) {
            return new AbleDoubleLiteral((double)this.myValue + ableRd.getNumericValue());
        }
        if (clazz == Float.TYPE) {
            return new AbleFloatLiteral((double)this.myValue + ableRd.getNumericValue());
        }
        return new AbleCharacterLiteral(this.myValue + (char)ableRd.getNumericValue());
    }

    public AbleLiteral compMinus(AbleRd ableRd) throws AbleDataException {
        Class clazz = ableRd.getDataTypeClass();
        if (clazz == Double.TYPE) {
            return new AbleDoubleLiteral((double)this.myValue - ableRd.getNumericValue());
        }
        if (clazz == Float.TYPE) {
            return new AbleFloatLiteral((double)this.myValue - ableRd.getNumericValue());
        }
        return new AbleCharacterLiteral(this.myValue - (char)ableRd.getNumericValue());
    }

    public AbleLiteral compMultiply(AbleRd ableRd) throws AbleDataException {
        Class clazz = ableRd.getDataTypeClass();
        if (clazz == Double.TYPE) {
            return new AbleDoubleLiteral((double)this.myValue * ableRd.getNumericValue());
        }
        if (clazz == Float.TYPE) {
            return new AbleFloatLiteral((double)this.myValue * ableRd.getNumericValue());
        }
        return new AbleCharacterLiteral(this.myValue * (char)ableRd.getNumericValue());
    }

    public AbleLiteral compDivide(AbleRd ableRd) throws AbleDataException {
        Class clazz = ableRd.getDataTypeClass();
        if (clazz == Double.TYPE) {
            return new AbleDoubleLiteral((double)this.myValue / ableRd.getNumericValue());
        }
        if (clazz == Float.TYPE) {
            return new AbleFloatLiteral((double)this.myValue / ableRd.getNumericValue());
        }
        return new AbleCharacterLiteral(this.myValue / (char)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseNOT(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(~this.myValue);
    }

    public AbleLiteral bitwiseShiftLeft(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.myValue << (int)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseShiftRight(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.myValue >> (int)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseShiftRightZeroFill(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.myValue >>> (int)ableRd.getNumericValue());
    }

    public boolean equals(Object object) {
        if (object instanceof AbleCharacterLiteral) {
            return this.myValue == ((AbleCharacterLiteral)object).myValue;
        }
        return false;
    }

    public int hashCode() {
        return this.myValue;
    }

    public String toString() {
        return this.arlCRdString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlCRdString();
            }
            case 4: {
                return this.arlCRdString();
            }
            case 5: {
                return this.xmlCRdString();
            }
        }
        return this.arlCRdString();
    }

    private String trcString(int n) {
        return '\'' + new Character(this.myValue).toString() + '\'';
    }

    public int getDataType() {
        return 41;
    }
}

