/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataContext;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleNewObjectLiteral;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleStringLiteral;
import com.ibm.able.data.AbleTypedVariable;
import java.io.Serializable;
import java.util.Vector;

public class AbleCategoricalVariable
extends AbleTypedVariable
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static String clsNm = "AbleCategoricalVariable";
    protected String myValue;
    protected Vector myValueList;
    protected String myInitialValue;
    static /* synthetic */ Class class$com$ibm$able$data$AbleCategoricalVariable;
    static /* synthetic */ Class class$com$ibm$able$data$AbleStringLiteral;

    public AbleCategoricalVariable(Object[] objectArray) throws AbleDataException {
        super("initializer", false, false, "Categorical", "com.ibm.able.data.AbleCategoricalVariable");
        this.myDataType = 12;
        this.myValue = null;
        this.myValueInitial = null;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < objectArray.length; ++i) {
            vector.add(((AbleRd)objectArray[i]).getStringValue());
        }
        this.myValueList = vector;
    }

    public AbleCategoricalVariable(Vector vector) throws AbleDataException {
        super("initializer", false, false, "Categorical", "com.ibm.able.data.AbleCategoricalVariable");
        this.myDataType = 12;
        this.myValue = null;
        this.myValueInitial = null;
        this.myValueList = (Vector)vector.clone();
    }

    public AbleCategoricalVariable(Object[] objectArray, String string) throws AbleDataException {
        super("initializer", false, false, "Categorical", "com.ibm.able.data.AbleCategoricalVariable");
        this.myDataType = 12;
        this.myValue = string;
        this.myValueInitial = string == null ? null : new AbleStringLiteral(string);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < objectArray.length; ++i) {
            vector.add(((AbleRd)objectArray[i]).getStringValue());
        }
        this.myValueList = vector;
    }

    public AbleCategoricalVariable(Vector vector, String string) throws AbleDataException {
        super("initializer", false, false, "Categorical", "com.ibm.able.data.AbleCategoricalVariable");
        this.myDataType = 12;
        this.myValue = string;
        this.myInitialValue = string;
        this.myValueInitial = string == null ? null : new AbleStringLiteral(string);
        this.myValueList = (Vector)vector.clone();
    }

    public AbleCategoricalVariable(String string, Vector vector) {
        super(string, false, false, "Categorical", "com.ibm.able.data.AbleCategoricalVariable");
        this.myDataType = 12;
        this.myValue = null;
        this.myValueInitial = null;
        this.myValueList = (Vector)vector.clone();
    }

    public AbleCategoricalVariable(String string, boolean bl, boolean bl2, Vector vector) {
        super(string, bl, bl2, "Categorical", "com.ibm.able.data.AbleCategoricalVariable");
        this.myDataType = 12;
        this.myValue = null;
        this.myValueInitial = null;
        this.myValueList = (Vector)vector.clone();
    }

    public static AbleRd createInitializer(AbleDataContext ableDataContext, Vector vector, String string) throws AbleDataException {
        Object object;
        AbleNewObjectLiteral ableNewObjectLiteral = null;
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            object = vector.get(i);
            if (object instanceof String) {
                object = new AbleStringLiteral((String)object);
            }
            vector2.add(object);
        }
        AbleNewObjectLiteral ableNewObjectLiteral2 = new AbleNewObjectLiteral(ableDataContext, "String[]", "", vector2, null);
        object = new Vector();
        ((Vector)object).add((AbleNewObjectLiteral)ableNewObjectLiteral2);
        if (string != null) {
            ((Vector)object).add(new AbleStringLiteral(string));
        }
        ableNewObjectLiteral = new AbleNewObjectLiteral(ableDataContext, "Categorical", "", (Vector)object, null);
        return ableNewObjectLiteral;
    }

    public boolean getBooleanValue() throws AbleDataException {
        if (this.myValue.equalsIgnoreCase("true")) {
            return true;
        }
        if (this.myValue.equalsIgnoreCase("false")) {
            return false;
        }
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToBoolean", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToFuzzy", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        return this.myValue;
    }

    public double getNumericValue() throws AbleDataException {
        Double d = null;
        try {
            d = Double.valueOf(this.myValue);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToNumeric", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
        }
        return d;
    }

    public String getStringValue() throws AbleDataException {
        return this.myValue;
    }

    public AbleLiteral getValue() throws AbleDataException {
        return new AbleStringLiteral(this.myValue);
    }

    public void asgnEq(AbleRd ableRd) throws AbleDataException {
        if (ableRd instanceof AbleNewObjectLiteral) {
            AbleCategoricalVariable ableCategoricalVariable = (AbleCategoricalVariable)ableRd.getGenericValue();
            this.myValueList = ableCategoricalVariable.getValueList();
            this.myValue = ableCategoricalVariable.getStringValue();
            this.myValueInitial = this.myValue == null ? null : new AbleStringLiteral(this.myValue);
            this.myBoundFlag = true;
        } else {
            this.setRawValue(ableRd.getStringValue());
        }
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        if (this.myValue == null) {
            return this.myValue == ableRd.getGenericValue();
        }
        return this.myValue.equals(ableRd.getStringValue());
    }

    public boolean cmpGt(AbleRd ableRd) throws AbleDataException {
        return AbleData.Collator.compare(this.myValue, ableRd.getStringValue()) > 0;
    }

    public boolean cmpGtEq(AbleRd ableRd) throws AbleDataException {
        return AbleData.Collator.compare(this.myValue, ableRd.getStringValue()) >= 0;
    }

    public boolean cmpLt(AbleRd ableRd) throws AbleDataException {
        return AbleData.Collator.compare(this.myValue, ableRd.getStringValue()) < 0;
    }

    public boolean cmpLtEq(AbleRd ableRd) throws AbleDataException {
        return AbleData.Collator.compare(this.myValue, ableRd.getStringValue()) <= 0;
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        if (this.myValue == null) {
            return this.myValue != ableRd.getGenericValue();
        }
        return !this.myValue.equals(ableRd.getStringValue());
    }

    public AbleLiteral compPlus(AbleRd ableRd) throws AbleDataException {
        if (this.myValue == null) {
            return new AbleStringLiteral("<null>" + ableRd.getStringValue());
        }
        return new AbleStringLiteral(this.myValue + ableRd.getStringValue());
    }

    public void setBooleanValue(boolean bl) throws AbleDataException {
        if (bl) {
            try {
                this.setRawValue("True");
            }
            catch (AbleDataException ableDataException) {
                throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromBoolean", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
            }
        }
        try {
            this.setRawValue("False");
        }
        catch (AbleDataException ableDataException) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromBoolean", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
        }
    }

    public void setFuzzyValue(AbleFuzzySet ableFuzzySet) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromFuzzy", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public void setGenericValue(Object object) throws AbleDataException {
        if (object instanceof Boolean) {
            this.setBooleanValue((Boolean)object);
        } else if (object instanceof Number) {
            this.setNumericValue(((Number)object).doubleValue());
        } else if (object instanceof String) {
            this.setStringValue((String)object);
        } else if (object instanceof AbleLiteral) {
            this.setValue((AbleLiteral)object);
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromGeneric", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
        }
    }

    public void setNumericValue(double d) throws AbleDataException {
        try {
            this.setRawValue(Double.toString(d));
        }
        catch (AbleDataException ableDataException) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromNumeric", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
        }
    }

    public void setStringValue(String string) throws AbleDataException {
        this.setRawValue(string);
    }

    public void setValue(AbleLiteral ableLiteral) throws AbleDataException {
        this.setRawValue(ableLiteral.getStringValue());
    }

    public String arlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myComment.length() > 0) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        stringBuffer.append(this.isTemplate() ? "    template " : "    ");
        stringBuffer.append(this.isStatic() ? "    static " : "    ");
        stringBuffer.append("Categorical " + this.myName);
        if (this.myValueInitial == null) {
            stringBuffer.append(";" + Able.LS);
        } else {
            String string = this.myValueInitial.arlCRdString();
            if (string.length() == 0) {
                stringBuffer.append(";");
            } else {
                stringBuffer.append(" = ");
                stringBuffer.append(string + ";" + Able.LS);
            }
        }
        return stringBuffer.toString();
    }

    public String xmlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <declareVar varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"");
        stringBuffer.append(" dataType=\"Categorical\"");
        stringBuffer.append((this.isStatic() ? " static=\"true\"" : "") + (this.isTemplate() ? " template=\"true\"" : "") + ">" + Able.LS);
        stringBuffer.append(this.xmlInitializerString());
        stringBuffer.append("       </declareVar>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <Variable varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"" + " dataType=\"" + "Categorical" + "\"" + (this.isStatic() ? " static=\"true\"" : "") + (this.isTemplate() ? " template=\"true\"" : "") + ">" + Able.LS);
        stringBuffer.append(this.armlInitializerString());
        stringBuffer.append("       </Variable>" + Able.LS);
        return stringBuffer.toString();
    }

    public void setValueString(String string) throws AbleDataException {
        this.setRawValue(string);
    }

    public String getValueString() {
        return this.myValue;
    }

    public void reset() throws AbleDataException {
        if (!this.myStaticFlag) {
            this.init();
        }
    }

    public void init() throws AbleDataException {
        if (this.myInitialValue == null) {
            this.myValue = null;
            this.myBoundFlag = false;
        } else {
            this.myValue = this.myInitialValue;
            this.myBoundFlag = true;
        }
    }

    public Class getDataTypeClass() {
        return class$com$ibm$able$data$AbleCategoricalVariable == null ? (class$com$ibm$able$data$AbleCategoricalVariable = AbleCategoricalVariable.class$("com.ibm.able.data.AbleCategoricalVariable")) : class$com$ibm$able$data$AbleCategoricalVariable;
    }

    public String getDataTypeClassName() {
        return "com.ibm.able.data.AbleCategoricalVariable";
    }

    public Class getLiteralClass() {
        return class$com$ibm$able$data$AbleStringLiteral == null ? (class$com$ibm$able$data$AbleStringLiteral = AbleCategoricalVariable.class$("com.ibm.able.data.AbleStringLiteral")) : class$com$ibm$able$data$AbleStringLiteral;
    }

    public void setInitialValue(AbleRd ableRd) throws AbleDataException {
        Object object;
        if (ableRd instanceof AbleNewObjectLiteral) {
            object = ableRd.getGenericValue();
            if (!(object instanceof AbleCategoricalVariable)) {
                throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidInitialValueForCategorical", new Object[]{this.myName}));
            }
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidInitialValueForCategorical", new Object[]{this.myName}));
        }
        AbleCategoricalVariable ableCategoricalVariable = (AbleCategoricalVariable)object;
        this.myValueList = ableCategoricalVariable.getValueList();
        this.myInitialValue = this.myValue = ableCategoricalVariable.getStringValue();
        this.myValueInitial = ableRd;
    }

    void setRawValue(String string) throws AbleDataException {
        if (this.valueExist(string)) {
            String string2 = this.myValue;
            this.myValue = string;
            this.myBoundFlag = true;
            if (this.myContext != null) {
                this.myContext.updateCurrentFactBase(this.myId);
            }
            if (this.myChgSupport != null) {
                this.myChgSupport.firePropertyChange("CategoricalValue " + this.myName, string2, string);
            }
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCategoryNotInCategoryList", new Object[]{Integer.toString(this.myId), this.myName, string}));
        }
    }

    public Object getRawValue() {
        return this.myValue;
    }

    public void setValueList(Vector vector) {
        Vector vector2 = (Vector)this.myValueList.clone();
        this.myValueList = (Vector)vector.clone();
        if (this.myChgSupport != null) {
            this.myChgSupport.firePropertyChange("CategoricalStringList " + this.myName, vector2, vector);
        }
        if (!this.valueExist(this.myValue)) {
            this.myValue = null;
        }
    }

    public Vector getValueList() {
        return this.myValueList;
    }

    public int getValueListSize() {
        return this.myValueList.size();
    }

    public boolean valueExist(String string) {
        return this.myValueList.contains(string);
    }

    public void addValue(String string) throws AbleDataException {
        if (this.valueExist(string)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCategoryAlreadyInCategoryList", new Object[]{Integer.toString(this.myId), this.myName, string}));
        }
        this.myValueList.addElement(string);
    }

    public void removeValue(String string) throws AbleDataException {
        if (this.valueExist(string)) {
            this.myValueList.removeElement(string);
            if (this.myValue.equals(string)) {
                this.myValue = null;
            }
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCategoryNotInCategoryList", new Object[]{Integer.toString(this.myId), this.myName, string}));
        }
    }

    public int getIndexOf(String string) throws AbleDataException {
        if (string == null) {
            return -1;
        }
        if (this.valueExist(string)) {
            return this.myValueList.indexOf(string);
        }
        throw new AbleDataException(Able.NlsMsg("Ex_VarCategoryNotInCategoryList", new Object[]{Integer.toString(this.myId), this.myName, string}));
    }

    public String getValueAt(int n) throws AbleDataException {
        try {
            return (String)this.myValueList.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCategoryIndex", new Object[]{Integer.toString(this.myId), this.myName, Integer.toString(n)}));
        }
    }

    public String toString() {
        return this.arlDclString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlDclString();
            }
            case 4: {
                return this.arlDclString();
            }
            case 5: {
                return this.xmlDclString();
            }
        }
        return this.arlDclString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.myName + ":<\"" + this.getValueString() + "\">");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

