/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.AbleUserDefinedFunction;
import com.ibm.able.AbleUserDefinedFunctionManager;
import com.ibm.able.data.AbleByteLiteral;
import com.ibm.able.data.AbleCharacterLiteral;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleDoubleLiteral;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleFloatLiteral;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleGenericLiteral;
import com.ibm.able.data.AbleGenericVariable;
import com.ibm.able.data.AbleIntegerLiteral;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleLongLiteral;
import com.ibm.able.data.AbleNewObjectLiteral;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleShortLiteral;
import com.ibm.able.data.AbleStringLiteral;
import com.ibm.able.data.AbleTypedVariable;
import com.ibm.able.data.AbleTypedVariableField;
import com.ibm.able.data.AbleTypedVariableMethodLiteral;
import com.ibm.able.data.AbleTypedVariableStringField;
import com.ibm.able.data.AbleVariable;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class AbleCallLiteral
extends AbleLiteral
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static final String clsNm = "AbleCallLiteral";
    protected transient Object myValue;
    protected Object myUdfMgr;
    protected String myCallee;
    protected Vector myArgs;
    protected int myArity;
    static /* synthetic */ Class class$java$lang$Object;

    public AbleCallLiteral(Object object, String string, Vector vector) {
        this.myUdfMgr = object;
        this.myCallee = string;
        this.myArgs = (Vector)vector.clone();
        this.myArity = vector.size();
        this.myValue = null;
    }

    public AbleCallLiteral(AbleCallLiteral ableCallLiteral, Vector vector) {
        this(ableCallLiteral.myUdfMgr, ableCallLiteral.myCallee, vector);
    }

    public AbleCallLiteral(String string, Vector vector) {
        this.myUdfMgr = null;
        this.myCallee = string;
        this.myArgs = (Vector)vector.clone();
        this.myArity = vector.size();
        this.myValue = null;
    }

    public boolean getBooleanValue() throws AbleDataException {
        return this.getValue().getBooleanValue();
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertCallToFuzzy"));
    }

    public Object getGenericValue() throws AbleDataException {
        this.performCall();
        return this.myValue;
    }

    public double getNumericValue() throws AbleDataException {
        return this.getValue().getNumericValue();
    }

    public String getStringValue() throws AbleDataException {
        return this.getValue().getStringValue();
    }

    public AbleLiteral getValue() throws AbleDataException {
        this.performCall();
        if (this.myValue != null) {
            if (this.myValue instanceof Boolean) {
                if (((Boolean)this.myValue).booleanValue()) {
                    return AbleData.True;
                }
                return AbleData.False;
            }
            if (this.myValue instanceof Integer) {
                return new AbleIntegerLiteral((Integer)this.myValue);
            }
            if (this.myValue instanceof Long) {
                return new AbleLongLiteral((Long)this.myValue);
            }
            if (this.myValue instanceof Double) {
                return new AbleDoubleLiteral((Double)this.myValue);
            }
            if (this.myValue instanceof Float) {
                return new AbleFloatLiteral(((Float)this.myValue).floatValue());
            }
            if (this.myValue instanceof Number) {
                return new AbleDoubleLiteral(((Number)this.myValue).doubleValue());
            }
            if (this.myValue instanceof String) {
                return new AbleStringLiteral((String)this.myValue);
            }
            if (this.myValue instanceof Object) {
                return new AbleGenericLiteral(this.myValue);
            }
            throw new AbleDataException(Able.NlsMsg("Ex_UnsupportedResultType", new Object[]{this.myCallee}));
        }
        return AbleGenericLiteral.NULL_LITERAL;
    }

    public Class getDataTypeClass() {
        try {
            return this.getReturnType();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public String getDataTypeClassName() {
        try {
            return this.getReturnType().getName();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public String arlCRdString() {
        int n = this.myArgs.size();
        String string = "";
        string = string + this.myCallee + "(";
        for (int i = 0; i < n; ++i) {
            AbleRd ableRd = (AbleRd)this.myArgs.elementAt(i);
            string = string + ableRd.arlCRdString();
            if (i >= n - 1) continue;
            string = string + ",";
        }
        string = string + ")";
        return string;
    }

    public String getTemplateString(Vector vector) {
        int n = this.myArgs.size();
        String string = "";
        string = string + this.myCallee + "(";
        for (int i = 0; i < n; ++i) {
            AbleRd ableRd = (AbleRd)this.myArgs.elementAt(i);
            string = string + ableRd.getTemplateString(vector);
            if (i >= n - 1) continue;
            string = string + ",";
        }
        string = string + ")";
        return string;
    }

    public String xmlCRdString() {
        int n = this.myArgs.size();
        String string = "";
        string = string + "<functionValue functionRef=\"" + this.myCallee + "\"";
        if (this.myArgs.isEmpty()) {
            string = string + "/>";
        } else {
            string = string + ">" + Able.LS;
            string = string + "          <argList>" + Able.LS;
            for (int i = 0; i < n; ++i) {
                AbleRd ableRd = (AbleRd)this.myArgs.elementAt(i);
                string = string + "          <arg>" + Able.LS;
                string = string + "           " + ableRd.xmlCRdString() + Able.LS;
                string = string + "          </arg>" + Able.LS;
            }
            string = string + "          </argList>" + Able.LS;
            string = string + "        </functionValue>";
        }
        return string;
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        this.performCall();
        Object object = this.myValue;
        if (object != null) {
            if (object instanceof String) {
                return ((String)object).equals(ableRd.getStringValue());
            }
            if (object instanceof Boolean) {
                return ((Boolean)object).booleanValue() == ableRd.getBooleanValue();
            }
            if (object instanceof Integer) {
                return (Integer)object == (int)ableRd.getNumericValue();
            }
            if (object instanceof Double) {
                return ((Double)object).doubleValue() == ableRd.getNumericValue();
            }
            if (object instanceof Float) {
                return ((Float)object).floatValue() == (float)ableRd.getNumericValue();
            }
            if (object instanceof Long) {
                return (Long)object == (long)ableRd.getNumericValue();
            }
            if (object instanceof Short) {
                return (Short)object == (short)ableRd.getNumericValue();
            }
            if (object instanceof Byte) {
                return (Byte)object == (byte)ableRd.getNumericValue();
            }
            if (object instanceof Character) {
                return ((Character)object).charValue() == (char)ableRd.getNumericValue();
            }
        }
        return new AbleGenericLiteral(this.myValue).cmpEq(ableRd);
    }

    public boolean cmpGt(AbleRd ableRd) throws AbleDataException {
        this.performCall();
        Object object = this.myValue;
        if (object != null) {
            if (object instanceof String) {
                return AbleData.Collator.compare(this.myValue, (Object)ableRd.getStringValue()) > 0;
            }
            if (object instanceof Boolean) {
                throw new AbleDataException(Able.NlsMsg("Ex_InvalidDataTypeLhs", new Object[]{this}));
            }
            if (object instanceof Integer) {
                return (Integer)object > (int)ableRd.getNumericValue();
            }
            if (object instanceof Double) {
                return (Double)object > ableRd.getNumericValue();
            }
            if (object instanceof Float) {
                return ((Float)object).floatValue() > (float)ableRd.getNumericValue();
            }
            if (object instanceof Long) {
                return (Long)object > (long)ableRd.getNumericValue();
            }
            if (object instanceof Short) {
                return (Short)object > (short)ableRd.getNumericValue();
            }
            if (object instanceof Byte) {
                return (Byte)object > (byte)ableRd.getNumericValue();
            }
            if (object instanceof Character) {
                return ((Character)object).charValue() > (char)ableRd.getNumericValue();
            }
        }
        return new AbleGenericLiteral(this.myValue).cmpGt(ableRd);
    }

    public boolean cmpGtEq(AbleRd ableRd) throws AbleDataException {
        this.performCall();
        Object object = this.myValue;
        if (object != null) {
            if (object instanceof String) {
                return AbleData.Collator.compare(this.myValue, (Object)ableRd.getStringValue()) >= 0;
            }
            if (object instanceof Boolean) {
                throw new AbleDataException(Able.NlsMsg("Ex_InvalidDataTypeLhs", new Object[]{this}));
            }
            if (object instanceof Integer) {
                return (Integer)object >= (int)ableRd.getNumericValue();
            }
            if (object instanceof Double) {
                return (Double)object >= ableRd.getNumericValue();
            }
            if (object instanceof Float) {
                return ((Float)object).floatValue() >= (float)ableRd.getNumericValue();
            }
            if (object instanceof Long) {
                return (Long)object >= (long)ableRd.getNumericValue();
            }
            if (object instanceof Short) {
                return (Short)object >= (short)ableRd.getNumericValue();
            }
            if (object instanceof Byte) {
                return (Byte)object >= (byte)ableRd.getNumericValue();
            }
            if (object instanceof Character) {
                return ((Character)object).charValue() >= (char)ableRd.getNumericValue();
            }
        }
        return new AbleGenericLiteral(this.myValue).cmpGtEq(ableRd);
    }

    public boolean cmpLt(AbleRd ableRd) throws AbleDataException {
        this.performCall();
        Object object = this.myValue;
        if (object != null) {
            if (object instanceof String) {
                return AbleData.Collator.compare(this.myValue, (Object)ableRd.getStringValue()) < 0;
            }
            if (object instanceof Boolean) {
                throw new AbleDataException(Able.NlsMsg("Ex_InvalidDataTypeLhs", new Object[]{this}));
            }
            if (object instanceof Integer) {
                return (Integer)object < (int)ableRd.getNumericValue();
            }
            if (object instanceof Double) {
                return (Double)object < ableRd.getNumericValue();
            }
            if (object instanceof Float) {
                return ((Float)object).floatValue() < (float)ableRd.getNumericValue();
            }
            if (object instanceof Long) {
                return (Long)object < (long)ableRd.getNumericValue();
            }
            if (object instanceof Short) {
                return (Short)object < (short)ableRd.getNumericValue();
            }
            if (object instanceof Byte) {
                return (Byte)object < (byte)ableRd.getNumericValue();
            }
            if (object instanceof Character) {
                return ((Character)object).charValue() < (char)ableRd.getNumericValue();
            }
        }
        return new AbleGenericLiteral(this.myValue).cmpLt(ableRd);
    }

    public boolean cmpLtEq(AbleRd ableRd) throws AbleDataException {
        this.performCall();
        Object object = this.myValue;
        if (object != null) {
            if (object instanceof String) {
                return AbleData.Collator.compare(this.myValue, (Object)ableRd.getStringValue()) <= 0;
            }
            if (object instanceof Boolean) {
                throw new AbleDataException(Able.NlsMsg("Ex_InvalidDataTypeLhs", new Object[]{this}));
            }
            if (object instanceof Integer) {
                return (Integer)object <= (int)ableRd.getNumericValue();
            }
            if (object instanceof Double) {
                return (Double)object <= ableRd.getNumericValue();
            }
            if (object instanceof Float) {
                return ((Float)object).floatValue() <= (float)ableRd.getNumericValue();
            }
            if (object instanceof Long) {
                return (Long)object <= (long)ableRd.getNumericValue();
            }
            if (object instanceof Short) {
                return (Short)object <= (short)ableRd.getNumericValue();
            }
            if (object instanceof Byte) {
                return (Byte)object <= (byte)ableRd.getNumericValue();
            }
            if (object instanceof Character) {
                return ((Character)object).charValue() <= (char)ableRd.getNumericValue();
            }
        }
        return new AbleGenericLiteral(this.myValue).cmpLtEq(ableRd);
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        this.performCall();
        Object object = this.myValue;
        if (object != null) {
            if (object instanceof String) {
                return !((String)object).equals(ableRd.getStringValue());
            }
            if (object instanceof Boolean) {
                return ((Boolean)object).booleanValue() != ableRd.getBooleanValue();
            }
            if (object instanceof Integer) {
                return (Integer)object != (int)ableRd.getNumericValue();
            }
            if (object instanceof Double) {
                return ((Double)object).doubleValue() != ableRd.getNumericValue();
            }
            if (object instanceof Float) {
                return ((Float)object).floatValue() != (float)ableRd.getNumericValue();
            }
            if (object instanceof Long) {
                return (Long)object != (long)ableRd.getNumericValue();
            }
            if (object instanceof Short) {
                return (Short)object != (short)ableRd.getNumericValue();
            }
            if (object instanceof Byte) {
                return (Byte)object != (byte)ableRd.getNumericValue();
            }
            if (object instanceof Character) {
                return ((Character)object).charValue() != (char)ableRd.getNumericValue();
            }
        }
        return new AbleGenericLiteral(this.myValue).cmpNeq(ableRd);
    }

    public AbleLiteral compPlus(AbleRd ableRd) throws AbleDataException {
        this.performCall();
        Object object = this.myValue;
        if (object != null) {
            if (object instanceof String) {
                return new AbleStringLiteral(this.myValue + ableRd.getStringValue());
            }
            if (object instanceof Boolean) {
                throw new AbleDataException(Able.NlsMsg("Ex_InvalidDataTypeLhs", new Object[]{this}));
            }
            if (object instanceof Integer) {
                return new AbleIntegerLiteral((Integer)object + (int)ableRd.getNumericValue());
            }
            if (object instanceof Double) {
                return new AbleDoubleLiteral((Double)object + ableRd.getNumericValue());
            }
            if (object instanceof Float) {
                return new AbleFloatLiteral(((Float)object).floatValue() + (float)ableRd.getNumericValue());
            }
            if (object instanceof Long) {
                return new AbleLongLiteral((Long)object + (long)ableRd.getNumericValue());
            }
            if (object instanceof Short) {
                return new AbleShortLiteral((Short)object + (short)ableRd.getNumericValue());
            }
            if (object instanceof Byte) {
                return new AbleByteLiteral((Byte)object + (byte)ableRd.getNumericValue());
            }
            if (object instanceof Character) {
                return new AbleCharacterLiteral(((Character)object).charValue() + (char)ableRd.getNumericValue());
            }
        }
        return new AbleGenericLiteral(this.myValue).compPlus(ableRd);
    }

    public AbleLiteral compMinus(AbleRd ableRd) throws AbleDataException {
        this.performCall();
        Object object = this.myValue;
        if (object != null) {
            if (object instanceof Integer) {
                return new AbleIntegerLiteral((Integer)object - (int)ableRd.getNumericValue());
            }
            if (object instanceof Double) {
                return new AbleDoubleLiteral((Double)object - ableRd.getNumericValue());
            }
            if (object instanceof Float) {
                return new AbleFloatLiteral(((Float)object).floatValue() - (float)ableRd.getNumericValue());
            }
            if (object instanceof Long) {
                return new AbleLongLiteral((Long)object - (long)ableRd.getNumericValue());
            }
            if (object instanceof Short) {
                return new AbleShortLiteral((Short)object - (short)ableRd.getNumericValue());
            }
            if (object instanceof Byte) {
                return new AbleByteLiteral((Byte)object - (byte)ableRd.getNumericValue());
            }
            if (object instanceof Character) {
                return new AbleCharacterLiteral(((Character)object).charValue() - (char)ableRd.getNumericValue());
            }
        }
        return new AbleGenericLiteral(this.myValue).compMinus(ableRd);
    }

    public AbleLiteral compMultiply(AbleRd ableRd) throws AbleDataException {
        this.performCall();
        Object object = this.myValue;
        if (object != null) {
            if (object instanceof Integer) {
                return new AbleIntegerLiteral((Integer)object * (int)ableRd.getNumericValue());
            }
            if (object instanceof Double) {
                return new AbleDoubleLiteral((Double)object * ableRd.getNumericValue());
            }
            if (object instanceof Float) {
                return new AbleFloatLiteral(((Float)object).floatValue() * (float)ableRd.getNumericValue());
            }
            if (object instanceof Long) {
                return new AbleLongLiteral((Long)object * (long)ableRd.getNumericValue());
            }
            if (object instanceof Short) {
                return new AbleShortLiteral((Short)object * (short)ableRd.getNumericValue());
            }
            if (object instanceof Byte) {
                return new AbleByteLiteral((Byte)object * (byte)ableRd.getNumericValue());
            }
            if (object instanceof Character) {
                return new AbleCharacterLiteral(((Character)object).charValue() * (char)ableRd.getNumericValue());
            }
        }
        return new AbleGenericLiteral(this.myValue).compMultiply(ableRd);
    }

    public AbleLiteral compDivide(AbleRd ableRd) throws AbleDataException {
        this.performCall();
        Object object = this.myValue;
        if (object != null) {
            if (object instanceof Integer) {
                return new AbleIntegerLiteral((Integer)object / (int)ableRd.getNumericValue());
            }
            if (object instanceof Double) {
                return new AbleDoubleLiteral((Double)object / ableRd.getNumericValue());
            }
            if (object instanceof Float) {
                return new AbleFloatLiteral(((Float)object).floatValue() / (float)ableRd.getNumericValue());
            }
            if (object instanceof Long) {
                return new AbleLongLiteral((Long)object / (long)ableRd.getNumericValue());
            }
            if (object instanceof Short) {
                return new AbleShortLiteral((Short)object / (short)ableRd.getNumericValue());
            }
            if (object instanceof Byte) {
                return new AbleByteLiteral((Byte)object / (byte)ableRd.getNumericValue());
            }
            if (object instanceof Character) {
                return new AbleCharacterLiteral(((Character)object).charValue() / (char)ableRd.getNumericValue());
            }
        }
        return new AbleGenericLiteral(this.myValue).compDivide(ableRd);
    }

    public AbleLiteral compUnaryMinus(AbleRd ableRd) throws AbleDataException {
        AbleLiteral ableLiteral = this.getValue();
        return new AbleDoubleLiteral(0.0 - ableLiteral.getNumericValue());
    }

    public boolean logicalAND(AbleRd ableRd) throws AbleDataException {
        AbleLiteral ableLiteral = this.getValue();
        return ableLiteral.getBooleanValue() && ableRd.getBooleanValue();
    }

    public boolean logicalOR(AbleRd ableRd) throws AbleDataException {
        AbleLiteral ableLiteral = this.getValue();
        return ableLiteral.getBooleanValue() || ableRd.getBooleanValue();
    }

    public boolean logicalNOT(AbleRd ableRd) throws AbleDataException {
        AbleLiteral ableLiteral = this.getValue();
        return !ableLiteral.getBooleanValue();
    }

    public boolean isConstant() {
        return false;
    }

    public Object getRawValue() {
        return this.myValue;
    }

    public String getCallee() {
        return this.myCallee;
    }

    public String getCalleeWithArity() {
        return this.myCallee + "/" + this.myArity;
    }

    public String getCalleeWithArgs() throws AbleDataException {
        Object[] objectArray = this.cvtArgs(this.myArgs);
        String string = "(";
        for (int i = 0; i < objectArray.length; ++i) {
            string = objectArray[i] == null ? string + objectArray[i] : string + objectArray[i].getClass().getName();
            string = i + 1 < objectArray.length ? string + "," : string + ")";
        }
        return this.myCallee + string;
    }

    private String getCalleeWithArgsX() {
        String string = this.getCalleeWithArity();
        try {
            string = this.getCalleeWithArgs();
        }
        catch (AbleDataException ableDataException) {
            // empty catch block
        }
        return string;
    }

    public Vector getArgs() {
        return this.myArgs;
    }

    public int getArity() {
        return this.myArity;
    }

    protected void performCall() throws AbleDataException {
        Object[] objectArray = this.cvtArgs(this.myArgs);
        try {
            this.myValue = ((AbleUserDefinedFunctionManager)this.myUdfMgr).invokeUserDefinedFunction(this.myCallee, objectArray);
        }
        catch (RemoteException remoteException) {
            String string = Able.NlsMsg("Ex_CallLiteralUdfException", new Object[]{this.arlCRdString(), remoteException.getClass().getName(), remoteException.getLocalizedMessage()});
            throw new AbleDataException(string, remoteException);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = Able.NlsMsg("Ex_CallLiteralUdfException", new Object[]{this.getCalleeWithArgsX(), invocationTargetException.getClass().getName(), invocationTargetException.getTargetException().getLocalizedMessage()});
            throw new AbleDataException(string, invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = Able.NlsMsg("Ex_CallLiteralUdfException", new Object[]{this.getCalleeWithArgsX(), illegalAccessException.getClass().getName(), illegalAccessException.getLocalizedMessage()});
            throw new AbleDataException(string, illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = Able.NlsMsg("Ex_CallLiteralUdfException", new Object[]{this.getCalleeWithArgsX(), noSuchMethodException.getClass().getName(), noSuchMethodException.getLocalizedMessage()});
            throw new AbleDataException(string, noSuchMethodException);
        }
    }

    protected Object[] cvtArgs(Vector vector) throws AbleDataException {
        Object[] objectArray = new Object[vector.size()];
        block3: for (int i = 0; i < vector.size(); ++i) {
            AbleRd ableRd = (AbleRd)vector.get(i);
            switch (ableRd.getDataType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    objectArray[i] = ableRd.getGenericValue();
                    continue block3;
                }
                default: {
                    throw new AbleDataException(Able.NlsMsg("Ex_CallUnrecognizedDataType", new Object[]{this.myCallee, Integer.toString(ableRd.getDataType())}));
                }
            }
        }
        return objectArray;
    }

    public Class getReturnType() throws RemoteException {
        AbleUserDefinedFunction ableUserDefinedFunction = ((AbleUserDefinedFunctionManager)this.myUdfMgr).getUserDefinedFunction(this.myCallee, this.myArity);
        if (ableUserDefinedFunction != null) {
            return ableUserDefinedFunction.getReturnType();
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = AbleCallLiteral.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public BitSet getReferents() {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < this.myArgs.size(); ++i) {
            bitSet.or(((AbleRd)this.myArgs.get(i)).getReferents());
        }
        return bitSet;
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlCRdString();
            }
            case 4: {
                return this.arlCRdString();
            }
            case 5: {
                return this.xmlCRdString();
            }
        }
        return this.arlCRdString();
    }

    protected String trcString(int n) {
        int n2 = this.myArgs.size();
        String string = "";
        string = string + this.myCallee + "(";
        for (int i = 0; i < n2; ++i) {
            AbleRd ableRd = (AbleRd)this.myArgs.elementAt(i);
            string = string + ableRd.traceString(n);
            if (i >= n2 - 1) continue;
            string = string + ",";
        }
        string = string + ")";
        return string;
    }

    public int getDataType() {
        return 2;
    }

    public HashSet getVariableReferences() {
        HashSet<AbleRd> hashSet = new HashSet<AbleRd>();
        for (int i = 0; i < this.myArgs.size(); ++i) {
            AbleRd ableRd = (AbleRd)this.myArgs.get(i);
            if (ableRd instanceof AbleExpression) {
                hashSet.addAll(((AbleExpression)ableRd).getVariableReferences());
                continue;
            }
            if (ableRd instanceof AbleVariable) {
                hashSet.add(ableRd);
                continue;
            }
            if (ableRd instanceof AbleTypedVariableMethodLiteral) {
                hashSet.addAll(((AbleTypedVariableMethodLiteral)ableRd).getVariableReferences());
                continue;
            }
            if (ableRd instanceof AbleTypedVariableField) {
                hashSet.add(((AbleTypedVariableField)ableRd).getTypedVariable());
                continue;
            }
            if (ableRd instanceof AbleCallLiteral) {
                hashSet.addAll(((AbleCallLiteral)ableRd).getVariableReferences());
                continue;
            }
            if (!(ableRd instanceof AbleNewObjectLiteral)) continue;
            hashSet.addAll(((AbleNewObjectLiteral)ableRd).getVariableReferences());
        }
        return hashSet;
    }

    public AbleLiteral createMatchLiteral(Hashtable hashtable) {
        AbleCallLiteral ableCallLiteral = null;
        AbleRd ableRd = null;
        Vector vector = this.myArgs;
        Vector<AbleExpression> vector2 = new Vector<AbleExpression>();
        for (int i = 0; i < vector.size(); ++i) {
            AbleVariable ableVariable;
            AbleVariable ableVariable2;
            Object e = vector.get(i);
            if (e instanceof AbleExpression) {
                ableRd = ((AbleExpression)e).createMatchExpression(hashtable);
                continue;
            }
            if (e instanceof AbleVariable) {
                ableVariable = ableVariable2 = (AbleVariable)e;
                if (ableVariable2.isGlobal()) {
                    ableVariable = ableVariable2;
                } else if (hashtable.containsKey(ableVariable2)) {
                    ableVariable = (AbleVariable)hashtable.get(ableVariable2);
                } else {
                    Able.MessageLog.message(4L, (Object)this, "createMatchLiteral()", "Ex_RsNoSuchVariable", new Object[]{ableVariable2.getName()});
                    ableVariable = new AbleGenericVariable(ableVariable2.getName() + "'", null);
                    hashtable.put(ableVariable2, ableVariable);
                }
                ableRd = ableVariable;
                continue;
            }
            if (e instanceof AbleTypedVariableMethodLiteral) {
                ableRd = ((AbleTypedVariableMethodLiteral)e).createMatchLiteral(hashtable);
                continue;
            }
            if (e instanceof AbleTypedVariableField) {
                ableVariable = ableVariable2 = ((AbleTypedVariableField)e).getTypedVariable();
                if (hashtable.containsKey(ableVariable2)) {
                    ableVariable = (AbleTypedVariable)hashtable.get(ableVariable2);
                    try {
                        if (e instanceof AbleTypedVariableStringField) {
                            ableRd = new AbleTypedVariableStringField((AbleTypedVariable)ableVariable, (AbleTypedVariableField)e);
                            continue;
                        }
                        ableRd = new AbleTypedVariableField((AbleTypedVariable)ableVariable, (AbleTypedVariableField)e);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                Able.MessageLog.message(4L, (Object)this, "createMatchLiteral()", "Ex_RsNoSuchVariable", new Object[]{ableVariable2.getName()});
                continue;
            }
            ableRd = e instanceof AbleCallLiteral ? ((AbleCallLiteral)e).createMatchLiteral(hashtable) : e;
        }
        vector2.add((AbleExpression)ableRd);
        try {
            ableCallLiteral = new AbleCallLiteral(this, vector2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ableCallLiteral;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

