/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleDoubleLiteral;
import com.ibm.able.data.AbleFloatLiteral;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import java.io.Serializable;

public class AbleByteLiteral
extends AbleLiteral
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static final String clsNm = "AbleByteLiteral";
    protected byte myValue;

    public AbleByteLiteral(int n) {
        this.myValue = (byte)n;
    }

    public AbleByteLiteral(byte by) {
        this.myValue = by;
    }

    public boolean getBooleanValue() throws AbleDataException {
        return this.myValue != 0;
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToFuzzy", new Object[]{clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        return new Byte(this.myValue);
    }

    public double getNumericValue() throws AbleDataException {
        return this.myValue;
    }

    public String getStringValue() throws AbleDataException {
        return Byte.toString(this.myValue);
    }

    public AbleLiteral getValue() throws AbleDataException {
        return this;
    }

    public Class getDataTypeClass() {
        return Byte.TYPE;
    }

    public String getDataTypeClassName() {
        return Byte.TYPE.getName();
    }

    public String arlCRdString() {
        return Byte.toString(this.myValue);
    }

    public String xmlCRdString() {
        return "<byteLiteral value=\"" + Byte.toString(this.myValue) + "\"/>";
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        return this.myValue == (byte)ableRd.getNumericValue();
    }

    public boolean cmpGt(AbleRd ableRd) throws AbleDataException {
        return this.myValue > (byte)ableRd.getNumericValue();
    }

    public boolean cmpGtEq(AbleRd ableRd) throws AbleDataException {
        return this.myValue >= (byte)ableRd.getNumericValue();
    }

    public boolean cmpLt(AbleRd ableRd) throws AbleDataException {
        return this.myValue < (byte)ableRd.getNumericValue();
    }

    public boolean cmpLtEq(AbleRd ableRd) throws AbleDataException {
        return this.myValue <= (byte)ableRd.getNumericValue();
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        return this.myValue != (byte)ableRd.getNumericValue();
    }

    public AbleLiteral compPlus(AbleRd ableRd) throws AbleDataException {
        Class clazz = ableRd.getDataTypeClass();
        if (clazz == Double.TYPE) {
            return new AbleDoubleLiteral((double)this.myValue + ableRd.getNumericValue());
        }
        if (clazz == Float.TYPE) {
            return new AbleFloatLiteral((double)this.myValue + ableRd.getNumericValue());
        }
        return new AbleByteLiteral(this.myValue + (byte)ableRd.getNumericValue());
    }

    public AbleLiteral compMinus(AbleRd ableRd) throws AbleDataException {
        Class clazz = ableRd.getDataTypeClass();
        if (clazz == Double.TYPE) {
            return new AbleDoubleLiteral((double)this.myValue - ableRd.getNumericValue());
        }
        if (clazz == Float.TYPE) {
            return new AbleFloatLiteral((double)this.myValue - ableRd.getNumericValue());
        }
        return new AbleByteLiteral(this.myValue - (byte)ableRd.getNumericValue());
    }

    public AbleLiteral compMultiply(AbleRd ableRd) throws AbleDataException {
        Class clazz = ableRd.getDataTypeClass();
        if (clazz == Double.TYPE) {
            return new AbleDoubleLiteral((double)this.myValue * ableRd.getNumericValue());
        }
        if (clazz == Float.TYPE) {
            return new AbleFloatLiteral((double)this.myValue * ableRd.getNumericValue());
        }
        return new AbleByteLiteral(this.myValue * (byte)ableRd.getNumericValue());
    }

    public AbleLiteral compDivide(AbleRd ableRd) throws AbleDataException {
        Class clazz = ableRd.getDataTypeClass();
        if (clazz == Double.TYPE) {
            return new AbleDoubleLiteral((double)this.myValue / ableRd.getNumericValue());
        }
        if (clazz == Float.TYPE) {
            return new AbleFloatLiteral((double)this.myValue / ableRd.getNumericValue());
        }
        return new AbleByteLiteral(this.myValue / (byte)ableRd.getNumericValue());
    }

    public AbleLiteral compUnaryMinus(AbleRd ableRd) throws AbleDataException {
        return new AbleByteLiteral(0 - this.myValue);
    }

    public AbleLiteral compModulo(AbleRd ableRd) throws AbleDataException {
        return new AbleByteLiteral(this.myValue % (byte)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseAND(AbleRd ableRd) throws AbleDataException {
        return new AbleByteLiteral(this.myValue & (byte)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseOR(AbleRd ableRd) throws AbleDataException {
        return new AbleByteLiteral(this.myValue | (byte)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseXOR(AbleRd ableRd) throws AbleDataException {
        return new AbleByteLiteral(this.myValue ^ (byte)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseNOT(AbleRd ableRd) throws AbleDataException {
        return new AbleByteLiteral((int)(~this.myValue));
    }

    public AbleLiteral bitwiseShiftLeft(AbleRd ableRd) throws AbleDataException {
        return new AbleByteLiteral(this.myValue << (byte)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseShiftRight(AbleRd ableRd) throws AbleDataException {
        return new AbleByteLiteral(this.myValue >> (byte)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseShiftRightZeroFill(AbleRd ableRd) throws AbleDataException {
        return new AbleByteLiteral(this.myValue >>> (byte)ableRd.getNumericValue());
    }

    public boolean equals(Object object) {
        if (object instanceof AbleByteLiteral) {
            return this.myValue == ((AbleByteLiteral)object).myValue;
        }
        return false;
    }

    public int hashCode() {
        return this.myValue;
    }

    public String toString() {
        return this.arlCRdString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlCRdString();
            }
            case 4: {
                return this.arlCRdString();
            }
            case 5: {
                return this.xmlCRdString();
            }
        }
        return this.arlCRdString();
    }

    private String trcString(int n) {
        return Integer.toString(this.myValue);
    }

    public int getDataType() {
        return 37;
    }
}

