/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleBooleanLiteral;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleTypedVariable;
import java.io.Serializable;

public class AbleBooleanVariable
extends AbleTypedVariable
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static String clsNm = "AbleBooleanVariable";
    protected boolean myValue;
    static /* synthetic */ Class class$com$ibm$able$data$AbleBooleanLiteral;

    public AbleBooleanVariable(String string, boolean bl) {
        super(string, false, false, new Boolean(bl), "Boolean");
        this.myDataType = 11;
        this.myValue = bl;
        this.myValueInitial = bl ? AbleBooleanLiteral.TRUE : AbleBooleanLiteral.FALSE;
    }

    public AbleBooleanVariable(String string, boolean bl, boolean bl2, boolean bl3) {
        super(string, bl, bl2, new Boolean(bl3), "Boolean");
        this.myDataType = 11;
        this.myValue = bl3;
        this.myValueInitial = bl3 ? AbleBooleanLiteral.TRUE : AbleBooleanLiteral.FALSE;
    }

    public AbleBooleanVariable(String string, boolean bl, boolean bl2) {
        super(string, bl, bl2, Boolean.FALSE, "Boolean");
        this.myDataType = 11;
        this.myValue = false;
        this.myValueInitial = null;
    }

    public boolean getBooleanValue() throws AbleDataException {
        return this.myValue;
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotConvertVarTypeXToFuzzy", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        if (this.myValue) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public double getNumericValue() throws AbleDataException {
        if (this.myValue) {
            return 1.0;
        }
        return 0.0;
    }

    public String getStringValue() throws AbleDataException {
        if (this.myValue) {
            return "true";
        }
        return "false";
    }

    public AbleLiteral getValue() throws AbleDataException {
        if (this.myValue) {
            return AbleData.True;
        }
        return AbleData.False;
    }

    public void asgnEq(AbleRd ableRd) throws AbleDataException {
        this.setRawValue(ableRd.getBooleanValue());
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        return this.getBooleanValue() == ableRd.getBooleanValue();
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        return this.getBooleanValue() != ableRd.getBooleanValue();
    }

    public boolean logicalAND(AbleRd ableRd) throws AbleDataException {
        return this.getBooleanValue() && ableRd.getBooleanValue();
    }

    public boolean logicalOR(AbleRd ableRd) throws AbleDataException {
        return this.getBooleanValue() || ableRd.getBooleanValue();
    }

    public boolean logicalNOT(AbleRd ableRd) throws AbleDataException {
        return !this.getBooleanValue();
    }

    public AbleLiteral bitwiseXOR(AbleRd ableRd) throws AbleDataException {
        return this.myValue ^ ableRd.getBooleanValue() ? AbleBooleanLiteral.TRUE : AbleBooleanLiteral.FALSE;
    }

    public void setBooleanValue(boolean bl) throws AbleDataException {
        this.setRawValue(bl);
    }

    public void setFuzzyValue(AbleFuzzySet ableFuzzySet) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromFuzzy", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
    }

    public void setGenericValue(Object object) throws AbleDataException {
        if (object instanceof Boolean) {
            this.setBooleanValue((Boolean)object);
        } else if (object instanceof Number) {
            this.setNumericValue(((Number)object).doubleValue());
        } else if (object instanceof String) {
            this.setStringValue((String)object);
        } else if (object instanceof AbleLiteral) {
            this.setValue((AbleLiteral)object);
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromGeneric", new Object[]{Integer.toString(this.myId), this.myName, clsNm}));
        }
    }

    public void setNumericValue(double d) throws AbleDataException {
        if (d == 0.0) {
            this.setRawValue(false);
        } else {
            this.setRawValue(true);
        }
    }

    public void setStringValue(String string) throws AbleDataException {
        this.setValueString(string);
    }

    public void setValue(AbleLiteral ableLiteral) throws AbleDataException {
        this.setRawValue(ableLiteral.getBooleanValue());
    }

    public String arlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myComment.length() > 0) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        stringBuffer.append(this.isTemplate() ? "    template " : "    ");
        stringBuffer.append(this.isStatic() ? "    static " : "    ");
        stringBuffer.append("Boolean " + this.myName);
        if (this.myValueInitial == null) {
            stringBuffer.append(";" + Able.LS);
        } else {
            stringBuffer.append(" = " + this.myValueInitial.arlCRdString() + ";" + Able.LS);
        }
        return stringBuffer.toString();
    }

    public String xmlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <declareVar varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"" + " dataType=\"" + "Boolean" + "\"" + (this.isStatic() ? " static=\"true\"" : "") + (this.isTemplate() ? " template=\"true\"" : "") + ">" + Able.LS);
        stringBuffer.append(this.xmlInitializerString());
        stringBuffer.append("       </declareVar>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <Variable varName=\"" + this.myName + "\"" + " comment=\"" + AbleData.escapeXMLString(this.myComment) + "\"" + " dataType=\"" + "Boolean" + "\"" + (this.isStatic() ? " static=\"true\"" : "") + (this.isTemplate() ? " template=\"true\"" : "") + ">" + Able.LS);
        stringBuffer.append(this.armlInitializerString());
        stringBuffer.append("       </Variable>" + Able.LS);
        return stringBuffer.toString();
    }

    public void setValueString(String string) throws AbleDataException {
        if (string.equalsIgnoreCase("True")) {
            this.setRawValue(true);
        } else if (string.equalsIgnoreCase("False")) {
            this.setRawValue(false);
        } else {
            throw new AbleDataException(Able.NlsMsg("Ex_VarInvalidBooleanString", new Object[]{Integer.toString(this.myId), this.myName, string}));
        }
    }

    public String getValueString() {
        String string = null;
        string = this.myValue ? "true" : "false";
        return string;
    }

    public void reset() throws AbleDataException {
        if (!this.myStaticFlag) {
            this.init();
        }
    }

    public void init() throws AbleDataException {
        if (this.myValueInitial == null) {
            this.myValue = false;
            this.myBoundFlag = false;
        } else {
            this.myValue = this.myValueInitial.getBooleanValue();
            this.myBoundFlag = true;
        }
    }

    public Class getDataTypeClass() {
        return Boolean.TYPE;
    }

    public String getDataTypeClassName() {
        return Boolean.TYPE.getName();
    }

    public String getDataTypeName() {
        return "Boolean";
    }

    public Class getLiteralClass() {
        return class$com$ibm$able$data$AbleBooleanLiteral == null ? (class$com$ibm$able$data$AbleBooleanLiteral = AbleBooleanVariable.class$("com.ibm.able.data.AbleBooleanLiteral")) : class$com$ibm$able$data$AbleBooleanLiteral;
    }

    void setRawValue(boolean bl) throws AbleDataException {
        boolean bl2 = this.myValue;
        this.myValue = bl;
        this.myBoundFlag = true;
        if (this.myContext != null) {
            this.myContext.updateCurrentFactBase(this.myId);
        }
        if (this.myChgSupport != null) {
            this.myChgSupport.firePropertyChange("BooleanValue " + this.myName, new Boolean(bl2), new Boolean(bl));
        }
    }

    public String toString() {
        return this.arlDclString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlDclString();
            }
            case 4: {
                return this.arlDclString();
            }
            case 5: {
                return this.xmlDclString();
            }
        }
        return this.arlDclString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.myName + ":<" + this.getValueString() + ">");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

