/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import java.io.Serializable;

public class AbleBooleanLiteral
extends AbleLiteral
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static final String clsNm = "AbleBooleanLiteral";
    protected boolean myValue;
    public static final AbleBooleanLiteral TRUE = new AbleBooleanLiteral(true);
    public static final AbleBooleanLiteral FALSE = new AbleBooleanLiteral(false);
    private static final String TRUE_STRING = "true";
    private static final String FALSE_STRING = "false";

    public AbleBooleanLiteral(boolean bl) {
        this.myValue = bl;
    }

    public boolean getBooleanValue() throws AbleDataException {
        return this.myValue;
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToFuzzy", new Object[]{clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        if (this.myValue) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public double getNumericValue() throws AbleDataException {
        if (this.myValue) {
            return 1.0;
        }
        return 0.0;
    }

    public String getStringValue() throws AbleDataException {
        if (this.myValue) {
            return TRUE_STRING;
        }
        return FALSE_STRING;
    }

    public AbleLiteral getValue() throws AbleDataException {
        return this;
    }

    public Class getDataTypeClass() {
        return Boolean.TYPE;
    }

    public String getDataTypeClassName() {
        return Boolean.TYPE.getName();
    }

    public String arlCRdString() {
        if (this.myValue) {
            return TRUE_STRING;
        }
        return FALSE_STRING;
    }

    public String xmlCRdString() {
        if (this.myValue) {
            return "<booleanLiteral value=\"true\"/>";
        }
        return "<booleanLiteral value=\"false\"/>";
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        return this.myValue == ableRd.getBooleanValue();
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        return this.myValue != ableRd.getBooleanValue();
    }

    public boolean logicalAND(AbleRd ableRd) throws AbleDataException {
        return this.getBooleanValue() && ableRd.getBooleanValue();
    }

    public boolean logicalOR(AbleRd ableRd) throws AbleDataException {
        return this.getBooleanValue() || ableRd.getBooleanValue();
    }

    public boolean logicalNOT(AbleRd ableRd) throws AbleDataException {
        return !this.getBooleanValue();
    }

    public AbleLiteral bitwiseXOR(AbleRd ableRd) throws AbleDataException {
        return this.myValue ^ ableRd.getBooleanValue() ? TRUE : FALSE;
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public int hashCode() {
        if (this.myValue) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.arlCRdString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlCRdString();
            }
            case 4: {
                return this.arlCRdString();
            }
            case 5: {
                return this.xmlCRdString();
            }
        }
        return this.arlCRdString();
    }

    private String trcString(int n) {
        if (this.myValue) {
            return TRUE_STRING;
        }
        return FALSE_STRING;
    }

    public int getDataType() {
        return 1;
    }
}

