/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleArrayVariable;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleGenericLiteral;
import com.ibm.able.data.AbleIntegerLiteral;
import com.ibm.able.data.AbleLhs;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleVariable;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Vector;

public class AbleArrayVariableExpression
extends AbleLhs
implements Serializable {
    static final long serialVersionUID = 2001030200000000001L;
    static String clsNm = "AbleArrayVariableExpression";
    protected int myDataType = 29;
    protected AbleArrayVariable myArrayVariable = null;
    protected AbleRd myIndexExpression = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public AbleArrayVariableExpression(AbleArrayVariable ableArrayVariable, AbleRd ableRd) {
        this.myArrayVariable = ableArrayVariable;
        this.myIndexExpression = ableRd;
    }

    public boolean getBooleanValue() throws AbleDataException {
        return this.getValue().getBooleanValue();
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromFuzzy", new Object[]{Integer.toString(0), this.myArrayVariable.getName() + "[" + this.myIndexExpression.getValue() + "]", clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        return this.getValue().getGenericValue();
    }

    public double getNumericValue() throws AbleDataException {
        return this.getValue().getNumericValue();
    }

    public String getStringValue() throws AbleDataException {
        return this.getValue().getStringValue();
    }

    public AbleLiteral getValue() throws AbleDataException {
        AbleLiteral ableLiteral = this.myIndexExpression.getValue();
        if (!(ableLiteral instanceof AbleIntegerLiteral)) {
            throw new AbleDataException(Able.NlsMsg("Ex_VarIllegalArrayIndexExpression", new Object[]{ableLiteral.getClass().getName()}));
        }
        AbleLiteral ableLiteral2 = this.myArrayVariable.getValueAt((int)ableLiteral.getNumericValue());
        if (ableLiteral2 != null) {
            if (ableLiteral2 instanceof AbleLiteral) {
                return ableLiteral2;
            }
            if (ableLiteral2 instanceof Object) {
                return new AbleGenericLiteral(ableLiteral2);
            }
            throw new AbleDataException(Able.NlsMsg("Ex_UnsupportedResultType", new Object[]{ableLiteral2}));
        }
        return new AbleGenericLiteral(ableLiteral2);
    }

    public int getReferent() {
        return this.myArrayVariable.getReferent();
    }

    public BitSet getReferents() {
        BitSet bitSet = new BitSet();
        bitSet.set(this.getReferent());
        return bitSet;
    }

    public int getDataType() {
        return this.myDataType;
    }

    public String arlCRdString() {
        return this.myArrayVariable.getName() + "[" + this.myIndexExpression.arlCRdString() + "]";
    }

    public String xmlCRdString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<arrayExprValue varRef=\"" + this.myArrayVariable.getName() + "\"");
        if (this.myIndexExpression instanceof AbleVariable) {
            stringBuffer.append(" index=\"" + ((AbleVariable)this.myIndexExpression).getName() + "\"/>");
        } else {
            try {
                stringBuffer.append(" index=\"" + this.myIndexExpression.getStringValue() + "\"/>");
            }
            catch (AbleDataException ableDataException) {
                stringBuffer.append(" index=\"unknown\"/>");
            }
        }
        return stringBuffer.toString();
    }

    public boolean cmpEq(AbleRd ableRd) throws AbleDataException {
        return this.getValue().cmpEq(ableRd);
    }

    public boolean cmpGt(AbleRd ableRd) throws AbleDataException {
        return this.getValue().cmpGt(ableRd);
    }

    public boolean cmpGtEq(AbleRd ableRd) throws AbleDataException {
        return this.getValue().cmpGtEq(ableRd);
    }

    public boolean cmpLt(AbleRd ableRd) throws AbleDataException {
        return this.getValue().cmpLt(ableRd);
    }

    public boolean cmpLtEq(AbleRd ableRd) throws AbleDataException {
        return this.getValue().cmpLtEq(ableRd);
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        return this.getValue().cmpNeq(ableRd);
    }

    public AbleLiteral compPlus(AbleRd ableRd) throws AbleDataException {
        return this.getValue().compPlus(ableRd);
    }

    public AbleLiteral compMinus(AbleRd ableRd) throws AbleDataException {
        return this.getValue().compMinus(ableRd);
    }

    public AbleLiteral compMultiply(AbleRd ableRd) throws AbleDataException {
        return this.getValue().compMultiply(ableRd);
    }

    public AbleLiteral compDivide(AbleRd ableRd) throws AbleDataException {
        return this.getValue().compDivide(ableRd);
    }

    public boolean logicalAND(AbleRd ableRd) throws AbleDataException {
        return this.getBooleanValue() && ableRd.getBooleanValue();
    }

    public boolean logicalOR(AbleRd ableRd) throws AbleDataException {
        return this.getBooleanValue() || ableRd.getBooleanValue();
    }

    public boolean logicalNOT(AbleRd ableRd) throws AbleDataException {
        return !this.getBooleanValue();
    }

    public void setBooleanValue(boolean bl) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromBoolean", new Object[]{Integer.toString(0), this.myArrayVariable.getName() + "." + this.myIndexExpression.arlCRdString(), clsNm}));
    }

    public void setFuzzyValue(AbleFuzzySet ableFuzzySet) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromFuzzy", new Object[]{Integer.toString(0), this.myArrayVariable.getName() + "." + this.myIndexExpression.arlCRdString(), clsNm}));
    }

    public void setGenericValue(Object object) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromGeneric", new Object[]{Integer.toString(0), this.myArrayVariable.getName() + "." + this.myIndexExpression.arlCRdString(), clsNm}));
    }

    public void setNumericValue(double d) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromNumeric", new Object[]{Integer.toString(0), this.myArrayVariable.getName() + "." + this.myIndexExpression.arlCRdString(), clsNm}));
    }

    public void setStringValue(String string) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_VarCannotSetVarTypeXFromNumeric", new Object[]{Integer.toString(0), this.myArrayVariable.getName() + "." + this.myIndexExpression.arlCRdString(), clsNm}));
    }

    public void setValue(AbleLiteral ableLiteral) throws AbleDataException {
        AbleLiteral ableLiteral2 = this.myIndexExpression.getValue();
        this.myArrayVariable.setValueAt((int)ableLiteral2.getNumericValue(), ableLiteral);
    }

    private Object extractProperValue(Class clazz, AbleLiteral ableLiteral) throws AbleDataException {
        Object object = null;
        if (clazz.isAssignableFrom(Boolean.TYPE)) {
            object = new Boolean(ableLiteral.getBooleanValue());
        } else if (clazz.isAssignableFrom(Byte.TYPE)) {
            object = new Byte(new Double(ableLiteral.getNumericValue()).byteValue());
        } else if (clazz.isAssignableFrom(Double.TYPE)) {
            object = new Double(ableLiteral.getNumericValue());
        } else if (clazz.isAssignableFrom(Float.TYPE)) {
            object = new Float(ableLiteral.getNumericValue());
        } else if (clazz.isAssignableFrom(Integer.TYPE)) {
            object = new Integer(new Double(ableLiteral.getNumericValue()).intValue());
        } else if (clazz.isAssignableFrom(Long.TYPE)) {
            object = new Long(new Double(ableLiteral.getNumericValue()).longValue());
        } else if (clazz.isAssignableFrom(Short.TYPE)) {
            object = new Short(new Double(ableLiteral.getNumericValue()).shortValue());
        } else if (clazz.isAssignableFrom(class$java$lang$Object == null ? (class$java$lang$Object = AbleArrayVariableExpression.class$("java.lang.Object")) : class$java$lang$Object)) {
            object = ableLiteral.getGenericValue();
        } else if (clazz.isAssignableFrom(class$java$lang$String == null ? (class$java$lang$String = AbleArrayVariableExpression.class$("java.lang.String")) : class$java$lang$String)) {
            object = ableLiteral.getStringValue();
        } else if (clazz.isAssignableFrom(class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbleArrayVariableExpression.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            object = new Boolean(ableLiteral.getBooleanValue());
        } else if (clazz.isAssignableFrom(class$java$lang$Byte == null ? (class$java$lang$Byte = AbleArrayVariableExpression.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            object = new Byte(new Double(ableLiteral.getNumericValue()).byteValue());
        } else if (clazz.isAssignableFrom(class$java$lang$Double == null ? (class$java$lang$Double = AbleArrayVariableExpression.class$("java.lang.Double")) : class$java$lang$Double)) {
            object = new Double(ableLiteral.getNumericValue());
        } else if (clazz.isAssignableFrom(class$java$lang$Float == null ? (class$java$lang$Float = AbleArrayVariableExpression.class$("java.lang.Float")) : class$java$lang$Float)) {
            object = new Float(ableLiteral.getNumericValue());
        } else if (clazz.isAssignableFrom(class$java$lang$Integer == null ? (class$java$lang$Integer = AbleArrayVariableExpression.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            object = new Integer(new Double(ableLiteral.getNumericValue()).intValue());
        } else if (clazz.isAssignableFrom(class$java$lang$Long == null ? (class$java$lang$Long = AbleArrayVariableExpression.class$("java.lang.Long")) : class$java$lang$Long)) {
            object = new Long(new Double(ableLiteral.getNumericValue()).longValue());
        } else if (clazz.isAssignableFrom(class$java$lang$Short == null ? (class$java$lang$Short = AbleArrayVariableExpression.class$("java.lang.Short")) : class$java$lang$Short)) {
            object = new Short(new Double(ableLiteral.getNumericValue()).shortValue());
        } else if (clazz.isAssignableFrom(ableLiteral.getDataTypeClass())) {
            object = ableLiteral.getGenericValue();
        }
        return object;
    }

    public String arlDclString() {
        return "";
    }

    public String xmlDclString() {
        return "";
    }

    public String xmlCWrString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<arrayExprValue varRef=\"" + this.myArrayVariable.getName() + "\"");
        if (this.myIndexExpression instanceof AbleVariable) {
            stringBuffer.append(" index=\"" + ((AbleVariable)this.myIndexExpression).getName() + "\"/>");
        } else {
            try {
                stringBuffer.append(" index=\"" + this.myIndexExpression.getStringValue() + "\"/>");
            }
            catch (AbleDataException ableDataException) {
                stringBuffer.append(" index=\"unknown\"/>");
            }
        }
        return stringBuffer.toString();
    }

    public String getTemplateString(Vector vector) {
        return this.arlCRdString();
    }

    public void asgnEq(AbleRd ableRd) throws AbleDataException {
        AbleRd ableRd2 = ableRd;
        AbleLiteral ableLiteral = this.myIndexExpression.getValue();
        if (ableRd instanceof AbleArrayVariableExpression) {
            ableRd2 = ((AbleArrayVariableExpression)ableRd).getValue();
        }
        this.myArrayVariable.setValueAt((int)ableLiteral.getNumericValue(), ableRd2);
    }

    public void asgnIs(AbleRd ableRd) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_InvalidDataTypeLhs", new Object[]{this}));
    }

    public void asgnIs(AbleRd ableRd, double d) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_InvalidDataTypeLhs", new Object[]{this}));
    }

    public AbleArrayVariable getVariable() {
        return this.myArrayVariable;
    }

    public AbleRd getIndexExpression() {
        return this.myIndexExpression;
    }

    public Class getDataTypeClass() {
        return this.myArrayVariable.getElementClass();
    }

    public String getDataTypeClassName() {
        return this.myArrayVariable.getElementClass().getName();
    }

    private void validateSources() throws AbleDataException {
        if (this.myArrayVariable == null) {
            throw new AbleDataException("Ex_VarNullArrayVariableExpression");
        }
        if (this.myArrayVariable.getGenericValue() == null) {
            throw new AbleDataException("Ex_VarNullArrayVariableExpressionValue");
        }
    }

    public String toString() {
        return this.arlCRdString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlCRdString();
            }
            case 4: {
                return this.arlCRdString();
            }
            case 5: {
                return this.xmlCRdString();
            }
        }
        return this.arlCRdString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(this.myArrayVariable.getName() + "[" + this.myIndexExpression.arlCRdString() + "]");
        return stringBuffer.toString();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

