/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.data;

import com.ibm.able.Able;
import com.ibm.able.data.AbleArrayVariable;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleFuzzySet;
import com.ibm.able.data.AbleIntegerLiteral;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleRd;
import java.io.Serializable;

public class AbleArrayLengthLiteral
extends AbleLiteral
implements Serializable {
    static final long serialVersionUID = 2000080100000000001L;
    static final String clsNm = "AbleArrayLengthLiteral";
    protected AbleArrayVariable myArrayVariable = null;

    public AbleArrayLengthLiteral(AbleArrayVariable ableArrayVariable) {
        this.myArrayVariable = ableArrayVariable;
    }

    public boolean getBooleanValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToBoolean", new Object[]{clsNm}));
    }

    public AbleFuzzySet getFuzzyValue() throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg("Ex_CannotConvertLitTypeXToFuzzy", new Object[]{clsNm}));
    }

    public Object getGenericValue() throws AbleDataException {
        return new AbleIntegerLiteral(this.getRawValue());
    }

    public double getNumericValue() throws AbleDataException {
        return this.getRawValue();
    }

    public String getStringValue() throws AbleDataException {
        return String.valueOf(this.getRawValue());
    }

    public AbleLiteral getValue() throws AbleDataException {
        return new AbleIntegerLiteral(this.getRawValue());
    }

    public Class getDataTypeClass() {
        return Integer.TYPE;
    }

    public String getDataTypeClassName() {
        return Integer.TYPE.getName();
    }

    public String arlCRdString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.myArrayVariable.getName() + "." + "length ");
        return stringBuffer.toString();
    }

    public String xmlCRdString() {
        return "<fieldValue varRef=\"" + this.myArrayVariable.getName() + "\" fieldName=\"" + "length" + "\"/>";
    }

    public boolean cmpGt(AbleRd ableRd) throws AbleDataException {
        return this.getRawValue() > (int)ableRd.getNumericValue();
    }

    public boolean cmpGtEq(AbleRd ableRd) throws AbleDataException {
        return this.getRawValue() >= (int)ableRd.getNumericValue();
    }

    public boolean cmpLt(AbleRd ableRd) throws AbleDataException {
        return this.getRawValue() < (int)ableRd.getNumericValue();
    }

    public boolean cmpLtEq(AbleRd ableRd) throws AbleDataException {
        return this.getRawValue() <= (int)ableRd.getNumericValue();
    }

    public boolean cmpNeq(AbleRd ableRd) throws AbleDataException {
        return this.getRawValue() != (int)ableRd.getNumericValue();
    }

    public AbleLiteral compPlus(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.getRawValue() + (int)ableRd.getNumericValue());
    }

    public AbleLiteral compMinus(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.getRawValue() - (int)ableRd.getNumericValue());
    }

    public AbleLiteral compMultiply(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.getRawValue() * (int)ableRd.getNumericValue());
    }

    public AbleLiteral compDivide(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.getRawValue() / (int)ableRd.getNumericValue());
    }

    public AbleLiteral compUnaryMinus(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(0 - this.getRawValue());
    }

    public AbleLiteral compModulo(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.getRawValue() % (int)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseAND(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.getRawValue() & (int)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseOR(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.getRawValue() | (int)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseXOR(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.getRawValue() ^ (int)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseNOT(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(~this.getRawValue());
    }

    public AbleLiteral bitwiseShiftLeft(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.getRawValue() << (int)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseShiftRight(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.getRawValue() >> (int)ableRd.getNumericValue());
    }

    public AbleLiteral bitwiseShiftRightZeroFill(AbleRd ableRd) throws AbleDataException {
        return new AbleIntegerLiteral(this.getRawValue() >>> (int)ableRd.getNumericValue());
    }

    int getRawValue() {
        return this.myArrayVariable.getLength();
    }

    public String toString() {
        return this.traceString(1);
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlCRdString();
            }
            case 4: {
                return this.arlCRdString();
            }
            case 5: {
                return this.xmlCRdString();
            }
        }
        return this.arlCRdString();
    }

    private String trcString(int n) {
        return "";
    }

    public int getDataType() {
        return 43;
    }
}

