/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able;

import com.ibm.able.Able;
import com.ibm.able.AbleLogger;
import com.ibm.able.AbleTraceDebugFormatter;
import com.ibm.able.AbleTraceFormatter;
import com.ibm.logging.AnyMaskFilter;
import com.ibm.logging.ConsoleHandler;
import com.ibm.logging.DailyFileHandler;
import com.ibm.logging.FileHandler;
import com.ibm.logging.IFilter;
import com.ibm.logging.IFormatter;
import com.ibm.logging.IHandler;
import com.ibm.logging.Logger;
import com.ibm.logging.MessageLogger;
import com.ibm.logging.TraceLogger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public class AbleTraceLogger
implements AbleLogger {
    static final long serialVersionUID = 2000100100000000001L;
    public static final String TRACE_CONSOLE_HANDLER = "AbleTraceConsole";
    public static final String TRACE_FILE_HANDLER = "AbleTraceFile";
    public static final String TRACE_JTEXTAREA_HANDLER = "AbleTraceJTextArea";
    public static final String TRACE_BEAN_CONSOLE_HANDLER = "AbleBeanTraceConsole";
    public static final String TRACE_BEAN_FILE_HANDLER = "AbleBeanTraceFile";
    public static final String TRACE_BEAN_JTEXTAREA_HANDLER = "AbleBeanTraceJTextArea";
    public static final String MESSAGE_CONSOLE_HANDLER = "AbleMessageConsole";
    public static final String MESSAGE_FILE_HANDLER = "AbleMessageFile";
    public static final String MESSAGE_JTEXTAREA_HANDLER = "AbleMessageJTextArea";
    private static transient AbleLogger TraceLogger;
    private static transient AbleLogger MessageLogger;
    private static ArrayList globalHandlerNames;
    private static Vector myTraceLogLevelValueVector;
    private static Vector myTraceLogLevelLabelVector;
    public static final Vector TraceLogLevelValuesVector;
    public static final Vector TraceLogLevelLabelsVector;
    private static Vector myMessageLogSeverityValueVector;
    private static Vector myMessageLogSeverityLabelVector;
    public static final Vector MessageLogSeverityValuesVector;
    public static final Vector MessageLogSeverityLabelsVector;
    private static AbleTraceDebugFormatter regressionFormatter;
    private static AbleTraceFormatter simpleFormatter;
    private String name = "AbleTraceLogger";
    private String description = "Default trace logger";
    private long mask = 0L;
    protected transient Logger logger = null;
    private boolean traceLogger = true;
    private long consoleLogLevel = 0L;
    private long fileLogLevel = 0L;
    private String fileLogName = null;

    public AbleTraceLogger(String string, String string2) {
        this(string, string2, true);
    }

    private AbleTraceLogger(String string, String string2, boolean bl) {
        if (string != null) {
            this.name = string;
        }
        if (string2 != null) {
            this.description = string2;
        }
        this.traceLogger = bl;
        this.logger = !this.traceLogger ? new MessageLogger(this.name, this.description) : new TraceLogger(this.name, this.description);
        this.logger.setLogging(false);
        this.logger.removeAllFilters();
        this.logger.setSynchronous(true);
        this.logger.addRecordClass("com.ibm.able.AbleLogRecord");
    }

    public AbleTraceLogger(Logger logger) {
        this.logger = logger;
        this.logger.addRecordClass("com.ibm.able.AbleLogRecord");
        this.name = logger.getName();
        this.description = logger.getDescription();
        this.traceLogger = !(logger instanceof TraceLogger);
    }

    private AbleTraceLogger() {
    }

    public static AbleLogger getTraceLogger(String string, String string2) {
        if (TraceLogger == null) {
            AbleTraceLogger ableTraceLogger = new AbleTraceLogger(string, string2, true);
            TraceLogger = ableTraceLogger;
        }
        return TraceLogger;
    }

    public static AbleLogger getMessageLogger(String string, String string2) {
        if (MessageLogger == null) {
            AbleTraceLogger ableTraceLogger = new AbleTraceLogger(string, string2, false);
            MessageLogger = ableTraceLogger;
        }
        return MessageLogger;
    }

    public static Object addConsoleHandler(AbleLogger ableLogger, String string, long l) {
        Object object = AbleTraceLogger.getHandler(ableLogger, string);
        Object object2 = object == null ? new ConsoleHandler(string, "Console handler") : (IHandler)object;
        return AbleTraceLogger.addHandler(ableLogger, object2, l);
    }

    public static Object addFileHandler(AbleLogger ableLogger, String string, long l, String string2) {
        Object object = AbleTraceLogger.getHandler(ableLogger, string);
        Object object2 = object == null ? (ableLogger.isTraceLogger() && Able.Preferences.getTraceLogDailyFile() || !ableLogger.isTraceLogger() && Able.Preferences.getMessageLogDailyFile() ? new DailyFileHandler(string, string, string2) : new FileHandler(string, string, string2)) : (IHandler)object;
        return AbleTraceLogger.addHandler(ableLogger, object2, l);
    }

    public static Object addHandler(AbleLogger ableLogger, Object object, long l) {
        if (object instanceof IHandler) {
            IHandler iHandler = (IHandler)object;
            iHandler.removeAllFilters();
            iHandler.addFilter((IFilter)new AnyMaskFilter("", "", AbleTraceLogger.calculateMask(l)));
            ableLogger.addHandler(iHandler, l);
            ableLogger.setLogging(true);
            return iHandler;
        }
        return object;
    }

    public static void setSimpleFormatter(Object object) {
        if (!(object instanceof IHandler)) {
            return;
        }
        IHandler iHandler = (IHandler)object;
        if (simpleFormatter == null) {
            simpleFormatter = new AbleTraceFormatter();
        }
        iHandler.removeFormatter((IFormatter)simpleFormatter);
        iHandler.addFormatter((IFormatter)simpleFormatter);
    }

    private static Object setFileHandlerLevel(AbleLogger ableLogger, String string, long l) {
        Object object = null;
        if (string.equals(MESSAGE_FILE_HANDLER)) {
            object = AbleTraceLogger.addFileHandler(ableLogger, string, l, Able.Preferences.getMessageLogFileName());
        } else if (string.equals(TRACE_FILE_HANDLER)) {
            object = AbleTraceLogger.addFileHandler(ableLogger, string, l, Able.Preferences.getTraceLogFileName());
        } else {
            AbleTraceLogger.addFileHandler(ableLogger, string, l, TRACE_BEAN_FILE_HANDLER);
        }
        AbleTraceLogger.setHandlerLevel(ableLogger, string, l);
        return object;
    }

    static Object setHandlerLevel(AbleLogger ableLogger, String string, long l, String string2) {
        Object object = AbleTraceLogger.addFileHandler(ableLogger, string, l, string2);
        AbleTraceLogger.setHandlerLevel(ableLogger, string, l);
        return object;
    }

    public long getConsoleLogLevel() {
        return this.consoleLogLevel;
    }

    public void setConsoleLogLevel(long l) {
        Enumeration enumeration = this.getHandlers();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof ConsoleHandler)) continue;
            this.consoleLogLevel = l;
            break;
        }
    }

    public long getFileLogLevel() {
        return this.fileLogLevel;
    }

    public void setFileLogLevel(long l) {
        Enumeration enumeration = this.getHandlers();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof FileHandler)) continue;
            this.fileLogLevel = l;
            break;
        }
    }

    public String getFileLogFileName() {
        return this.fileLogName;
    }

    public int getConsoleLogLevelAsInt() {
        int n;
        Vector vector = MessageLogSeverityValuesVector;
        if (this.traceLogger) {
            vector = TraceLogLevelValuesVector;
        }
        return (n = vector.indexOf(new Long(this.consoleLogLevel))) == -1 ? 0 : n;
    }

    public int getFileLogLevelAsInt() {
        int n;
        Vector vector = MessageLogSeverityValuesVector;
        if (this.traceLogger) {
            vector = TraceLogLevelValuesVector;
        }
        return (n = vector.indexOf(new Long(this.fileLogLevel))) == -1 ? 0 : n;
    }

    static Object removeHandler(AbleLogger ableLogger, String string) {
        Object object = AbleTraceLogger.getHandler(ableLogger, string);
        if (object != null) {
            ableLogger.removeHandler(object);
            ableLogger.setLogging(ableLogger.getHandlers().hasMoreElements());
        }
        return object;
    }

    public static Object removeHandler(AbleLogger ableLogger, Object object) {
        if (object != null) {
            ableLogger.removeHandler(object);
            ableLogger.setLogging(ableLogger.getHandlers().hasMoreElements());
        }
        return object;
    }

    public static void stopHandler(Object object) {
        if (object != null && object instanceof IHandler) {
            IHandler iHandler = (IHandler)object;
            iHandler.stop();
            iHandler.closeDevice();
        }
    }

    public static void startHandler(Object object) {
        if (object != null && object instanceof IHandler) {
            IHandler iHandler = (IHandler)object;
            iHandler.start();
        }
    }

    public static void stopLogger(AbleLogger ableLogger) {
        AbleTraceLogger.removeAllHandlers(ableLogger);
    }

    static void removeAllHandlers(AbleLogger ableLogger) {
        Enumeration enumeration = ableLogger.getHandlers();
        if (enumeration == null) {
            return;
        }
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            vector.add(e);
            if (!(e instanceof IHandler)) continue;
            ((IHandler)e).stop();
            ((IHandler)e).closeDevice();
        }
        int n = vector.size();
        for (int i = n - 1; i >= 0; --i) {
            ableLogger.removeHandler(vector.elementAt(i));
        }
    }

    static boolean hasHandler(AbleLogger ableLogger, String string) {
        return null != AbleTraceLogger.getHandler(ableLogger, string);
    }

    public static boolean hasConsoleHandler(AbleLogger ableLogger) {
        Enumeration enumeration = ableLogger.getHandlers();
        if (enumeration == null) {
            return false;
        }
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof ConsoleHandler)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFileHandler(AbleLogger ableLogger) {
        Enumeration enumeration = ableLogger.getHandlers();
        if (enumeration == null) {
            return false;
        }
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof FileHandler)) continue;
            return true;
        }
        return false;
    }

    public static Object setHandlerLevel(Object object, long l) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof IHandler)) {
            return AbleTraceLogger.addAnyMaskFilter(object, l);
        }
        if ((object instanceof ConsoleHandler || object instanceof FileHandler) && globalHandlerNames.contains(((IHandler)object).getName())) {
            return null;
        }
        return AbleTraceLogger.addAnyMaskFilter(object, l);
    }

    public static void setHandlerLevel(AbleLogger ableLogger, String string, long l) {
        Object object = AbleTraceLogger.getHandler(ableLogger, string);
        if (object == null) {
            if (l != 0L && l != 0L) {
                object = string.toUpperCase().indexOf("FILE_HANDLER") >= 0 ? AbleTraceLogger.setFileHandlerLevel(ableLogger, string, l) : AbleTraceLogger.addConsoleHandler(ableLogger, string, l);
                AbleTraceLogger.startHandler(object);
            }
        } else if (l == 0L || l == 0L) {
            AbleTraceLogger.stopHandler(object);
            AbleTraceLogger.removeHandler(ableLogger, object);
        } else if (object instanceof ConsoleHandler && globalHandlerNames.contains(string)) {
            ableLogger.setConsoleLogLevel(l);
            AbleTraceLogger.addAnyMaskFilter(object, l);
        } else if (object instanceof FileHandler && globalHandlerNames.contains(string)) {
            ableLogger.setFileLogLevel(l);
            AbleTraceLogger.addAnyMaskFilter(object, l);
        } else {
            AbleTraceLogger.addAnyMaskFilter(object, l);
        }
    }

    private static AnyMaskFilter addAnyMaskFilter(Object object, long l) {
        AnyMaskFilter anyMaskFilter = null;
        if (object != null && object instanceof IHandler) {
            anyMaskFilter = new AnyMaskFilter("", "", AbleTraceLogger.calculateMask(l));
            IHandler iHandler = (IHandler)object;
            iHandler.removeAllFilters();
            iHandler.addFilter((IFilter)anyMaskFilter);
        }
        return anyMaskFilter;
    }

    static long calculateMask(long l) {
        long l2 = l;
        if (l == 0x100000L) {
            l2 = 7696583229824L;
        } else if (l == 524288L) {
            l2 = 3298535670144L;
        } else if (l == 262144L) {
            l2 = 0x10000040000L;
        } else if (l == 1L) {
            l2 = 0x70000000007L;
        } else if (l == 2L) {
            l2 = 0x30000000006L;
        } else if (l == 4L) {
            l2 = 0x10000000004L;
        } else if (l == 0x40000000000L) {
            l2 = 0x70000000000L;
        } else if (l == 0x20000000000L) {
            l2 = 0x30000000000L;
        } else if (l == 0x10000000000L) {
            l2 = 0x10000000000L;
        }
        return l2;
    }

    void addFilter(Object object) {
        if (this.logger != null && object instanceof IFilter) {
            this.logger.addFilter((IFilter)object);
        }
    }

    void removeFilter(Object object) {
        if (this.logger != null && object instanceof IFilter) {
            this.logger.removeFilter((IFilter)object);
        }
    }

    void removeAllFilters() {
        if (this.logger != null) {
            this.logger.removeAllFilters();
        }
    }

    public boolean isLogging() {
        return this.logger.isLogging;
    }

    public void setLogging(boolean bl) {
        this.logger.setLogging(bl);
    }

    public void message(long l, Object object, String string, String string2) {
        String string3 = Able.NlsMsg(string2);
        this.logger.text(l, object, string, string3);
    }

    public void message(long l, Object object, String string, String string2, String string3) {
        String string4 = Able.NlsMsg(string2, new Object[]{string3});
        this.logger.text(l, object, string, string4);
    }

    public void message(long l, Object object, String string, String string2, Object[] objectArray) {
        String string3 = Able.NlsMsg(string2, objectArray);
        this.logger.text(l, object, string, string3);
    }

    public void stackTrace(long l, Object object, String string) {
        this.logger.stackTrace(l, object, string);
    }

    public void text(long l, String string) {
        this.logger.text(l, (Object)"", "", string);
    }

    public void text(long l, Object object, String string, String string2) {
        this.logger.text(l, object, string, string2);
    }

    public void text(long l, Object object, String string, String string2, Object[] objectArray) {
        this.logger.text(l, object, string, string2, objectArray);
    }

    public void entry(long l, Object object, String string) {
        this.logger.entry(l, object, string);
    }

    public void entry(long l, Object object, String string, Object object2) {
        this.logger.entry(l, object, string, object2);
    }

    public void entry(long l, Object object, String string, Object[] objectArray) {
        this.logger.entry(l, object, string, objectArray);
    }

    public void exception(long l, Object object, String string, Throwable throwable) {
        this.logger.exception(l, object, string, throwable);
    }

    public void exit(long l, Object object, String string) {
        this.logger.exit(l, object, string);
    }

    public void exit(long l, Object object, String string, Object object2) {
        this.logger.exit(l, object, string, object2);
    }

    public void addHandler(Object object, long l) {
        if (this.logger != null) {
            if (object instanceof IHandler) {
                IHandler iHandler = (IHandler)object;
                String string = iHandler.getName();
                if (!AbleTraceLogger.hasHandler(this, string)) {
                    this.logger.addHandler(iHandler);
                }
                if (l != Long.MIN_VALUE) {
                    if (object instanceof ConsoleHandler && globalHandlerNames.contains(string)) {
                        this.consoleLogLevel = l;
                    } else if (object instanceof FileHandler && globalHandlerNames.contains(string)) {
                        this.fileLogLevel = l;
                        this.fileLogName = ((FileHandler)object).getFileName();
                    }
                }
            } else {
                this.logger.text(262144L, (Object)this, "addHandler", "Handler not added; not an instanceof IHandler");
            }
        }
    }

    public void removeHandler(Object object) {
        if (this.logger != null) {
            if (object instanceof IHandler) {
                IHandler iHandler = (IHandler)object;
                this.logger.removeHandler(iHandler);
                String string = iHandler.getName();
                if (iHandler instanceof ConsoleHandler && globalHandlerNames.contains(string)) {
                    this.consoleLogLevel = 0L;
                } else if (iHandler instanceof FileHandler && globalHandlerNames.contains(string)) {
                    this.fileLogLevel = 0L;
                }
            } else {
                this.logger.text(262144L, (Object)this, "removeHandler", "Handler not removed; not an instanceof IHandler");
            }
        }
    }

    public Enumeration getHandlers() {
        if (this.logger != null) {
            return this.logger.getHandlers();
        }
        return null;
    }

    public static Object getHandler(AbleLogger ableLogger, String string) {
        Enumeration enumeration = ableLogger.getHandlers();
        if (enumeration == null) {
            return null;
        }
        while (enumeration.hasMoreElements()) {
            IHandler iHandler;
            Object e = enumeration.nextElement();
            if (!(e instanceof IHandler) || !string.equals((iHandler = (IHandler)e).getName())) continue;
            return iHandler;
        }
        return null;
    }

    static void copyLoggerHandlers(AbleLogger ableLogger, AbleLogger ableLogger2) {
        Enumeration enumeration = ableLogger.getHandlers();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof ConsoleHandler) {
                ConsoleHandler consoleHandler = (ConsoleHandler)e;
                if (ableLogger2.isBeanLogger()) {
                    if (AbleTraceLogger.hasConsoleHandler(ableLogger2)) continue;
                    AbleTraceLogger.addConsoleHandler(ableLogger2, TRACE_BEAN_CONSOLE_HANDLER, Able.TraceLog.getConsoleLogLevel());
                    continue;
                }
                ableLogger2.addHandler(consoleHandler, Long.MIN_VALUE);
                continue;
            }
            ableLogger2.addHandler(e, Long.MIN_VALUE);
        }
    }

    public boolean isBeanLogger() {
        if (this.traceLogger) {
            return Able.TraceLog != this;
        }
        return Able.MessageLog != this;
    }

    public boolean isTraceLogger() {
        return this.traceLogger;
    }

    public boolean isMessageLogger() {
        return !this.traceLogger;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        TraceLogger = Able.TraceLog;
        MessageLogger = Able.MessageLog;
        this.logger = this.traceLogger ? (MessageLogger instanceof AbleTraceLogger ? ((AbleTraceLogger)AbleTraceLogger.MessageLogger).logger : new MessageLogger(this.name, this.description)) : (TraceLogger instanceof AbleTraceLogger ? ((AbleTraceLogger)AbleTraceLogger.TraceLogger).logger : new TraceLogger(this.name, this.description));
        objectInputStream.defaultReadObject();
        if (this.logger == null || this.logger.getHandlers() == null || !this.logger.getHandlers().hasMoreElements()) {
            if (this.traceLogger) {
                if (MessageLogger instanceof AbleTraceLogger) {
                    this.logger = ((AbleTraceLogger)AbleTraceLogger.MessageLogger).logger;
                }
            } else if (TraceLogger instanceof AbleTraceLogger) {
                this.logger = ((AbleTraceLogger)AbleTraceLogger.TraceLogger).logger;
            }
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static {
        globalHandlerNames = new ArrayList();
        globalHandlerNames.add(TRACE_CONSOLE_HANDLER);
        globalHandlerNames.add(TRACE_FILE_HANDLER);
        globalHandlerNames.add(TRACE_JTEXTAREA_HANDLER);
        globalHandlerNames.add(MESSAGE_CONSOLE_HANDLER);
        globalHandlerNames.add(MESSAGE_FILE_HANDLER);
        globalHandlerNames.add(MESSAGE_JTEXTAREA_HANDLER);
        globalHandlerNames.add(TRACE_BEAN_CONSOLE_HANDLER);
        globalHandlerNames.add(TRACE_BEAN_FILE_HANDLER);
        globalHandlerNames.add(TRACE_BEAN_JTEXTAREA_HANDLER);
        myTraceLogLevelValueVector = new Vector();
        myTraceLogLevelLabelVector = new Vector();
        myTraceLogLevelValueVector.add(new Long(0L));
        myTraceLogLevelLabelVector.add("None");
        myTraceLogLevelValueVector.add(new Long(262144L));
        myTraceLogLevelLabelVector.add("Low");
        myTraceLogLevelValueVector.add(new Long(524288L));
        myTraceLogLevelLabelVector.add("Medium");
        myTraceLogLevelValueVector.add(new Long(0x100000L));
        myTraceLogLevelLabelVector.add("High");
        TraceLogLevelValuesVector = myTraceLogLevelValueVector;
        TraceLogLevelLabelsVector = myTraceLogLevelLabelVector;
        myMessageLogSeverityValueVector = new Vector();
        myMessageLogSeverityLabelVector = new Vector();
        myMessageLogSeverityValueVector.add(new Long(0L));
        myMessageLogSeverityLabelVector.add("None");
        myMessageLogSeverityValueVector.add(new Long(1L));
        myMessageLogSeverityLabelVector.add("Info");
        myMessageLogSeverityValueVector.add(new Long(2L));
        myMessageLogSeverityLabelVector.add("Warning");
        myMessageLogSeverityValueVector.add(new Long(4L));
        myMessageLogSeverityLabelVector.add("Error");
        MessageLogSeverityValuesVector = myMessageLogSeverityValueVector;
        MessageLogSeverityLabelsVector = myMessageLogSeverityLabelVector;
        regressionFormatter = null;
        simpleFormatter = null;
    }
}

