/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able;

import com.ibm.able.Able;
import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleRemoteAgent;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class AbleRemoteDefaultAgent
extends AbleDefaultAgent
implements AbleRemoteAgent,
Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    public static final String defaultName = Able.NlsMsg("DFLT_NAME_DefaultAgent");
    protected String agentAddr = "";
    protected String agentHost = "";
    protected String agentName = "";
    protected Remote myRemoteStub = null;

    public AbleRemoteDefaultAgent() throws RemoteException {
        this.ctorHelper();
    }

    public AbleRemoteDefaultAgent(String string) throws RemoteException {
        super(string);
        this.ctorHelper();
    }

    public AbleRemoteDefaultAgent(String string, String string2) throws RemoteException {
        super(string, string2);
        this.ctorHelper();
    }

    private void ctorHelper() throws RemoteException {
        this.myRemoteStub = Able.GetSocketFactory() != null ? UnicastRemoteObject.exportObject(this, 0, Able.GetSocketFactory(), Able.GetSocketFactory()) : UnicastRemoteObject.exportObject((Remote)this, 0);
    }

    public void init() throws AbleException {
        this.agentHost = this.determineHostName();
        this.agentName = Able.AgentName(this.name, this.agentHost);
        this.agentAddr = Able.AgentAddr(this.agentHost);
        this.changed = true;
        super.init();
    }

    public void init(Object object) throws AbleException {
        this.agentHost = this.determineHostName();
        this.agentName = Able.AgentName(this.name, this.agentHost);
        this.agentAddr = Able.AgentAddr(this.agentHost);
        this.changed = true;
        super.init(object);
    }

    public String getAgentAddr() throws AbleException {
        return this.agentAddr;
    }

    public String getAgentHost() throws AbleException {
        return this.agentHost;
    }

    public String getAgentName() throws AbleException {
        return this.agentName;
    }

    public void rmiRebind() throws AbleException {
        String string = "rmiRebind";
        try {
            Naming.rebind(this.agentName, this);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = Able.NlsMsg("EX_NAMING_REBIND", new Object[]{this.agentName, this.agentHost});
            this.logger.text(4L, this, string, string2);
            throw new AbleException(string2, malformedURLException);
        }
        catch (RemoteException remoteException) {
            String string3 = Able.NlsMsg("EX_NAMING_REBIND", new Object[]{this.agentName, this.agentHost});
            this.logger.text(4L, this, string, string3);
            throw new AbleException(string3, remoteException);
        }
    }

    public void rmiUnbind() throws AbleException {
        String string = "rmiUnbind";
        try {
            Naming.unbind(this.agentName);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = malformedURLException.getLocalizedMessage();
            this.trace.text(4L, this, string, string2);
            throw new AbleException(string2, malformedURLException);
        }
        catch (NotBoundException notBoundException) {
            String string3 = notBoundException.getLocalizedMessage();
            this.logger.text(2L, this, string, string3);
            throw new AbleException(string3, notBoundException);
        }
        catch (RemoteException remoteException) {
            String string4 = remoteException.getLocalizedMessage();
            this.logger.text(2L, this, string, string4);
            throw new AbleException(string4, remoteException);
        }
    }

    private String determineHostName() throws AbleException {
        String string = "determineHostName";
        String string2 = "";
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            String string3 = Able.NlsMsg("EX_CANT_GET_LOCALHOSTNAME");
            this.logger.text(4L, this, string, string3);
            throw new AbleException(string3, unknownHostException);
        }
        string2 = inetAddress.getHostName();
        return string2;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

