/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able;

import com.ibm.able.Able;
import com.ibm.able.AbleTraceLogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class AblePreferences {
    static final long serialVersionUID = 1999100100000000001L;
    private String myPropertiesFile = "";
    private Properties myProperties = null;
    private String myWorkingDirectory = System.getProperty("user.home");
    private int myTraceLogConsoleLevel = 0;
    private int myTraceLogFileLevel = 0;
    private boolean myTraceLogDailyFile = false;
    private String myTraceLogFileName = this.myWorkingDirectory + File.separator + "AbleTrc.log";
    private int myMessageLogConsoleSeverity = 0;
    private int myMessageLogFileSeverity = 0;
    private String myMessageLogFileName = this.myWorkingDirectory + File.separator + "AbleMsg.log";
    private boolean myMessageLogDailyFile = false;
    private String myCommPort = "";
    private String mySocketFactoryClass = "";
    private boolean mySecurity = false;
    private String mySmtpRelay = "";

    private final String cvtWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public final void setWorkingDirectory(String string) {
        this.myWorkingDirectory = string;
    }

    public final String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    private final String cvtTraceLogConsoleLevel() {
        return Integer.toString(this.myTraceLogConsoleLevel);
    }

    public final long getTraceLogConsoleLevel() {
        return this.traceLogLevelFromInt(this.myTraceLogConsoleLevel);
    }

    public final void setTraceLogConsoleLevel(long l) {
        this.myTraceLogConsoleLevel = this.traceLogLevelToInt(l);
    }

    private final void setTraceLogConsoleLevel(String string) {
        this.myTraceLogConsoleLevel = this.traceLogLevelFromString(string);
    }

    private final String cvtTraceLogFileLevel() {
        return Integer.toString(this.myTraceLogFileLevel);
    }

    public final long getTraceLogFileLevel() {
        return this.traceLogLevelFromInt(this.myTraceLogFileLevel);
    }

    public final void setTraceLogFileLevel(long l) {
        this.myTraceLogFileLevel = this.traceLogLevelToInt(l);
    }

    private final void setTraceLogFileLevel(String string) {
        this.myTraceLogFileLevel = this.traceLogLevelFromString(string);
    }

    private String cvtTraceLogDailyFile() {
        return this.myTraceLogDailyFile ? "1" : "0";
    }

    public boolean getTraceLogDailyFile() {
        return this.myTraceLogDailyFile;
    }

    public void setTraceLogDailyFile(boolean bl) {
        this.myTraceLogDailyFile = bl;
    }

    private void setTraceLogDailyFile(String string) {
        this.myTraceLogDailyFile = string.trim().equals("1");
    }

    private final String cvtTraceLogFileName() {
        return Able.getSerializablePathX(this.myTraceLogFileName);
    }

    public final String getTraceLogFileName() {
        return Able.getLocalPathX(this.myTraceLogFileName);
    }

    public final void setTraceLogFileName(String string) {
        this.myTraceLogFileName = string;
    }

    private final String cvtMessageLogConsoleSeverity() {
        return Integer.toString(this.myMessageLogConsoleSeverity);
    }

    public final long getMessageLogConsoleSeverity() {
        return this.messageLogSeverityFromInt(this.myMessageLogConsoleSeverity);
    }

    public final void setMessageLogConsoleSeverity(long l) {
        this.myMessageLogConsoleSeverity = this.messageLogSeverityToInt(l);
    }

    private final void setMessageLogConsoleSeverity(String string) {
        this.myMessageLogConsoleSeverity = this.messageLogSeverityFromString(string);
    }

    private final String cvtMessageLogFileSeverity() {
        return Integer.toString(this.myMessageLogFileSeverity);
    }

    public final long getMessageLogFileSeverity() {
        return this.messageLogSeverityFromInt(this.myMessageLogFileSeverity);
    }

    public final void setMessageLogFileSeverity(long l) {
        this.myMessageLogFileSeverity = this.messageLogSeverityToInt(l);
    }

    private final void setMessageLogFileSeverity(String string) {
        this.myMessageLogFileSeverity = this.messageLogSeverityFromString(string);
    }

    private final String cvtMessageLogFileName() {
        return Able.getSerializablePathX(this.myMessageLogFileName);
    }

    public final String getMessageLogFileName() {
        return Able.getLocalPathX(this.myMessageLogFileName);
    }

    public final void setMessageLogFileName(String string) {
        this.myMessageLogFileName = string;
    }

    private String cvtMessageLogDailyFile() {
        return this.myMessageLogDailyFile ? "1" : "0";
    }

    public boolean getMessageLogDailyFile() {
        return this.myMessageLogDailyFile;
    }

    public void setMessageLogDailyFile(boolean bl) {
        this.myMessageLogDailyFile = bl;
    }

    private void setMessageLogDailyFile(String string) {
        this.myMessageLogDailyFile = string.trim().equals("1");
    }

    private final String cvtCommPort() {
        return this.myCommPort;
    }

    public final void setCommPort(String string) {
        this.myCommPort = string;
    }

    public final String getCommPort() {
        return this.myCommPort;
    }

    private final String cvtSocketFactoryClass() {
        return this.mySocketFactoryClass;
    }

    public final void setSocketFactoryClass(String string) {
        this.mySocketFactoryClass = string;
    }

    public final String getSocketFactoryClass() {
        return this.mySocketFactoryClass;
    }

    public final boolean getSecurity() {
        return this.mySecurity;
    }

    public final boolean isSecure() {
        return this.mySecurity;
    }

    private final String cvtSecurity() {
        return this.mySecurity ? "on" : "off";
    }

    private final void setSecurity(boolean bl) {
        this.mySecurity = bl;
    }

    private final void setSecurity(String string) {
        this.mySecurity = string.trim().equalsIgnoreCase("on");
    }

    private final String cvtSmtpRelay() {
        return this.mySmtpRelay;
    }

    public final void setSmtpRelay(String string) {
        this.mySmtpRelay = string;
    }

    public final String getSmtpRelay() {
        return this.mySmtpRelay;
    }

    public AblePreferences() {
        String string = System.getProperty("able.prefdir", "");
        String string2 = System.getProperty("user.home");
        this.myPropertiesFile = string.trim().length() == 0 ? string2 + File.separator + "able.preferences" : string + File.separator + "able.preferences";
        this.readPropertiesFile();
    }

    public void readPropertiesFile() {
        this.myProperties = new Properties();
        try {
            this.myProperties.load(new BufferedInputStream(new FileInputStream(this.myPropertiesFile)));
            this.movePropertiesToPreferenceVariables(this.myProperties);
        }
        catch (Exception exception) {
            this.movePreferenceVariablesToProperties(this.myProperties);
            this.writePropertiesFile();
        }
    }

    public void writePropertiesFile() {
        if (this.myProperties == null) {
            this.myProperties = new Properties();
        }
        try {
            this.movePreferenceVariablesToProperties(this.myProperties);
            this.myProperties.store(new FileOutputStream(this.myPropertiesFile), "IBM Agent Building and Learning Environment Preferences File");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updatePreferenceVariablesAndWritePropertiesFile(AblePreferences ablePreferences) {
        this.setWorkingDirectory(ablePreferences.getWorkingDirectory());
        this.setTraceLogConsoleLevel(ablePreferences.getTraceLogConsoleLevel());
        this.setTraceLogFileLevel(ablePreferences.getTraceLogFileLevel());
        this.setTraceLogFileName(ablePreferences.getTraceLogFileName());
        this.setTraceLogDailyFile(ablePreferences.getMessageLogDailyFile());
        this.setMessageLogConsoleSeverity(ablePreferences.getMessageLogConsoleSeverity());
        this.setMessageLogFileSeverity(ablePreferences.getMessageLogFileSeverity());
        this.setMessageLogFileName(ablePreferences.getMessageLogFileName());
        this.setMessageLogDailyFile(ablePreferences.getMessageLogDailyFile());
        this.setCommPort(ablePreferences.getCommPort());
        this.setSocketFactoryClass(ablePreferences.getSocketFactoryClass());
        this.setSmtpRelay(ablePreferences.getSmtpRelay());
        this.writePropertiesFile();
    }

    private void movePropertiesToPreferenceVariables(Properties properties) {
        block15: {
            String string = "";
            try {
                string = properties.getProperty("WorkingDirectory");
                if (string != null) {
                    this.setWorkingDirectory(string);
                }
                if ((string = properties.getProperty("TraceLogConsoleLevel")) != null) {
                    this.setTraceLogConsoleLevel(string);
                }
                if ((string = properties.getProperty("TraceLogFileLevel")) != null) {
                    this.setTraceLogFileLevel(string);
                }
                if ((string = properties.getProperty("TraceLogFileName")) != null) {
                    this.setTraceLogFileName(string);
                }
                if ((string = properties.getProperty("TraceLogDailyFile")) != null) {
                    this.setTraceLogDailyFile(string);
                }
                if ((string = properties.getProperty("MessageLogConsoleSeverity")) != null) {
                    this.setMessageLogConsoleSeverity(string);
                }
                if ((string = properties.getProperty("MessageLogFileSeverity")) != null) {
                    this.setMessageLogFileSeverity(string);
                }
                if ((string = properties.getProperty("MessageLogFileName")) != null) {
                    this.setMessageLogFileName(string);
                }
                if ((string = properties.getProperty("MessageLogDailyFile")) != null) {
                    this.setMessageLogDailyFile(string);
                }
                if ((string = properties.getProperty("CommPort")) != null) {
                    this.setCommPort(string);
                }
                if ((string = properties.getProperty("SocketFactory")) != null) {
                    this.setSocketFactoryClass(string);
                }
                if ((string = properties.getProperty("Security")) != null) {
                    this.setSecurity(string);
                }
                if ((string = properties.getProperty("SmtpRelay")) != null) {
                    this.setSmtpRelay(string);
                }
            }
            catch (Exception exception) {
                this.debugTrace("Cannot load ABLE preferences. Exception is " + exception.getLocalizedMessage());
                if (Able.TraceLog == null || !Able.TraceLog.isLogging()) break block15;
                Able.TraceLog.exception(262144L, this, "movePropertiesToPreferenceVariables()", exception);
            }
        }
    }

    private void movePreferenceVariablesToProperties(Properties properties) {
        properties.put("WorkingDirectory", this.cvtWorkingDirectory());
        properties.put("TraceLogConsoleLevel", this.cvtTraceLogConsoleLevel());
        properties.put("TraceLogFileLevel", this.cvtTraceLogFileLevel());
        properties.put("TraceLogFileName", this.cvtTraceLogFileName());
        properties.put("TraceLogDailyFile", this.cvtTraceLogDailyFile());
        properties.put("MessageLogConsoleSeverity", this.cvtMessageLogConsoleSeverity());
        properties.put("MessageLogFileSeverity", this.cvtMessageLogFileSeverity());
        properties.put("MessageLogFileName", this.cvtMessageLogFileName());
        properties.put("MessageLogDailyFile", this.cvtMessageLogDailyFile());
        properties.put("CommPort", this.cvtCommPort());
        properties.put("SocketFactory", this.cvtSocketFactoryClass());
        properties.put("Security", this.cvtSecurity());
        properties.put("SmtpRelay", this.cvtSmtpRelay());
    }

    private int messageLogSeverityToInt(long l) {
        int n = AbleTraceLogger.MessageLogSeverityValuesVector.indexOf(new Long(l));
        if (n >= 0) {
            return n;
        }
        return 0;
    }

    private long messageLogSeverityFromInt(int n) {
        long l = 4L;
        int n2 = AbleTraceLogger.MessageLogSeverityValuesVector.size();
        if (n >= 0 && n < n2) {
            Long l2 = (Long)AbleTraceLogger.MessageLogSeverityValuesVector.elementAt(n);
            l = l2;
        }
        return l;
    }

    private int messageLogSeverityFromString(String string) {
        return new Integer(string);
    }

    private int traceLogLevelToInt(long l) {
        int n = AbleTraceLogger.TraceLogLevelValuesVector.indexOf(new Long(l));
        if (n >= 0) {
            return n;
        }
        return 0;
    }

    private long traceLogLevelFromInt(int n) {
        long l = 4L;
        int n2 = AbleTraceLogger.TraceLogLevelValuesVector.size();
        if (n >= 0 && n < n2) {
            Long l2 = (Long)AbleTraceLogger.TraceLogLevelValuesVector.elementAt(n);
            l = l2;
        }
        return l;
    }

    private int traceLogLevelFromString(String string) {
        return new Integer(string);
    }

    private void debugTrace(String string) {
        try {
            System.err.println(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

