/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleBeanContainer;
import com.ibm.able.AbleBufferConnection;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleEventListener;
import com.ibm.able.AbleEventQueue;
import com.ibm.able.AbleException;
import com.ibm.able.AbleLogger;
import com.ibm.able.AblePropertyConnection;
import com.ibm.able.AblePropertyConnectionManager;
import com.ibm.able.AbleState;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class AbleObject
implements AbleBean,
Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    static NumberFormat numberFormatter = NumberFormat.getInstance();
    public static final String defaultName = Able.NlsMsg("DFLT_NAME_Object");
    protected String name = "";
    protected String comment = "";
    protected boolean changed = false;
    protected boolean dataFlowEnabled = false;
    protected String fileName = "untitled.ser";
    protected AbleLogger trace = Able.TraceLog;
    protected AbleLogger logger = Able.MessageLog;
    protected AbleBeanContainer parent = null;
    protected AbleState state = new AbleState();
    protected Object inputBuffer = null;
    protected Object outputBuffer = null;
    protected Vector sourceBufferConnections = new Vector();
    protected Vector destBufferConnections = new Vector();
    protected AblePropertyConnectionManager propertyConnectionMgr = new AblePropertyConnectionManager();
    protected Map properties = new Hashtable();
    protected AbleEventQueue eventQueue = new AbleEventQueue(this);
    protected transient Vector listeners = new Vector();
    protected transient PropertyChangeSupport chgSupport = new PropertyChangeSupport(this);
    protected transient PropertyChangeSupport stateChgSupport = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class array$Ljava$lang$Double;
    static /* synthetic */ Class array$Ljava$lang$Float;
    static /* synthetic */ Class array$Ljava$lang$Integer;
    static /* synthetic */ Class array$Ljava$lang$Long;
    static /* synthetic */ Class array$Ljava$lang$Short;
    static /* synthetic */ Class array$Ljava$lang$Number;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$Hashtable;

    public static AbleBean restoreFromSerializedFile(String string) throws ClassNotFoundException, IOException {
        AbleBean ableBean = null;
        FileInputStream fileInputStream = new FileInputStream(Able.getLocalPath(string));
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.entry(524288L, (Object)"com.ibm.able.AbleObject", "restoreFromSerializedFile", new Object[]{string});
        }
        ableBean = (AbleBean)objectInputStream.readObject();
        fileInputStream.close();
        ableBean.setFileName(string);
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(524288L, "com.ibm.able.AbleObject", "restoreFromSerializedFile", " <" + ableBean.getName() + "> successfully deserialized from <" + string + ">.");
        }
        return ableBean;
    }

    public static AbleBean restoreFromStream(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        AbleBean ableBean = null;
        ableBean = (AbleBean)objectInputStream.readObject();
        ableBean.setFileName("");
        return ableBean;
    }

    public AbleObject() {
        this(defaultName);
    }

    public AbleObject(String string) {
        this.name = string;
        this.state.setState(1026);
        this.chgSupport.addPropertyChangeListener(this.propertyConnectionMgr);
    }

    public AbleObject(String string, String string2) {
        this.name = string;
        this.comment = string2;
        this.setState(1026);
        this.chgSupport.addPropertyChangeListener(this.propertyConnectionMgr);
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.chgSupport.firePropertyChange("name", string2, string);
    }

    public String getName() {
        return this.name;
    }

    public void setComment(String string) {
        String string2 = this.comment;
        this.comment = string;
        this.chgSupport.firePropertyChange("comment", string2, string);
    }

    public String getComment() {
        return this.comment;
    }

    public void setChanged(boolean bl) {
        boolean bl2 = this.changed;
        this.changed = bl;
        this.chgSupport.firePropertyChange("changed", new Boolean(bl2), new Boolean(bl));
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void dataChanged(Object object) throws AbleException {
        if (this.listeners.size() > 0) {
            AbleEvent ableEvent = new AbleEvent(this, object);
            this.notifyAbleEventListeners(ableEvent);
        }
    }

    public void setDataFlowEnabled(boolean bl) {
        boolean bl2 = this.dataFlowEnabled;
        this.dataFlowEnabled = bl;
        this.chgSupport.firePropertyChange("dataFlowEnabled", new Boolean(bl2), new Boolean(bl));
    }

    public boolean isDataFlowEnabled() {
        return this.dataFlowEnabled;
    }

    public void setFileName(String string) {
        String string2 = this.fileName;
        this.fileName = string;
        this.chgSupport.firePropertyChange("fileName", string2, string);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setTraceLogger(AbleLogger ableLogger) {
        if (ableLogger != null) {
            AbleLogger ableLogger2 = this.trace;
            this.trace = ableLogger;
            this.chgSupport.firePropertyChange("logger", ableLogger2, ableLogger);
        }
    }

    public AbleLogger getTraceLogger() {
        return this.trace;
    }

    public void setLogger(AbleLogger ableLogger) {
        if (ableLogger != null) {
            AbleLogger ableLogger2 = this.logger;
            this.logger = ableLogger;
            this.chgSupport.firePropertyChange("logger", ableLogger2, ableLogger);
        }
    }

    public AbleLogger getLogger() {
        return this.logger;
    }

    public void setParent(AbleBeanContainer ableBeanContainer) {
        AbleBeanContainer ableBeanContainer2 = this.parent;
        this.parent = ableBeanContainer;
        this.chgSupport.firePropertyChange("parent", ableBeanContainer2, ableBeanContainer);
    }

    public AbleBeanContainer getParent() {
        return this.parent;
    }

    public void setState(int n) {
        int n2 = this.state.getState();
        this.state.setState(n);
        this.stateChgSupport.firePropertyChange("state", new Integer(n2), new Integer(n));
    }

    public int getState() {
        return this.state.getState();
    }

    public synchronized void setInputBuffer(Object object) throws AbleException {
        this.inputBuffer = object;
    }

    public Object getInputBuffer() {
        return this.inputBuffer;
    }

    public void setInputBuffer(int n, Object object) throws AbleException {
        this.setBuffer(this.inputBuffer, n, object);
    }

    public Object getInputBuffer(int n) throws AbleException {
        return this.getBuffer(this.inputBuffer, n);
    }

    public boolean hasInputBuffer() {
        return this.inputBuffer != null;
    }

    public String[] getInputBufferAsStringArray() throws AbleException {
        return this.getBufferAsStringArray(this.inputBuffer);
    }

    public Enumeration getInputBufferContents() throws AbleException {
        return this.getBufferContents(this.inputBuffer);
    }

    public void setOutputBuffer(Object object) throws AbleException {
        Object object2 = this.outputBuffer;
        this.outputBuffer = object;
        this.chgSupport.firePropertyChange("outputBuffer", object2, object);
    }

    public Object getOutputBuffer() {
        return this.outputBuffer;
    }

    public void setOutputBuffer(int n, Object object) throws AbleException {
        this.setBuffer(this.outputBuffer, n, object);
    }

    public Object getOutputBuffer(int n) throws AbleException {
        return this.getBuffer(this.outputBuffer, n);
    }

    public boolean hasOutputBuffer() {
        return this.outputBuffer != null;
    }

    public String[] getOutputBufferAsStringArray() throws AbleException {
        return this.getBufferAsStringArray(this.outputBuffer);
    }

    public Enumeration getOutputBufferContents() throws AbleException {
        return this.getBufferContents(this.outputBuffer);
    }

    public String getOutputBufferAsString() throws AbleException {
        return this.toStringFromBuffer(this.getBufferAsStringArray(this.outputBuffer));
    }

    public String getInputBufferAsString() throws AbleException {
        return this.toStringFromBuffer(this.getBufferAsStringArray(this.inputBuffer));
    }

    private String toStringFromBuffer(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (objectArray == null) {
            stringBuffer.append(objectArray);
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(objectArray[i] + " ");
            }
        }
        return stringBuffer.toString();
    }

    public void addSourceBufferConnection(AbleBufferConnection ableBufferConnection) {
        this.sourceBufferConnections.addElement(ableBufferConnection);
        this.chgSupport.firePropertyChange("sourceBufferConnections", null, ableBufferConnection);
        this.changed = true;
    }

    public void removeSourceBufferConnection(AbleBufferConnection ableBufferConnection) {
        this.sourceBufferConnections.removeElement(ableBufferConnection);
        this.chgSupport.firePropertyChange("sourceBufferConnections", ableBufferConnection, null);
        this.changed = true;
    }

    public Vector getSourceBufferConnections() {
        return (Vector)this.sourceBufferConnections.clone();
    }

    public void addDestBufferConnection(AbleBufferConnection ableBufferConnection) {
        this.destBufferConnections.addElement(ableBufferConnection);
        this.chgSupport.firePropertyChange("destBufferConnections", null, ableBufferConnection);
        this.changed = true;
    }

    public void removeDestBufferConnection(AbleBufferConnection ableBufferConnection) {
        this.destBufferConnections.removeElement(ableBufferConnection);
        this.chgSupport.firePropertyChange("destBufferConnections", ableBufferConnection, null);
        this.changed = true;
    }

    public Vector getDestBufferConnections() {
        return (Vector)this.destBufferConnections.clone();
    }

    public boolean isConnectable() {
        return true;
    }

    public void processBufferConnections() throws AbleException {
        AbleBufferConnection ableBufferConnection = null;
        Vector vector = (Vector)this.sourceBufferConnections.clone();
        Vector<AbleException> vector2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            ableBufferConnection = (AbleBufferConnection)vector.elementAt(i);
            try {
                ableBufferConnection.process();
                continue;
            }
            catch (AbleException ableException) {
                if (vector2 == null) {
                    vector2 = new Vector<AbleException>();
                }
                vector2.add(ableException);
            }
        }
        if (vector2 != null) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, this, "processBufferConnections", "Unable to process " + vector2.size() + " of " + vector.size() + " connections.");
            }
            throw new AbleException(Able.NlsMsg("Ex_CantProcessConnections", new Object[]{Integer.toString(vector2.size()), Integer.toString(vector.size())}), vector2);
        }
    }

    public void removeAllConnections() throws AbleException {
        this.removeAllAbleEventListeners();
        this.removeAllBufferConnections();
        this.removeAllPropertyConnections();
    }

    public synchronized void removeAllBufferConnections() {
        AbleBufferConnection ableBufferConnection = null;
        Vector vector = (Vector)this.sourceBufferConnections.clone();
        for (int i = 0; i < this.sourceBufferConnections.size(); ++i) {
            ableBufferConnection = (AbleBufferConnection)this.sourceBufferConnections.elementAt(i);
            ableBufferConnection.remove();
        }
        this.sourceBufferConnections.removeAllElements();
        this.chgSupport.firePropertyChange("sourceBufferConnections", vector, this.sourceBufferConnections);
        Vector vector2 = (Vector)this.destBufferConnections.clone();
        for (int i = 0; i < this.destBufferConnections.size(); ++i) {
            ableBufferConnection = (AbleBufferConnection)this.destBufferConnections.elementAt(i);
            ableBufferConnection.remove();
        }
        this.destBufferConnections.removeAllElements();
        this.chgSupport.firePropertyChange("destBufferConnections", vector2, this.destBufferConnections);
    }

    public void addPropertyConnection(AblePropertyConnection ablePropertyConnection) {
        this.propertyConnectionMgr.addConnection(ablePropertyConnection);
        this.chgSupport.firePropertyChange("propertyConnectionMgr", null, ablePropertyConnection);
    }

    public void removePropertyConnection(AblePropertyConnection ablePropertyConnection) throws AbleException {
        this.propertyConnectionMgr.removeConnection(ablePropertyConnection);
        this.chgSupport.firePropertyChange("propertyConnectionMgr", ablePropertyConnection, null);
    }

    public synchronized void removeAllPropertyConnections() throws AbleException {
        Hashtable hashtable = (Hashtable)this.propertyConnectionMgr.getConnectionsByPropertyName().clone();
        Enumeration enumeration = this.propertyConnectionMgr.getConnectionsByPropertyName().elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            for (int i = 0; i < vector.size(); ++i) {
                AblePropertyConnection ablePropertyConnection = (AblePropertyConnection)vector.elementAt(i);
                this.propertyConnectionMgr.removeConnection(ablePropertyConnection);
            }
        }
        this.chgSupport.firePropertyChange("propertyConnectionMgr", hashtable, this.propertyConnectionMgr.getConnectionsByPropertyName());
    }

    public AblePropertyConnectionManager getPropertyConnectionManager() {
        return this.propertyConnectionMgr;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.chgSupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.chgSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        return this.chgSupport.getPropertyChangeListeners();
    }

    public synchronized void firePropertyChange(String string, Object object, Object object2) {
        this.chgSupport.firePropertyChange(string, object, object2);
    }

    public void init() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, this, "init " + this.name);
        }
        if (this.isAbleEventProcessingEnabled() || this.isTimerEventProcessingEnabled()) {
            this.startEnabledEventProcessing();
        } else {
            int n = this.state.getState();
            this.state.setState(1022);
            this.chgSupport.firePropertyChange("processingState", new Integer(n), new Integer(1022));
        }
    }

    public void init(Object object) throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, (Object)this, "init(arg) " + this.name, new Object[]{object});
        }
        if (this.isAbleEventProcessingEnabled() || this.isTimerEventProcessingEnabled()) {
            this.startEnabledEventProcessing();
        } else {
            int n = this.state.getState();
            this.state.setState(1022);
            this.chgSupport.firePropertyChange("processingState", new Integer(n), new Integer(1022));
        }
    }

    public void reset() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, this, "reset " + this.name);
        }
    }

    public void process() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, this, "process " + this.name);
        }
    }

    public Object process(Object object) throws AbleException {
        int n;
        Object object2;
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, (Object)this, "process(arg) " + this.name, new Object[]{object});
        }
        if (this.inputBuffer == null) {
            String string = Able.NlsMsg("EX_VARIABLE_IS_NULL", new Object[]{"inputBuffer", this.name});
            AbleException ableException = new AbleException(string);
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, this, "process(Object)", ableException);
            }
            this.logger.text(4L, this, "process(Object)", string);
            throw ableException;
        }
        if (object.getClass() != this.inputBuffer.getClass()) {
            String string = Able.NlsMsg("EX_INPUTBUFFER_MISMATCH", new Object[]{this.inputBuffer.getClass().getName(), object.getClass().getName(), this.name});
            AbleException ableException = new AbleException(string);
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, this, "process(Object)", ableException);
            }
            this.logger.text(4L, this, "process(Object)", string);
            throw ableException;
        }
        if (this.inputBuffer instanceof double[]) {
            object2 = (double[])object;
            if (((double[])this.inputBuffer).length != ((double[])object2).length) {
                String string = Able.NlsMsg("Ex_RsProcessArgWrongLength", new Object[]{new Integer(((double[])object2).length), new Integer(((Object[])this.inputBuffer).length)});
                AbleException ableException = new AbleException(string);
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "process(Object)", ableException);
                }
                this.logger.text(4L, this, "process(Object)", string);
                throw ableException;
            }
            for (n = 0; n < ((double[])object2).length; ++n) {
                ((double[])this.inputBuffer)[n] = (double)object2[n];
            }
        } else if (this.inputBuffer instanceof String[]) {
            object2 = (String[])object;
            if (((String[])this.inputBuffer).length != ((double[])object2).length) {
                String string = Able.NlsMsg("Ex_RsProcessArgWrongLength", new Object[]{new Integer(((Object)object2).length), new Integer(((Object[])this.inputBuffer).length)});
                AbleException ableException = new AbleException(string);
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "process(Object)", ableException);
                }
                this.logger.text(4L, this, "process(Object)", string);
                throw ableException;
            }
            for (n = 0; n < ((double[])object2).length; ++n) {
                ((String[])this.inputBuffer)[n] = object2[n];
            }
        } else if (this.inputBuffer instanceof Object[]) {
            object2 = (Object[])object;
            if (((Object[])this.inputBuffer).length != ((double[])object2).length) {
                String string = Able.NlsMsg("Ex_RsProcessArgWrongLength", new Object[]{new Integer(((Object)object2).length), new Integer(((Object[])this.inputBuffer).length)});
                AbleException ableException = new AbleException(string);
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "process(Object)", ableException);
                }
                this.logger.text(4L, this, "process(Object)", string);
                throw ableException;
            }
            for (n = 0; n < ((Object)object2).length; ++n) {
                ((Object[])this.inputBuffer)[n] = object2[n];
            }
        } else if (this.inputBuffer instanceof Vector) {
            object2 = (Vector)object;
            if (((Vector)this.inputBuffer).size() != object2.size()) {
                String string = Able.NlsMsg("Ex_RsProcessArgWrongLength", new Object[]{new Integer(object2.size()), new Integer(((Object[])this.inputBuffer).length)});
                AbleException ableException = new AbleException(string);
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "process(Object)", ableException);
                }
                this.logger.text(4L, this, "process(Object)", string);
                throw ableException;
            }
            for (n = 0; n < object2.size(); ++n) {
                ((Vector)this.inputBuffer).set(n, object2.get(n));
            }
        } else {
            String string = Able.NlsMsg("EX_BUFFER_TYPE_NOT_SUPPORTED", new Object[]{this.name, "inputBuffer", this.inputBuffer.getClass().getName()});
            AbleException ableException = new AbleException(string);
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, this, "process(Object)", ableException);
            }
            this.logger.text(4L, this, "process(Object)", string);
            throw ableException;
        }
        if (this.sourceBufferConnections.size() > 0) {
            object2 = Able.NlsMsg("EX_DATACONNECTIONS_DEFINED", new Object[]{this.name, new Integer(this.sourceBufferConnections.size())});
            AbleException ableException = new AbleException((String)object2);
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, this, "process(Object)", ableException);
            }
            this.logger.text(4L, this, "process(Object)", (String)object2);
            throw ableException;
        }
        this.process();
        if (this.outputBuffer == null) {
            object2 = Able.NlsMsg("EX_VARIABLE_IS_NULL", new Object[]{"outputBuffer", this.name});
            AbleException ableException = new AbleException((String)object2);
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, this, "process(Object)", ableException);
            }
            this.logger.text(4L, this, "process(Object)", (String)object2);
            throw ableException;
        }
        object2 = null;
        if (this.outputBuffer instanceof String[]) {
            object2 = ((String[])this.outputBuffer).clone();
        } else if (this.outputBuffer instanceof double[]) {
            object2 = ((double[])this.outputBuffer).clone();
        } else if (this.outputBuffer instanceof Object[]) {
            object2 = ((Object[])this.outputBuffer).clone();
        } else if (this.outputBuffer instanceof Vector) {
            object2 = ((Vector)this.outputBuffer).clone();
        } else {
            String string = Able.NlsMsg("EX_BUFFER_TYPE_NOT_SUPPORTED", new Object[]{this.name, "outputBuffer", this.outputBuffer.getClass().getName()});
            AbleException ableException = new AbleException(string);
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, this, "process(Object)", ableException);
            }
            this.logger.text(4L, this, "process(Object)", string);
            throw ableException;
        }
        return object2;
    }

    public void quitAll() throws AbleException {
        this.quitEnabledEventProcessing();
    }

    public void suspendAll() throws AbleException {
        this.suspendEnabledEventProcessing();
    }

    public void resumeAll() throws AbleException {
        this.resumeEnabledEventProcessing();
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public String getProperty(String string) {
        return (String)this.properties.get(string);
    }

    public String removeProperty(String string) {
        return (String)this.properties.remove(string);
    }

    public void setProperties(Map map) {
        if (map != null) {
            this.properties = map;
        }
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setSleepTime(long l) {
        long l2 = this.eventQueue.getSleepTime();
        this.eventQueue.setSleepTime(l);
        this.chgSupport.firePropertyChange("sleepTime", new Long(l2), new Long(l));
    }

    public long getSleepTime() {
        return this.eventQueue.getSleepTime();
    }

    public void setTimerEventProcessingEnabled(boolean bl) {
        boolean bl2 = this.eventQueue.isTimerEventProcessingEnabled();
        this.eventQueue.setTimerEventProcessingEnabled(bl);
        this.chgSupport.firePropertyChange("timerEventProcessingEnabled", new Boolean(bl2), new Boolean(bl));
    }

    public boolean isTimerEventProcessingEnabled() {
        return this.eventQueue.isTimerEventProcessingEnabled();
    }

    public void setAbleEventProcessingEnabled(int n) throws IllegalArgumentException {
        int n2 = this.eventQueue.getAbleEventProcessingEnabled();
        this.eventQueue.setAbleEventProcessingEnabled(n);
        this.chgSupport.firePropertyChange("ableEventProcessingEnabled", new Integer(n2), new Integer(n));
    }

    public int getAbleEventProcessingEnabled() {
        return this.eventQueue.getAbleEventProcessingEnabled();
    }

    public boolean isAbleEventPostingEnabled() {
        return this.eventQueue.isAbleEventPostingEnabled();
    }

    public boolean isAbleEventProcessingEnabled() {
        return this.eventQueue.isAbleEventProcessingEnabled();
    }

    public void flushAbleEventQueue() {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, this, "flushAbleEventQueue " + this.name);
        }
        this.eventQueue.flushEvents();
    }

    public int getAbleEventQueueSize() {
        return this.eventQueue.size();
    }

    public void startEnabledEventProcessing() {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, this, "startEnabledEventProcessing " + this.name);
        }
        int n = this.state.getState();
        this.eventQueue.startProcessingEvents();
        this.chgSupport.firePropertyChange("processingState", new Integer(n), new Integer(1021));
    }

    public void quitEnabledEventProcessing() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, this, "quitEnabledEventProcessing " + this.name);
        }
        int n = this.state.getState();
        Able.stopBeanTraceLogging(this);
        this.eventQueue.stopProcessingEvents();
        this.chgSupport.firePropertyChange("processingState", new Integer(n), new Integer(1020));
    }

    public void suspendEnabledEventProcessing() {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, this, "suspendEnabledEventProcessing " + this.name);
        }
        int n = this.state.getState();
        this.eventQueue.suspendProcessingEvents();
        this.chgSupport.firePropertyChange("processingState", new Integer(n), new Integer(1023));
    }

    public void resumeEnabledEventProcessing() {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, this, "resumeEnabledEventProcessing " + this.name);
        }
        int n = this.state.getState();
        this.eventQueue.resumeProcessingEvents();
        this.chgSupport.firePropertyChange("processingState", new Integer(n), new Integer(1021));
    }

    public void restartEnabledEventProcessing() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, this, "restartEnabledEventProcessing " + this.name);
        }
        int n = this.state.getState();
        this.eventQueue.startProcessingEvents();
        this.chgSupport.firePropertyChange("processingState", new Integer(n), new Integer(1021));
    }

    public synchronized void addAbleEventListener(AbleEventListener ableEventListener) {
        this.listeners.addElement(ableEventListener);
        this.chgSupport.firePropertyChange("listeners", null, ableEventListener);
    }

    public synchronized void removeAbleEventListener(AbleEventListener ableEventListener) {
        this.listeners.removeElement(ableEventListener);
        this.chgSupport.firePropertyChange("listeners", ableEventListener, null);
    }

    public synchronized void removeAllAbleEventListeners() {
        Vector vector = (Vector)this.listeners.clone();
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.removeElementAt(i);
        }
        this.chgSupport.firePropertyChange("listeners", vector, this.listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAbleEventListeners(AbleEvent ableEvent) throws AbleException {
        Vector vector;
        StringBuffer stringBuffer = null;
        Vector<Exception> vector2 = null;
        AbleObject ableObject = this;
        synchronized (ableObject) {
            vector = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            AbleEventListener ableEventListener = (AbleEventListener)vector.elementAt(i);
            try {
                ableEventListener.handleAbleEvent(ableEvent);
                continue;
            }
            catch (Exception exception) {
                String string = ableEventListener.getClass().getName();
                if (ableEventListener instanceof AbleBean) {
                    string = ((AbleBean)ableEventListener).getName();
                }
                String string2 = Able.NlsMsg("EX_CANT_NOTIFY_LISTENER", new Object[]{string}) + Able.LS + Able.NlsMsg("EX_MESSAGE_CONTENT", new Object[]{exception.getLocalizedMessage()});
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string2);
                } else {
                    stringBuffer.append(Able.LS + string2);
                }
                if (vector2 == null) {
                    vector2 = new Vector<Exception>();
                }
                if (exception instanceof AbleException) {
                    vector2.add(exception);
                } else {
                    vector2.add(new AbleException(string2, this, (Throwable)exception));
                }
                this.logger.text(4L, this, "notifyAbleEventListeners", string2);
                if (!this.trace.isLogging()) continue;
                this.trace.exception(262144L, this, "notifyAbleEventListeners", exception);
            }
        }
        if (stringBuffer != null) {
            throw new AbleException(stringBuffer.toString(), vector2);
        }
    }

    public Vector getAbleEventListeners() {
        return (Vector)this.listeners.clone();
    }

    public synchronized void addStateChangeListener(PropertyChangeListener propertyChangeListener) {
        this.stateChgSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removeStateChangeListener(PropertyChangeListener propertyChangeListener) {
        this.stateChgSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void saveToFile() throws IOException {
        this.saveToFile(this.fileName);
    }

    public void saveToFile(String string) throws IOException {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, (Object)this, "saveToFile " + this.name, new Object[]{string});
        }
        if (!this.fileName.equals(string)) {
            this.setFileName(string);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        this.setChanged(false);
        objectOutputStream.writeObject(this);
        fileOutputStream.flush();
        fileOutputStream.close();
        if (this.trace.isLogging()) {
            this.trace.text(524288L, this, "saveToFile", "<" + this.name + "> successfully serialized to <" + string + ">.");
        }
    }

    public AbleBean restoreFromFile() throws ClassNotFoundException, IOException {
        return this.restoreFromFile(this.fileName);
    }

    public AbleBean restoreFromFile(String string) throws ClassNotFoundException, IOException {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, (Object)this, "restoreFromFile", new Object[]{string});
        }
        AbleBean ableBean = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        ableBean = (AbleBean)objectInputStream.readObject();
        fileInputStream.close();
        ableBean.setFileName(string);
        if (this.trace.isLogging()) {
            this.trace.text(524288L, this, "restoreFromFile", " <" + ableBean.getName() + "> successfully deserialized from <" + string + ">.");
        }
        return ableBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAbleEvent(AbleEvent ableEvent) throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, (Object)this, "handleAbleEvent " + this.name, new Object[]{ableEvent});
        }
        if (ableEvent.isAsynchronous()) {
            AbleEventQueue ableEventQueue = this.eventQueue;
            synchronized (ableEventQueue) {
                this.eventQueue.postEvent(ableEvent);
            }
        } else {
            this.processAbleEvent(ableEvent);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processAbleEvent(AbleEvent ableEvent) throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, (Object)this, "processAbleEvent(arg) " + this.name, new Object[]{ableEvent});
        }
        String string = ableEvent.getAction();
        Object object = ableEvent.getArgObject();
        Object object2 = ableEvent.getReplyTo();
        String string2 = ableEvent.getReplyAction();
        String string3 = ableEvent.getTransactionId();
        boolean bl = !ableEvent.isAsynchronous();
        AbleEvent ableEvent2 = null;
        Object object3 = null;
        if (string != null && string.trim().length() != 0) {
            Method method;
            block18: {
                Class<?> clazz = this.getClass();
                method = null;
                try {
                    method = object == null ? clazz.getMethod(string.trim(), new Class[0]) : clazz.getMethod(string.trim(), class$java$lang$Object == null ? (class$java$lang$Object = AbleObject.class$("java.lang.Object")) : class$java$lang$Object);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (this.trace.isLogging()) {
                        this.trace.exception(262144L, this, "processAbleEvent", noSuchMethodException);
                    }
                    this.logger.text(4L, "AbleObject", "processAbleEvent", noSuchMethodException.getLocalizedMessage());
                    if (bl) {
                        throw new AbleException(noSuchMethodException.getLocalizedMessage(), this, (Throwable)noSuchMethodException);
                    }
                }
                catch (SecurityException securityException) {
                    if (this.trace.isLogging()) {
                        this.trace.exception(262144L, this, "processAbleEvent", securityException);
                    }
                    this.logger.text(4L, "AbleObject", "processAbleEvent", securityException.getLocalizedMessage());
                    if (!bl) break block18;
                    throw new AbleException(securityException.getLocalizedMessage(), this, (Throwable)securityException);
                }
            }
            if (method == null) {
                if (!this.trace.isLogging()) return;
                this.trace.text(524288L, this, "processAbleEvent", "Retrieved method is null: nothing to do!");
                return;
            }
            try {
                object3 = object == null ? method.invoke((Object)this, new Object[0]) : method.invoke((Object)this, object);
                if (object2 == null) return;
                ableEvent2 = new AbleEvent(this, object3, string2, true, null, null, string3);
                if (object2 instanceof Object[]) {
                    this.handleMultipleReplies(Arrays.asList((Object[])object2), ableEvent2);
                    return;
                }
                if (object2 instanceof Collection) {
                    this.handleMultipleReplies((Collection)object2, ableEvent2);
                    return;
                }
                ((AbleEventListener)object2).handleAbleEvent(ableEvent2);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "processAbleEvent", invocationTargetException);
                }
                this.logger.text(4L, "AbleObject", "processAbleEvent", invocationTargetException.getLocalizedMessage());
                if (!bl) return;
                throw new AbleException(invocationTargetException.getLocalizedMessage(), invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "processAbleEvent", illegalAccessException);
                }
                this.logger.text(4L, "AbleObject", "processAbleEvent", illegalAccessException.getLocalizedMessage());
                if (!bl) return;
                throw new AbleException(illegalAccessException.getLocalizedMessage(), illegalAccessException);
            }
            catch (AbleException ableException) {
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "processAbleEvent", ableException);
                }
                this.logger.text(4L, "AbleObject", "processAbleEvent", ableException.getLocalizedMessage());
                if (!bl) return;
                throw ableException;
            }
        }
        if (!this.trace.isLogging()) return;
        this.trace.text(524288L, this, "processAbleEvent", "Action is null or empty string: nothing to do!");
    }

    private void handleMultipleReplies(Collection collection, AbleEvent ableEvent) throws AbleException {
        Vector<AbleException> vector = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            AbleEventListener ableEventListener = (AbleEventListener)iterator.next();
            try {
                ableEventListener.handleAbleEvent(ableEvent);
            }
            catch (Exception exception) {
                if (vector == null) {
                    vector = new Vector<AbleException>();
                }
                vector.add(new AbleException(exception.getLocalizedMessage(), ableEventListener, (Throwable)exception));
            }
        }
        if (vector != null) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, this, "processAbleEvent", "Unable to reply to " + vector.size() + " of " + collection.size() + " requestors.");
            }
            throw new AbleException(Able.NlsMsg("Ex_CantRespondToListeners", new Object[]{Integer.toString(vector.size()), Integer.toString(collection.size())}), vector);
        }
    }

    public void processTimerEvent() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, this, "processTimerEvent " + this.name);
        }
    }

    public void processNoEventProcessingEnabledSituation() {
        if (this.trace.isLogging()) {
            this.trace.entry(262144L, this, "processNoEventProcessingEnabledSituation " + this.name);
        }
    }

    public boolean sourceConnectionsOK(Vector vector) {
        boolean bl = true;
        AbleBufferConnection ableBufferConnection = null;
        Enumeration enumeration = null;
        int n = this.sourceBufferConnections.size();
        for (int i = 0; i < n; ++i) {
            ableBufferConnection = (AbleBufferConnection)this.sourceBufferConnections.elementAt(i);
            bl = false;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                if (!ableBufferConnection.isSourceObject((AbleBean)enumeration.nextElement())) continue;
                bl = true;
                break;
            }
            if (!bl) break;
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.chgSupport = new PropertyChangeSupport(this);
        this.listeners = new Vector();
        this.stateChgSupport = new PropertyChangeSupport(this);
        this.state = new AbleState();
        this.trace = Able.TraceLog;
        this.logger = Able.MessageLog;
        boolean bl = this.trace.isLogging();
        if (bl) {
            this.trace.text(0x100000L, this, "readObject", "Reserializing object '" + this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "';");
        }
        try {
            objectInputStream.defaultReadObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                this.trace.text(262144L, this, "readObject", "ERROR: Reserializing object '" + this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "';");
                this.trace.exception(262144L, this, "readObject", classNotFoundException);
            }
            this.logger.text(4L, this, "readObject", classNotFoundException.getLocalizedMessage());
            throw classNotFoundException;
        }
        catch (IOException iOException) {
            if (bl) {
                this.trace.text(262144L, this, "readObject", "ERROR: Reserializing object '" + this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "';");
                this.trace.exception(262144L, this, "readObject", iOException);
            }
            this.logger.text(4L, this, "readObject", iOException.getLocalizedMessage());
            throw iOException;
        }
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        if (bl) {
            this.trace.text(0x100000L, this, "readObject", " reserialized object '" + this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + " named '" + this.name + "'.");
        }
        this.chgSupport.addPropertyChangeListener(this.propertyConnectionMgr);
    }

    private void setBuffer(Object object, int n, Object object2) throws AbleException {
        Class<?> clazz = object.getClass();
        if (clazz == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = AbleObject.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
            ((String[])object)[n] = AbleObject.convertToString(object2);
            return;
        }
        if (clazz == (array$D == null ? (array$D = AbleObject.class$("[D")) : array$D)) {
            ((double[])object)[n] = this.convertToDoublePrm(object2);
            return;
        }
        if (clazz == (array$J == null ? (array$J = AbleObject.class$("[J")) : array$J)) {
            ((long[])object)[n] = this.convertToLongPrm(object2);
            return;
        }
        if (clazz == (array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = AbleObject.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte)) {
            ((Byte[])object)[n] = this.convertToByte(object2);
            return;
        }
        if (clazz == (array$Ljava$lang$Double == null ? (array$Ljava$lang$Double = AbleObject.class$("[Ljava.lang.Double;")) : array$Ljava$lang$Double)) {
            ((Double[])object)[n] = this.convertToDoubleCls(object2);
            return;
        }
        if (clazz == (array$Ljava$lang$Float == null ? (array$Ljava$lang$Float = AbleObject.class$("[Ljava.lang.Float;")) : array$Ljava$lang$Float)) {
            ((Float[])object)[n] = this.convertToFloat(object2);
            return;
        }
        if (clazz == (array$Ljava$lang$Integer == null ? (array$Ljava$lang$Integer = AbleObject.class$("[Ljava.lang.Integer;")) : array$Ljava$lang$Integer)) {
            ((Integer[])object)[n] = this.convertToInteger(object2);
            return;
        }
        if (clazz == (array$Ljava$lang$Long == null ? (array$Ljava$lang$Long = AbleObject.class$("[Ljava.lang.Long;")) : array$Ljava$lang$Long)) {
            ((Long[])object)[n] = this.convertToLongCls(object2);
            return;
        }
        if (clazz == (array$Ljava$lang$Short == null ? (array$Ljava$lang$Short = AbleObject.class$("[Ljava.lang.Short;")) : array$Ljava$lang$Short)) {
            ((Short[])object)[n] = this.convertToShort(object2);
            return;
        }
        if (clazz == (array$Ljava$lang$Number == null ? (array$Ljava$lang$Number = AbleObject.class$("[Ljava.lang.Number;")) : array$Ljava$lang$Number)) {
            ((Number[])object)[n] = this.convertToNumber(object2);
            return;
        }
        if (clazz == (array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbleObject.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object)) {
            ((Object[])object)[n] = object2;
            return;
        }
        if (clazz == (class$java$util$Vector == null ? (class$java$util$Vector = AbleObject.class$("java.util.Vector")) : class$java$util$Vector)) {
            ((Vector)object).setElementAt(object2, n);
            return;
        }
        if (clazz == (class$java$util$Hashtable == null ? (class$java$util$Hashtable = AbleObject.class$("java.util.Hashtable")) : class$java$util$Hashtable)) {
            ((Hashtable)object).put(Integer.toString(n), object2);
            return;
        }
        String string = Able.NlsMsg("Ex_BuffNoIndexing2", new Object[]{new Integer(n), object2});
        if (this.trace.isLogging()) {
            this.trace.text(262144L, this, "setBuffer(buffer,int,obj)", string);
        }
        throw new AbleException(string);
    }

    private Object getBuffer(Object object, int n) throws AbleException {
        Class<?> clazz = object.getClass();
        if (clazz == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = AbleObject.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
            return ((String[])object)[n];
        }
        if (clazz == (array$D == null ? (array$D = AbleObject.class$("[D")) : array$D)) {
            return new Double(((double[])object)[n]);
        }
        if (clazz == (array$J == null ? (array$J = AbleObject.class$("[J")) : array$J)) {
            return new Long(((long[])object)[n]);
        }
        if (clazz == (array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = AbleObject.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte)) {
            return ((Byte[])object)[n];
        }
        if (clazz == (array$Ljava$lang$Double == null ? (array$Ljava$lang$Double = AbleObject.class$("[Ljava.lang.Double;")) : array$Ljava$lang$Double)) {
            return ((Double[])object)[n];
        }
        if (clazz == (array$Ljava$lang$Float == null ? (array$Ljava$lang$Float = AbleObject.class$("[Ljava.lang.Float;")) : array$Ljava$lang$Float)) {
            return ((Float[])object)[n];
        }
        if (clazz == (array$Ljava$lang$Integer == null ? (array$Ljava$lang$Integer = AbleObject.class$("[Ljava.lang.Integer;")) : array$Ljava$lang$Integer)) {
            return ((Integer[])object)[n];
        }
        if (clazz == (array$Ljava$lang$Long == null ? (array$Ljava$lang$Long = AbleObject.class$("[Ljava.lang.Long;")) : array$Ljava$lang$Long)) {
            return ((Long[])object)[n];
        }
        if (clazz == (array$Ljava$lang$Short == null ? (array$Ljava$lang$Short = AbleObject.class$("[Ljava.lang.Short;")) : array$Ljava$lang$Short)) {
            return ((Short[])object)[n];
        }
        if (clazz == (array$Ljava$lang$Number == null ? (array$Ljava$lang$Number = AbleObject.class$("[Ljava.lang.Number;")) : array$Ljava$lang$Number)) {
            return ((Number[])object)[n];
        }
        if (clazz == (array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbleObject.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object)) {
            return ((Object[])object)[n];
        }
        if (clazz == (class$java$util$Vector == null ? (class$java$util$Vector = AbleObject.class$("java.util.Vector")) : class$java$util$Vector)) {
            return ((Vector)object).elementAt(n);
        }
        if (clazz == (class$java$util$Hashtable == null ? (class$java$util$Hashtable = AbleObject.class$("java.util.Hashtable")) : class$java$util$Hashtable)) {
            return ((Hashtable)object).get(Integer.toString(n));
        }
        String string = Able.NlsMsg("Ex_BuffNoIndexing1", new Object[]{new Integer(n)});
        if (this.trace.isLogging()) {
            this.trace.text(262144L, this, "getBuffer(buffer,int)", string);
        }
        throw new AbleException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getBufferAsStringArray(Object object) throws AbleException {
        String[] stringArray = null;
        int n = 0;
        Class<?> clazz = null;
        if (object == null) {
            return null;
        }
        clazz = object.getClass();
        if (clazz == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = AbleObject.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
            stringArray = (String[])object;
            return stringArray;
        }
        numberFormatter.setMaximumFractionDigits(6);
        if (clazz == (array$D == null ? (array$D = AbleObject.class$("[D")) : array$D)) {
            double[] dArray = (double[])object;
            n = dArray.length;
            stringArray = new String[n];
            Object object2 = object;
            synchronized (object2) {
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = numberFormatter.format(dArray[i]);
                }
            }
            return stringArray;
        }
        if (clazz == (array$J == null ? (array$J = AbleObject.class$("[J")) : array$J)) {
            long[] lArray = (long[])object;
            n = lArray.length;
            stringArray = new String[n];
            Object object3 = object;
            synchronized (object3) {
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = numberFormatter.format(lArray[i]);
                }
            }
            return stringArray;
        }
        if (clazz == (array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = AbleObject.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte) || clazz == (array$Ljava$lang$Double == null ? (array$Ljava$lang$Double = AbleObject.class$("[Ljava.lang.Double;")) : array$Ljava$lang$Double) || clazz == (array$Ljava$lang$Float == null ? (array$Ljava$lang$Float = AbleObject.class$("[Ljava.lang.Float;")) : array$Ljava$lang$Float) || clazz == (array$Ljava$lang$Integer == null ? (array$Ljava$lang$Integer = AbleObject.class$("[Ljava.lang.Integer;")) : array$Ljava$lang$Integer) || clazz == (array$Ljava$lang$Long == null ? (array$Ljava$lang$Long = AbleObject.class$("[Ljava.lang.Long;")) : array$Ljava$lang$Long) || clazz == (array$Ljava$lang$Short == null ? (array$Ljava$lang$Short = AbleObject.class$("[Ljava.lang.Short;")) : array$Ljava$lang$Short) || clazz == (array$Ljava$lang$Number == null ? (array$Ljava$lang$Number = AbleObject.class$("[Ljava.lang.Number;")) : array$Ljava$lang$Number)) {
            Number[] numberArray = (Number[])object;
            n = numberArray.length;
            stringArray = new String[n];
            Object object4 = object;
            synchronized (object4) {
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = numberFormatter.format(numberArray[i].doubleValue());
                }
            }
            return stringArray;
        }
        if (clazz == (array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbleObject.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object)) {
            Object[] objectArray = (Object[])object;
            n = objectArray.length;
            stringArray = new String[n];
            Object object5 = object;
            synchronized (object5) {
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = AbleObject.convertToString(objectArray[i]);
                }
            }
            return stringArray;
        }
        if (clazz == (class$java$util$Vector == null ? (class$java$util$Vector = AbleObject.class$("java.util.Vector")) : class$java$util$Vector)) {
            Vector vector = (Vector)object;
            n = vector.size();
            stringArray = new String[n];
            Object object6 = object;
            synchronized (object6) {
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = AbleObject.convertToString(vector.elementAt(i));
                }
            }
            return stringArray;
        }
        if (clazz == (class$java$util$Hashtable == null ? (class$java$util$Hashtable = AbleObject.class$("java.util.Hashtable")) : class$java$util$Hashtable)) {
            Hashtable hashtable = (Hashtable)object;
            n = hashtable.size();
            stringArray = new String[n];
            int n2 = 0;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                stringArray[n2] = AbleObject.convertToString(enumeration.nextElement());
                ++n2;
            }
            return stringArray;
        }
        String string = Able.NlsMsg("Ex_BuffUnsupportedType", new Object[]{clazz});
        if (this.trace.isLogging()) {
            this.trace.text(262144L, this, "getBufferAsStringArray(buffer)", string);
        }
        throw new AbleException(string);
    }

    private Enumeration getBufferContents(Object object) throws AbleException {
        Class<?> clazz = null;
        if (object == null) {
            return null;
        }
        clazz = object.getClass();
        if (clazz == (class$java$util$Vector == null ? (class$java$util$Vector = AbleObject.class$("java.util.Vector")) : class$java$util$Vector)) {
            return ((Vector)object).elements();
        }
        if (clazz == (class$java$util$Hashtable == null ? (class$java$util$Hashtable = AbleObject.class$("java.util.Hashtable")) : class$java$util$Hashtable)) {
            return ((Hashtable)object).elements();
        }
        if (clazz.isArray()) {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < Array.getLength(object); ++i) {
                vector.addElement("" + Array.get(object, i));
            }
            return Collections.enumeration(vector);
        }
        String string = Able.NlsMsg("Ex_BuffUnsupportedType", new Object[]{clazz});
        if (this.trace.isLogging()) {
            this.trace.text(262144L, this, "getBufferContents(buffer)", string);
        }
        throw new AbleException(string);
    }

    private static String convertToString(Object object) {
        String string = null;
        string = object == null ? (String)null : (object instanceof Number ? numberFormatter.format(((Number)object).doubleValue()) : object.toString());
        return string;
    }

    private double convertToDoublePrm(Object object) throws AbleException {
        double d = 0.0;
        if (object instanceof Number) {
            d = ((Number)object).doubleValue();
            return d;
        }
        if (object instanceof String) {
            try {
                d = Double.valueOf((String)object);
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "double"});
                this.logger.text(4L, this, "convertToDoublePrm", string);
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "convertToDoublePrm", numberFormatException);
                }
                throw new AbleException(string);
            }
        }
        String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "double"});
        this.logger.text(4L, this, "convertToDoublePrm", string);
        if (this.trace.isLogging()) {
            this.trace.text(262144L, this, "convertToDoublePrm", string);
        }
        throw new AbleException(string);
    }

    private long convertToLongPrm(Object object) throws AbleException {
        long l = 0L;
        if (object instanceof Number) {
            l = ((Number)object).longValue();
            return l;
        }
        if (object instanceof String) {
            try {
                l = Long.valueOf((String)object);
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "long"});
                this.logger.text(4L, this, "convertToLongPrm", string);
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "convertToLongPrm", numberFormatException);
                }
                throw new AbleException(string);
            }
        }
        String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "long"});
        this.logger.text(4L, this, "convertToLongPrm", string);
        if (this.trace.isLogging()) {
            this.trace.text(262144L, this, "convertToLongPrm", string);
        }
        throw new AbleException(string);
    }

    private Byte convertToByte(Object object) throws AbleException {
        Byte by = null;
        if (object instanceof Number) {
            by = new Byte(((Number)object).byteValue());
            return by;
        }
        if (object instanceof String) {
            try {
                by = Byte.valueOf((String)object);
                return by;
            }
            catch (NumberFormatException numberFormatException) {
                String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "Byte"});
                this.logger.text(4L, this, "convertToBytePrm", string);
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "convertToBytePrm", numberFormatException);
                }
                throw new AbleException(string);
            }
        }
        String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "Byte"});
        this.logger.text(4L, this, "convertToBytePrm", string);
        if (this.trace.isLogging()) {
            this.trace.text(262144L, this, "convertToBytePrm", string);
        }
        throw new AbleException(string);
    }

    private Double convertToDoubleCls(Object object) throws AbleException {
        Double d = null;
        if (object instanceof Number) {
            d = new Double(((Number)object).doubleValue());
            return d;
        }
        if (object instanceof String) {
            try {
                d = Double.valueOf((String)object);
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "Double"});
                this.logger.text(4L, this, "convertToDoubleCls", string);
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "convertToDoubleCls", numberFormatException);
                }
                throw new AbleException(string);
            }
        }
        String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "Double"});
        this.logger.text(4L, this, "convertToDoubleCls", string);
        if (this.trace.isLogging()) {
            this.trace.text(262144L, this, "convertToDoubleCls", string);
        }
        throw new AbleException(string);
    }

    private Integer convertToInteger(Object object) throws AbleException {
        Integer n = null;
        if (object instanceof Number) {
            n = new Integer(((Number)object).intValue());
            return n;
        }
        if (object instanceof String) {
            try {
                n = Integer.valueOf((String)object);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "Integer"});
                this.logger.text(4L, this, "convertToInteger", string);
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "convertToInteger", numberFormatException);
                }
                throw new AbleException(string);
            }
        }
        String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "Integer"});
        this.logger.text(4L, this, "convertToInteger", string);
        if (this.trace.isLogging()) {
            this.trace.text(262144L, this, "convertToInteger", string);
        }
        throw new AbleException(string);
    }

    private Float convertToFloat(Object object) throws AbleException {
        Float f = null;
        if (object instanceof Number) {
            f = new Float(((Number)object).floatValue());
            return f;
        }
        if (object instanceof String) {
            try {
                f = Float.valueOf((String)object);
                return f;
            }
            catch (NumberFormatException numberFormatException) {
                String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "Float"});
                this.logger.text(4L, this, "convertToFloat", string);
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "convertToFloat", numberFormatException);
                }
                throw new AbleException(string);
            }
        }
        String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "Float"});
        this.logger.text(4L, this, "convertToFloat", string);
        if (this.trace.isLogging()) {
            this.trace.text(262144L, this, "convertToFloat", string);
        }
        throw new AbleException(string);
    }

    private Long convertToLongCls(Object object) throws AbleException {
        Long l = null;
        if (object instanceof Number) {
            l = new Long(((Number)object).longValue());
            return l;
        }
        if (object instanceof String) {
            try {
                l = Long.valueOf((String)object);
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "Long"});
                this.logger.text(4L, this, "convertToLongCls", string);
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "convertToLongCls", numberFormatException);
                }
                throw new AbleException(string);
            }
        }
        String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "Long"});
        this.logger.text(4L, this, "convertToLongCls", string);
        if (this.trace.isLogging()) {
            this.trace.text(262144L, this, "convertToLongCls", string);
        }
        throw new AbleException(string);
    }

    private Short convertToShort(Object object) throws AbleException {
        Short s = null;
        if (object instanceof Number) {
            s = new Short(((Number)object).shortValue());
            return s;
        }
        if (object instanceof String) {
            try {
                s = Short.valueOf((String)object);
                return s;
            }
            catch (NumberFormatException numberFormatException) {
                String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "Short"});
                this.logger.text(4L, this, "convertToShort", string);
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "convertToShort", numberFormatException);
                }
                throw new AbleException(string);
            }
        }
        String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "Short"});
        this.logger.text(4L, this, "convertToShort", string);
        if (this.trace.isLogging()) {
            this.trace.text(262144L, this, "convertToShort", string);
        }
        throw new AbleException(string);
    }

    private Number convertToNumber(Object object) throws AbleException {
        Number number = null;
        if (object instanceof Number) {
            number = (Number)object;
            return number;
        }
        if (object instanceof String) {
            try {
                number = Double.valueOf((String)object);
                return number;
            }
            catch (NumberFormatException numberFormatException) {
                String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "Number"});
                this.logger.text(4L, this, "convertToNumber", string);
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "convertToNumber", numberFormatException);
                }
                throw new AbleException(string);
            }
        }
        String string = Able.NlsMsg("Ex_BuffCantConvert", new Object[]{object, "Number"});
        this.logger.text(4L, this, "convertToNumber", string);
        if (this.trace.isLogging()) {
            this.trace.text(262144L, this, "convertToNumber", string);
        }
        throw new AbleException(string);
    }

    private static String Copyright() {
        return "Licensed Materials - Property of IBM\nPackage: com.ibm.able\n(C) Copyright IBM Corporation 1999, 2005. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

