/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able;

import com.ibm.logging.LogRecord;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class AbleLogRecord
extends LogRecord {
    public Hashtable getSupportedTypes() {
        Hashtable hashtable = super.getSupportedTypes();
        hashtable.put("Inferencing trace high", new Long(0x40000000000L));
        hashtable.put("Inferencing trace medium", new Long(0x20000000000L));
        hashtable.put("Inferencing trace low", new Long(0x10000000000L));
        hashtable.put("Ruleset trace high", new Long(0x400000000L));
        hashtable.put("Ruleset trace medium", new Long(0x200000000L));
        hashtable.put("Ruleset trace low", new Long(0x100000000L));
        return hashtable;
    }

    public long maskLongValue(String string) {
        long l = super.maskLongValue(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("TRC_HIGH_INFER")) {
                l |= 0x40000000000L;
                continue;
            }
            if (string2.equals("TRC_MEDIUM_INFER")) {
                l |= 0x20000000000L;
                continue;
            }
            if (string2.equals("TRC_LOW_INFER")) {
                l |= 0x10000000000L;
                continue;
            }
            if (string2.equals("TRC_HIGH_RLST")) {
                l |= 0x400000000L;
                continue;
            }
            if (string2.equals("TRC_MEDIUM_RLST")) {
                l |= 0x200000000L;
                continue;
            }
            if (!string2.equals("TRC_LOW_RLST")) continue;
            l |= 0x100000000L;
        }
        return l;
    }

    public String maskToString(long l) {
        StringBuffer stringBuffer = new StringBuffer(super.maskToString(l));
        if ((l & 0x40000000000L) != 0L) {
            stringBuffer.append("TRC_HIGH_INFER ");
        }
        if ((l & 0x20000000000L) != 0L) {
            stringBuffer.append("TRC_MEDIUM_INFER ");
        }
        if ((l & 0x10000000000L) != 0L) {
            stringBuffer.append("TRC_LOW_INFER ");
        }
        if ((l & 0x400000000L) != 0L) {
            stringBuffer.append("TRC_HIGH_RLST ");
        }
        if ((l & 0x200000000L) != 0L) {
            stringBuffer.append("TRC_MEDIUM_RLST ");
        }
        if ((l & 0x100000000L) != 0L) {
            stringBuffer.append("TRC_LOW_RLST ");
        }
        return stringBuffer.toString().trim();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

