/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able;

import com.ibm.able.Able;
import com.ibm.able.AbleAgent;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleBeanContainer;
import com.ibm.able.AbleDataSource;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleEventConnection;
import com.ibm.able.AbleEventListener;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import com.ibm.able.AbleUserDefinedFunction;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;

public class AbleDefaultAgent
extends AbleObject
implements AbleAgent,
PropertyChangeListener,
Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    public static final String defaultName = Able.NlsMsg("DFLT_NAME_DefaultAgent");
    private Vector beans = new Vector();
    protected Hashtable myBeans = new Hashtable();
    protected boolean activeDataSource = false;
    protected Vector eventConnections = new Vector();
    protected transient Vector processList = new Vector();
    protected transient boolean processListOK = false;
    protected long numEpochs = 0L;
    protected Hashtable userDefinedFunctions = new Hashtable();
    private AbleBean inputBufferTargetObject = null;
    private AbleBean outputBufferSourceObject = null;

    public AbleDefaultAgent() throws AbleException {
        this(defaultName);
    }

    public AbleDefaultAgent(String string) throws AbleException {
        super(string);
    }

    public AbleDefaultAgent(String string, String string2) throws AbleException {
        super(string, string2);
    }

    public void setActiveDataSource(boolean bl) throws AbleException {
        boolean bl2 = this.activeDataSource;
        this.activeDataSource = bl;
        this.firePropertyChange("activeDataSource", new Boolean(bl2), new Boolean(bl));
        this.changed = true;
    }

    public boolean isActiveDataSource() throws AbleException {
        AbleDataSource ableDataSource = this.getDataSource();
        if (ableDataSource == null) {
            return false;
        }
        AbleBean ableBean = ableDataSource;
        this.activeDataSource = ableBean.isDataFlowEnabled();
        return this.activeDataSource;
    }

    public AbleDataSource getDataSource() throws AbleException {
        if (!this.processListOK) {
            this.buildProcessList();
        }
        if (this.processList == null || this.processList.size() == 0) {
            return null;
        }
        AbleBean ableBean = (AbleBean)this.processList.firstElement();
        if (ableBean instanceof AbleDataSource) {
            return (AbleDataSource)ableBean;
        }
        return null;
    }

    public Vector getEventConnections() {
        return this.eventConnections;
    }

    public void addEventConnection(AbleEventConnection ableEventConnection) throws AbleException {
        boolean bl = false;
        AbleBean ableBean = ableEventConnection.getSource();
        AbleEventListener ableEventListener = ableEventConnection.getListener();
        AbleEventConnection ableEventConnection2 = null;
        Iterator iterator = this.eventConnections.iterator();
        while (!bl && iterator.hasNext()) {
            ableEventConnection2 = (AbleEventConnection)iterator.next();
            AbleBean ableBean2 = ableEventConnection2.getSource();
            AbleEventListener ableEventListener2 = ableEventConnection2.getListener();
            bl = ableBean.equals(ableBean2) && ableEventListener.equals(ableEventListener2);
        }
        if (bl) {
            this.eventConnections.remove(ableEventConnection2);
        }
        this.eventConnections.addElement(ableEventConnection);
        this.changed = true;
    }

    public void removeEventConnection(AbleEventConnection ableEventConnection) throws AbleException {
        this.eventConnections.removeElement(ableEventConnection);
        this.changed = true;
    }

    public void removeAllEventConnections() throws AbleException {
        this.eventConnections.removeAllElements();
        this.changed = true;
    }

    private void removeEventConnection(AbleBean ableBean, AbleEventListener ableEventListener) throws AbleException {
        Iterator iterator = this.eventConnections.iterator();
        while (iterator.hasNext()) {
            AbleEventConnection ableEventConnection = (AbleEventConnection)iterator.next();
            if (ableEventConnection.getSource() != ableBean || ableEventConnection.getListener() != ableEventListener) continue;
            iterator.remove();
            this.changed = true;
        }
    }

    public void setProcessList(Vector vector) throws AbleException {
        Vector vector2 = this.processList;
        this.processList = vector;
        this.processListOK = true;
        this.setBufferSources();
        this.firePropertyChange("processList", vector2, vector);
    }

    public Vector getProcessList() throws AbleException {
        return this.processList;
    }

    public long getNumEpochs() throws AbleException {
        return this.numEpochs;
    }

    public void removeAllConnections() throws AbleException {
        super.removeAllConnections();
        this.removeAllEventConnections();
    }

    public void reset() throws AbleException {
        Vector<AbleException> vector = null;
        super.reset();
        Enumeration enumeration = this.myBeans.elements();
        while (enumeration.hasMoreElements()) {
            AbleBean ableBean = (AbleBean)enumeration.nextElement();
            try {
                if (!ableBean.isDataFlowEnabled()) continue;
                ableBean.reset();
            }
            catch (AbleException ableException) {
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "reset", ableException);
                }
                this.logger.text(2L, this, "reset", ableException.getLocalizedMessage());
                if (vector == null) {
                    vector = new Vector<AbleException>();
                }
                vector.add(ableException);
            }
        }
        this.changed = true;
        if (vector != null) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, this, "reset", "Unable to reset " + vector.size() + " of " + this.myBeans.size() + " beans.");
            }
            throw new AbleException(Able.NlsMsg("Ex_CantResetBeans", new Object[]{Integer.toString(vector.size()), Integer.toString(this.myBeans.size())}), vector);
        }
        this.numEpochs = 0L;
    }

    public void resetAllBeans() throws AbleException {
        this.reset();
    }

    public void initAllBeans() throws AbleException {
        Enumeration enumeration = this.myBeans.elements();
        while (enumeration.hasMoreElements()) {
            AbleBean ableBean = (AbleBean)enumeration.nextElement();
            ableBean.init();
        }
        this.init();
    }

    public void init() throws AbleException {
        super.init();
        this.changed = true;
    }

    public void process() throws AbleException {
        super.process();
        if (!this.processListOK) {
            this.buildProcessList();
        }
        this.processBufferConnections();
        if (this.dataFlowEnabled && this.inputBufferTargetObject != null) {
            this.inputBufferTargetObject.setInputBuffer(this.inputBuffer);
        }
        int n = this.processList.size();
        StringBuffer stringBuffer = null;
        AbleBean ableBean = null;
        Vector<Exception> vector = null;
        for (int i = 0; i < n; ++i) {
            ableBean = (AbleBean)this.processList.elementAt(i);
            if (!ableBean.isDataFlowEnabled()) continue;
            try {
                ableBean.process();
                continue;
            }
            catch (Exception exception) {
                String string = Able.NlsMsg("EX_CANT_PROCESS_BEAN", new Object[]{ableBean.getName() + "{" + ableBean.getClass().getName()}) + "}" + Able.LS + Able.NlsMsg("EX_MESSAGE_CONTENT", new Object[]{exception instanceof AbleException ? exception.getLocalizedMessage() : exception.toString()});
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string);
                } else {
                    stringBuffer.append(Able.LS + string);
                }
                this.logger.text(4L, this, "process", string);
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, this, "process", exception);
                }
                if (vector == null) {
                    vector = new Vector<Exception>();
                }
                if (exception instanceof AbleException) {
                    vector.add(exception);
                    continue;
                }
                vector.add(new AbleException(string, ableBean, (Throwable)exception));
            }
        }
        if (this.dataFlowEnabled && this.outputBufferSourceObject != null) {
            this.outputBuffer = this.outputBufferSourceObject.getOutputBuffer();
        }
        this.dataChanged(this);
        if (stringBuffer != null) {
            throw new AbleException(stringBuffer.toString(), vector);
        }
    }

    public void setDataFlowEnabled(boolean bl) {
        super.setDataFlowEnabled(bl);
        this.processListOK = false;
    }

    public void quitEnabledEventProcessing() throws AbleException {
        Vector<AbleException> vector = null;
        try {
            super.quitEnabledEventProcessing();
        }
        catch (AbleException ableException) {
            vector = new Vector<AbleException>();
            if (ableException instanceof AbleException) {
                vector.add(ableException);
            }
            vector.add(new AbleException(ableException.getLocalizedMessage(), this, (Throwable)ableException));
        }
        Enumeration enumeration = this.myBeans.elements();
        while (enumeration.hasMoreElements()) {
            AbleBean ableBean = (AbleBean)enumeration.nextElement();
            try {
                ableBean.quitAll();
            }
            catch (AbleException ableException) {
                if (vector == null) {
                    vector = new Vector();
                }
                if (ableException instanceof AbleException) {
                    vector.add(ableException);
                    continue;
                }
                vector.add(new AbleException(ableException.getLocalizedMessage(), ableBean, (Throwable)ableException));
            }
        }
        if (vector != null) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, this, "quitEnabledEventProcessing", "Unable to quit event processing " + vector.size() + " of " + this.myBeans.size() + " beans.");
            }
            throw new AbleException(Able.NlsMsg("Ex_CantQuitEventProcessingBeans", new Object[]{Integer.toString(vector.size()), Integer.toString(this.myBeans.size())}), vector);
        }
    }

    public void quitAll() throws AbleException {
        this.quitEnabledEventProcessing();
        this.changed = true;
    }

    public void suspendAll() throws AbleException {
        Vector<AbleException> vector = null;
        super.suspendEnabledEventProcessing();
        Enumeration enumeration = this.myBeans.elements();
        while (enumeration.hasMoreElements()) {
            AbleBean ableBean = (AbleBean)enumeration.nextElement();
            try {
                ableBean.suspendAll();
            }
            catch (AbleException ableException) {
                if (vector == null) {
                    vector = new Vector<AbleException>();
                }
                if (ableException instanceof AbleException) {
                    vector.add(ableException);
                    continue;
                }
                vector.add(new AbleException(ableException.getLocalizedMessage(), ableBean, (Throwable)ableException));
            }
        }
        this.changed = true;
        if (vector != null) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, this, "suspendAll", "Unable to suspend " + vector.size() + " of " + this.myBeans.size() + " beans.");
            }
            throw new AbleException(Able.NlsMsg("Ex_CantSuspendBeans", new Object[]{Integer.toString(vector.size()), Integer.toString(this.myBeans.size())}), vector);
        }
    }

    public void resumeAll() throws AbleException {
        Vector<AbleException> vector = null;
        super.resumeEnabledEventProcessing();
        Enumeration enumeration = this.myBeans.elements();
        while (enumeration.hasMoreElements()) {
            AbleBean ableBean = (AbleBean)enumeration.nextElement();
            try {
                ableBean.resumeAll();
            }
            catch (AbleException ableException) {
                if (vector == null) {
                    vector = new Vector<AbleException>();
                }
                if (ableException instanceof AbleException) {
                    vector.add(ableException);
                    continue;
                }
                vector.add(new AbleException(ableException.getLocalizedMessage(), ableBean, (Throwable)ableException));
            }
        }
        this.changed = true;
        if (vector != null) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, this, "resumeAll", "Unable to resume " + vector.size() + " of " + this.myBeans.size() + " beans.");
            }
            throw new AbleException(Able.NlsMsg("Ex_CantResumeBeans", new Object[]{Integer.toString(vector.size()), Integer.toString(this.myBeans.size())}), vector);
        }
    }

    public void handleAbleEvent(AbleEvent ableEvent) throws AbleException {
        if (ableEvent.getId() == 2) {
            ++this.numEpochs;
            if (this.trace.isLogging()) {
                this.trace.entry(0x100000L, (Object)this, "handleAbleEvent", ableEvent);
            }
        } else {
            super.handleAbleEvent(ableEvent);
        }
    }

    public void addBean(AbleBean ableBean) throws AbleException {
        String string;
        block8: {
            if (ableBean == null || this.myBeans.containsValue(ableBean)) {
                return;
            }
            string = ableBean.getName();
            if (this.myBeans.containsKey(string)) {
                String string2 = AbleDefaultAgent.generateUniqueName(this, ableBean);
                ableBean.setName(string2);
            }
            if (ableBean.getParent() != null) {
                try {
                    ableBean.getParent().removeBean(ableBean);
                }
                catch (AbleException ableException) {
                    if (!this.trace.isLogging()) break block8;
                    this.trace.text(262144L, this, "addBean", "Could not remove Bean <{0}> from parent <{1}> before adding it to new parent <{2}>", new Object[]{string, ableBean.getParent().getName(), this.name});
                    this.trace.exception(262144L, this, "addBean", ableException);
                }
            }
        }
        this.myBeans.put(ableBean.getName(), ableBean);
        ableBean.setParent(this);
        ableBean.addPropertyChangeListener(this);
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, this, "addBean", "Bean <{0}> added to parent <{1}>.", new Object[]{string, this.name});
        }
        if (ableBean instanceof AbleDataSource) {
            this.addEventConnection(new AbleEventConnection(ableBean, this));
            boolean bl = ableBean.isDataFlowEnabled();
            if (bl && ableBean instanceof AbleObject) {
                ((AbleObject)ableBean).firePropertyChange("dataFlowEnabled", new Boolean(!bl), new Boolean(bl));
            }
        }
        this.processListOK = false;
        this.changed = true;
        this.firePropertyChange("beans", null, ableBean);
    }

    public static String generateUniqueName(AbleBeanContainer ableBeanContainer, AbleBean ableBean) {
        String string = ableBean.getName();
        while (ableBeanContainer.containsBean(string)) {
            int n = 0;
            n = string.lastIndexOf(95);
            if (n != -1) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                try {
                    int n2 = Integer.parseInt(string3);
                    string = string2 + "_" + (n2 + 1);
                }
                catch (NumberFormatException numberFormatException) {
                    string = string + "_1";
                }
            } else {
                string = string + "_1";
            }
            if (!Able.TraceLog.isLogging()) continue;
            Able.TraceLog.text(0x100000L, ableBeanContainer, "generateUniqueName", "Name collision - new name = " + string);
        }
        return string;
    }

    public void removeBean(AbleBean ableBean) throws AbleException {
        if (ableBean != null && this.myBeans.containsValue(ableBean)) {
            this.myBeans.remove(ableBean.getName());
            ableBean.setParent(null);
            this.removeEventConnection(ableBean, this);
            this.firePropertyChange("beans", ableBean, null);
            if (this.trace.isLogging()) {
                this.trace.text(0x100000L, this, "removeBean", "Bean <{0}> removed from parent <{1}>.", new Object[]{ableBean.getName(), this.name});
            }
            this.processListOK = false;
            this.changed = true;
        }
    }

    public void removeBean(String string) throws AbleException {
        this.removeBean(this.getBean(string));
    }

    public static void removeBeans(AbleBeanContainer ableBeanContainer, AbleBean[] ableBeanArray) throws AbleException {
        for (int i = 0; i < ableBeanArray.length; ++i) {
            ableBeanContainer.removeBean(ableBeanArray[i]);
        }
    }

    public static void addBeans(AbleBeanContainer ableBeanContainer, AbleBean[] ableBeanArray) throws AbleException {
        for (int i = 0; i < ableBeanArray.length; ++i) {
            ableBeanContainer.addBean(ableBeanArray[i]);
        }
    }

    public void removeAllBeans() throws AbleException {
        Vector vector = this.getBeans();
        for (int i = 0; i < vector.size(); ++i) {
            AbleBean ableBean = (AbleBean)vector.elementAt(i);
            this.removeBean(ableBean);
        }
    }

    public boolean containsBean(AbleBean ableBean) {
        return this.myBeans.containsValue(ableBean);
    }

    public boolean containsBean(String string) {
        return this.myBeans.containsKey(string);
    }

    public AbleBean getBean(String string) {
        if (this.myBeans.containsKey(string)) {
            return (AbleBean)this.myBeans.get(string);
        }
        return null;
    }

    public Vector getBeans() {
        return new Vector(this.myBeans.values());
    }

    public void addUserDefinedFunction(AbleUserDefinedFunction ableUserDefinedFunction) {
        this.userDefinedFunctions.put(ableUserDefinedFunction.getNameWithArity(), ableUserDefinedFunction);
        this.firePropertyChange("userDefinedFunction", null, ableUserDefinedFunction);
        this.changed = true;
    }

    public void removeUserDefinedFunction(String string, int n) {
        String string2 = string + "/" + n;
        if (this.userDefinedFunctions.containsKey(string2)) {
            AbleUserDefinedFunction ableUserDefinedFunction = (AbleUserDefinedFunction)this.userDefinedFunctions.get(string2);
            this.userDefinedFunctions.remove(string2);
            this.firePropertyChange("userDefinedFunction", ableUserDefinedFunction, null);
            this.changed = true;
        }
    }

    public boolean containsUserDefinedFunction(String string, int n) {
        String string2 = string + "/" + n;
        return this.userDefinedFunctions.containsKey(string2);
    }

    public AbleUserDefinedFunction getUserDefinedFunction(String string, int n) {
        String string2 = string + "/" + n;
        AbleUserDefinedFunction ableUserDefinedFunction = (AbleUserDefinedFunction)this.userDefinedFunctions.get(string2);
        if (ableUserDefinedFunction != null) {
            return ableUserDefinedFunction;
        }
        return null;
    }

    public Object invokeUserDefinedFunction(String string, Object[] objectArray) throws AbleException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, SecurityException {
        String string2;
        AbleUserDefinedFunction ableUserDefinedFunction;
        if (this.trace.isLogging()) {
            this.trace.entry(0x100000L, (Object)this, "invokeUserDefinedFunction", string);
        }
        if ((ableUserDefinedFunction = (AbleUserDefinedFunction)this.userDefinedFunctions.get(string2 = string + "/" + (objectArray == null ? 0 : objectArray.length))) == null) {
            String string3 = Able.NlsMsg("Ex_UdfNotRegistered", new Object[]{string2});
            this.logger.text(4L, this, "invokeUserDefinedFunction", string3);
            if (this.trace.isLogging()) {
                this.trace.text(262144L, this, "invokeUserDefinedFunction()", string3);
            }
            throw new AbleException(string3);
        }
        return ableUserDefinedFunction.invoke(objectArray);
    }

    public void setUserDefinedFunctions(Hashtable hashtable) {
        Hashtable hashtable2 = this.getUserDefinedFunctions();
        this.userDefinedFunctions = (Hashtable)hashtable.clone();
        this.firePropertyChange("userDefinedFunction", hashtable2, this.getUserDefinedFunctions());
        this.changed = true;
    }

    public Hashtable getUserDefinedFunctions() {
        return (Hashtable)this.userDefinedFunctions.clone();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.trace.isLogging()) {
            this.trace.entry(0x100000L, (Object)this, "propertyChange " + this.name, new Object[]{propertyChangeEvent});
        }
        AbleBean ableBean = (AbleBean)propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("dataFlowEnabled") && ableBean instanceof AbleDataSource) {
            if (ableBean.isDataFlowEnabled() && this.myBeans != null) {
                Enumeration enumeration = this.myBeans.elements();
                while (enumeration.hasMoreElements()) {
                    AbleBean ableBean2 = (AbleBean)enumeration.nextElement();
                    if (!(ableBean2 instanceof AbleDataSource) || ableBean2 == ableBean || !ableBean2.isDataFlowEnabled()) continue;
                    ableBean2.setDataFlowEnabled(false);
                }
                this.processListOK = false;
                this.changed = true;
            }
        } else if (string.equals("sourceBufferConnections")) {
            this.processListOK = false;
            this.changed = true;
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        } else if (string.equals("name") && this.myBeans.containsKey(propertyChangeEvent.getOldValue())) {
            this.myBeans.remove(propertyChangeEvent.getOldValue());
            if (this.myBeans.containsKey(ableBean.getName())) {
                String string2 = AbleDefaultAgent.generateUniqueName(this, ableBean);
                ableBean.setName(string2);
            }
            this.myBeans.put(ableBean.getName(), ableBean);
        }
    }

    protected void buildProcessList() throws AbleException {
        if (this.myBeans == null) {
            return;
        }
        boolean bl = false;
        Iterator iterator = this.myBeans.values().iterator();
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        StringBuffer stringBuffer = new StringBuffer("");
        Vector<Object> vector2 = new Vector<Object>();
        ListIterator listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            AbleObject ableObject = (AbleObject)listIterator.next();
            if (!(ableObject instanceof AbleDataSource)) continue;
            if (ableObject.isDataFlowEnabled()) {
                vector2.insertElementAt(ableObject, 0);
                stringBuffer.insert(0, ableObject.getName() + " ");
                listIterator.remove();
                continue;
            }
            vector2.addElement(ableObject);
            stringBuffer.append(ableObject.getName() + " ");
            listIterator.remove();
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            ListIterator listIterator2 = vector.listIterator();
            bl = false;
            while (listIterator2.hasNext()) {
                object = (AbleObject)listIterator2.next();
                if (!((AbleObject)object).sourceConnectionsOK(vector2)) continue;
                stringBuffer.append(((AbleObject)object).getName() + " ");
                vector2.addElement(object);
                listIterator2.remove();
                bl = true;
                break;
            }
            if (bl || vector.size() <= 0) continue;
            object = Able.NlsMsg("EX_CIRCULAR_PROCESS_LIST", new Object[]{this.getName()});
            this.logger.text(4L, this, "buildProcessList", (String)object);
            if (!this.trace.isLogging()) break;
            this.trace.text(262144L, this, "buildProcessList()", (String)object);
            break;
        }
        if (vector2.size() == this.myBeans.size()) {
            this.setProcessList(vector2);
            this.processListOK = true;
            if (this.trace.isLogging()) {
                this.trace.text(0x100000L, this, "buildProcessList", "Process list now = " + stringBuffer);
            }
        } else {
            this.setBufferSources();
        }
    }

    private void setBufferSources() throws AbleException {
        int n;
        AbleBean ableBean = null;
        this.inputBufferTargetObject = null;
        int n2 = this.processList.size();
        for (n = 0; n < n2; ++n) {
            ableBean = (AbleBean)this.processList.elementAt(n);
            if (!ableBean.isDataFlowEnabled()) continue;
            this.inputBufferTargetObject = ableBean;
            break;
        }
        ableBean = null;
        this.outputBufferSourceObject = null;
        for (n = this.processList.size() - 1; n >= 0; --n) {
            ableBean = (AbleBean)this.processList.elementAt(n);
            if (!ableBean.isDataFlowEnabled()) continue;
            this.outputBufferSourceObject = ableBean;
            break;
        }
    }

    protected void debugTrace(String string) {
    }

    protected String clsNm() {
        return this.getClass().getName();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        AbleBean ableBean;
        this.processList = new Vector();
        this.processListOK = false;
        objectInputStream.defaultReadObject();
        if (this.myBeans == null) {
            this.myBeans = new Hashtable();
            for (int i = 0; i < this.beans.size(); ++i) {
                ableBean = (AbleBean)this.beans.get(i);
                this.myBeans.put(ableBean.getName(), ableBean);
            }
            this.beans.clear();
        }
        if (this.myBeans != null) {
            Iterator iterator = this.myBeans.values().iterator();
            while (iterator.hasNext()) {
                ableBean = (AbleBean)iterator.next();
                ableBean.addPropertyChangeListener(this);
            }
        }
    }

    private static String Copyright() {
        return "Licensed Materials - Property of IBM\nPackage: com.ibm.able\n(C) Copyright IBM Corporation 1999, 2005. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    }
}

